/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.CommitScn;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleDefaultValueConverter;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.connector.oracle.logminer.processor.AbstractLogMinerEventProcessor;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.relational.Column;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.schema.SchemaTopicNamingStrategy;
import io.debezium.spi.topic.TopicNamingStrategy;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public abstract class AbstractProcessorUnitTest<T extends AbstractLogMinerEventProcessor>
extends AbstractConnectorTest {
    private static final String TRANSACTION_ID_1 = "1234567890";
    private static final String TRANSACTION_ID_2 = "9876543210";
    private static final String TRANSACTION_ID_3 = "9880212345";
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();
    protected ChangeEventSource.ChangeEventSourceContext context;
    protected EventDispatcher<OraclePartition, TableId> dispatcher;
    protected OracleDatabaseSchema schema;
    protected OracleStreamingChangeEventSourceMetrics metrics;
    protected OraclePartition partition;
    protected OracleOffsetContext offsetContext;
    protected OracleConnection connection;

    @Before
    public void before() throws Exception {
        this.context = (ChangeEventSource.ChangeEventSourceContext)Mockito.mock(ChangeEventSource.ChangeEventSourceContext.class);
        Mockito.when((Object)this.context.isRunning()).thenReturn((Object)true);
        this.dispatcher = (EventDispatcher)Mockito.mock(EventDispatcher.class);
        this.partition = (OraclePartition)Mockito.mock(OraclePartition.class);
        this.offsetContext = (OracleOffsetContext)Mockito.mock(OracleOffsetContext.class);
        CommitScn commitScn = CommitScn.valueOf((String)null);
        Mockito.when((Object)this.offsetContext.getCommitScn()).thenReturn((Object)commitScn);
        this.connection = this.createOracleConnection(false);
        this.schema = this.createOracleDatabaseSchema();
        this.metrics = this.createMetrics(this.schema);
    }

    @After
    public void after() {
        if (this.schema != null) {
            try {
                this.schema.close();
            }
            finally {
                this.schema = null;
            }
        }
    }

    protected abstract Configuration.Builder getConfig();

    protected abstract T getProcessor(OracleConnectorConfig var1);

    protected boolean isTransactionAbandonmentSupported() {
        return true;
    }

    @Test
    public void testCacheIsEmpty() throws Exception {
        OracleConnectorConfig config = new OracleConnectorConfig(this.getConfig().build());
        try (T processor = this.getProcessor(config);){
            Assertions.assertThat((boolean)processor.getTransactionCache().isEmpty()).isTrue();
        }
    }

    @Test
    public void testCacheIsNotEmptyWhenTransactionIsAdded() throws Exception {
        OracleConnectorConfig config = new OracleConnectorConfig(this.getConfig().build());
        try (T processor = this.getProcessor(config);){
            processor.handleStart(this.getStartLogMinerEventRow(Scn.valueOf((long)1L), TRANSACTION_ID_1));
            processor.handleDataEvent(this.getInsertLogMinerEventRow(Scn.valueOf((long)2L), TRANSACTION_ID_1));
            Assertions.assertThat((boolean)processor.getTransactionCache().isEmpty()).isFalse();
        }
    }

    @Test
    public void testCacheIsEmptyWhenTransactionIsCommitted() throws Exception {
        OracleConnectorConfig config = new OracleConnectorConfig(this.getConfig().build());
        OraclePartition partition = new OraclePartition(config.getLogicalName(), config.getDatabaseName());
        try (T processor = this.getProcessor(config);){
            LogMinerEventRow insertRow = this.getInsertLogMinerEventRow(Scn.valueOf((long)2L), TRANSACTION_ID_1);
            processor.handleStart(this.getStartLogMinerEventRow(Scn.valueOf((long)1L), TRANSACTION_ID_1));
            processor.handleDataEvent(insertRow);
            processor.handleCommit(partition, this.getCommitLogMinerEventRow(Scn.valueOf((long)3L), TRANSACTION_ID_1));
            Assertions.assertThat((boolean)processor.getTransactionCache().isEmpty()).isTrue();
        }
    }

    @Test
    public void testCacheIsEmptyWhenTransactionIsRolledBack() throws Exception {
        OracleConnectorConfig config = new OracleConnectorConfig(this.getConfig().build());
        try (T processor = this.getProcessor(config);){
            processor.handleStart(this.getStartLogMinerEventRow(Scn.valueOf((long)1L), TRANSACTION_ID_1));
            processor.handleDataEvent(this.getInsertLogMinerEventRow(Scn.valueOf((long)2L), TRANSACTION_ID_1));
            processor.handleRollback(this.getRollbackLogMinerEventRow(Scn.valueOf((long)3L), TRANSACTION_ID_1));
            Assertions.assertThat((boolean)processor.getTransactionCache().isEmpty()).isTrue();
        }
    }

    @Test
    public void testCacheIsNotEmptyWhenFirstTransactionIsRolledBack() throws Exception {
        OracleConnectorConfig config = new OracleConnectorConfig(this.getConfig().build());
        try (T processor = this.getProcessor(config);){
            processor.handleStart(this.getStartLogMinerEventRow(Scn.valueOf((long)1L), TRANSACTION_ID_1));
            processor.handleDataEvent(this.getInsertLogMinerEventRow(Scn.valueOf((long)2L), TRANSACTION_ID_1));
            processor.handleStart(this.getStartLogMinerEventRow(Scn.valueOf((long)3L), TRANSACTION_ID_2));
            processor.handleDataEvent(this.getInsertLogMinerEventRow(Scn.valueOf((long)4L), TRANSACTION_ID_2));
            processor.handleRollback(this.getRollbackLogMinerEventRow(Scn.valueOf((long)5L), TRANSACTION_ID_1));
            Assertions.assertThat((boolean)processor.getTransactionCache().isEmpty()).isFalse();
            Assertions.assertThat((boolean)this.metrics.getRolledBackTransactionIds().contains(TRANSACTION_ID_1)).isTrue();
            Assertions.assertThat((boolean)this.metrics.getRolledBackTransactionIds().contains(TRANSACTION_ID_2)).isFalse();
        }
    }

    @Test
    public void testCacheIsNotEmptyWhenSecondTransactionIsRolledBack() throws Exception {
        OracleConnectorConfig config = new OracleConnectorConfig(this.getConfig().build());
        try (T processor = this.getProcessor(config);){
            processor.handleStart(this.getStartLogMinerEventRow(Scn.valueOf((long)1L), TRANSACTION_ID_1));
            processor.handleDataEvent(this.getInsertLogMinerEventRow(Scn.valueOf((long)2L), TRANSACTION_ID_1));
            processor.handleStart(this.getStartLogMinerEventRow(Scn.valueOf((long)3L), TRANSACTION_ID_2));
            processor.handleDataEvent(this.getInsertLogMinerEventRow(Scn.valueOf((long)4L), TRANSACTION_ID_2));
            processor.handleRollback(this.getRollbackLogMinerEventRow(Scn.valueOf((long)5L), TRANSACTION_ID_2));
            Assertions.assertThat((boolean)processor.getTransactionCache().isEmpty()).isFalse();
            Assertions.assertThat((boolean)this.metrics.getRolledBackTransactionIds().contains(TRANSACTION_ID_2)).isTrue();
            Assertions.assertThat((boolean)this.metrics.getRolledBackTransactionIds().contains(TRANSACTION_ID_1)).isFalse();
        }
    }

    @Test
    public void testCalculateScnWhenTransactionIsCommitted() throws Exception {
        OracleConnectorConfig config = new OracleConnectorConfig(this.getConfig().build());
        OraclePartition partition = new OraclePartition(config.getLogicalName(), config.getDatabaseName());
        try (T processor = this.getProcessor(config);){
            processor.handleStart(this.getStartLogMinerEventRow(Scn.valueOf((long)1L), TRANSACTION_ID_1));
            processor.handleDataEvent(this.getInsertLogMinerEventRow(Scn.valueOf((long)2L), TRANSACTION_ID_1));
            processor.handleCommit(partition, this.getCommitLogMinerEventRow(Scn.valueOf((long)3L), TRANSACTION_ID_1));
            Assertions.assertThat((BigInteger)this.metrics.getOldestScn()).isEqualTo(Scn.valueOf((long)2L).toString());
            Assertions.assertThat((Iterable)this.metrics.getRolledBackTransactionIds()).isEmpty();
        }
    }

    @Test
    public void testCalculateScnWhenFirstTransactionIsCommitted() throws Exception {
        OracleConnectorConfig config = new OracleConnectorConfig(this.getConfig().build());
        OraclePartition partition = new OraclePartition(config.getLogicalName(), config.getDatabaseName());
        try (T processor = this.getProcessor(config);){
            processor.handleStart(this.getStartLogMinerEventRow(Scn.valueOf((long)1L), TRANSACTION_ID_1));
            processor.handleDataEvent(this.getInsertLogMinerEventRow(Scn.valueOf((long)2L), TRANSACTION_ID_1));
            processor.handleStart(this.getStartLogMinerEventRow(Scn.valueOf((long)3L), TRANSACTION_ID_2));
            processor.handleDataEvent(this.getInsertLogMinerEventRow(Scn.valueOf((long)4L), TRANSACTION_ID_2));
            processor.handleCommit(partition, this.getCommitLogMinerEventRow(Scn.valueOf((long)5L), TRANSACTION_ID_1));
            Assertions.assertThat((BigInteger)this.metrics.getOldestScn()).isEqualTo(Scn.valueOf((long)3L).toString());
            Assertions.assertThat((Iterable)this.metrics.getRolledBackTransactionIds()).isEmpty();
            processor.handleCommit(partition, this.getCommitLogMinerEventRow(Scn.valueOf((long)6L), TRANSACTION_ID_2));
            Assertions.assertThat((BigInteger)this.metrics.getOldestScn()).isEqualTo(Scn.valueOf((long)4L).toString());
        }
    }

    @Test
    public void testCalculateScnWhenSecondTransactionIsCommitted() throws Exception {
        OracleConnectorConfig config = new OracleConnectorConfig(this.getConfig().build());
        OraclePartition partition = new OraclePartition(config.getLogicalName(), config.getDatabaseName());
        try (T processor = this.getProcessor(config);){
            processor.handleStart(this.getStartLogMinerEventRow(Scn.valueOf((long)1L), TRANSACTION_ID_1));
            processor.handleDataEvent(this.getInsertLogMinerEventRow(Scn.valueOf((long)2L), TRANSACTION_ID_1));
            processor.handleStart(this.getStartLogMinerEventRow(Scn.valueOf((long)3L), TRANSACTION_ID_2));
            processor.handleDataEvent(this.getInsertLogMinerEventRow(Scn.valueOf((long)4L), TRANSACTION_ID_2));
            processor.handleCommit(partition, this.getCommitLogMinerEventRow(Scn.valueOf((long)5L), TRANSACTION_ID_2));
            Assertions.assertThat((BigInteger)this.metrics.getOldestScn()).isEqualTo(Scn.valueOf((long)1L).toString());
            Assertions.assertThat((Iterable)this.metrics.getRolledBackTransactionIds()).isEmpty();
        }
    }

    @Test
    public void testAbandonOneTransaction() throws Exception {
        if (!this.isTransactionAbandonmentSupported()) {
            return;
        }
        OracleConnectorConfig config = new OracleConnectorConfig(this.getConfig().build());
        try (T processor = this.getProcessor(config);){
            Mockito.when((Object)this.offsetContext.getScn()).thenReturn((Object)Scn.valueOf((long)1L));
            Mockito.when((Object)this.offsetContext.getSnapshotScn()).thenReturn((Object)Scn.NULL);
            Instant changeTime = Instant.now().minus(24L, ChronoUnit.HOURS);
            processor.processRow(this.partition, this.getStartLogMinerEventRow(Scn.valueOf((long)2L), TRANSACTION_ID_1, changeTime));
            processor.processRow(this.partition, this.getInsertLogMinerEventRow(Scn.valueOf((long)3L), TRANSACTION_ID_1, changeTime));
            processor.abandonTransactions(Duration.ofHours(1L));
            Assertions.assertThat((boolean)processor.getTransactionCache().isEmpty()).isTrue();
        }
    }

    @Test
    public void testAbandonTransactionHavingAnotherOne() throws Exception {
        if (!this.isTransactionAbandonmentSupported()) {
            return;
        }
        OracleConnectorConfig config = new OracleConnectorConfig(this.getConfig().build());
        try (T processor = this.getProcessor(config);){
            Mockito.when((Object)this.offsetContext.getScn()).thenReturn((Object)Scn.valueOf((long)1L));
            Mockito.when((Object)this.offsetContext.getSnapshotScn()).thenReturn((Object)Scn.NULL);
            Instant changeTime = Instant.now().minus(24L, ChronoUnit.HOURS);
            processor.processRow(this.partition, this.getStartLogMinerEventRow(Scn.valueOf((long)2L), TRANSACTION_ID_1, changeTime));
            processor.processRow(this.partition, this.getInsertLogMinerEventRow(Scn.valueOf((long)3L), TRANSACTION_ID_1, changeTime));
            processor.processRow(this.partition, this.getStartLogMinerEventRow(Scn.valueOf((long)4L), TRANSACTION_ID_2));
            processor.processRow(this.partition, this.getInsertLogMinerEventRow(Scn.valueOf((long)5L), TRANSACTION_ID_2));
            processor.abandonTransactions(Duration.ofHours(1L));
            Assertions.assertThat((boolean)processor.getTransactionCache().isEmpty()).isFalse();
            Assertions.assertThat(processor.getTransactionCache().get(TRANSACTION_ID_1)).isNull();
            Assertions.assertThat(processor.getTransactionCache().get(TRANSACTION_ID_2)).isNotNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-6355"})
    public void testAbandonTransactionsUsingFallbackBasedOnChangeTime() throws Exception {
        if (!this.isTransactionAbandonmentSupported()) {
            return;
        }
        this.schema.close();
        this.connection = this.createOracleConnection(true);
        this.schema = this.createOracleDatabaseSchema();
        this.metrics = this.createMetrics(this.schema);
        OracleConnectorConfig config = new OracleConnectorConfig(this.getConfig().build());
        try (T processor = this.getProcessor(config);){
            Mockito.when((Object)this.offsetContext.getScn()).thenReturn((Object)Scn.valueOf((long)1L));
            Mockito.when((Object)this.offsetContext.getSnapshotScn()).thenReturn((Object)Scn.NULL);
            Instant changeTime1 = Instant.now().minus(24L, ChronoUnit.HOURS);
            Instant changeTime2 = Instant.now().minus(23L, ChronoUnit.HOURS);
            processor.processRow(this.partition, this.getStartLogMinerEventRow(Scn.valueOf((long)2L), TRANSACTION_ID_1, changeTime1));
            processor.processRow(this.partition, this.getInsertLogMinerEventRow(Scn.valueOf((long)3L), TRANSACTION_ID_1, changeTime1));
            processor.processRow(this.partition, this.getStartLogMinerEventRow(Scn.valueOf((long)4L), TRANSACTION_ID_2, changeTime2));
            processor.processRow(this.partition, this.getInsertLogMinerEventRow(Scn.valueOf((long)5L), TRANSACTION_ID_2, changeTime2));
            processor.processRow(this.partition, this.getStartLogMinerEventRow(Scn.valueOf((long)6L), TRANSACTION_ID_3));
            processor.processRow(this.partition, this.getInsertLogMinerEventRow(Scn.valueOf((long)7L), TRANSACTION_ID_3));
            processor.abandonTransactions(Duration.ofHours(1L));
            Assertions.assertThat((boolean)processor.getTransactionCache().isEmpty()).isFalse();
            Assertions.assertThat(processor.getTransactionCache().get(TRANSACTION_ID_1)).isNull();
            Assertions.assertThat(processor.getTransactionCache().get(TRANSACTION_ID_2)).isNull();
            Assertions.assertThat(processor.getTransactionCache().get(TRANSACTION_ID_3)).isNotNull();
        }
    }

    private OracleDatabaseSchema createOracleDatabaseSchema() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(this.getConfig().build());
        SchemaTopicNamingStrategy topicNamingStrategy = SchemaTopicNamingStrategy.create((CommonConnectorConfig)connectorConfig);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjuster();
        OracleValueConverters converters = connectorConfig.getAdapter().getValueConverter(connectorConfig, this.connection);
        OracleDefaultValueConverter defaultValueConverter = new OracleDefaultValueConverter(converters, this.connection);
        StreamingAdapter.TableNameCaseSensitivity sensitivity = connectorConfig.getAdapter().getTableNameCaseSensitivity(this.connection);
        OracleDatabaseSchema schema = new OracleDatabaseSchema(connectorConfig, converters, (DefaultValueConverter)defaultValueConverter, schemaNameAdjuster, (TopicNamingStrategy)topicNamingStrategy, sensitivity);
        Table table = Table.editor().tableId(TableId.parse((String)"ORCLPDB1.DEBEZIUM.TEST_TABLE")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("DATA").create()).create();
        schema.refresh(table);
        return schema;
    }

    private OracleConnection createOracleConnection(boolean singleOptionalValueThrowException) throws Exception {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.next()).thenReturn((Object)true);
        Mockito.when((Object)Float.valueOf(rs.getFloat(1))).thenReturn((Object)Float.valueOf(2.0f));
        PreparedStatement stmt = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)stmt.executeQuery()).thenReturn((Object)rs);
        Connection conn = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)conn.prepareStatement((String)Mockito.any())).thenReturn((Object)stmt);
        OracleConnection connection = (OracleConnection)Mockito.mock(OracleConnection.class);
        Mockito.when((Object)connection.connection(Mockito.anyBoolean())).thenReturn((Object)conn);
        if (!singleOptionalValueThrowException) {
            Mockito.when((Object)connection.singleOptionalValue(ArgumentMatchers.anyString(), (JdbcConnection.ResultSetExtractor)ArgumentMatchers.any())).thenReturn((Object)BigInteger.TWO);
        } else {
            Mockito.when((Object)connection.singleOptionalValue(ArgumentMatchers.anyString(), (JdbcConnection.ResultSetExtractor)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SQLException("ORA-01555 Snapshot too old", null, 1555)});
        }
        return connection;
    }

    private OracleStreamingChangeEventSourceMetrics createMetrics(OracleDatabaseSchema schema) throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(this.getConfig().build());
        OracleTaskContext taskContext = new OracleTaskContext(connectorConfig, schema);
        ChangeEventQueue queue = new ChangeEventQueue.Builder().pollInterval(Duration.of(8192L, ChronoUnit.MILLIS)).maxBatchSize(2048).maxQueueSize(8192).build();
        return new OracleStreamingChangeEventSourceMetrics((CdcSourceTaskContext)taskContext, (ChangeEventQueueMetrics)queue, null, connectorConfig);
    }

    private LogMinerEventRow getStartLogMinerEventRow(Scn scn, String transactionId) {
        return this.getStartLogMinerEventRow(scn, transactionId, Instant.now());
    }

    private LogMinerEventRow getStartLogMinerEventRow(Scn scn, String transactionId, Instant changeTime) {
        LogMinerEventRow row = (LogMinerEventRow)Mockito.mock(LogMinerEventRow.class);
        Mockito.when((Object)row.getEventType()).thenReturn((Object)EventType.START);
        Mockito.when((Object)row.getTransactionId()).thenReturn((Object)transactionId);
        Mockito.when((Object)row.getScn()).thenReturn((Object)scn);
        Mockito.when((Object)row.getChangeTime()).thenReturn((Object)changeTime);
        return row;
    }

    private LogMinerEventRow getCommitLogMinerEventRow(Scn scn, String transactionId) {
        LogMinerEventRow row = (LogMinerEventRow)Mockito.mock(LogMinerEventRow.class);
        Mockito.when((Object)row.getEventType()).thenReturn((Object)EventType.COMMIT);
        Mockito.when((Object)row.getTransactionId()).thenReturn((Object)transactionId);
        Mockito.when((Object)row.getScn()).thenReturn((Object)scn);
        Mockito.when((Object)row.getChangeTime()).thenReturn((Object)Instant.now());
        return row;
    }

    private LogMinerEventRow getRollbackLogMinerEventRow(Scn scn, String transactionId) {
        LogMinerEventRow row = (LogMinerEventRow)Mockito.mock(LogMinerEventRow.class);
        Mockito.when((Object)row.getEventType()).thenReturn((Object)EventType.ROLLBACK);
        Mockito.when((Object)row.getTransactionId()).thenReturn((Object)transactionId);
        Mockito.when((Object)row.getScn()).thenReturn((Object)scn);
        Mockito.when((Object)row.getChangeTime()).thenReturn((Object)Instant.now());
        return row;
    }

    private LogMinerEventRow getInsertLogMinerEventRow(Scn scn, String transactionId) {
        return this.getInsertLogMinerEventRow(scn, transactionId, Instant.now());
    }

    private LogMinerEventRow getInsertLogMinerEventRow(Scn scn, String transactionId, Instant changeTime) {
        LogMinerEventRow row = (LogMinerEventRow)Mockito.mock(LogMinerEventRow.class);
        Mockito.when((Object)row.getEventType()).thenReturn((Object)EventType.INSERT);
        Mockito.when((Object)row.getTransactionId()).thenReturn((Object)transactionId);
        Mockito.when((Object)row.getScn()).thenReturn((Object)scn);
        Mockito.when((Object)row.getChangeTime()).thenReturn((Object)changeTime);
        Mockito.when((Object)row.getRowId()).thenReturn((Object)TRANSACTION_ID_1);
        Mockito.when((Object)row.getOperation()).thenReturn((Object)"INSERT");
        Mockito.when((Object)row.getTableName()).thenReturn((Object)"TEST_TABLE");
        Mockito.when((Object)row.getTableId()).thenReturn((Object)TableId.parse((String)"ORCLPDB1.DEBEZIUM.TEST_TABLE"));
        Mockito.when((Object)row.getRedoSql()).thenReturn((Object)"insert into \"DEBEZIUM\".\"TEST_TABLE\"(\"ID\",\"DATA\") values ('1','Test');");
        Mockito.when((Object)row.getRsId()).thenReturn((Object)"A.B.C");
        Mockito.when((Object)row.getTablespaceName()).thenReturn((Object)"DEBEZIUM");
        Mockito.when((Object)row.getUserName()).thenReturn((Object)"debezium");
        return row;
    }
}

