/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.junit;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.junit.SkipOnDatabaseOption;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.junit.AnnotationBasedTestRule;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.Objects;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipTestDependingOnDatabaseOptionRule
extends AnnotationBasedTestRule {
    private static final String FALSE = "FALSE";
    private static final String TRUE = "TRUE";

    public Statement apply(Statement base, Description description) {
        SkipOnDatabaseOption option = (SkipOnDatabaseOption)this.hasAnnotation(description, SkipOnDatabaseOption.class);
        if (Objects.nonNull(option)) {
            String optionValue = this.getDatabaseOptionValue(option.value());
            if (option.enabled() && TRUE.equals(optionValue)) {
                return SkipTestDependingOnDatabaseOptionRule.emptyStatement((String)("Database option '" + optionValue + "' is enabled and available"), (Description)description);
            }
            if (!option.enabled() && (Strings.isNullOrEmpty((String)optionValue) || FALSE.equals(optionValue))) {
                return SkipTestDependingOnDatabaseOptionRule.emptyStatement((String)("Database option '" + optionValue + "' not available"), (Description)description);
            }
        }
        return base;
    }

    private String getDatabaseOptionValue(String option) {
        String string;
        block8: {
            OracleConnection connection = TestHelper.testConnection();
            try {
                string = (String)connection.queryAndMap("SELECT VALUE FROM V$OPTION WHERE PARAMETER='" + option + "'", rs -> {
                    if (rs.next()) {
                        return rs.getString(1);
                    }
                    return null;
                });
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed to resolve database option " + option, e);
                }
            }
            connection.close();
        }
        return string;
    }
}

