/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class OracleSkipMessagesWithoutChangeConfigIT
extends AbstractConnectorTest {
    @Rule
    public final TestRule skipAdapterRule = new SkipTestDependingOnAdapterNameRule();
    private OracleConnection connection;

    @Before
    public void before() {
        this.connection = TestHelper.testConnection();
        TestHelper.dropTable(this.connection, "debezium.test");
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws Exception {
        if (this.connection != null) {
            TestHelper.dropTable(this.connection, "debezium.test");
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-2979"})
    public void shouldSkipEventsWithNoChangeInIncludedColumnsWhenSkipEnabled() throws Exception {
        String ddl = "CREATE TABLE debezium.test (  id INT NOT NULL, white INT, black INT, PRIMARY KEY (id))";
        this.connection.execute(new String[]{ddl});
        this.connection.execute(new String[]{"GRANT SELECT ON debezium.test TO " + TestHelper.getConnectorUserName()});
        this.connection.execute(new String[]{"ALTER TABLE debezium.test ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.TEST")).with(OracleConnectorConfig.COLUMN_INCLUDE_LIST, "DEBEZIUM\\.TEST\\.ID, DEBEZIUM\\.TEST\\.WHITE")).with(OracleConnectorConfig.SKIP_MESSAGES_WITHOUT_CHANGE, true)).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(OracleConnector.class, config);
        OracleSkipMessagesWithoutChangeConfigIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        this.connection.execute(new String[]{"INSERT INTO debezium.test VALUES (1, 1, 1)"});
        this.connection.execute(new String[]{"UPDATE debezium.test SET black=2 where id = 1"});
        this.connection.execute(new String[]{"UPDATE debezium.test SET white=2 where id = 1"});
        this.connection.execute(new String[]{"UPDATE debezium.test SET white=3, black=3 where id = 1"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(3);
        List recordsForTopic = records.recordsForTopic(OracleSkipMessagesWithoutChangeConfigIT.topicName("test"));
        Assertions.assertThat((List)recordsForTopic).hasSize(3);
        Struct secondMessage = ((Struct)((SourceRecord)recordsForTopic.get(1)).value()).getStruct("after");
        Assertions.assertThat((Object)secondMessage.get("WHITE")).isEqualTo((Object)new BigDecimal("2"));
        Struct thirdMessage = ((Struct)((SourceRecord)recordsForTopic.get(2)).value()).getStruct("after");
        Assertions.assertThat((Object)thirdMessage.get("WHITE")).isEqualTo((Object)new BigDecimal("3"));
    }

    @Test
    @FixFor(value={"DBZ-2979"})
    public void shouldSkipEventsWithNoChangeInIncludedColumnsWhenSkipEnabledWithExcludeConfig() throws Exception {
        String ddl = "CREATE TABLE debezium.test (  id INT NOT NULL, white INT, black INT, PRIMARY KEY (id))";
        this.connection.execute(new String[]{ddl});
        this.connection.execute(new String[]{"GRANT SELECT ON debezium.test TO " + TestHelper.getConnectorUserName()});
        this.connection.execute(new String[]{"ALTER TABLE debezium.test ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.TEST")).with(OracleConnectorConfig.COLUMN_EXCLUDE_LIST, "DEBEZIUM\\.TEST\\.BLACK")).with(OracleConnectorConfig.SKIP_MESSAGES_WITHOUT_CHANGE, true)).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(OracleConnector.class, config);
        OracleSkipMessagesWithoutChangeConfigIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        this.connection.execute(new String[]{"INSERT INTO debezium.test VALUES (1, 1, 1)"});
        this.connection.execute(new String[]{"UPDATE debezium.test SET black=2 where id = 1"});
        this.connection.execute(new String[]{"UPDATE debezium.test SET white=2 where id = 1"});
        this.connection.execute(new String[]{"UPDATE debezium.test SET white=3, black=3 where id = 1"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(3);
        List recordsForTopic = records.recordsForTopic(OracleSkipMessagesWithoutChangeConfigIT.topicName("test"));
        Assertions.assertThat((List)recordsForTopic).hasSize(3);
        Struct secondMessage = ((Struct)((SourceRecord)recordsForTopic.get(1)).value()).getStruct("after");
        Assertions.assertThat((Object)secondMessage.get("WHITE")).isEqualTo((Object)new BigDecimal("2"));
        Struct thirdMessage = ((Struct)((SourceRecord)recordsForTopic.get(2)).value()).getStruct("after");
        Assertions.assertThat((Object)thirdMessage.get("WHITE")).isEqualTo((Object)new BigDecimal("3"));
    }

    @Test
    @FixFor(value={"DBZ-2979"})
    public void shouldNotSkipEventsWithNoChangeInIncludedColumnsWhenSkipDisabled() throws Exception {
        String ddl = "CREATE TABLE debezium.test (  id INT NOT NULL, white INT, black INT, PRIMARY KEY (id))";
        this.connection.execute(new String[]{ddl});
        this.connection.execute(new String[]{"GRANT SELECT ON debezium.test TO " + TestHelper.getConnectorUserName()});
        this.connection.execute(new String[]{"ALTER TABLE debezium.test ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.TEST")).with(OracleConnectorConfig.COLUMN_INCLUDE_LIST, "DEBEZIUM\\.TEST\\.ID, DEBEZIUM\\.TEST\\.WHITE")).with(OracleConnectorConfig.SKIP_MESSAGES_WITHOUT_CHANGE, false)).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(OracleConnector.class, config);
        OracleSkipMessagesWithoutChangeConfigIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        this.connection.execute(new String[]{"INSERT INTO debezium.test VALUES (1, 1, 1)"});
        this.connection.execute(new String[]{"UPDATE debezium.test SET black=2 where id = 1"});
        this.connection.execute(new String[]{"UPDATE debezium.test SET white=2 where id = 1"});
        this.connection.execute(new String[]{"UPDATE debezium.test SET white=3, black=3 where id = 1"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(4);
        List recordsForTopic = records.recordsForTopic(OracleSkipMessagesWithoutChangeConfigIT.topicName("test"));
        Assertions.assertThat((List)recordsForTopic).hasSize(4);
        Struct secondMessage = ((Struct)((SourceRecord)recordsForTopic.get(1)).value()).getStruct("after");
        Assertions.assertThat((Object)secondMessage.get("WHITE")).isEqualTo((Object)new BigDecimal("1"));
        Struct thirdMessage = ((Struct)((SourceRecord)recordsForTopic.get(2)).value()).getStruct("after");
        Assertions.assertThat((Object)thirdMessage.get("WHITE")).isEqualTo((Object)new BigDecimal("2"));
        Struct forthMessage = ((Struct)((SourceRecord)recordsForTopic.get(3)).value()).getStruct("after");
        Assertions.assertThat((Object)forthMessage.get("WHITE")).isEqualTo((Object)new BigDecimal("3"));
    }

    private static String topicName(String tableName) {
        return "server1.DEBEZIUM." + tableName.toUpperCase();
    }
}

