/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import org.apache.kafka.connect.errors.RetriableException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class OracleConnectionTest {
    private Statement statement;
    private JdbcConfiguration jdbcConfiguration;
    private JdbcConnection.ConnectionFactory connectionFactory;

    @Before
    public void setUp() throws Exception {
        this.jdbcConfiguration = (JdbcConfiguration)Mockito.mock(JdbcConfiguration.class);
        this.connectionFactory = (JdbcConnection.ConnectionFactory)Mockito.mock(JdbcConnection.ConnectionFactory.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        this.statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)connection.createStatement()).thenReturn((Object)this.statement);
        Mockito.when((Object)this.connectionFactory.connect(this.jdbcConfiguration)).thenReturn((Object)connection);
    }

    @Test
    public void whenOracleConnectionGetSQLRecoverableExceptionThenARetriableExceptionWillBeThrown() throws SQLException {
        Mockito.when((Object)this.statement.executeQuery((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SQLRecoverableException("IO Error: The Network Adapter could not establish the connection (CONNECTION_ID=u/VErjYySfO0HgLtwdCuTQ==)")});
        Assert.assertThrows(RetriableException.class, () -> new OracleConnection(this.jdbcConfiguration, this.connectionFactory, true));
    }
}

