/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.parser.XmlBeginParser;
import io.debezium.doc.FixFor;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.text.ParsingException;
import java.sql.SQLException;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class XmlBeginParserTest {
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();
    private static final XmlBeginParser parser = new XmlBeginParser();

    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldParseSimpleXmlBeginRedoSql() throws SQLException {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.XML_TEST")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("DATA").create()).create();
        String redoSql = "XML DOC BEGIN:  select \"DATA\" from \"DEBEZIUM\".\"XML_TEST\" where \"ID\" = '1'";
        LogMinerDmlEntry entry = parser.parse(redoSql, table);
        Assertions.assertThat((String)parser.getColumnName()).isEqualTo((Object)"DATA");
        Assertions.assertThat((String)entry.getObjectOwner()).isEqualTo((Object)"DEBEZIUM");
        Assertions.assertThat((String)entry.getObjectName()).isEqualTo((Object)"XML_TEST");
    }

    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldParseSimpleXmlBeginRedoSqlWithSpacesInObjectNames() throws SQLException {
        Table table = Table.editor().tableId(TableId.parse((String)"\"DEBEZIUM OBJ\".\"XML_TEST OBJ\"")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("DATA OBJ").create()).create();
        String redoSql = "XML DOC BEGIN:  select \"DATA OBJ\" from \"DEBEZIUM OBJ\".\"XML_TEST OBJ\" where \"ID\" = '1'";
        LogMinerDmlEntry entry = parser.parse(redoSql, table);
        Assertions.assertThat((String)parser.getColumnName()).isEqualTo((Object)"DATA OBJ");
        Assertions.assertThat((String)entry.getObjectOwner()).isEqualTo((Object)"DEBEZIUM OBJ");
        Assertions.assertThat((String)entry.getObjectName()).isEqualTo((Object)"XML_TEST OBJ");
    }

    @Test(expected=ParsingException.class)
    @FixFor(value={"DBZ-3605"})
    public void shouldNotParseSimpleXmlBeginRedoSqlWithInvalidPreamble() {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.XML_TEST")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("DATA").create()).create();
        String redoSql = "XMLDOCBEGIN:  select \"DATA\" from \"DEBEZIUM\".\"XML_TEST\" where \"ID\" = '1'";
        parser.parse(redoSql, table);
    }
}

