/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleEventMetadataProvider;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import java.math.BigInteger;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

public class OracleStreamingMetricsTest {
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();
    private OracleConnectorConfig connectorConfig;
    private OracleStreamingChangeEventSourceMetrics metrics;
    private Clock fixedClock;

    @Before
    public void before() {
        this.init(TestHelper.defaultConfig());
    }

    @Test
    public void testMetrics() {
        this.metrics.setLastCapturedDmlCount(1);
        Assertions.assertThat((this.metrics.getTotalCapturedDmlCount() == 1L ? 1 : 0) != 0).isTrue();
        this.metrics.setCurrentScn(Scn.valueOf((long)1000L));
        Assertions.assertThat((BigInteger)this.metrics.getCurrentScn()).isEqualTo("1000");
        this.metrics.setBatchSize(10);
        Assertions.assertThat((this.metrics.getBatchSize() == this.connectorConfig.getLogMiningBatchSizeDefault() ? 1 : 0) != 0).isTrue();
        this.metrics.setBatchSize(1000000);
        Assertions.assertThat((int)this.metrics.getBatchSize()).isEqualTo(this.connectorConfig.getLogMiningBatchSizeDefault());
        this.metrics.setBatchSize(6000);
        Assertions.assertThat((int)this.metrics.getBatchSize()).isEqualTo(6000);
        Assertions.assertThat((long)this.metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1000L);
        this.metrics.changeSleepingTime(true);
        Assertions.assertThat((long)this.metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1200L);
        this.metrics.changeSleepingTime(false);
        Assertions.assertThat((long)this.metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1000L);
        this.metrics.setMillisecondToSleepBetweenMiningQuery(-1L);
        Assertions.assertThat((long)this.metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1000L);
        this.metrics.setMillisecondToSleepBetweenMiningQuery(4000L);
        Assertions.assertThat((long)this.metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1000L);
        this.metrics.setMillisecondToSleepBetweenMiningQuery(2000L);
        Assertions.assertThat((long)this.metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(2000L);
        this.metrics.setLastDurationOfBatchCapturing(Duration.ofMillis(100L));
        Assertions.assertThat((Long)this.metrics.getLastDurationOfFetchQueryInMilliseconds()).isEqualTo(100L);
        this.metrics.setLastDurationOfBatchCapturing(Duration.ofMillis(200L));
        Assertions.assertThat((Long)this.metrics.getLastDurationOfFetchQueryInMilliseconds()).isEqualTo(200L);
        Assertions.assertThat((Long)this.metrics.getMaxDurationOfFetchQueryInMilliseconds()).isEqualTo(200L);
        Assertions.assertThat((long)this.metrics.getFetchingQueryCount()).isEqualTo(2L);
        this.metrics.setCurrentLogFileName(new HashSet<String>(Arrays.asList("name", "name1")));
        Assertions.assertThat((boolean)this.metrics.getCurrentRedoLogFileName()[0].equals("name")).isTrue();
        Assertions.assertThat((boolean)this.metrics.getCurrentRedoLogFileName()[1].equals("name1")).isTrue();
        this.metrics.setSwitchCount(5);
        Assertions.assertThat((this.metrics.getSwitchCounter() == 5 ? 1 : 0) != 0).isTrue();
        this.metrics.reset();
        this.metrics.setLastDurationOfBatchCapturing(Duration.ofMillis(1000L));
        Assertions.assertThat((Long)this.metrics.getLastDurationOfFetchQueryInMilliseconds()).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getFetchingQueryCount()).isEqualTo(1L);
        this.metrics.reset();
        this.metrics.setLastCapturedDmlCount(300);
        this.metrics.setLastDurationOfBatchProcessing(Duration.ofMillis(1000L));
        Assertions.assertThat((int)this.metrics.getLastCapturedDmlCount()).isEqualTo(300);
        Assertions.assertThat((long)this.metrics.getLastBatchProcessingTimeInMilliseconds()).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getAverageBatchProcessingThroughput()).isGreaterThanOrEqualTo(300L);
        Assertions.assertThat((Long)this.metrics.getMaxCapturedDmlInBatch()).isEqualTo(300L);
        Assertions.assertThat((long)this.metrics.getMaxBatchProcessingThroughput()).isEqualTo(300L);
        this.metrics.setLastCapturedDmlCount(500);
        this.metrics.setLastDurationOfBatchProcessing(Duration.ofMillis(1000L));
        Assertions.assertThat((long)this.metrics.getAverageBatchProcessingThroughput()).isEqualTo(400L);
        Assertions.assertThat((Long)this.metrics.getMaxCapturedDmlInBatch()).isEqualTo(500L);
        Assertions.assertThat((long)this.metrics.getMaxBatchProcessingThroughput()).isEqualTo(500L);
        Assertions.assertThat((long)this.metrics.getLastBatchProcessingThroughput()).isEqualTo(500L);
        this.metrics.setLastDurationOfBatchProcessing(Duration.ofMillis(5000L));
        Assertions.assertThat((long)this.metrics.getLastBatchProcessingThroughput()).isEqualTo(100L);
        this.metrics.setLastDurationOfBatchProcessing(Duration.ZERO);
        Assertions.assertThat((long)this.metrics.getLastBatchProcessingThroughput()).isEqualTo(0L);
        Assertions.assertThat((int)this.metrics.getHoursToKeepTransactionInBuffer()).isEqualTo(0);
        Assertions.assertThat((long)this.metrics.getMillisecondsToKeepTransactionsInBuffer()).isEqualTo(0L);
        this.metrics.setRedoLogStatus(Collections.singletonMap("name", "current"));
        Assertions.assertThat((boolean)this.metrics.getRedoLogStatus()[0].equals("name | current")).isTrue();
        Assertions.assertThat((boolean)this.metrics.toString().contains("logMinerQueryCount"));
        this.metrics.incrementNetworkConnectionProblemsCounter();
        Assertions.assertThat((long)this.metrics.getNetworkConnectionProblemsCounter()).isEqualTo(1L);
        this.metrics.setBatchSize(5000);
        this.metrics.changeBatchSize(true, false);
        Assertions.assertThat((int)this.metrics.getBatchSize()).isEqualTo(6000);
        this.metrics.changeBatchSize(false, false);
        Assertions.assertThat((int)this.metrics.getBatchSize()).isEqualTo(5000);
    }

    @Test
    public void testLagMetrics() {
        long lag = this.metrics.getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(0L);
        Instant dbEventTime = this.fixedClock.instant().minusMillis(2000L);
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(2000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSourceInMilliseconds()).isEqualTo(2000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSourceInMilliseconds()).isEqualTo(2000L);
        dbEventTime = this.fixedClock.instant().plusMillis(3000L);
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(3000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSourceInMilliseconds()).isEqualTo(3000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSourceInMilliseconds()).isEqualTo(2000L);
        this.metrics.reset();
        OffsetDateTime dbTime = OffsetDateTime.parse("2021-05-16T00:30:01.00+12:00");
        this.metrics.calculateTimeDifference(dbTime);
        dbEventTime = Instant.parse("2021-05-16T00:29:58.00Z");
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(3000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSourceInMilliseconds()).isEqualTo(3000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSourceInMilliseconds()).isEqualTo(3000L);
        dbEventTime = Instant.parse("2021-05-16T00:29:57.00Z");
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(4000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSourceInMilliseconds()).isEqualTo(4000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSourceInMilliseconds()).isEqualTo(3000L);
        this.metrics.reset();
        dbTime = OffsetDateTime.parse("2021-05-15T12:30:01.00Z");
        this.metrics.calculateTimeDifference(dbTime);
        dbEventTime = Instant.parse("2021-05-15T12:29:58.00Z");
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(3000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSourceInMilliseconds()).isEqualTo(3000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSourceInMilliseconds()).isEqualTo(3000L);
        dbEventTime = Instant.parse("2021-05-15T12:29:57.00Z");
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(4000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSourceInMilliseconds()).isEqualTo(4000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSourceInMilliseconds()).isEqualTo(3000L);
        this.metrics.reset();
        dbTime = OffsetDateTime.parse("2021-05-15T00:30:01.00-12:00");
        this.metrics.calculateTimeDifference(dbTime);
        dbEventTime = Instant.parse("2021-05-15T00:29:58.00Z");
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(3000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSourceInMilliseconds()).isEqualTo(3000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSourceInMilliseconds()).isEqualTo(3000L);
        dbEventTime = Instant.parse("2021-05-15T00:29:57.00Z");
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(4000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSourceInMilliseconds()).isEqualTo(4000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSourceInMilliseconds()).isEqualTo(3000L);
        this.metrics.reset();
        dbTime = OffsetDateTime.parse("2021-05-16T00:29:59.00+12:00");
        this.metrics.calculateTimeDifference(dbTime);
        dbEventTime = Instant.parse("2021-05-16T00:29:58.00Z");
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSourceInMilliseconds()).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSourceInMilliseconds()).isEqualTo(1000L);
        dbTime = OffsetDateTime.parse("2021-05-15T12:29:59.00Z");
        this.metrics.calculateTimeDifference(dbTime);
        dbEventTime = Instant.parse("2021-05-15T12:29:58.00Z");
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSourceInMilliseconds()).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSourceInMilliseconds()).isEqualTo(1000L);
        dbTime = OffsetDateTime.parse("2021-05-15T00:29:59.00-12:00");
        this.metrics.calculateTimeDifference(dbTime);
        dbEventTime = Instant.parse("2021-05-15T00:29:58.00Z");
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSourceInMilliseconds()).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSourceInMilliseconds()).isEqualTo(1000L);
    }

    @Test
    public void testOtherMetrics() {
        this.metrics.incrementScnFreezeCount();
        Assertions.assertThat((int)this.metrics.getScnFreezeCount()).isEqualTo(1);
        this.metrics.incrementErrorCount();
        Assertions.assertThat((int)this.metrics.getErrorCount()).isEqualTo(1);
        this.metrics.incrementWarningCount();
        Assertions.assertThat((int)this.metrics.getWarningCount()).isEqualTo(1);
        this.metrics.incrementCommittedDmlCount(5000L);
        for (int i = 0; i < 1000; ++i) {
            this.metrics.incrementRegisteredDmlCount();
            this.metrics.incrementCommittedTransactions();
        }
        Assertions.assertThat((long)this.metrics.getRegisteredDmlCount()).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getNumberOfCommittedTransactions()).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getCommitThroughput()).isGreaterThanOrEqualTo(1000L);
        this.metrics.incrementOversizedTransactions();
        Assertions.assertThat((long)this.metrics.getNumberOfOversizedTransactions()).isEqualTo(1L);
        this.metrics.incrementRolledBackTransactions();
        Assertions.assertThat((long)this.metrics.getNumberOfRolledBackTransactions()).isEqualTo(1L);
        this.metrics.setActiveTransactions(5L);
        Assertions.assertThat((long)this.metrics.getNumberOfActiveTransactions()).isEqualTo(5L);
        this.metrics.addRolledBackTransactionId("rolledback id");
        Assertions.assertThat((long)this.metrics.getNumberOfRolledBackTransactions()).isEqualTo(1L);
        Assertions.assertThat((boolean)this.metrics.getRolledBackTransactionIds().contains("rolledback id")).isTrue();
        this.metrics.addAbandonedTransactionId("abandoned id");
        Assertions.assertThat((int)this.metrics.getAbandonedTransactionIds().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.metrics.getAbandonedTransactionIds().contains("abandoned id")).isTrue();
        this.metrics.setOldestScn(Scn.valueOf((long)10L));
        Assertions.assertThat((BigInteger)this.metrics.getOldestScn()).isEqualTo("10");
        this.metrics.setCommittedScn(Scn.valueOf((long)10L));
        Assertions.assertThat((BigInteger)this.metrics.getCommittedScn()).isEqualTo("10");
        Assertions.assertThat((boolean)this.metrics.toString().contains("registeredDmlCount=1000")).isTrue();
        this.metrics.setLastCommitDuration(Duration.ofMillis(100L));
        Assertions.assertThat((long)this.metrics.getLastCommitDurationInMilliseconds()).isEqualTo(100L);
        this.metrics.setLastCommitDuration(Duration.ofMillis(50L));
        Assertions.assertThat((long)this.metrics.getMaxCommitDurationInMilliseconds()).isEqualTo(100L);
        this.metrics.setOffsetScn(Scn.valueOf((long)10L));
        Assertions.assertThat((BigInteger)this.metrics.getOldestScn()).isEqualTo("10");
    }

    @Test
    @FixFor(value={"DBZ-2754"})
    public void testCustomTransactionRetention() throws Exception {
        this.init((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.LOG_MINING_TRANSACTION_RETENTION, 3));
        Assertions.assertThat((int)this.metrics.getHoursToKeepTransactionInBuffer()).isEqualTo(3);
        Assertions.assertThat((long)this.metrics.getMillisecondsToKeepTransactionsInBuffer()).isEqualTo(10800000L);
    }

    @Test
    @FixFor(value={"DBZ-5179"})
    public void testRollbackTransactionIdSetSizeLimit() throws Exception {
        this.init((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.LOG_MINING_TRANSACTION_RETENTION, 3));
        for (int i = 1; i <= 10; ++i) {
            this.metrics.addRolledBackTransactionId(String.valueOf(i));
        }
        Assertions.assertThat((Iterable)this.metrics.getRolledBackTransactionIds()).containsOnly((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        this.metrics.addRolledBackTransactionId("11");
        Assertions.assertThat((Iterable)this.metrics.getRolledBackTransactionIds()).containsOnly((Object[])new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11"});
        this.metrics.addRolledBackTransactionId("11");
        Assertions.assertThat((Iterable)this.metrics.getRolledBackTransactionIds()).containsOnly((Object[])new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11"});
    }

    @Test
    @FixFor(value={"DBZ-5179"})
    public void testAbandonedTransactionIdSetSizeLimit() throws Exception {
        this.init((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.LOG_MINING_TRANSACTION_RETENTION, 3));
        for (int i = 1; i <= 10; ++i) {
            this.metrics.addAbandonedTransactionId(String.valueOf(i));
        }
        Assertions.assertThat((Iterable)this.metrics.getAbandonedTransactionIds()).containsOnly((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        this.metrics.addAbandonedTransactionId("11");
        Assertions.assertThat((Iterable)this.metrics.getAbandonedTransactionIds()).containsOnly((Object[])new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11"});
        this.metrics.addAbandonedTransactionId("11");
        Assertions.assertThat((Iterable)this.metrics.getAbandonedTransactionIds()).containsOnly((Object[])new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11"});
    }

    private void init(Configuration.Builder builder) {
        this.connectorConfig = new OracleConnectorConfig(builder.build());
        ChangeEventQueue queue = new ChangeEventQueue.Builder().pollInterval(Duration.of(8192L, ChronoUnit.MILLIS)).maxBatchSize(2048).maxQueueSize(8192).build();
        OracleTaskContext taskContext = (OracleTaskContext)Mockito.mock(OracleTaskContext.class);
        Mockito.when((Object)taskContext.getConnectorName()).thenReturn((Object)"connector name");
        Mockito.when((Object)taskContext.getConnectorType()).thenReturn((Object)"connector type");
        OracleEventMetadataProvider metadataProvider = new OracleEventMetadataProvider();
        this.fixedClock = Clock.fixed(Instant.parse("2021-05-15T12:30:00.00Z"), ZoneOffset.UTC);
        this.metrics = new OracleStreamingChangeEventSourceMetrics((CdcSourceTaskContext)taskContext, (ChangeEventQueueMetrics)queue, (EventMetadataProvider)metadataProvider, this.connectorConfig, this.fixedClock);
    }
}

