/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.CommitScn;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.AbstractSchemaHistoryTest;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.TableChanges;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;

public class OracleSchemaHistoryTest
extends AbstractSchemaHistoryTest {
    protected HistoryRecord getRenameCreateHistoryRecord() {
        return new HistoryRecord(Map.of("server", "server1"), Map.of("snapshot_scn", "1", "snapshot", true, "scn", "1", "snapshot_completed", false), TestHelper.getDatabaseName(), "DEBEZIUM", "CREATE TABLE \"DEBEZIUM\".\"DBZ4451A\" (\"ID\" NUMBER(9,0), PRIMARY KEY(\"ID\");", new TableChanges().create(this.getTableToBeRenamed()), Instant.now());
    }

    protected HistoryRecord getRenameAlterHistoryRecord() {
        Table oldTable = this.getTableToBeRenamed();
        TableId oldTableId = oldTable.id();
        Table table = oldTable.edit().tableId(this.getRenameTableId()).create();
        return new HistoryRecord(Map.of("server", "server1"), Map.of("snapshot_scn", "2", "scn", "2", "commit_scn", "2"), TestHelper.getDatabaseName(), "DEBEZIUM", "ALTER TABLE DBZ4451A RENAME TO DBZ4451B;", new TableChanges().rename(table, oldTableId), Instant.now());
    }

    protected TableId getRenameTableId() {
        return TableId.parse((String)"ORCLPDB1.DEBEZIUM.DBZ4451B");
    }

    protected Offsets<Partition, OffsetContext> getOffsets() {
        OraclePartition source = new OraclePartition("server1", TestHelper.getDatabaseName());
        Configuration config = ((Configuration.Builder)Configuration.empty().edit().with(CommonConnectorConfig.TOPIC_PREFIX, "server1")).build();
        OracleOffsetContext position = new OracleOffsetContext(new OracleConnectorConfig(config), Scn.valueOf((int)999), CommitScn.valueOf((Long)999L), null, Scn.valueOf((int)999), Collections.emptyMap(), false, true, new TransactionContext(), (IncrementalSnapshotContext)new SignalBasedIncrementalSnapshotContext());
        return Offsets.of((Partition)source, (OffsetContext)position);
    }

    protected DdlParser getDdlParser() {
        return new OracleDdlParser();
    }

    private Table getTableToBeRenamed() {
        TableId tableId = TableId.parse((String)"ORCLPDB1.DEBEZIUM.DBZ4451A");
        return Table.editor().tableId(tableId).addColumn(Column.editor().name("ID").type("NUMBER").length(9).scale(Integer.valueOf(0)).jdbcType(2).optional(false).create()).setPrimaryKeyNames(new String[]{"ID"}).create();
    }
}

