/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.junit.SkipTestRule;
import io.debezium.pipeline.AbstractBlockingSnapshotTest;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;

public class BlockingSnapshotIT
extends AbstractBlockingSnapshotTest {
    private OracleConnection connection;
    @Rule
    public SkipTestRule skipRule = new SkipTestRule();

    @Before
    public void before() throws Exception {
        this.connection = TestHelper.testConnection();
        TestHelper.dropTable(this.connection, "a");
        TestHelper.dropTable(this.connection, "b");
        this.connection.execute(new String[]{"CREATE TABLE a (pk numeric(9,0) primary key, aa numeric(9,0))"});
        this.connection.execute(new String[]{"CREATE TABLE b (pk numeric(9,0) primary key, aa numeric(9,0))"});
        this.connection.execute(new String[]{"GRANT INSERT on a to " + TestHelper.getConnectorUserName()});
        this.connection.execute(new String[]{"GRANT INSERT on b to " + TestHelper.getConnectorUserName()});
        TestHelper.streamTable(this.connection, "a");
        TestHelper.streamTable(this.connection, "b");
        TestHelper.dropTable(this.connection, "debezium_signal");
        this.connection.execute(new String[]{"CREATE TABLE debezium_signal (id varchar2(64), type varchar2(32), data varchar2(2048))"});
        this.connection.execute(new String[]{"GRANT INSERT on debezium_signal to " + TestHelper.getConnectorUserName()});
        TestHelper.streamTable(this.connection, "debezium_signal");
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws Exception {
        this.stopConnector();
        if (this.connection != null) {
            TestHelper.dropTable(this.connection, "a");
            TestHelper.dropTable(this.connection, "b");
            TestHelper.dropTable(this.connection, "debezium_signal");
            this.connection.close();
        }
    }

    protected void waitForConnectorToStart() {
        super.waitForConnectorToStart();
        try {
            BlockingSnapshotIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected Class<OracleConnector> connectorClass() {
        return OracleConnector.class;
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected String topicName() {
        return "server1.DEBEZIUM.A";
    }

    protected List<String> topicNames() {
        return List.of("server1.DEBEZIUM.A", "server1.DEBEZIUM.B");
    }

    protected String tableName() {
        return "DEBEZIUM.A";
    }

    protected List<String> tableNames() {
        return List.of("DEBEZIUM.A", "DEBEZIUM.B");
    }

    protected String tableDataCollectionId() {
        return TestHelper.getDatabaseName() + ".DEBEZIUM.A";
    }

    protected List<String> tableDataCollectionIds() {
        return List.of(TestHelper.getDatabaseName() + ".DEBEZIUM.A", TestHelper.getDatabaseName() + ".DEBEZIUM.B");
    }

    protected String signalTableName() {
        return "DEBEZIUM.DEBEZIUM_SIGNAL";
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL)).with(OracleConnectorConfig.SIGNAL_DATA_COLLECTION, TestHelper.getDatabaseName() + ".DEBEZIUM.DEBEZIUM_SIGNAL")).with(OracleConnectorConfig.SCHEMA_INCLUDE_LIST, "DEBEZIUM")).with(OracleConnectorConfig.SNAPSHOT_MODE_TABLES, TestHelper.getDatabaseName() + ".DEBEZIUM.A")).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true);
    }

    protected Configuration.Builder mutableConfig(boolean signalTableOnly, boolean storeOnlyCapturedDdl) {
        return this.config();
    }

    protected String valueFieldName() {
        return "AA";
    }

    protected String pkFieldName() {
        return "PK";
    }

    protected String alterTableAddColumnStatement(String tableName) {
        return "ALTER TABLE " + tableName + " ADD col3 INTEGER DEFAULT 0";
    }

    protected String connector() {
        return "oracle";
    }

    protected String server() {
        return "server1";
    }
}

