/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.olr.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.olr.client.OlrNetworkClientException;
import io.debezium.connector.oracle.olr.client.StreamingEvent;
import io.debezium.connector.oracle.proto.OpenLogReplicatorProtocol;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlrNetworkClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(OlrNetworkClient.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final String hostName;
    private final int port;
    private final String sourceName;
    private SocketChannel channel;
    private boolean skipToStartScn;
    private Scn startScn;
    private long prevScn;

    public OlrNetworkClient(OracleConnectorConfig connectorConfig) {
        this.hostName = connectorConfig.getOpenLogReplicatorHostname();
        this.port = connectorConfig.getOpenLogReplicatorPort();
        this.sourceName = connectorConfig.getOpenLogReplicatorSource();
    }

    public boolean connect(Scn scn) {
        if (scn == null || scn.isNull()) {
            throw new OlrNetworkClientException("Cannot connect and start with a null system change number");
        }
        try {
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(true);
            if (this.channel.connect(new InetSocketAddress(this.hostName, this.port))) {
                this.startScn = scn;
                return this.startFrom(scn);
            }
            return false;
        }
        catch (IOException e) {
            throw new OlrNetworkClientException("Failed to connect and start", e);
        }
    }

    public void disconnect() {
        block6: {
            try {
                if (!this.channel.isOpen()) break block6;
                try {
                    this.channel.shutdownInput();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.channel.shutdownOutput();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.channel.close();
            }
            catch (IOException e) {
                throw new OlrNetworkClientException("Failed to disconnect client.", e);
            }
        }
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public StreamingEvent readEvent() throws OlrNetworkClientException {
        StreamingEvent event = this.skipToStartScn ? this.readNextEventWithStartScnSkip() : this.readNextEvent();
        LOGGER.trace("Received Event: {}", (Object)event);
        return event;
    }

    public void confirm(Scn scn) {
        this.confirm(scn.longValue());
    }

    private StreamingEvent readNextEventWithStartScnSkip() {
        boolean notifySkip = true;
        StreamingEvent event = null;
        while (this.skipToStartScn) {
            event = this.readNextEvent();
            if (event.getEventScn().compareTo(this.startScn) < 0) {
                if (!notifySkip) continue;
                LOGGER.info("Advancing change stream to SCN {}", (Object)this.startScn);
                notifySkip = false;
                continue;
            }
            this.skipToStartScn = false;
        }
        LOGGER.info("Stream advanced, reading stream starting at {}", (Object)event.getScn());
        return event;
    }

    private StreamingEvent readNextEvent() {
        String data = new String(this.read().array(), StandardCharsets.UTF_8);
        try {
            return (StreamingEvent)this.mapper.readValue(data, StreamingEvent.class);
        }
        catch (JsonProcessingException e) {
            throw new OlrNetworkClientException("Failed to deserialize network packet: " + data, e);
        }
    }

    private void confirm(long newScn) {
        if (this.prevScn != 0L && this.prevScn < newScn) {
            LOGGER.debug("Confirming SCN {}", (Object)newScn);
            this.send(this.createRequest(OpenLogReplicatorProtocol.RequestCode.CONFIRM).setScn(newScn).build());
        }
        this.prevScn = newScn;
    }

    private boolean startFrom(Scn scn) {
        LOGGER.info("Streaming will start at SCN {}.", (Object)scn);
        this.send(this.createRequest(OpenLogReplicatorProtocol.RequestCode.INFO).build());
        OpenLogReplicatorProtocol.RedoResponse response = this.readResponse();
        if (response.getCode() == OpenLogReplicatorProtocol.ResponseCode.READY) {
            LOGGER.info("OpenLogReplicator ready, streaming from SCN {}.", (Object)scn);
            this.send(this.createRequest(OpenLogReplicatorProtocol.RequestCode.START).setScn(scn.longValue()).build());
            for (int attempts = 5; attempts >= 0; --attempts) {
                response = this.readResponse();
                if (response.getCode() == OpenLogReplicatorProtocol.ResponseCode.STARTED || response.getCode() == OpenLogReplicatorProtocol.ResponseCode.ALREADY_STARTED) {
                    if (response.getCode() == OpenLogReplicatorProtocol.ResponseCode.ALREADY_STARTED) {
                        LOGGER.info("OpenLogReplicator already started at {}.", (Object)response.getScn());
                        if (Scn.valueOf(response.getScn()).compareTo(scn) < 0) {
                            this.skipToStartScn = true;
                        }
                    }
                    this.send(this.createRequest(OpenLogReplicatorProtocol.RequestCode.REDO).build());
                    break;
                }
                if (attempts == 0) {
                    LOGGER.error("Failed to restart, OpenLogReplicator client shutting down.");
                    return false;
                }
                if (response.getCode() == OpenLogReplicatorProtocol.ResponseCode.FAILED_START) {
                    LOGGER.warn("OpenLogReplicator failed to start, attempting to start again.");
                    this.send(this.createRequest(OpenLogReplicatorProtocol.RequestCode.START).setScn(scn.longValue()).build());
                    continue;
                }
                throw new OlrNetworkClientException("Unexpected response: " + response.getCode());
            }
        } else if (response.getCode() == OpenLogReplicatorProtocol.ResponseCode.STARTED) {
            Scn startScn = Scn.valueOf(response.getScn());
            if (startScn.compareTo(scn) < 0) {
                this.skipToStartScn = true;
            }
            LOGGER.info("OpenLogReplicator already started, SCN {}.", (Object)startScn);
            this.send(this.createRequest(OpenLogReplicatorProtocol.RequestCode.REDO).build());
        } else {
            LOGGER.warn("Failed to get proper response from INFO request.");
            return false;
        }
        response = this.readResponse();
        if (response.getCode() != OpenLogReplicatorProtocol.ResponseCode.STREAMING) {
            LOGGER.warn("Server failed to enter streaming mode, OpenLogReplicator client shutting down.");
            return false;
        }
        LOGGER.info("OpenLogReplicator streaming client started successfully.");
        return true;
    }

    private OpenLogReplicatorProtocol.RedoRequest.Builder createRequest(OpenLogReplicatorProtocol.RequestCode requestCode) {
        return OpenLogReplicatorProtocol.RedoRequest.newBuilder().setCode(requestCode).setDatabaseName(this.sourceName);
    }

    private OpenLogReplicatorProtocol.RedoResponse readResponse() {
        try {
            return OpenLogReplicatorProtocol.RedoResponse.parseFrom(this.read().array());
        }
        catch (IOException e) {
            throw new OlrNetworkClientException("Failed to read response", e);
        }
    }

    private ByteBuffer read() {
        ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
        sizeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.fillBuffer(sizeBuffer);
        int messageSize = sizeBuffer.getInt();
        ByteBuffer payload = ByteBuffer.allocate(messageSize);
        this.fillBuffer(payload);
        return payload;
    }

    private int send(OpenLogReplicatorProtocol.RedoRequest request) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(4 + request.getSerializedSize());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(request.getSerializedSize());
            buffer.put(request.toByteArray());
            buffer.flip();
            return this.channel.write(buffer);
        }
        catch (IOException e) {
            throw new OlrNetworkClientException("Failed to send request to server", e);
        }
    }

    private void fillBuffer(ByteBuffer buffer) {
        try {
            int bytesRead;
            for (int remaining = buffer.remaining(); remaining > 0; remaining -= bytesRead) {
                bytesRead = this.channel.read(buffer);
                if (bytesRead != -1) continue;
                throw new OlrNetworkClientException("Connection lost");
            }
            buffer.flip();
        }
        catch (IOException e) {
            throw new OlrNetworkClientException("Failed to fill byte buffer", e);
        }
    }
}

