/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Path;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.xdb.XMLType;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class OracleXmlDataTypesIT
extends AbstractConnectorTest {
    private static final String XML_DATA = Testing.Files.readResourceAsString((String)"data/test_xml_data_short.xml");
    private static final String XML_DATA2 = Testing.Files.readResourceAsString((String)"data/test_xml_data_short2.xml");
    private static final String XML_LONG_DATA = Testing.Files.readResourceAsString((String)"data/test_xml_data_long.xml");
    private static final String XML_LONG_DATA2 = Testing.Files.readResourceAsString((String)"data/test_xml_data_long2.xml");
    @Rule
    public final TestRule skipAdapterRule = new SkipTestDependingOnAdapterNameRule();
    private OracleConnection connection;

    @Before
    public void before() {
        this.connection = TestHelper.testConnection();
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldSnapshotTableWithXmlTypeColumnWithSimpleXmlData() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA xmltype, primary key(ID))"});
            TestHelper.streamTable(this.connection, "dbz3605");
            String xml = "<?xml version=\"1.0\"?><warehouse></warehouse>";
            this.connection.execute(new String[]{"insert into dbz3605 values (1, xmltype('<?xml version=\"1.0\"?><warehouse></warehouse>'))"});
            Configuration config = ((Configuration.Builder)this.getDefaultXmlConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleXmlDataTypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
            Struct after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", "<?xml version=\"1.0\"?><warehouse></warehouse>");
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldSnapshotTableWithXmlTypeColumnWithShortXmlData() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA xmltype, primary key(ID))"});
            TestHelper.streamTable(this.connection, "dbz3605");
            String xml = XML_DATA;
            this.connection.prepareQuery("insert into dbz3605 values (1,xmltype(?))", ps -> ps.setObject(1, xml), null);
            this.connection.commit();
            Configuration config = ((Configuration.Builder)this.getDefaultXmlConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleXmlDataTypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
            Struct after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", xml);
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldSnapshotTableWithXmlTypeColumnWithLongXmlData() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA xmltype, primary key(ID))"});
            TestHelper.streamTable(this.connection, "dbz3605");
            String xml = XML_LONG_DATA;
            this.connection.prepareQuery("insert into dbz3605 values (1,?)", ps -> ps.setObject(1, this.toXmlType(xml)), null);
            this.connection.commit();
            Configuration config = ((Configuration.Builder)this.getDefaultXmlConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleXmlDataTypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
            Struct after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", xml);
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldStreamTableWithXmlTypeColumnWithSimpleXmlData() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA xmltype, primary key(ID))"});
            TestHelper.streamTable(this.connection, "dbz3605");
            Configuration config = ((Configuration.Builder)this.getDefaultXmlConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleXmlDataTypesIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            String xml = "<?xml version=\"1.0\"?><warehouse></warehouse>";
            this.connection.execute(new String[]{"insert into dbz3605 values (1, xmltype('<?xml version=\"1.0\"?><warehouse></warehouse>'))"});
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
            Struct after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", "<?xml version=\"1.0\"?><warehouse></warehouse>");
            String updateXml = "<?xml version=\"1.0\"?><warehouse><dept>25</dept></warehouse>";
            this.connection.execute(new String[]{"UPDATE dbz3605 SET data = xmltype('<?xml version=\"1.0\"?><warehouse><dept>25</dept></warehouse>') WHERE id = 1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
            after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", "<?xml version=\"1.0\"?><warehouse><dept>25</dept></warehouse>");
            this.connection.execute(new String[]{"DELETE FROM dbz3605 WHERE id = 1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
            after = OracleXmlDataTypesIT.before(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertFieldIsUnavailablePlaceholder(after, "DATA", config);
            Assertions.assertThat((Object)OracleXmlDataTypesIT.after(record)).isNull();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldStreamTableWithXmlTypeColumnWithShortXmlData() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA xmltype, primary key(ID))"});
            TestHelper.streamTable(this.connection, "dbz3605");
            Configuration config = ((Configuration.Builder)this.getDefaultXmlConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleXmlDataTypesIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            String xml = XML_DATA;
            this.connection.prepareQuery("insert into dbz3605 values (1, xmltype(?))", ps -> ps.setObject(1, xml), null);
            this.connection.commit();
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
            Struct after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", xml);
            String updateXml = XML_DATA2;
            this.connection.prepareQuery("UPDATE dbz3605 SET data = xmltype(?) WHERE id=1", ps -> ps.setObject(1, updateXml), null);
            this.connection.commit();
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
            after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", updateXml);
            this.connection.execute(new String[]{"DELETE FROM dbz3605 WHERE id = 1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
            after = OracleXmlDataTypesIT.before(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertFieldIsUnavailablePlaceholder(after, "DATA", config);
            Assertions.assertThat((Object)OracleXmlDataTypesIT.after(record)).isNull();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldStreamTableWithXmlTypeColumnWithLongXmlData() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA xmltype, primary key(ID))"});
            TestHelper.streamTable(this.connection, "dbz3605");
            Configuration config = ((Configuration.Builder)this.getDefaultXmlConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleXmlDataTypesIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            String xml = XML_LONG_DATA;
            this.connection.prepareQuery("insert into dbz3605 values (1,?)", ps -> ps.setObject(1, this.toXmlType(xml)), null);
            this.connection.commit();
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
            Struct after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", xml);
            String updateXml = XML_LONG_DATA2;
            this.connection.prepareQuery("UPDATE dbz3605 SET data = ? WHERE id=1", ps -> ps.setObject(1, this.toXmlType(updateXml)), null);
            this.connection.commit();
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
            after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", updateXml);
            this.connection.execute(new String[]{"DELETE FROM dbz3605 WHERE id = 1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
            after = OracleXmlDataTypesIT.before(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertFieldIsUnavailablePlaceholder(after, "DATA", config);
            Assertions.assertThat((Object)OracleXmlDataTypesIT.after(record)).isNull();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldStreamTableWithXmlTypeColumnAndOtherNonLobColumns() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA xmltype, DATA2 varchar2(50))"});
            TestHelper.streamTable(this.connection, "dbz3605");
            Configuration config = ((Configuration.Builder)this.getDefaultXmlConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleXmlDataTypesIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            String xml = XML_LONG_DATA;
            this.connection.prepareQuery("insert into dbz3605 values (1,?,'Acme')", ps -> ps.setObject(1, this.toXmlType(xml)), null);
            this.connection.commit();
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidInsert((SourceRecord)record, (boolean)false);
            Struct after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", xml);
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Acme");
            String updateXml = XML_LONG_DATA2;
            this.connection.prepareQuery("UPDATE dbz3605 SET data = ? WHERE id=1", ps -> ps.setObject(1, this.toXmlType(updateXml)), null);
            this.connection.commit();
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (boolean)false);
            after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", updateXml);
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Acme");
            this.connection.prepareQuery("UPDATE dbz3605 SET data = ?, DATA2 = 'Data' WHERE id=1", ps -> ps.setObject(1, this.toXmlType(xml)), null);
            this.connection.commit();
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (boolean)false);
            after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", xml);
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Data");
            this.connection.execute(new String[]{"UPDATE dbz3605 SET DATA2 = 'Acme' WHERE id=1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (boolean)false);
            after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertFieldIsUnavailablePlaceholder(after, "DATA", config);
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Acme");
            this.connection.execute(new String[]{"DELETE FROM dbz3605 WHERE id = 1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidDelete((SourceRecord)record, (boolean)false);
            after = OracleXmlDataTypesIT.before(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertFieldIsUnavailablePlaceholder(after, "DATA", config);
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Acme");
            Assertions.assertThat((Object)OracleXmlDataTypesIT.after(record)).isNull();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldStreamTableWithNoPrimaryKeyWithXmlTypeColumn() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA xmltype)"});
            TestHelper.streamTable(this.connection, "dbz3605");
            Configuration config = ((Configuration.Builder)this.getDefaultXmlConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleXmlDataTypesIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            String xml = XML_LONG_DATA;
            this.connection.prepareQuery("insert into dbz3605 values (1,?)", ps -> ps.setObject(1, this.toXmlType(xml)), null);
            this.connection.commit();
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidInsert((SourceRecord)record, (boolean)false);
            Struct after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", xml);
            String updateXml = XML_LONG_DATA2;
            this.connection.prepareQuery("UPDATE dbz3605 SET data = ? WHERE id=1", ps -> ps.setObject(1, this.toXmlType(updateXml)), null);
            this.connection.commit();
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (boolean)false);
            after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", updateXml);
            this.connection.execute(new String[]{"DELETE FROM dbz3605 WHERE id = 1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidDelete((SourceRecord)record, (boolean)false);
            after = OracleXmlDataTypesIT.before(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertFieldIsUnavailablePlaceholder(after, "DATA", config);
            Assertions.assertThat((Object)OracleXmlDataTypesIT.after(record)).isNull();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldStreamTableWithXmlTypeColumnAndAnotherLobColumn() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA xmltype, DATA2 clob)"});
            TestHelper.streamTable(this.connection, "dbz3605");
            Configuration config = ((Configuration.Builder)this.getDefaultXmlConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleXmlDataTypesIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            String xml = XML_LONG_DATA;
            Clob clob = this.connection.connection().createClob();
            clob.setString(1L, XML_LONG_DATA);
            this.connection.prepareQuery("insert into dbz3605 values (1,?,?)", ps -> {
                ps.setObject(1, this.toXmlType(xml));
                ps.setClob(2, clob);
            }, null);
            this.connection.commit();
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidInsert((SourceRecord)record, (boolean)false);
            Struct after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", xml);
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)clob.getSubString(1L, (int)clob.length()));
            String updateXml = XML_LONG_DATA2;
            this.connection.prepareQuery("UPDATE dbz3605 SET data = ? WHERE id=1", ps -> ps.setObject(1, this.toXmlType(updateXml)), null);
            this.connection.commit();
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (boolean)false);
            after = OracleXmlDataTypesIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertXmlFieldIsEqual(after, "DATA", updateXml);
            OracleXmlDataTypesIT.assertFieldIsUnavailablePlaceholder(after, "DATA2", config);
            this.connection.execute(new String[]{"DELETE FROM dbz3605 WHERE id = 1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleXmlDataTypesIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidDelete((SourceRecord)record, (boolean)false);
            after = OracleXmlDataTypesIT.before(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            OracleXmlDataTypesIT.assertFieldIsUnavailablePlaceholder(after, "DATA", config);
            OracleXmlDataTypesIT.assertFieldIsUnavailablePlaceholder(after, "DATA2", config);
            Assertions.assertThat((Object)OracleXmlDataTypesIT.after(record)).isNull();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    private Configuration.Builder getDefaultXmlConfig() {
        return (Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.LOB_ENABLED, true);
    }

    private XMLType toXmlType(String data) throws SQLException {
        return XMLType.createXML((Connection)this.connection.connection(), (String)data, (String)"oracle.xml.parser.XMLDocument.THIN");
    }

    private static void assertFieldIsUnavailablePlaceholder(Struct after, String fieldName, Configuration config) {
        Assertions.assertThat((String)after.getString(fieldName)).isEqualTo((Object)config.getString(OracleConnectorConfig.UNAVAILABLE_VALUE_PLACEHOLDER));
    }

    private static void assertXmlFieldIsEqual(Struct after, String fieldName, String expected) {
        Assertions.assertThat((String)OracleXmlDataTypesIT.formatToOracleXml(after.getString(fieldName))).isEqualTo((Object)OracleXmlDataTypesIT.formatToOracleXml(expected));
    }

    private static String formatToOracleXml(String data) {
        if (data == null) {
            return null;
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            InputStream xslt = Testing.Files.readResourceAsStream((String)"xml-format.xslt");
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(xslt));
            StreamSource in = new StreamSource(new StringReader(data));
            StreamResult out = new StreamResult(new StringWriter());
            transformer.transform(in, out);
            return out.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse XML: " + data, e);
        }
    }

    private static String topicName(String tableName) {
        return "server1.DEBEZIUM." + tableName;
    }

    private static Struct before(SourceRecord record) {
        return ((Struct)record.value()).getStruct("before");
    }

    private static Struct after(SourceRecord record) {
        return ((Struct)record.value()).getStruct("after");
    }
}

