/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleCheckAdapter;
import org.jboss.byteman.agent.adapter.RuleCheckMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.type.Type;

public class IndexParamAccessCheckAdapter
extends RuleCheckAdapter {
    private int paramIdx;
    private int flags;
    private int count;

    public IndexParamAccessCheckAdapter(ClassVisitor cv, TransformContext transformContext, int paramIdx, int flags, int count) {
        super(cv, transformContext);
        this.paramIdx = paramIdx;
        this.flags = flags;
        this.count = count;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        int paramSlotIdx;
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matchTargetMethod(access, name, desc) && (paramSlotIdx = Type.paramSlotIdx(access, desc, this.paramIdx)) >= 0) {
            this.setVisited();
            return new IndexParamAccessCheckMethodAdapter(mv, this.getTransformContext(), paramSlotIdx, access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class IndexParamAccessCheckMethodAdapter
    extends RuleCheckMethodAdapter {
        private int access;
        private String name;
        private String descriptor;
        private String signature;
        private String[] exceptions;
        private int index;
        private int visitedCount;

        IndexParamAccessCheckMethodAdapter(MethodVisitor mv, TransformContext transformContext, int paramSlotIdx, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor);
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
            this.index = paramSlotIdx;
            this.visitedCount = 0;
        }

        private boolean matchCall(int opcode) {
            if (opcode < 54) {
                return (IndexParamAccessCheckAdapter.this.flags & 1) != 0;
            }
            return (IndexParamAccessCheckAdapter.this.flags & 2) != 0;
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            if (var == this.index && (IndexParamAccessCheckAdapter.this.count == 0 || this.visitedCount < IndexParamAccessCheckAdapter.this.count) && this.matchCall(opcode)) {
                ++this.visitedCount;
                if (IndexParamAccessCheckAdapter.this.count == 0 || this.visitedCount == IndexParamAccessCheckAdapter.this.count) {
                    this.setTriggerPoint();
                }
            }
            super.visitVarInsn(opcode, var);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            if (var == this.index && (IndexParamAccessCheckAdapter.this.count == 0 || this.visitedCount < IndexParamAccessCheckAdapter.this.count)) {
                ++this.visitedCount;
                if (IndexParamAccessCheckAdapter.this.count == 0 || this.visitedCount == IndexParamAccessCheckAdapter.this.count) {
                    this.setTriggerPoint();
                }
            }
            super.visitIincInsn(var, increment);
        }
    }
}

