/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.memory;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.connector.oracle.logminer.processor.AbstractLogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.AbstractTransaction;
import io.debezium.connector.oracle.logminer.processor.memory.MemoryTransaction;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.TableId;
import io.debezium.util.Loggings;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryLogMinerEventProcessor
extends AbstractLogMinerEventProcessor<MemoryTransaction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryLogMinerEventProcessor.class);
    private final OracleConnection jdbcConnection;
    private final EventDispatcher<OraclePartition, TableId> dispatcher;
    private final OraclePartition partition;
    private final OracleOffsetContext offsetContext;
    private final OracleStreamingChangeEventSourceMetrics metrics;
    private final Map<String, MemoryTransaction> transactionCache = new HashMap<String, MemoryTransaction>();
    private final Map<String, Scn> recentlyProcessedTransactionsCache = new HashMap<String, Scn>();
    private final Set<Scn> schemaChangesCache = new HashSet<Scn>();
    private final Set<String> abandonedTransactionsCache = new HashSet<String>();

    public MemoryLogMinerEventProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<OraclePartition, TableId> dispatcher, OraclePartition partition, OracleOffsetContext offsetContext, OracleDatabaseSchema schema, OracleStreamingChangeEventSourceMetrics metrics) {
        super(context, connectorConfig, schema, partition, offsetContext, dispatcher, metrics);
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.partition = partition;
        this.offsetContext = offsetContext;
        this.metrics = metrics;
    }

    @Override
    protected Map<String, MemoryTransaction> getTransactionCache() {
        return this.transactionCache;
    }

    @Override
    protected MemoryTransaction createTransaction(LogMinerEventRow row) {
        return new MemoryTransaction(row.getTransactionId(), row.getScn(), row.getChangeTime(), row.getUserName(), row.getThread());
    }

    @Override
    protected void removeEventWithRowId(LogMinerEventRow row) {
        MemoryTransaction transaction = this.getTransactionCache().get(row.getTransactionId());
        if (transaction == null) {
            if (this.isTransactionIdWithNoSequence(row.getTransactionId())) {
                String transactionPrefix = this.getTransactionIdPrefix(row.getTransactionId());
                LOGGER.debug("Undo change refers to a transaction that has no explicit sequence, '{}'", (Object)row.getTransactionId());
                LOGGER.debug("Checking all transactions with prefix '{}'", (Object)transactionPrefix);
                for (String transactionKey : this.getTransactionCache().keySet()) {
                    if (!transactionKey.startsWith(transactionPrefix) || (transaction = this.getTransactionCache().get(transactionKey)) == null || !transaction.removeEventWithRowId(row.getRowId())) continue;
                    Loggings.logDebugAndTraceRecord((Logger)LOGGER, (Object)row, (String)"Undo change on table '{}' was applied to transaction '{}'", (Object[])new Object[]{row.getTableId(), transactionKey});
                    return;
                }
                Loggings.logWarningAndTraceRecord((Logger)LOGGER, (Object)row, (String)"Cannot undo change on table '{}' since event with row-id {} was not found", (Object[])new Object[]{row.getTableId(), row.getRowId()});
            } else if (!this.getConfig().isLobEnabled()) {
                Loggings.logWarningAndTraceRecord((Logger)LOGGER, (Object)row, (String)"Cannot undo change on table '{}' since transaction '{}' was not found.", (Object[])new Object[]{row.getTableId(), row.getTransactionId()});
            }
        } else if (!transaction.removeEventWithRowId(row.getRowId())) {
            Loggings.logWarningAndTraceRecord((Logger)LOGGER, (Object)row, (String)"Cannot undo change on table '{}' since event with row-id {} was not found.", (Object[])new Object[]{row.getTableId(), row.getRowId()});
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void abandonTransactions(Duration retention) throws InterruptedException {
        Optional<Scn> lastScnToAbandonTransactions;
        if (!Duration.ZERO.equals(retention) && (lastScnToAbandonTransactions = this.getLastScnToAbandon(this.jdbcConnection, retention)).isPresent()) {
            Scn thresholdScn = lastScnToAbandonTransactions.get();
            Scn smallestScn = this.getTransactionCacheMinimumScn();
            if (!smallestScn.isNull() && thresholdScn.compareTo(smallestScn) >= 0) {
                boolean first = true;
                Iterator<Map.Entry<String, MemoryTransaction>> iterator = this.transactionCache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, MemoryTransaction> entry = iterator.next();
                    if (entry.getValue().getStartScn().compareTo(thresholdScn) > 0) continue;
                    if (first) {
                        LOGGER.warn("All transactions with SCN <= {} will be abandoned.", (Object)thresholdScn);
                        first = false;
                    }
                    LOGGER.warn("Transaction {} (start SCN {}, change time {}, redo thread {}, {} events) is being abandoned.", new Object[]{entry.getKey(), entry.getValue().getStartScn(), entry.getValue().getChangeTime(), entry.getValue().getRedoThreadId(), entry.getValue().getNumberOfEvents()});
                    this.abandonedTransactionsCache.add(entry.getKey());
                    iterator.remove();
                    this.metrics.addAbandonedTransactionId(entry.getKey());
                    this.metrics.setActiveTransactions(this.transactionCache.size());
                }
                smallestScn = this.getTransactionCacheMinimumScn();
                this.metrics.setOldestScn(smallestScn.isNull() ? Scn.valueOf(-1) : smallestScn);
                this.offsetContext.setScn(thresholdScn);
            }
            this.dispatcher.dispatchHeartbeatEvent((Partition)this.partition, (OffsetContext)this.offsetContext);
        }
    }

    @Override
    protected boolean isRecentlyProcessed(String transactionId) {
        return this.recentlyProcessedTransactionsCache.containsKey(transactionId);
    }

    @Override
    protected boolean hasSchemaChangeBeenSeen(LogMinerEventRow row) {
        return this.schemaChangesCache.contains(row.getScn());
    }

    @Override
    protected MemoryTransaction getAndRemoveTransactionFromCache(String transactionId) {
        return this.getTransactionCache().remove(transactionId);
    }

    @Override
    protected void removeTransactionAndEventsFromCache(MemoryTransaction transaction) {
        this.abandonedTransactionsCache.remove(transaction.getTransactionId());
    }

    @Override
    protected Iterator<LogMinerEvent> getTransactionEventIterator(MemoryTransaction transaction) {
        return transaction.getEvents().iterator();
    }

    @Override
    protected void finalizeTransactionCommit(String transactionId, Scn commitScn) {
        this.abandonedTransactionsCache.remove(transactionId);
        if (this.getConfig().isLobEnabled()) {
            this.recentlyProcessedTransactionsCache.put(transactionId, commitScn);
        }
    }

    @Override
    protected void finalizeTransactionRollback(String transactionId, Scn rollbackScn) {
        this.transactionCache.remove(transactionId);
        this.abandonedTransactionsCache.remove(transactionId);
        if (this.getConfig().isLobEnabled()) {
            this.recentlyProcessedTransactionsCache.put(transactionId, rollbackScn);
        }
    }

    @Override
    protected void handleSchemaChange(LogMinerEventRow row) throws InterruptedException {
        super.handleSchemaChange(row);
        if (row.getTableName() != null && this.getConfig().isLobEnabled()) {
            this.schemaChangesCache.add(row.getScn());
        }
    }

    @Override
    protected void handleCommitNotFoundInBuffer(LogMinerEventRow row) {
        this.abandonedTransactionsCache.remove(row.getTransactionId());
    }

    @Override
    protected void handleRollbackNotFoundInBuffer(LogMinerEventRow row) {
        this.abandonedTransactionsCache.remove(row.getTransactionId());
    }

    @Override
    protected void addToTransaction(String transactionId, LogMinerEventRow row, Supplier<LogMinerEvent> eventSupplier) {
        if (this.abandonedTransactionsCache.contains(transactionId)) {
            LOGGER.warn("Event for abandoned transaction {}, skipped.", (Object)transactionId);
            return;
        }
        if (!this.isRecentlyProcessed(transactionId)) {
            MemoryTransaction transaction = this.getTransactionCache().get(transactionId);
            if (transaction == null) {
                LOGGER.trace("Transaction {} not in cache for DML, creating.", (Object)transactionId);
                transaction = this.createTransaction(row);
                this.getTransactionCache().put(transactionId, transaction);
            }
            if (this.isTransactionOverEventThreshold(transaction)) {
                this.abandonTransactionOverEventThreshold(transaction);
                return;
            }
            int eventId = transaction.getNextEventId();
            if (transaction.getEvents().size() <= eventId) {
                LOGGER.trace("Transaction {}, adding event reference at index {}", (Object)transactionId, (Object)eventId);
                transaction.getEvents().add(eventSupplier.get());
                this.metrics.calculateLagMetrics(row.getChangeTime());
            }
            this.metrics.setActiveTransactions(this.getTransactionCache().size());
        } else if (!this.getConfig().isLobEnabled()) {
            LOGGER.warn("Event for transaction {} has already been processed, skipped.", (Object)transactionId);
        }
    }

    @Override
    protected int getTransactionEventCount(MemoryTransaction transaction) {
        return transaction.getEvents().size();
    }

    @Override
    protected PreparedStatement createQueryStatement() throws SQLException {
        return this.jdbcConnection.connection().prepareStatement(this.getQueryString(), 1003, 1007, 1);
    }

    @Override
    protected Scn calculateNewStartScn(Scn endScn, Scn maxCommittedScn) throws InterruptedException {
        if (this.getConfig().isLobEnabled()) {
            if (this.transactionCache.isEmpty() && !maxCommittedScn.isNull()) {
                this.offsetContext.setScn(maxCommittedScn);
                this.dispatcher.dispatchHeartbeatEvent((Partition)this.partition, (OffsetContext)this.offsetContext);
            } else {
                this.abandonTransactions(this.getConfig().getLogMiningTransactionRetention());
                Scn minStartScn = this.getTransactionCacheMinimumScn();
                if (!minStartScn.isNull()) {
                    this.recentlyProcessedTransactionsCache.entrySet().removeIf(entry -> ((Scn)entry.getValue()).compareTo(minStartScn) < 0);
                    this.schemaChangesCache.removeIf(scn -> scn.compareTo(minStartScn) < 0);
                    this.offsetContext.setScn(minStartScn.subtract(Scn.valueOf(1)));
                    this.dispatcher.dispatchHeartbeatEvent((Partition)this.partition, (OffsetContext)this.offsetContext);
                }
            }
            return this.offsetContext.getScn();
        }
        if (!this.getLastProcessedScn().isNull() && this.getLastProcessedScn().compareTo(endScn) < 0) {
            endScn = this.getLastProcessedScn();
        }
        if (this.transactionCache.isEmpty()) {
            this.offsetContext.setScn(endScn);
            this.dispatcher.dispatchHeartbeatEvent((Partition)this.partition, (OffsetContext)this.offsetContext);
        } else {
            this.abandonTransactions(this.getConfig().getLogMiningTransactionRetention());
            Scn minStartScn = this.getTransactionCacheMinimumScn();
            if (!minStartScn.isNull()) {
                this.offsetContext.setScn(minStartScn.subtract(Scn.valueOf(1)));
                this.dispatcher.dispatchHeartbeatEvent((Partition)this.partition, (OffsetContext)this.offsetContext);
            }
        }
        return endScn;
    }

    protected Optional<Scn> getLastScnToAbandon(OracleConnection connection, Duration retention) {
        try {
            if (this.getLastProcessedScn().isNull()) {
                return Optional.empty();
            }
            BigInteger scnToAbandon = (BigInteger)connection.singleOptionalValue(SqlUtils.getScnByTimeDeltaQuery(this.getLastProcessedScn(), retention), rs -> rs.getBigDecimal(1).toBigInteger());
            return Optional.of(new Scn(scnToAbandon));
        }
        catch (SQLException e) {
            Scn calculatedLastScn;
            if (this.getLastProcessedScnChangeTime() != null && !(calculatedLastScn = this.getLastScnToAbandonFallbackByTransactionChangeTime(retention)).isNull()) {
                return Optional.of(calculatedLastScn);
            }
            LOGGER.error(String.format("Cannot fetch SCN %s by given duration to calculate SCN to abandon", this.getLastProcessedScn()), (Throwable)e);
            this.metrics.incrementErrorCount();
            return Optional.empty();
        }
    }

    @Override
    protected void abandonTransactionOverEventThreshold(MemoryTransaction transaction) {
        super.abandonTransactionOverEventThreshold(transaction);
        this.abandonedTransactionsCache.add(transaction.getTransactionId());
    }

    @Override
    protected Scn getTransactionCacheMinimumScn() {
        return this.transactionCache.values().stream().map(AbstractTransaction::getStartScn).min(Scn::compareTo).orElse(Scn.NULL);
    }

    private Scn getLastScnToAbandonFallbackByTransactionChangeTime(Duration retention) {
        LOGGER.debug("Getting abandon SCN breakpoint based on change time {} (retention {} minutes).", (Object)this.getLastProcessedScnChangeTime(), (Object)retention.toMinutes());
        Scn calculatedLastScn = Scn.NULL;
        for (MemoryTransaction transaction : this.getTransactionCache().values()) {
            Instant changeTime = transaction.getChangeTime();
            long diffMinutes = Duration.between(this.getLastProcessedScnChangeTime(), changeTime).abs().toMinutes();
            if (diffMinutes <= 0L || diffMinutes <= retention.toMinutes()) continue;
            LOGGER.debug("Transaction {} with SCN {} started at {}, age is {} minutes.", new Object[]{transaction.getTransactionId(), transaction.getStartScn(), changeTime, diffMinutes});
            if (!calculatedLastScn.isNull() && calculatedLastScn.compareTo(transaction.getStartScn()) >= 0) continue;
            calculatedLastScn = transaction.getStartScn();
        }
        return calculatedLastScn;
    }
}

