/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.pipeline.notification.AbstractNotificationsIT;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import org.junit.After;
import org.junit.Before;

public class NotificationsIT
extends AbstractNotificationsIT<OracleConnector> {
    private OracleConnection connection;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        TestHelper.dropTable(this.connection, "a");
        this.connection.execute(new String[]{"CREATE TABLE a (pk numeric(9,0) primary key, aa numeric(9,0))"});
        TestHelper.streamTable(this.connection, "a");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() {
        this.stopConnector();
    }

    protected Class<OracleConnector> connectorClass() {
        return OracleConnector.class;
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL);
    }

    protected String snapshotStatusResult() {
        return "COMPLETED";
    }
}

