/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.CommitScn;
import io.debezium.connector.oracle.Scn;
import io.debezium.doc.FixFor;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CommitScnTest {
    @Test
    @FixFor(value={"DBZ-5245"})
    public void shouldParseCommitScnThatIsNull() throws Exception {
        CommitScn commitScn = CommitScn.valueOf((String)null);
        Assertions.assertThat((Object)commitScn).isNotNull();
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).isEmpty();
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.NULL);
        Assertions.assertThat((String)CommitScnTest.encodedCommitScn(commitScn)).isNull();
        commitScn = CommitScn.valueOf((Long)null);
        Assertions.assertThat((Object)commitScn).isNotNull();
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).isEmpty();
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.NULL);
        Assertions.assertThat((String)CommitScnTest.encodedCommitScn(commitScn)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-5245"})
    public void shouldParseCommitScnThatIsNumeric() throws Exception {
        CommitScn commitScn = CommitScn.valueOf((Long)12345L);
        Assertions.assertThat((Object)commitScn).isNotNull();
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).hasSize(1);
        Assertions.assertThat(commitScn.getCommitScnForAllRedoThreads().keySet()).containsOnly((Object[])new Integer[]{1});
        Assertions.assertThat((Comparable)((Scn)commitScn.getCommitScnForAllRedoThreads().get(1))).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(1)).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((String)CommitScnTest.encodedCommitScn(commitScn)).isEqualTo((Object)"12345:1:");
    }

    @Test
    @FixFor(value={"DBZ-5245", "DBZ-5439"})
    public void shouldParseCommitScnThatIsString() throws Exception {
        CommitScn commitScn = CommitScn.valueOf((String)"12345");
        Assertions.assertThat((Object)commitScn).isNotNull();
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).hasSize(1);
        Assertions.assertThat(commitScn.getCommitScnForAllRedoThreads().keySet()).containsOnly((Object[])new Integer[]{1});
        Assertions.assertThat((Comparable)((Scn)commitScn.getCommitScnForAllRedoThreads().get(1))).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(1)).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((String)CommitScnTest.encodedCommitScn(commitScn)).isEqualTo((Object)"12345:1:");
        commitScn = CommitScn.valueOf((String)"12345:00241f.00093ff0.0010:0:1");
        Assertions.assertThat((Object)commitScn).isNotNull();
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).hasSize(1);
        Assertions.assertThat(commitScn.getCommitScnForAllRedoThreads().keySet()).containsOnly((Object[])new Integer[]{1});
        Assertions.assertThat((Comparable)((Scn)commitScn.getCommitScnForAllRedoThreads().get(1))).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(1)).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((String)CommitScnTest.encodedCommitScn(commitScn)).isEqualTo((Object)"12345:1:");
        commitScn = CommitScn.valueOf((String)"12345:1:123456789-234567890");
        Assertions.assertThat((Object)commitScn).isNotNull();
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).hasSize(1);
        Assertions.assertThat(commitScn.getCommitScnForAllRedoThreads().keySet()).containsOnly((Object[])new Integer[]{1});
        Assertions.assertThat((Comparable)((Scn)commitScn.getCommitScnForAllRedoThreads().get(1))).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(1)).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Iterable)commitScn.getRedoThreadCommitScn(1).getTxIds()).containsOnly((Object[])new String[]{"123456789", "234567890"});
        Assertions.assertThat((String)CommitScnTest.encodedCommitScn(commitScn)).isEqualTo((Object)"12345:1:123456789-234567890");
        commitScn = CommitScn.valueOf((String)"12345:00241f.00093ff0.0010:0:1,678901:1253ef.123457ee0.abcd:0:2");
        Assertions.assertThat((Object)commitScn).isNotNull();
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)678901L));
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).hasSize(2);
        Assertions.assertThat(commitScn.getCommitScnForAllRedoThreads().keySet()).containsOnly((Object[])new Integer[]{1, 2});
        Assertions.assertThat((Comparable)((Scn)commitScn.getCommitScnForAllRedoThreads().get(1))).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Comparable)((Scn)commitScn.getCommitScnForAllRedoThreads().get(2))).isEqualTo((Object)Scn.valueOf((long)678901L));
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(1)).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(2)).isEqualTo((Object)Scn.valueOf((long)678901L));
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)678901L));
        Assertions.assertThat((String)CommitScnTest.encodedCommitScn(commitScn)).isEqualTo((Object)"12345:1:,678901:2:");
        commitScn = CommitScn.valueOf((String)"12345:1:23456-78901,678901:2:12345-67890");
        Assertions.assertThat((Object)commitScn).isNotNull();
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)678901L));
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).hasSize(2);
        Assertions.assertThat(commitScn.getCommitScnForAllRedoThreads().keySet()).containsOnly((Object[])new Integer[]{1, 2});
        Assertions.assertThat((Comparable)((Scn)commitScn.getCommitScnForAllRedoThreads().get(1))).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Comparable)((Scn)commitScn.getCommitScnForAllRedoThreads().get(2))).isEqualTo((Object)Scn.valueOf((long)678901L));
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(1)).isEqualTo((Object)Scn.valueOf((long)12345L));
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(2)).isEqualTo((Object)Scn.valueOf((long)678901L));
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)678901L));
        Assertions.assertThat((Iterable)commitScn.getRedoThreadCommitScn(1).getTxIds()).containsOnly((Object[])new String[]{"23456", "78901"});
        Assertions.assertThat((Iterable)commitScn.getRedoThreadCommitScn(2).getTxIds()).containsOnly((Object[])new String[]{"12345", "67890"});
        Assertions.assertThat((String)CommitScnTest.encodedCommitScn(commitScn)).isEqualTo((Object)"12345:1:23456-78901,678901:2:12345-67890");
    }

    @Test
    @FixFor(value={"DBZ-5245", "DBZ-5439"})
    public void shouldSetCommitScnAcrossAllRedoThreads() throws Exception {
        CommitScn commitScn = CommitScn.valueOf((String)null);
        commitScn.setCommitScnOnAllThreads(Scn.valueOf((long)23456L));
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.NULL);
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).isEmpty();
        commitScn = CommitScn.valueOf((String)"12345");
        commitScn.setCommitScnOnAllThreads(Scn.valueOf((long)23456L));
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)23456L));
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).hasSize(1);
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(1)).isEqualTo((Object)Scn.valueOf((long)23456L));
        commitScn = CommitScn.valueOf((String)"12345:00241f.00093ff0.0010:0:1");
        commitScn.setCommitScnOnAllThreads(Scn.valueOf((long)23456L));
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)23456L));
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).hasSize(1);
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(1)).isEqualTo((Object)Scn.valueOf((long)23456L));
        commitScn = CommitScn.valueOf((String)"12345:1:12345-67890");
        commitScn.setCommitScnOnAllThreads(Scn.valueOf((long)23456L));
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)23456L));
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).hasSize(1);
        Assertions.assertThat((Iterable)commitScn.getRedoThreadCommitScn(1).getTxIds()).containsOnly((Object[])new String[]{"12345", "67890"});
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(1)).isEqualTo((Object)Scn.valueOf((long)23456L));
        commitScn = CommitScn.valueOf((String)"12345:00241f.00093ff0.0010:0:1,678901:1253ef.123457ee0.abcd:0:2");
        commitScn.setCommitScnOnAllThreads(Scn.valueOf((long)23456L));
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)23456L));
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).hasSize(2);
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(1)).isEqualTo((Object)Scn.valueOf((long)23456L));
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(2)).isEqualTo((Object)Scn.valueOf((long)23456L));
        commitScn = CommitScn.valueOf((String)"12345:1:12345-67890,678901:2:23456-78901");
        commitScn.setCommitScnOnAllThreads(Scn.valueOf((long)23456L));
        Assertions.assertThat((Comparable)commitScn.getMaxCommittedScn()).isEqualTo((Object)Scn.valueOf((long)23456L));
        Assertions.assertThat((Map)commitScn.getCommitScnForAllRedoThreads()).hasSize(2);
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(1)).isEqualTo((Object)Scn.valueOf((long)23456L));
        Assertions.assertThat((Comparable)commitScn.getCommitScnForRedoThread(2)).isEqualTo((Object)Scn.valueOf((long)23456L));
        Assertions.assertThat((Iterable)commitScn.getRedoThreadCommitScn(1).getTxIds()).containsOnly((Object[])new String[]{"12345", "67890"});
        Assertions.assertThat((Iterable)commitScn.getRedoThreadCommitScn(2).getTxIds()).containsOnly((Object[])new String[]{"23456", "78901"});
    }

    @Test
    @FixFor(value={"DBZ-5245"})
    public void shouldBeComparableWithScn() throws Exception {
        CommitScn commitScn = CommitScn.valueOf((String)null);
        Assertions.assertThat((int)commitScn.compareTo(Scn.NULL)).isEqualTo(0);
        Assertions.assertThat((int)commitScn.compareTo(Scn.valueOf((long)12345L))).isEqualTo(-1);
        commitScn = CommitScn.valueOf((String)"12345");
        Assertions.assertThat((int)commitScn.compareTo(Scn.NULL)).isEqualTo(1);
        Assertions.assertThat((int)commitScn.compareTo(Scn.valueOf((long)123L))).isEqualTo(1);
        Assertions.assertThat((int)commitScn.compareTo(Scn.valueOf((long)12345L))).isEqualTo(0);
        Assertions.assertThat((int)commitScn.compareTo(Scn.valueOf((long)23456L))).isEqualTo(-1);
        commitScn = CommitScn.valueOf((String)"12345:00241f.00093ff0.0010:0:1");
        Assertions.assertThat((int)commitScn.compareTo(Scn.NULL)).isEqualTo(1);
        Assertions.assertThat((int)commitScn.compareTo(Scn.valueOf((long)123L))).isEqualTo(1);
        Assertions.assertThat((int)commitScn.compareTo(Scn.valueOf((long)12345L))).isEqualTo(0);
        Assertions.assertThat((int)commitScn.compareTo(Scn.valueOf((long)23456L))).isEqualTo(-1);
        commitScn = CommitScn.valueOf((String)"12345:00241f.00093ff0.0010:0:1,345678:1253ef.123457ee0.abcd:0:2");
        Assertions.assertThat((int)commitScn.compareTo(Scn.NULL)).isEqualTo(1);
        Assertions.assertThat((int)commitScn.compareTo(Scn.valueOf((long)123L))).isEqualTo(1);
        Assertions.assertThat((int)commitScn.compareTo(Scn.valueOf((long)12345L))).isEqualTo(0);
        Assertions.assertThat((int)commitScn.compareTo(Scn.valueOf((long)23456L))).isEqualTo(-1);
        Assertions.assertThat((int)commitScn.compareTo(Scn.valueOf((long)456789L))).isEqualTo(-1);
    }

    private static String encodedCommitScn(CommitScn value) {
        Map offsets = value.store(new HashMap());
        return (String)offsets.get("commit_scn");
    }
}

