/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SchemaHistoryTopicIT
extends AbstractConnectorTest {
    private static OracleConnection connection;

    @Before
    public void before() throws SQLException {
        connection = TestHelper.testConnection();
        TestHelper.dropTable(connection, "debezium.tablea");
        TestHelper.dropTable(connection, "debezium.tableb");
        TestHelper.dropTable(connection, "debezium.tablec");
        connection.execute(new String[]{"CREATE TABLE debezium.tablea (id numeric(9,0) not null, cola varchar2(30), primary key(id))", "CREATE TABLE debezium.tableb (id numeric(9,0) not null, colb varchar2(30), primary key(id))", "CREATE TABLE debezium.tablec (id numeric(9,0) not null, colc varchar2(30), primary key(id))"});
        connection.execute(new String[]{"GRANT SELECT ON debezium.tablea to  " + TestHelper.getConnectorUserName()});
        connection.execute(new String[]{"ALTER TABLE debezium.tablea ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        connection.execute(new String[]{"GRANT SELECT ON debezium.tableb to  " + TestHelper.getConnectorUserName()});
        connection.execute(new String[]{"ALTER TABLE debezium.tableb ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        connection.execute(new String[]{"GRANT SELECT ON debezium.tablec to  " + TestHelper.getConnectorUserName()});
        connection.execute(new String[]{"ALTER TABLE debezium.tablec ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (connection != null) {
            TestHelper.dropTable(connection, "debezium.tablea");
            TestHelper.dropTable(connection, "debezium.tableb");
            TestHelper.dropTable(connection, "debezium.tablec");
            connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-1904"})
    public void snapshotSchemaChanges() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START_1 = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL)).with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.TABLE[ABC]")).with(OracleConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            connection.execute(new String[]{"INSERT INTO debezium.tablea VALUES(" + id + ", 'a')"});
            connection.execute(new String[]{"INSERT INTO debezium.tableb VALUES(" + id + ", 'b')"});
        }
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        SchemaHistoryTopicIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Testing.Print.enable();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(3);
        List schemaRecords = records.allRecordsInOrder();
        Assertions.assertThat((List)schemaRecords).hasSize(3);
        schemaRecords.forEach(record -> {
            Assertions.assertThat((String)record.topic()).isEqualTo((Object)"server1");
            Assertions.assertThat((String)((Struct)record.key()).getString("databaseName")).isEqualTo((Object)TestHelper.getDatabaseName());
            Assertions.assertThat(record.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        });
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(0)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(1)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(2)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(0)).value()).getStruct("source").getString("schema")).isEqualTo((Object)"DEBEZIUM");
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(0)).value()).getString("ddl")).contains(new CharSequence[]{"CREATE TABLE"});
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(0)).value()).getString("schemaName")).isEqualTo((Object)"DEBEZIUM");
        List tableChanges = ((Struct)((SourceRecord)schemaRecords.get(0)).value()).getArray("tableChanges");
        Assertions.assertThat((List)tableChanges).hasSize(1);
        Assertions.assertThat((Object)((Struct)tableChanges.get(0)).get("type")).isEqualTo((Object)"CREATE");
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.DEBEZIUM.TABLEA")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.DEBEZIUM.TABLEB")).hasSize(5);
        records.recordsForTopic("server1.DEBEZIUM.TABLEB").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.DEBEZIUM.TABLEB.Value").field("ID", Schema.INT32_SCHEMA).field("COLB", Schema.OPTIONAL_STRING_SCHEMA).build()));
    }
}

