/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;

public class CommitCommand
extends AbstractTransactionBoundaryCommand {
    public static final byte COMMAND_ID = 14;
    private Map<Integer, IracMetadata> iracMetadataMap;

    private CommitCommand() {
        super(null);
    }

    public CommitCommand(ByteString cacheName, GlobalTransaction gtx) {
        super(cacheName);
        this.globalTx = gtx;
    }

    public CommitCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitCommitCommand((TxInvocationContext)ctx, this);
    }

    @Override
    protected Object invalidRemoteTxReturnValue(TransactionTable txTable) {
        TransactionTable.CompletedTransactionStatus txStatus = txTable.getCompletedTransactionStatus(this.globalTx);
        switch (txStatus) {
            case COMMITTED: {
                return null;
            }
            case ABORTED: {
                throw Log.CONTAINER.remoteTransactionAlreadyRolledBack(this.globalTx);
            }
            case EXPIRED: {
                throw Log.CONTAINER.remoteTransactionStatusMissing(this.globalTx);
            }
        }
        throw new IllegalStateException("Remote transaction not found: " + this.globalTx);
    }

    @Override
    public byte getCommandId() {
        return 14;
    }

    @Override
    public String toString() {
        return "CommitCommand{iracMetadataMap=" + this.iracMetadataMap + ", " + super.toString();
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        MarshallUtil.marshallMap(this.iracMetadataMap, DataOutput::writeInt, IracMetadata::writeTo, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.iracMetadataMap = MarshallUtil.unmarshallMap((ObjectInput)input, DataInput::readInt, IracMetadata::readFrom, HashMap::new);
    }

    public void addIracMetadata(int segment, IracMetadata metadata) {
        if (this.iracMetadataMap == null) {
            this.iracMetadataMap = new HashMap<Integer, IracMetadata>();
        }
        this.iracMetadataMap.put(segment, metadata);
    }

    public IracMetadata getIracMetadata(int segment) {
        return this.iracMetadataMap != null ? this.iracMetadataMap.get(segment) : null;
    }
}

