/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetricsMXBean;
import io.debezium.connector.oracle.Scn;
import io.debezium.pipeline.metrics.DefaultStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.util.LRUCacheMap;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OracleStreamingChangeEventSourceMetrics
extends DefaultStreamingChangeEventSourceMetrics<OraclePartition>
implements OracleStreamingChangeEventSourceMetricsMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleStreamingChangeEventSourceMetrics.class);
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final int TRANSACTION_ID_SET_SIZE = 10;
    private final AtomicReference<Scn> currentScn = new AtomicReference();
    private final AtomicInteger logMinerQueryCount = new AtomicInteger();
    private final AtomicInteger totalCapturedDmlCount = new AtomicInteger();
    private final AtomicReference<Duration> totalDurationOfFetchingQuery = new AtomicReference();
    private final AtomicInteger lastCapturedDmlCount = new AtomicInteger();
    private final AtomicReference<Duration> lastDurationOfFetchingQuery = new AtomicReference();
    private final AtomicLong maxCapturedDmlCount = new AtomicLong();
    private final AtomicLong totalProcessedRows = new AtomicLong();
    private final AtomicReference<Duration> maxDurationOfFetchingQuery = new AtomicReference();
    private final AtomicReference<Duration> totalBatchProcessingDuration = new AtomicReference();
    private final AtomicReference<Duration> lastBatchProcessingDuration = new AtomicReference();
    private final AtomicReference<Duration> totalParseTime = new AtomicReference();
    private final AtomicReference<Duration> totalStartLogMiningSessionDuration = new AtomicReference();
    private final AtomicReference<Duration> lastStartLogMiningSessionDuration = new AtomicReference();
    private final AtomicReference<Duration> maxStartingLogMiningSessionDuration = new AtomicReference();
    private final AtomicReference<Duration> totalProcessingTime = new AtomicReference();
    private final AtomicReference<Duration> minBatchProcessingTime = new AtomicReference();
    private final AtomicReference<Duration> maxBatchProcessingTime = new AtomicReference();
    private final AtomicReference<Duration> totalResultSetNextTime = new AtomicReference();
    private final AtomicLong maxBatchProcessingThroughput = new AtomicLong();
    private final AtomicReference<String[]> currentLogFileName;
    private final AtomicReference<String[]> redoLogStatus;
    private final AtomicLong minimumLogsMined = new AtomicLong();
    private final AtomicLong maximumLogsMined = new AtomicLong();
    private final AtomicInteger switchCounter = new AtomicInteger();
    private final AtomicInteger batchSize = new AtomicInteger();
    private final AtomicLong millisecondToSleepBetweenMiningQuery = new AtomicLong();
    private final AtomicInteger hoursToKeepTransaction = new AtomicInteger();
    private final AtomicLong networkConnectionProblemsCounter = new AtomicLong();
    private final AtomicReference<Duration> lagFromTheSourceDuration = new AtomicReference();
    private final AtomicReference<Duration> minLagFromTheSourceDuration = new AtomicReference();
    private final AtomicReference<Duration> maxLagFromTheSourceDuration = new AtomicReference();
    private final AtomicReference<Duration> lastCommitDuration = new AtomicReference();
    private final AtomicReference<Duration> maxCommitDuration = new AtomicReference();
    private final AtomicLong activeTransactions = new AtomicLong();
    private final AtomicLong rolledBackTransactions = new AtomicLong();
    private final AtomicLong committedTransactions = new AtomicLong();
    private final AtomicLong oversizedTransactions = new AtomicLong();
    private final AtomicReference<LRUCacheMap<String, String>> abandonedTransactionIds = new AtomicReference();
    private final AtomicReference<LRUCacheMap<String, String>> rolledBackTransactionIds = new AtomicReference();
    private final AtomicLong registeredDmlCount = new AtomicLong();
    private final AtomicLong committedDmlCount = new AtomicLong();
    private final AtomicInteger errorCount = new AtomicInteger();
    private final AtomicInteger warningCount = new AtomicInteger();
    private final AtomicInteger scnFreezeCount = new AtomicInteger();
    private final AtomicLong timeDifference = new AtomicLong();
    private final AtomicReference<ZoneOffset> zoneOffset = new AtomicReference();
    private final AtomicReference<Scn> oldestScn = new AtomicReference();
    private final AtomicReference<Scn> committedScn = new AtomicReference();
    private final AtomicReference<Scn> offsetScn = new AtomicReference();
    private final AtomicInteger unparsableDdlCount = new AtomicInteger();
    private final AtomicLong miningSessionUserGlobalAreaMemory = new AtomicLong();
    private final AtomicLong miningSessionUserGlobalAreaMaxMemory = new AtomicLong();
    private final AtomicLong miningSessionProcessGlobalAreaMemory = new AtomicLong();
    private final AtomicLong miningSessionProcessGlobalAreaMaxMemory = new AtomicLong();
    private final int batchSizeMin;
    private final int batchSizeMax;
    private final int batchSizeDefault;
    private final long sleepTimeMin;
    private final long sleepTimeMax;
    private final long sleepTimeDefault;
    private final long sleepTimeIncrement;
    private final Instant startTime;
    private final Clock clock;

    public OracleStreamingChangeEventSourceMetrics(CdcSourceTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider, OracleConnectorConfig connectorConfig) {
        this(taskContext, changeEventQueueMetrics, metadataProvider, connectorConfig, Clock.systemUTC());
    }

    OracleStreamingChangeEventSourceMetrics(CdcSourceTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider, OracleConnectorConfig connectorConfig, Clock clock) {
        super(taskContext, changeEventQueueMetrics, metadataProvider);
        this.clock = clock;
        this.startTime = clock.instant();
        this.timeDifference.set(0L);
        this.zoneOffset.set(ZoneOffset.UTC);
        this.currentScn.set(Scn.NULL);
        this.oldestScn.set(Scn.NULL);
        this.offsetScn.set(Scn.NULL);
        this.committedScn.set(Scn.NULL);
        this.currentLogFileName = new AtomicReference<String[]>(new String[0]);
        this.minimumLogsMined.set(0L);
        this.maximumLogsMined.set(0L);
        this.redoLogStatus = new AtomicReference<String[]>(new String[0]);
        this.switchCounter.set(0);
        this.batchSizeDefault = connectorConfig.getLogMiningBatchSizeDefault();
        this.batchSizeMin = connectorConfig.getLogMiningBatchSizeMin();
        this.batchSizeMax = connectorConfig.getLogMiningBatchSizeMax();
        this.sleepTimeDefault = connectorConfig.getLogMiningSleepTimeDefault().toMillis();
        this.sleepTimeMin = connectorConfig.getLogMiningSleepTimeMin().toMillis();
        this.sleepTimeMax = connectorConfig.getLogMiningSleepTimeMax().toMillis();
        this.sleepTimeIncrement = connectorConfig.getLogMiningSleepTimeIncrement().toMillis();
        this.hoursToKeepTransaction.set(Long.valueOf(connectorConfig.getLogMiningTransactionRetention().toHours()).intValue());
        this.reset();
    }

    @Override
    public void reset() {
        this.batchSize.set(this.batchSizeDefault);
        this.millisecondToSleepBetweenMiningQuery.set(this.sleepTimeDefault);
        this.totalCapturedDmlCount.set(0);
        this.totalProcessedRows.set(0L);
        this.maxDurationOfFetchingQuery.set(Duration.ZERO);
        this.lastDurationOfFetchingQuery.set(Duration.ZERO);
        this.logMinerQueryCount.set(0);
        this.totalDurationOfFetchingQuery.set(Duration.ZERO);
        this.lastCapturedDmlCount.set(0);
        this.maxCapturedDmlCount.set(0L);
        this.totalBatchProcessingDuration.set(Duration.ZERO);
        this.maxBatchProcessingThroughput.set(0L);
        this.lastBatchProcessingDuration.set(Duration.ZERO);
        this.networkConnectionProblemsCounter.set(0L);
        this.totalParseTime.set(Duration.ZERO);
        this.totalStartLogMiningSessionDuration.set(Duration.ZERO);
        this.lastStartLogMiningSessionDuration.set(Duration.ZERO);
        this.maxStartingLogMiningSessionDuration.set(Duration.ZERO);
        this.totalProcessingTime.set(Duration.ZERO);
        this.minBatchProcessingTime.set(Duration.ZERO);
        this.maxBatchProcessingTime.set(Duration.ZERO);
        this.totalResultSetNextTime.set(Duration.ZERO);
        this.miningSessionUserGlobalAreaMemory.set(0L);
        this.miningSessionUserGlobalAreaMaxMemory.set(0L);
        this.miningSessionProcessGlobalAreaMemory.set(0L);
        this.miningSessionProcessGlobalAreaMaxMemory.set(0L);
        this.lagFromTheSourceDuration.set(Duration.ZERO);
        this.maxLagFromTheSourceDuration.set(Duration.ZERO);
        this.minLagFromTheSourceDuration.set(Duration.ZERO);
        this.lastCommitDuration.set(Duration.ZERO);
        this.maxCommitDuration.set(Duration.ZERO);
        this.activeTransactions.set(0L);
        this.rolledBackTransactions.set(0L);
        this.committedTransactions.set(0L);
        this.oversizedTransactions.set(0L);
        this.registeredDmlCount.set(0L);
        this.committedDmlCount.set(0L);
        this.abandonedTransactionIds.set((LRUCacheMap<String, String>)new LRUCacheMap(10));
        this.rolledBackTransactionIds.set((LRUCacheMap<String, String>)new LRUCacheMap(10));
        this.errorCount.set(0);
        this.warningCount.set(0);
        this.scnFreezeCount.set(0);
    }

    public void setCurrentScn(Scn scn) {
        this.currentScn.set(scn);
    }

    public void setCurrentLogFileName(Set<String> names) {
        this.currentLogFileName.set((String[])names.stream().toArray(String[]::new));
        if ((long)names.size() < this.minimumLogsMined.get()) {
            this.minimumLogsMined.set(names.size());
        } else if (this.minimumLogsMined.get() == 0L) {
            this.minimumLogsMined.set(names.size());
        }
        if ((long)names.size() > this.maximumLogsMined.get()) {
            this.maximumLogsMined.set(names.size());
        }
    }

    @Override
    public long getMinimumMinedLogCount() {
        return this.minimumLogsMined.get();
    }

    @Override
    public long getMaximumMinedLogCount() {
        return this.maximumLogsMined.get();
    }

    public void setRedoLogStatus(Map<String, String> status) {
        String[] statusArray = (String[])status.entrySet().stream().map(e -> (String)e.getKey() + " | " + (String)e.getValue()).toArray(String[]::new);
        this.redoLogStatus.set(statusArray);
    }

    public void setSwitchCount(int counter) {
        this.switchCounter.set(counter);
    }

    public void setLastCapturedDmlCount(int dmlCount) {
        this.lastCapturedDmlCount.set(dmlCount);
        if ((long)dmlCount > this.maxCapturedDmlCount.get()) {
            this.maxCapturedDmlCount.set(dmlCount);
        }
        this.totalCapturedDmlCount.getAndAdd(dmlCount);
    }

    public void setLastDurationOfBatchCapturing(Duration lastDuration) {
        this.lastDurationOfFetchingQuery.set(lastDuration);
        this.totalDurationOfFetchingQuery.accumulateAndGet(this.lastDurationOfFetchingQuery.get(), Duration::plus);
        if (this.maxDurationOfFetchingQuery.get().toMillis() < this.lastDurationOfFetchingQuery.get().toMillis()) {
            this.maxDurationOfFetchingQuery.set(lastDuration);
        }
        this.logMinerQueryCount.incrementAndGet();
    }

    public void setLastDurationOfBatchProcessing(Duration lastDuration) {
        this.lastBatchProcessingDuration.set(lastDuration);
        this.totalBatchProcessingDuration.accumulateAndGet(lastDuration, Duration::plus);
        if (this.maxBatchProcessingTime.get().toMillis() < lastDuration.toMillis()) {
            this.maxBatchProcessingTime.set(lastDuration);
        }
        if (this.minBatchProcessingTime.get().toMillis() > lastDuration.toMillis()) {
            this.minBatchProcessingTime.set(lastDuration);
        } else if (this.minBatchProcessingTime.get().toMillis() == 0L) {
            this.minBatchProcessingTime.set(lastDuration);
        }
        if (this.getLastBatchProcessingThroughput() > this.maxBatchProcessingThroughput.get()) {
            this.maxBatchProcessingThroughput.set(this.getLastBatchProcessingThroughput());
        }
    }

    public void incrementNetworkConnectionProblemsCounter() {
        this.networkConnectionProblemsCounter.incrementAndGet();
    }

    @Override
    public String getCurrentScn() {
        return this.currentScn.get().toString();
    }

    @Override
    public long getTotalCapturedDmlCount() {
        return this.totalCapturedDmlCount.get();
    }

    @Override
    public String[] getCurrentRedoLogFileName() {
        return this.currentLogFileName.get();
    }

    @Override
    public String[] getRedoLogStatus() {
        return this.redoLogStatus.get();
    }

    @Override
    public int getSwitchCounter() {
        return this.switchCounter.get();
    }

    @Override
    public Long getLastDurationOfFetchQueryInMilliseconds() {
        return this.lastDurationOfFetchingQuery.get() == null ? 0L : this.lastDurationOfFetchingQuery.get().toMillis();
    }

    @Override
    public long getLastBatchProcessingTimeInMilliseconds() {
        return this.lastBatchProcessingDuration.get().toMillis();
    }

    @Override
    public Long getMaxDurationOfFetchQueryInMilliseconds() {
        return this.maxDurationOfFetchingQuery.get() == null ? 0L : this.maxDurationOfFetchingQuery.get().toMillis();
    }

    @Override
    public Long getMaxCapturedDmlInBatch() {
        return this.maxCapturedDmlCount.get();
    }

    @Override
    public int getLastCapturedDmlCount() {
        return this.lastCapturedDmlCount.get();
    }

    @Override
    public long getTotalProcessedRows() {
        return this.totalProcessedRows.get();
    }

    @Override
    public long getTotalResultSetNextTimeInMilliseconds() {
        return this.totalResultSetNextTime.get().toMillis();
    }

    @Override
    public long getAverageBatchProcessingThroughput() {
        if (this.totalBatchProcessingDuration.get().isZero()) {
            return 0L;
        }
        return Math.round(this.totalCapturedDmlCount.floatValue() / (float)this.totalBatchProcessingDuration.get().toMillis() * 1000.0f);
    }

    @Override
    public long getLastBatchProcessingThroughput() {
        if (this.lastBatchProcessingDuration.get().isZero()) {
            return 0L;
        }
        return Math.round(this.lastCapturedDmlCount.floatValue() / (float)this.lastBatchProcessingDuration.get().toMillis() * 1000.0f);
    }

    @Override
    public long getFetchingQueryCount() {
        return this.logMinerQueryCount.get();
    }

    @Override
    public int getBatchSize() {
        return this.batchSize.get();
    }

    @Override
    public long getMillisecondToSleepBetweenMiningQuery() {
        return this.millisecondToSleepBetweenMiningQuery.get();
    }

    @Override
    public int getHoursToKeepTransactionInBuffer() {
        return this.hoursToKeepTransaction.get();
    }

    @Override
    public long getMaxBatchProcessingThroughput() {
        return this.maxBatchProcessingThroughput.get();
    }

    @Override
    public long getNetworkConnectionProblemsCounter() {
        return this.networkConnectionProblemsCounter.get();
    }

    @Override
    public long getTotalParseTimeInMilliseconds() {
        return this.totalParseTime.get().toMillis();
    }

    public void addCurrentParseTime(Duration currentParseTime) {
        this.totalParseTime.accumulateAndGet(currentParseTime, Duration::plus);
    }

    @Override
    public long getTotalMiningSessionStartTimeInMilliseconds() {
        return this.totalStartLogMiningSessionDuration.get().toMillis();
    }

    public void addCurrentMiningSessionStart(Duration currentStartLogMiningSession) {
        this.lastStartLogMiningSessionDuration.set(currentStartLogMiningSession);
        if (currentStartLogMiningSession.compareTo(this.maxStartingLogMiningSessionDuration.get()) > 0) {
            this.maxStartingLogMiningSessionDuration.set(currentStartLogMiningSession);
        }
        this.totalStartLogMiningSessionDuration.accumulateAndGet(currentStartLogMiningSession, Duration::plus);
    }

    @Override
    public long getLastMiningSessionStartTimeInMilliseconds() {
        return this.lastStartLogMiningSessionDuration.get().toMillis();
    }

    @Override
    public long getMaxMiningSessionStartTimeInMilliseconds() {
        return this.maxStartingLogMiningSessionDuration.get().toMillis();
    }

    @Override
    public long getTotalProcessingTimeInMilliseconds() {
        return this.totalProcessingTime.get().toMillis();
    }

    @Override
    public long getMinBatchProcessingTimeInMilliseconds() {
        return this.minBatchProcessingTime.get().toMillis();
    }

    @Override
    public long getMaxBatchProcessingTimeInMilliseconds() {
        return this.maxBatchProcessingTime.get().toMillis();
    }

    public void setCurrentBatchProcessingTime(Duration currentBatchProcessingTime) {
        this.totalProcessingTime.accumulateAndGet(currentBatchProcessingTime, Duration::plus);
        this.setLastDurationOfBatchProcessing(currentBatchProcessingTime);
    }

    public void addCurrentResultSetNext(Duration currentNextTime) {
        this.totalResultSetNextTime.accumulateAndGet(currentNextTime, Duration::plus);
    }

    public void addProcessedRows(Long rows) {
        this.totalProcessedRows.getAndAdd(rows);
    }

    @Override
    public void setBatchSize(int size) {
        if (size >= this.batchSizeMin && size <= this.batchSizeMax) {
            this.batchSize.set(size);
        }
    }

    @Override
    public void setMillisecondToSleepBetweenMiningQuery(long milliseconds) {
        if (milliseconds >= this.sleepTimeMin && milliseconds < this.sleepTimeMax) {
            this.millisecondToSleepBetweenMiningQuery.set(milliseconds);
        }
    }

    @Override
    public void changeSleepingTime(boolean increment) {
        long sleepTime = this.millisecondToSleepBetweenMiningQuery.get();
        if (increment && sleepTime < this.sleepTimeMax) {
            sleepTime = this.millisecondToSleepBetweenMiningQuery.addAndGet(this.sleepTimeIncrement);
        } else if (sleepTime > this.sleepTimeMin) {
            sleepTime = this.millisecondToSleepBetweenMiningQuery.addAndGet(-this.sleepTimeIncrement);
        }
        LOGGER.debug("Updating sleep time window. Sleep time {}. Min sleep time {}. Max sleep time {}.", new Object[]{sleepTime, this.sleepTimeMin, this.sleepTimeMax});
    }

    @Override
    public void changeBatchSize(boolean increment, boolean lobEnabled) {
        int currentBatchSize = this.batchSize.get();
        boolean incremented = false;
        if (increment && currentBatchSize < this.batchSizeMax) {
            currentBatchSize = this.batchSize.addAndGet(this.batchSizeMin);
            incremented = true;
        } else if (!increment && currentBatchSize > this.batchSizeMin) {
            currentBatchSize = this.batchSize.addAndGet(-this.batchSizeMin);
        }
        if (incremented && currentBatchSize == this.batchSizeMax) {
            if (!lobEnabled) {
                LOGGER.info("The connector is now using the maximum batch size {} when querying the LogMiner view. This could be indicative of large SCN gaps", (Object)currentBatchSize);
            } else {
                LOGGER.info("The connector is now using the maximum batch size {} when querying the LogMiner view.", (Object)currentBatchSize);
            }
        } else {
            LOGGER.debug("Updating batch size window. Batch size {}. Min batch size {}. Max batch size {}.", new Object[]{currentBatchSize, this.batchSizeMin, this.batchSizeMax});
        }
    }

    @Override
    public long getNumberOfActiveTransactions() {
        return this.activeTransactions.get();
    }

    @Override
    public long getNumberOfRolledBackTransactions() {
        return this.rolledBackTransactions.get();
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.committedTransactions.get();
    }

    @Override
    public long getNumberOfOversizedTransactions() {
        return this.oversizedTransactions.get();
    }

    @Override
    public long getCommitThroughput() {
        long timeSpent = Duration.between(this.startTime, this.clock.instant()).toMillis();
        return this.committedTransactions.get() * 1000L / (timeSpent != 0L ? timeSpent : 1L);
    }

    @Override
    public long getRegisteredDmlCount() {
        return this.registeredDmlCount.get();
    }

    @Override
    public String getOldestScn() {
        return this.oldestScn.get().toString();
    }

    @Override
    public String getCommittedScn() {
        return this.committedScn.get().toString();
    }

    @Override
    public String getOffsetScn() {
        return this.offsetScn.get().toString();
    }

    @Override
    public long getLagFromSourceInMilliseconds() {
        return this.lagFromTheSourceDuration.get().toMillis();
    }

    @Override
    public long getMaxLagFromSourceInMilliseconds() {
        return this.maxLagFromTheSourceDuration.get().toMillis();
    }

    @Override
    public long getMinLagFromSourceInMilliseconds() {
        return this.minLagFromTheSourceDuration.get().toMillis();
    }

    @Override
    public Set<String> getAbandonedTransactionIds() {
        return this.abandonedTransactionIds.get().keySet();
    }

    @Override
    public Set<String> getRolledBackTransactionIds() {
        return this.rolledBackTransactionIds.get().keySet();
    }

    @Override
    public long getLastCommitDurationInMilliseconds() {
        return this.lastCommitDuration.get().toMillis();
    }

    @Override
    public long getMaxCommitDurationInMilliseconds() {
        return this.maxCommitDuration.get().toMillis();
    }

    @Override
    public int getErrorCount() {
        return this.errorCount.get();
    }

    @Override
    public int getWarningCount() {
        return this.warningCount.get();
    }

    @Override
    public int getScnFreezeCount() {
        return this.scnFreezeCount.get();
    }

    @Override
    public int getUnparsableDdlCount() {
        return this.unparsableDdlCount.get();
    }

    @Override
    public long getMiningSessionUserGlobalAreaMemoryInBytes() {
        return this.miningSessionUserGlobalAreaMemory.get();
    }

    @Override
    public long getMiningSessionUserGlobalAreaMaxMemoryInBytes() {
        return this.miningSessionUserGlobalAreaMaxMemory.get();
    }

    @Override
    public long getMiningSessionProcessGlobalAreaMemoryInBytes() {
        return this.miningSessionProcessGlobalAreaMemory.get();
    }

    @Override
    public long getMiningSessionProcessGlobalAreaMaxMemoryInBytes() {
        return this.miningSessionProcessGlobalAreaMaxMemory.get();
    }

    public void setOldestScn(Scn scn) {
        this.oldestScn.set(scn);
    }

    public void setCommittedScn(Scn scn) {
        this.committedScn.set(scn);
    }

    public void setOffsetScn(Scn scn) {
        this.offsetScn.set(scn);
    }

    public void setActiveTransactions(long activeTransactionCount) {
        this.activeTransactions.set(activeTransactionCount);
    }

    public void incrementRolledBackTransactions() {
        this.rolledBackTransactions.incrementAndGet();
    }

    public void incrementCommittedTransactions() {
        this.committedTransactions.incrementAndGet();
    }

    public void incrementOversizedTransactions() {
        this.oversizedTransactions.incrementAndGet();
    }

    public void incrementRegisteredDmlCount() {
        this.registeredDmlCount.incrementAndGet();
    }

    public void incrementCommittedDmlCount(long counter) {
        this.committedDmlCount.getAndAdd(counter);
    }

    public void incrementErrorCount() {
        this.errorCount.incrementAndGet();
    }

    public void incrementWarningCount() {
        this.warningCount.incrementAndGet();
    }

    public void incrementScnFreezeCount() {
        this.scnFreezeCount.incrementAndGet();
    }

    public void addAbandonedTransactionId(String transactionId) {
        if (transactionId != null) {
            this.abandonedTransactionIds.get().put((Object)transactionId, (Object)transactionId);
        }
    }

    public void addRolledBackTransactionId(String transactionId) {
        if (transactionId != null) {
            this.rolledBackTransactionIds.get().put((Object)transactionId, (Object)transactionId);
        }
    }

    public void setLastCommitDuration(Duration lastDuration) {
        this.lastCommitDuration.set(lastDuration);
        if (lastDuration.toMillis() > this.maxCommitDuration.get().toMillis()) {
            this.maxCommitDuration.set(lastDuration);
        }
    }

    public void calculateTimeDifference(OffsetDateTime databaseSystemTime) {
        this.zoneOffset.set(databaseSystemTime.getOffset());
        LOGGER.trace("Timezone offset of database system time is {} seconds", (Object)this.zoneOffset.get().getTotalSeconds());
        Instant now = this.clock.instant();
        long timeDiffMillis = Duration.between(databaseSystemTime.toInstant(), now).toMillis();
        this.timeDifference.set(timeDiffMillis);
        LOGGER.trace("Current time {} ms, database difference {} ms", (Object)now.toEpochMilli(), (Object)timeDiffMillis);
    }

    public ZoneOffset getDatabaseOffset() {
        return this.zoneOffset.get();
    }

    public void calculateLagMetrics(Instant changeTime) {
        if (changeTime != null) {
            Instant correctedChangeTime = changeTime.plusMillis(this.timeDifference.longValue()).minusSeconds(this.zoneOffset.get().getTotalSeconds());
            Duration lag = Duration.between(correctedChangeTime, this.clock.instant()).abs();
            this.lagFromTheSourceDuration.set(lag);
            if (this.maxLagFromTheSourceDuration.get().toMillis() < lag.toMillis()) {
                this.maxLagFromTheSourceDuration.set(lag);
            }
            if (this.minLagFromTheSourceDuration.get().toMillis() > lag.toMillis()) {
                this.minLagFromTheSourceDuration.set(lag);
            } else if (this.minLagFromTheSourceDuration.get().toMillis() == 0L) {
                this.minLagFromTheSourceDuration.set(lag);
            }
        }
    }

    public void incrementUnparsableDdlCount() {
        this.unparsableDdlCount.incrementAndGet();
    }

    public void setUserGlobalAreaMemory(long ugaMemory, long ugaMaxMemory) {
        this.miningSessionUserGlobalAreaMemory.set(ugaMemory);
        if (ugaMaxMemory > this.miningSessionUserGlobalAreaMaxMemory.get()) {
            this.miningSessionUserGlobalAreaMaxMemory.set(ugaMaxMemory);
        }
    }

    public void setProcessGlobalAreaMemory(long pgaMemory, long pgaMaxMemory) {
        this.miningSessionProcessGlobalAreaMemory.set(pgaMemory);
        if (pgaMemory > this.miningSessionProcessGlobalAreaMaxMemory.get()) {
            this.miningSessionProcessGlobalAreaMaxMemory.set(pgaMemory);
        }
    }

    public String toString() {
        return "OracleStreamingChangeEventSourceMetrics{currentScn=" + this.currentScn + ", oldestScn=" + this.oldestScn.get() + ", committedScn=" + this.committedScn.get() + ", offsetScn=" + this.offsetScn.get() + ", logMinerQueryCount=" + this.logMinerQueryCount + ", totalProcessedRows=" + this.totalProcessedRows + ", totalCapturedDmlCount=" + this.totalCapturedDmlCount + ", totalDurationOfFetchingQuery=" + this.totalDurationOfFetchingQuery + ", lastCapturedDmlCount=" + this.lastCapturedDmlCount + ", lastDurationOfFetchingQuery=" + this.lastDurationOfFetchingQuery + ", maxCapturedDmlCount=" + this.maxCapturedDmlCount + ", maxDurationOfFetchingQuery=" + this.maxDurationOfFetchingQuery + ", totalBatchProcessingDuration=" + this.totalBatchProcessingDuration + ", lastBatchProcessingDuration=" + this.lastBatchProcessingDuration + ", maxBatchProcessingThroughput=" + this.maxBatchProcessingThroughput + ", currentLogFileName=" + Arrays.asList(this.currentLogFileName.get()) + ", minLogFilesMined=" + this.minimumLogsMined + ", maxLogFilesMined=" + this.maximumLogsMined + ", redoLogStatus=" + Arrays.asList(this.redoLogStatus.get()) + ", switchCounter=" + this.switchCounter + ", batchSize=" + this.batchSize + ", millisecondToSleepBetweenMiningQuery=" + this.millisecondToSleepBetweenMiningQuery + ", hoursToKeepTransaction=" + this.hoursToKeepTransaction + ", networkConnectionProblemsCounter" + this.networkConnectionProblemsCounter + ", batchSizeDefault=" + this.batchSizeDefault + ", batchSizeMin=" + this.batchSizeMin + ", batchSizeMax=" + this.batchSizeMax + ", sleepTimeDefault=" + this.sleepTimeDefault + ", sleepTimeMin=" + this.sleepTimeMin + ", sleepTimeMax=" + this.sleepTimeMax + ", sleepTimeIncrement=" + this.sleepTimeIncrement + ", totalParseTime=" + this.totalParseTime + ", totalStartLogMiningSessionDuration=" + this.totalStartLogMiningSessionDuration + ", lastStartLogMiningSessionDuration=" + this.lastStartLogMiningSessionDuration + ", maxStartLogMiningSessionDuration=" + this.maxStartingLogMiningSessionDuration + ", totalProcessTime=" + this.totalProcessingTime + ", minBatchProcessTime=" + this.minBatchProcessingTime + ", maxBatchProcessTime=" + this.maxBatchProcessingTime + ", totalResultSetNextTime=" + this.totalResultSetNextTime + ", lagFromTheSource=Duration" + this.lagFromTheSourceDuration.get() + ", maxLagFromTheSourceDuration=" + this.maxLagFromTheSourceDuration.get() + ", minLagFromTheSourceDuration=" + this.minLagFromTheSourceDuration.get() + ", lastCommitDuration=" + this.lastCommitDuration + ", maxCommitDuration=" + this.maxCommitDuration + ", activeTransactions=" + this.activeTransactions.get() + ", rolledBackTransactions=" + this.rolledBackTransactions.get() + ", oversizedTransactions=" + this.oversizedTransactions.get() + ", committedTransactions=" + this.committedTransactions.get() + ", abandonedTransactionIds=" + this.abandonedTransactionIds.get() + ", rolledbackTransactionIds=" + this.rolledBackTransactionIds.get() + ", registeredDmlCount=" + this.registeredDmlCount.get() + ", committedDmlCount=" + this.committedDmlCount.get() + ", errorCount=" + this.errorCount.get() + ", warningCount=" + this.warningCount.get() + ", scnFreezeCount=" + this.scnFreezeCount.get() + ", unparsableDdlCount=" + this.unparsableDdlCount.get() + ", miningSessionUserGlobalAreaMemory=" + this.miningSessionUserGlobalAreaMemory.get() + ", miningSessionUserGlobalAreaMaxMemory=" + this.miningSessionUserGlobalAreaMaxMemory.get() + ", miningSessionProcessGlobalAreaMemory=" + this.miningSessionProcessGlobalAreaMemory.get() + ", miningSessionProcessGlobalAreaMaxMemory=" + this.miningSessionProcessGlobalAreaMaxMemory.get() + "}";
    }
}

