/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.config.Instantiator;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.oracle.Module;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleSourceInfoStructMaker;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.connector.oracle.logminer.logwriter.LogWriterFlushStrategy;
import io.debezium.connector.oracle.logminer.processor.LogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.infinispan.EmbeddedInfinispanLogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.infinispan.RemoteInfinispanLogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.memory.MemoryLogMinerEventProcessor;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.util.Strings;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    protected static final int DEFAULT_PORT = 1528;
    protected static final int DEFAULT_LOG_FILE_QUERY_MAX_RETRIES = 5;
    protected static final int DEFAULT_BATCH_SIZE = 20000;
    protected static final int MIN_BATCH_SIZE = 1000;
    protected static final int MAX_BATCH_SIZE = 100000;
    protected static final int DEFAULT_SCN_GAP_SIZE = 1000000;
    protected static final int DEFAULT_SCN_GAP_TIME_INTERVAL = 20000;
    protected static final int DEFAULT_TRANSACTION_EVENTS_THRESHOLD = 0;
    protected static final Duration MAX_SLEEP_TIME = Duration.ofMillis(3000L);
    protected static final Duration DEFAULT_SLEEP_TIME = Duration.ofMillis(1000L);
    protected static final Duration MIN_SLEEP_TIME = Duration.ZERO;
    protected static final Duration SLEEP_TIME_INCREMENT = Duration.ofMillis(200L);
    protected static final Duration ARCHIVE_LOG_ONLY_POLL_TIME = Duration.ofMillis(10000L);
    public static final Field PORT = RelationalDatabaseConnectorConfig.PORT.withDefault(1528);
    public static final Field HOSTNAME = RelationalDatabaseConnectorConfig.HOSTNAME.withNoValidation().withValidation(new Field.Validator[]{OracleConnectorConfig::requiredWhenNoUrl});
    public static final Field PDB_NAME = Field.create((String)"database.pdb.name").withDisplayName("PDB name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)8)).withDescription("Name of the pluggable database when working with a multi-tenant set-up. The CDB name must be given via " + DATABASE_NAME.name() + " in this case.");
    public static final Field XSTREAM_SERVER_NAME = Field.create((String)"database.out.server.name").withDisplayName("XStream out server name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)9)).withValidation(new Field.Validator[]{OracleConnectorConfig::validateOutServerName}).withDescription("Name of the XStream Out server to connect to.");
    public static final Field INTERVAL_HANDLING_MODE = Field.create((String)"interval.handling.mode").withDisplayName("Interval Handling").withEnum(IntervalHandlingMode.class, (Enum)IntervalHandlingMode.NUMERIC).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)6)).withDescription("Specify how INTERVAL columns should be represented in change events, including: 'string' represents values as an exact ISO formatted string; 'numeric' (default) represents values using the inexact conversion into microseconds");
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)0)).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should run a snapshot only when no offsets are available for the logical server name; 'schema_only' to specify the connector should run a snapshot of the schema when no offsets are available for the logical server name. ");
    public static final Field SNAPSHOT_LOCKING_MODE = Field.create((String)"snapshot.locking.mode").withDisplayName("Snapshot locking mode").withEnum(SnapshotLockingMode.class, (Enum)SnapshotLockingMode.SHARED).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)1)).withDescription("Controls how the connector holds locks on tables while performing the schema snapshot. The default is 'shared', which means the connector will hold a table lock that prevents exclusive table access for just the initial portion of the snapshot while the database schemas and other metadata are being read. The remaining work in a snapshot involves selecting all rows from each table, and this is done using a flashback query that requires no locks. However, in some cases it may be desirable to avoid locks entirely which can be done by specifying 'none'. This mode is only safe to use if no schema changes are happening while the snapshot is taken.");
    public static final Field CONNECTOR_ADAPTER = Field.create((String)"database.connection.adapter").withDisplayName("Connector adapter").withEnum(ConnectorAdapter.class, (Enum)ConnectorAdapter.LOG_MINER).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)7)).withDescription("The adapter to use when capturing changes from the database. Options include: 'logminer': (the default) to capture changes using native Oracle LogMiner; 'xstream' to capture changes using Oracle XStreams");
    public static final Field LOG_MINING_STRATEGY = Field.create((String)"log.mining.strategy").withDisplayName("Log Mining Strategy").withEnum(LogMiningStrategy.class, (Enum)LogMiningStrategy.CATALOG_IN_REDO).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)8)).withDescription("There are strategies: Online catalog with faster mining but no captured DDL. Another - with data dictionary loaded into REDO LOG files");
    public static final Field CONTINUOUS_MINE = Field.create((String)"log.mining.continuous.mine").withDisplayName("Should log mining session configured with CONTINUOUS_MINE setting?").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("If true, CONTINUOUS_MINE option will be added to the log mining session. This will manage log files switches seamlessly.");
    public static final Field SNAPSHOT_ENHANCEMENT_TOKEN = Field.create((String)"snapshot.enhance.predicate.scn").withDisplayName("A string to replace on snapshot predicate enhancement").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)11)).withDescription("A token to replace on snapshot predicate template");
    public static final Field LOG_MINING_TRANSACTION_RETENTION = Field.create((String)"log.mining.transaction.retention.hours").withDisplayName("Log Mining long running transaction retention").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(0).withValidation(new Field.Validator[]{Field::isNonNegativeInteger}).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)18)).withDescription("Hours to keep long running transactions in transaction buffer between log mining sessions. By default, all transactions are retained.");
    public static final Field RAC_NODES = Field.create((String)"rac.nodes").withDisplayName("Oracle RAC nodes").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{OracleConnectorConfig::validateRacNodes}).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)11)).withDescription("A comma-separated list of RAC node hostnames or ip addresses");
    public static final Field URL = Field.create((String)"database.url").withDisplayName("Complete JDBC URL").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{OracleConnectorConfig::requiredWhenNoHostname}).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)10)).withDescription("Complete JDBC URL as an alternative to specifying hostname, port and database provided as a way to support alternative connection scenarios.");
    public static final Field LOG_MINING_ARCHIVE_LOG_HOURS = Field.create((String)"log.mining.archive.log.hours").withDisplayName("Log Mining Archive Log Hours").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)10)).withDefault(0).withDescription("The number of hours in the past from SYSDATE to mine archive logs. Using 0 mines all available archive logs");
    public static final Field LOG_MINING_BATCH_SIZE_MIN = Field.create((String)"log.mining.batch.size.min").withDisplayName("Minimum batch size for reading redo/archive logs.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)12)).withDefault(1000).withDescription("The minimum SCN interval size that this connector will try to read from redo/archive logs. Active batch size will be also increased/decreased by this amount for tuning connector throughput when needed.");
    public static final Field LOG_MINING_BATCH_SIZE_DEFAULT = Field.create((String)"log.mining.batch.size.default").withDisplayName("Default batch size for reading redo/archive logs.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)11)).withDefault(20000).withDescription("The starting SCN interval size that the connector will use for reading data from redo/archive logs.");
    public static final Field LOG_MINING_BATCH_SIZE_MAX = Field.create((String)"log.mining.batch.size.max").withDisplayName("Maximum batch size for reading redo/archive logs.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)13)).withDefault(100000).withDescription("The maximum SCN interval size that this connector will use when reading from redo/archive logs.");
    public static final Field LOG_MINING_SLEEP_TIME_MIN_MS = Field.create((String)"log.mining.sleep.time.min.ms").withDisplayName("Minimum sleep time in milliseconds when reading redo/archive logs.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)15)).withDefault(MIN_SLEEP_TIME.toMillis()).withDescription("The minimum amount of time that the connector will sleep after reading data from redo/archive logs and before starting reading data again. Value is in milliseconds.");
    public static final Field LOG_MINING_SLEEP_TIME_DEFAULT_MS = Field.create((String)"log.mining.sleep.time.default.ms").withDisplayName("Default sleep time in milliseconds when reading redo/archive logs.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)14)).withDefault(DEFAULT_SLEEP_TIME.toMillis()).withDescription("The amount of time that the connector will sleep after reading data from redo/archive logs and before starting reading data again. Value is in milliseconds.");
    public static final Field LOG_MINING_SLEEP_TIME_MAX_MS = Field.create((String)"log.mining.sleep.time.max.ms").withDisplayName("Maximum sleep time in milliseconds when reading redo/archive logs.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)16)).withDefault(MAX_SLEEP_TIME.toMillis()).withDescription("The maximum amount of time that the connector will sleep after reading data from redo/archive logs and before starting reading data again. Value is in milliseconds.");
    public static final Field LOG_MINING_SLEEP_TIME_INCREMENT_MS = Field.create((String)"log.mining.sleep.time.increment.ms").withDisplayName("The increment in sleep time in milliseconds used to tune auto-sleep behavior.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)17)).withDefault(SLEEP_TIME_INCREMENT.toMillis()).withDescription("The maximum amount of time that the connector will use to tune the optimal sleep time when reading data from LogMiner. Value is in milliseconds.");
    public static final Field LOG_MINING_ARCHIVE_LOG_ONLY_MODE = Field.create((String)"log.mining.archive.log.only.mode").withDisplayName("Specifies whether log mining should only target archive logs or both archive and redo logs").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)9)).withDefault(false).withDescription("When set to 'false', the default, the connector will mine both archive log and redo logs to emit change events. When set to 'true', the connector will only mine archive logs. There are circumstances where its advantageous to only mine archive logs and accept latency in event emission due to frequent revolving redo logs.");
    public static final Field LOG_MINING_ARCHIVE_LOG_ONLY_SCN_POLL_INTERVAL_MS = Field.create((String)"log.mining.archive.log.only.scn.poll.interval.ms").withDisplayName("The interval in milliseconds to wait between polls when SCN is not yet in the archive logs").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)27)).withDefault(ARCHIVE_LOG_ONLY_POLL_TIME.toMillis()).withDescription("The interval in milliseconds to wait between polls checking to see if the SCN is in the archive logs.");
    public static final Field LOB_ENABLED = Field.create((String)"lob.enabled").withDisplayName("Specifies whether the connector supports mining LOB fields and operations").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)21)).withDefault(false).withDescription("When set to 'false', the default, LOB fields will not be captured nor emitted. When set to 'true', the connector will capture LOB fields and emit changes for those fields like any other column type.");
    public static final Field LOG_MINING_USERNAME_EXCLUDE_LIST = Field.create((String)"log.mining.username.exclude.list").withDisplayName("List of users to exclude from LogMiner query").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)19)).withDescription("Comma separated list of usernames to exclude from LogMiner query.");
    public static final Field LOG_MINING_ARCHIVE_DESTINATION_NAME = Field.create((String)"log.mining.archive.destination.name").withDisplayName("Name of the archive log destination to be used for reading archive logs").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)20)).withDescription("Sets the specific archive log destination as the source for reading archive logs.When not set, the connector will automatically select the first LOCAL and VALID destination.");
    public static final Field LOG_MINING_BUFFER_TYPE = Field.create((String)"log.mining.buffer.type").withDisplayName("Controls which buffer type implementation to be used").withEnum(LogMiningBufferType.class, (Enum)LogMiningBufferType.MEMORY).withValidation(new Field.Validator[]{OracleConnectorConfig::validateLogMiningBufferType}).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)21)).withDescription("The buffer type controls how the connector manages buffering transaction data." + System.lineSeparator() + System.lineSeparator() + "memory - Uses the JVM process' heap to buffer all transaction data." + System.lineSeparator() + System.lineSeparator() + "infinispan_embedded - This option uses an embedded Infinispan cache to buffer transaction data and persist it to disk." + System.lineSeparator() + System.lineSeparator() + "infinispan_remote - This option uses a remote Infinispan cluster to buffer transaction data and persist it to disk.");
    public static final Field LOG_MINING_BUFFER_TRANSACTION_EVENTS_THRESHOLD = Field.create((String)"log.mining.buffer.transaction.events.threshold").withDisplayName("The maximum number of events a transaction can have before being discarded.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(0).withValidation(new Field.Validator[]{Field::isNonNegativeLong}).withDescription("The number of events a transaction can include before the transaction is discarded. This is useful for managing buffer memory and/or space when dealing with very large transactions. Defaults to 0, meaning that no threshold is applied and transactions can have unlimited events.");
    public static final Field LOG_MINING_BUFFER_INFINISPAN_CACHE_TRANSACTIONS = Field.create((String)"log.mining.buffer.infinispan.cache.transactions").withDisplayName("Infinispan 'transactions' cache configuration").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)23)).withValidation(new Field.Validator[]{OracleConnectorConfig::validateLogMiningInfinispanCacheConfiguration}).withDescription("Specifies the XML configuration for the Infinispan 'transactions' cache");
    public static final Field LOG_MINING_BUFFER_INFINISPAN_CACHE_PROCESSED_TRANSACTIONS = Field.create((String)"log.mining.buffer.infinispan.cache.processed_transactions").withDisplayName("Infinispan 'processed-transactions' cache configuration").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)25)).withValidation(new Field.Validator[]{OracleConnectorConfig::validateLogMiningInfinispanCacheConfiguration}).withDescription("Specifies the XML configuration for the Infinispan 'processed-transactions' cache");
    public static final Field LOG_MINING_BUFFER_INFINISPAN_CACHE_EVENTS = Field.create((String)"log.mining.buffer.infinispan.cache.events").withDisplayName("Infinispan 'events' cache configurations").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)24)).withValidation(new Field.Validator[]{OracleConnectorConfig::validateLogMiningInfinispanCacheConfiguration}).withDescription("Specifies the XML configuration for the Infinispan 'events' cache");
    public static final Field LOG_MINING_BUFFER_INFINISPAN_CACHE_SCHEMA_CHANGES = Field.create((String)"log.mining.buffer.infinispan.cache.schema_changes").withDisplayName("Infinispan 'schema-changes' cache configuration").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)26)).withValidation(new Field.Validator[]{OracleConnectorConfig::validateLogMiningInfinispanCacheConfiguration}).withDescription("Specifies the XML configuration for the Infinispan 'schema-changes' cache");
    public static final Field LOG_MINING_BUFFER_DROP_ON_STOP = Field.create((String)"log.mining.buffer.drop.on.stop").withDisplayName("Controls whether the buffer cache is dropped when connector is stopped").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("When set to true the underlying buffer cache is not retained when the connector is stopped. When set to false (the default), the buffer cache is retained across restarts.");
    public static final Field LOG_MINING_SCN_GAP_DETECTION_GAP_SIZE_MIN = Field.create((String)"log.mining.scn.gap.detection.gap.size.min").withDisplayName("SCN gap size used to detect SCN gap").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)28)).withDefault(1000000).withDescription("Used for SCN gap detection, if the difference between current SCN and previous end SCN is bigger than this value, and the time difference of current SCN and previous end SCN is smaller than log.mining.scn.gap.detection.time.interval.max.ms, consider it a SCN gap.");
    public static final Field LOG_MINING_SCN_GAP_DETECTION_TIME_INTERVAL_MAX_MS = Field.create((String)"log.mining.scn.gap.detection.time.interval.max.ms").withDisplayName("Timer interval used to detect SCN gap").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)29)).withDefault(20000).withDescription("Used for SCN gap detection, if the difference between current SCN and previous end SCN is bigger than log.mining.scn.gap.detection.gap.size.min, and the time difference of current SCN and previous end SCN is smaller than  this value, consider it a SCN gap.");
    public static final Field LOG_MINING_LOG_QUERY_MAX_RETRIES = Field.createInternal((String)"log.mining.log.query.max.retries").withDisplayName("Maximum number of retries before failing to locate redo logs").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(5).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("The maximum number of log query retries before throwing an exception that logs cannot be found.");
    public static final Field LOG_MINING_LOG_BACKOFF_INITIAL_DELAY_MS = Field.createInternal((String)"log.mining.log.backoff.initial.delay.ms").withDisplayName("Initial delay when logs cannot yet be found (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(TimeUnit.SECONDS.toMillis(1L)).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("The initial delay when trying to query database redo logs, given in milliseconds. Defaults to 1 second (1,000 ms).");
    public static final Field LOG_MINING_LOG_BACKOFF_MAX_DELAY_MS = Field.createInternal((String)"log.mining.log.backoff.max.delay.ms").withDisplayName("Maximum delay when logs cannot yet be found (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(TimeUnit.MINUTES.toMillis(1L)).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("The maximum delay when trying to query database redo logs, given in milliseconds. Defaults to 60 seconds (60,000 ms).");
    public static final Field LOG_MINING_SESSION_MAX_MS = Field.create((String)"log.mining.session.max.ms").withDisplayName("Maximum number of milliseconds of a single LogMiner session").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(TimeUnit.MINUTES.toMillis(0L)).withValidation(new Field.Validator[]{Field::isNonNegativeInteger}).withDescription("The maximum number of milliseconds that a LogMiner session lives for before being restarted. Defaults to 0 (indefinite until a log switch occurs)");
    public static final Field LOG_MINING_TRANSACTION_SNAPSHOT_BOUNDARY_MODE = Field.createInternal((String)"log.mining.transaction.snapshot.boundary.mode").withEnum(TransactionSnapshotBoundaryMode.class, (Enum)TransactionSnapshotBoundaryMode.SKIP).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Specifies how in-progress transactions are to be handled when resolving the snapshot SCN. " + System.lineSeparator() + "all - Captures in-progress transactions from both V$TRANSACTION and starting a LogMiner session near the snapshot SCN." + System.lineSeparator() + "transaction_view_only - Captures in-progress transactions based on data in V$TRANSACTION only. Recently committed transactions near the flashback query SCN won't be included in the snapshot nor streaming." + System.lineSeparator() + "skip - Skips gathering any in-progress transactions.");
    public static final Field LOG_MINING_READ_ONLY = Field.createInternal((String)"log.mining.read.only").withDisplayName("Runs the connector in read-only mode").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(Boolean.FALSE.booleanValue()).withValidation(new Field.Validator[]{OracleConnectorConfig::validateLogMiningReadOnly}).withDescription("When set to 'true', the connector will not attempt to flush the LGWR buffer to disk, allowing connecting to read-only databases.");
    private static final ConfigDefinition CONFIG_DEFINITION = HistorizedRelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("Oracle").excluding(new Field[]{SCHEMA_INCLUDE_LIST, SCHEMA_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN}).type(new Field[]{HOSTNAME, PORT, USER, PASSWORD, DATABASE_NAME, PDB_NAME, XSTREAM_SERVER_NAME, SNAPSHOT_MODE, CONNECTOR_ADAPTER, LOG_MINING_STRATEGY, URL}).connector(new Field[]{SNAPSHOT_ENHANCEMENT_TOKEN, SNAPSHOT_LOCKING_MODE, RAC_NODES, INTERVAL_HANDLING_MODE, LOG_MINING_ARCHIVE_LOG_HOURS, LOG_MINING_BATCH_SIZE_DEFAULT, LOG_MINING_BATCH_SIZE_MIN, LOG_MINING_BATCH_SIZE_MAX, LOG_MINING_SLEEP_TIME_DEFAULT_MS, LOG_MINING_SLEEP_TIME_MIN_MS, LOG_MINING_SLEEP_TIME_MAX_MS, LOG_MINING_SLEEP_TIME_INCREMENT_MS, LOG_MINING_TRANSACTION_RETENTION, LOG_MINING_ARCHIVE_LOG_ONLY_MODE, LOB_ENABLED, LOG_MINING_USERNAME_EXCLUDE_LIST, LOG_MINING_ARCHIVE_DESTINATION_NAME, LOG_MINING_BUFFER_TYPE, LOG_MINING_BUFFER_DROP_ON_STOP, LOG_MINING_BUFFER_INFINISPAN_CACHE_TRANSACTIONS, LOG_MINING_BUFFER_INFINISPAN_CACHE_EVENTS, LOG_MINING_BUFFER_INFINISPAN_CACHE_PROCESSED_TRANSACTIONS, LOG_MINING_BUFFER_INFINISPAN_CACHE_SCHEMA_CHANGES, LOG_MINING_BUFFER_TRANSACTION_EVENTS_THRESHOLD, LOG_MINING_ARCHIVE_LOG_ONLY_SCN_POLL_INTERVAL_MS, LOG_MINING_SCN_GAP_DETECTION_GAP_SIZE_MIN, LOG_MINING_SCN_GAP_DETECTION_TIME_INTERVAL_MAX_MS, UNAVAILABLE_VALUE_PLACEHOLDER, BINARY_HANDLING_MODE, SCHEMA_NAME_ADJUSTMENT_MODE, LOG_MINING_LOG_QUERY_MAX_RETRIES, LOG_MINING_LOG_BACKOFF_INITIAL_DELAY_MS, LOG_MINING_LOG_BACKOFF_MAX_DELAY_MS, LOG_MINING_SESSION_MAX_MS, LOG_MINING_TRANSACTION_SNAPSHOT_BOUNDARY_MODE, LOG_MINING_READ_ONLY}).create();
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    public static final List<String> EXCLUDED_SCHEMAS = Collections.unmodifiableList(Arrays.asList("appqossys", "audsys", "ctxsys", "dvsys", "dbsfwuser", "dbsnmp", "gsmadmin_internal", "lbacsys", "mdsys", "ojvmsys", "olapsys", "orddata", "ordsys", "outln", "sys", "system", "wmsys", "xdb"));
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleConnectorConfig.class);
    private final String databaseName;
    private final String pdbName;
    private final String xoutServerName;
    private final IntervalHandlingMode intervalHandlingMode;
    private final SnapshotMode snapshotMode;
    private ConnectorAdapter connectorAdapter;
    private final StreamingAdapter streamingAdapter;
    private final String snapshotEnhancementToken;
    private final SnapshotLockingMode snapshotLockingMode;
    private final LogMiningStrategy logMiningStrategy;
    private final Set<String> racNodes;
    private final boolean logMiningContinuousMine;
    private final Duration logMiningArchiveLogRetention;
    private final int logMiningBatchSizeMin;
    private final int logMiningBatchSizeMax;
    private final int logMiningBatchSizeDefault;
    private final Duration logMiningSleepTimeMin;
    private final Duration logMiningSleepTimeMax;
    private final Duration logMiningSleepTimeDefault;
    private final Duration logMiningSleepTimeIncrement;
    private final Duration logMiningTransactionRetention;
    private final boolean archiveLogOnlyMode;
    private final Duration archiveLogOnlyScnPollTime;
    private final boolean lobEnabled;
    private final Set<String> logMiningUsernameExcludes;
    private final String logMiningArchiveDestinationName;
    private final LogMiningBufferType logMiningBufferType;
    private final long logMiningBufferTransactionEventsThreshold;
    private final boolean logMiningBufferDropOnStop;
    private final int logMiningScnGapDetectionGapSizeMin;
    private final int logMiningScnGapDetectionTimeIntervalMaxMs;
    private final int logMiningLogFileQueryMaxRetries;
    private final Duration logMiningInitialDelay;
    private final Duration logMiningMaxDelay;
    private final Duration logMiningMaximumSession;
    private final TransactionSnapshotBoundaryMode logMiningTransactionSnapshotBoundaryMode;
    private final Boolean logMiningReadOnly;

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public OracleConnectorConfig(Configuration config) {
        super(OracleConnector.class, config, (Tables.TableFilter)new SystemTablesPredicate(config), x -> x.schema() + "." + x.table(), true, ColumnFilterMode.SCHEMA, false);
        this.databaseName = OracleConnectorConfig.toUpperCase(config.getString(DATABASE_NAME));
        this.pdbName = OracleConnectorConfig.toUpperCase(config.getString(PDB_NAME));
        this.xoutServerName = config.getString(XSTREAM_SERVER_NAME);
        this.intervalHandlingMode = IntervalHandlingMode.parse(config.getString(INTERVAL_HANDLING_MODE));
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE));
        this.snapshotEnhancementToken = config.getString(SNAPSHOT_ENHANCEMENT_TOKEN);
        this.connectorAdapter = ConnectorAdapter.parse(config.getString(CONNECTOR_ADAPTER));
        this.snapshotLockingMode = SnapshotLockingMode.parse(config.getString(SNAPSHOT_LOCKING_MODE), SNAPSHOT_LOCKING_MODE.defaultValueAsString());
        this.lobEnabled = config.getBoolean(LOB_ENABLED);
        this.streamingAdapter = this.connectorAdapter.getInstance(this);
        if (this.streamingAdapter == null) {
            throw new DebeziumException("Unable to instantiate the connector adapter implementation");
        }
        this.logMiningStrategy = LogMiningStrategy.parse(config.getString(LOG_MINING_STRATEGY));
        this.racNodes = this.resolveRacNodes(config);
        this.logMiningContinuousMine = config.getBoolean(CONTINUOUS_MINE);
        this.logMiningArchiveLogRetention = Duration.ofHours(config.getLong(LOG_MINING_ARCHIVE_LOG_HOURS));
        this.logMiningBatchSizeMin = config.getInteger(LOG_MINING_BATCH_SIZE_MIN);
        this.logMiningBatchSizeMax = config.getInteger(LOG_MINING_BATCH_SIZE_MAX);
        this.logMiningBatchSizeDefault = config.getInteger(LOG_MINING_BATCH_SIZE_DEFAULT);
        this.logMiningSleepTimeMin = Duration.ofMillis(config.getInteger(LOG_MINING_SLEEP_TIME_MIN_MS));
        this.logMiningSleepTimeMax = Duration.ofMillis(config.getInteger(LOG_MINING_SLEEP_TIME_MAX_MS));
        this.logMiningSleepTimeDefault = Duration.ofMillis(config.getInteger(LOG_MINING_SLEEP_TIME_DEFAULT_MS));
        this.logMiningSleepTimeIncrement = Duration.ofMillis(config.getInteger(LOG_MINING_SLEEP_TIME_INCREMENT_MS));
        this.logMiningTransactionRetention = Duration.ofHours(config.getInteger(LOG_MINING_TRANSACTION_RETENTION));
        this.archiveLogOnlyMode = config.getBoolean(LOG_MINING_ARCHIVE_LOG_ONLY_MODE);
        this.logMiningUsernameExcludes = Strings.setOf((String)config.getString(LOG_MINING_USERNAME_EXCLUDE_LIST), String::new);
        this.logMiningArchiveDestinationName = config.getString(LOG_MINING_ARCHIVE_DESTINATION_NAME);
        this.logMiningBufferType = LogMiningBufferType.parse(config.getString(LOG_MINING_BUFFER_TYPE));
        this.logMiningBufferTransactionEventsThreshold = config.getLong(LOG_MINING_BUFFER_TRANSACTION_EVENTS_THRESHOLD);
        this.logMiningBufferDropOnStop = config.getBoolean(LOG_MINING_BUFFER_DROP_ON_STOP);
        this.archiveLogOnlyScnPollTime = Duration.ofMillis(config.getInteger(LOG_MINING_ARCHIVE_LOG_ONLY_SCN_POLL_INTERVAL_MS));
        this.logMiningScnGapDetectionGapSizeMin = config.getInteger(LOG_MINING_SCN_GAP_DETECTION_GAP_SIZE_MIN);
        this.logMiningScnGapDetectionTimeIntervalMaxMs = config.getInteger(LOG_MINING_SCN_GAP_DETECTION_TIME_INTERVAL_MAX_MS);
        this.logMiningLogFileQueryMaxRetries = config.getInteger(LOG_MINING_LOG_QUERY_MAX_RETRIES);
        this.logMiningInitialDelay = Duration.ofMillis(config.getLong(LOG_MINING_LOG_BACKOFF_INITIAL_DELAY_MS));
        this.logMiningMaxDelay = Duration.ofMillis(config.getLong(LOG_MINING_LOG_BACKOFF_MAX_DELAY_MS));
        this.logMiningMaximumSession = Duration.ofMillis(config.getLong(LOG_MINING_SESSION_MAX_MS));
        this.logMiningTransactionSnapshotBoundaryMode = TransactionSnapshotBoundaryMode.parse(config.getString(LOG_MINING_TRANSACTION_SNAPSHOT_BOUNDARY_MODE));
        this.logMiningReadOnly = config.getBoolean(LOG_MINING_READ_ONLY);
    }

    private static String toUpperCase(String property) {
        return property == null ? null : property.toUpperCase();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public String getCatalogName() {
        return this.pdbName != null ? this.pdbName : this.databaseName;
    }

    public String getXoutServerName() {
        return this.xoutServerName;
    }

    public IntervalHandlingMode getIntervalHandlingMode() {
        return this.intervalHandlingMode;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public SnapshotLockingMode getSnapshotLockingMode() {
        return this.snapshotLockingMode;
    }

    protected HistoryRecordComparator getHistoryRecordComparator() {
        return this.getAdapter().getHistoryRecordComparator();
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new OracleSourceInfoStructMaker(Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    public String getContextName() {
        return Module.contextName();
    }

    public StreamingAdapter getAdapter() {
        return this.streamingAdapter;
    }

    public LogMiningStrategy getLogMiningStrategy() {
        return this.logMiningStrategy;
    }

    public Boolean isRacSystem() {
        return !this.racNodes.isEmpty();
    }

    public Set<String> getRacNodes() {
        return this.racNodes;
    }

    public String getTokenToReplaceInSnapshotPredicate() {
        return this.snapshotEnhancementToken;
    }

    public boolean isContinuousMining() {
        return this.logMiningContinuousMine;
    }

    public Duration getLogMiningArchiveLogRetention() {
        return this.logMiningArchiveLogRetention;
    }

    public int getLogMiningBatchSizeMin() {
        return this.logMiningBatchSizeMin;
    }

    public int getLogMiningBatchSizeMax() {
        return this.logMiningBatchSizeMax;
    }

    public int getLogMiningScnGapDetectionGapSizeMin() {
        return this.logMiningScnGapDetectionGapSizeMin;
    }

    public int getLogMiningScnGapDetectionTimeIntervalMaxMs() {
        return this.logMiningScnGapDetectionTimeIntervalMaxMs;
    }

    public Duration getLogMiningSleepTimeMin() {
        return this.logMiningSleepTimeMin;
    }

    public Duration getLogMiningSleepTimeMax() {
        return this.logMiningSleepTimeMax;
    }

    public Duration getLogMiningSleepTimeDefault() {
        return this.logMiningSleepTimeDefault;
    }

    public Duration getLogMiningSleepTimeIncrement() {
        return this.logMiningSleepTimeIncrement;
    }

    public Duration getLogMiningTransactionRetention() {
        return this.logMiningTransactionRetention;
    }

    public boolean isArchiveLogOnlyMode() {
        return this.archiveLogOnlyMode;
    }

    public Duration getArchiveLogOnlyScnPollTime() {
        return this.archiveLogOnlyScnPollTime;
    }

    public boolean isLobEnabled() {
        return this.lobEnabled;
    }

    public Set<String> getLogMiningUsernameExcludes() {
        return this.logMiningUsernameExcludes;
    }

    public String getLogMiningArchiveDestinationName() {
        return this.logMiningArchiveDestinationName;
    }

    public LogMiningBufferType getLogMiningBufferType() {
        return this.logMiningBufferType;
    }

    public long getLogMiningBufferTransactionEventsThreshold() {
        return this.logMiningBufferTransactionEventsThreshold;
    }

    public boolean isLogMiningBufferDropOnStop() {
        return this.logMiningBufferDropOnStop;
    }

    public int getLogMiningBatchSizeDefault() {
        return this.logMiningBatchSizeDefault;
    }

    public int getMaximumNumberOfLogQueryRetries() {
        return this.logMiningLogFileQueryMaxRetries;
    }

    public Duration getLogMiningInitialDelay() {
        return this.logMiningInitialDelay;
    }

    public Duration getLogMiningMaxDelay() {
        return this.logMiningMaxDelay;
    }

    public Optional<Duration> getLogMiningMaximumSession() {
        return this.logMiningMaximumSession.toMillis() == 0L ? Optional.empty() : Optional.of(this.logMiningMaximumSession);
    }

    public TransactionSnapshotBoundaryMode getLogMiningTransactionSnapshotBoundaryMode() {
        return this.logMiningTransactionSnapshotBoundaryMode;
    }

    public boolean isLogMiningReadOnly() {
        return this.logMiningReadOnly;
    }

    public String getConnectorName() {
        return Module.name();
    }

    private Set<String> resolveRacNodes(Configuration config) {
        boolean portProvided = config.hasKey(PORT.name());
        Set nodes = Strings.setOf((String)config.getString(RAC_NODES), String::new);
        return nodes.stream().map(node -> {
            if (portProvided && !node.contains(":")) {
                return node + ":" + config.getInteger(PORT);
            }
            if (!portProvided && !node.contains(":")) {
                throw new DebeziumException("RAC node '" + node + "' must specify a port.");
            }
            return node;
        }).collect(Collectors.toSet());
    }

    public static int validateOutServerName(Configuration config, Field field, Field.ValidationOutput problems) {
        if (ConnectorAdapter.XSTREAM.equals((Object)ConnectorAdapter.parse(config.getString(CONNECTOR_ADAPTER)))) {
            return Field.isRequired((Configuration)config, (Field)field, (Field.ValidationOutput)problems);
        }
        return 0;
    }

    public static int requiredWhenNoUrl(Configuration config, Field field, Field.ValidationOutput problems) {
        if (config.getString(URL) == null) {
            return Field.isRequired((Configuration)config, (Field)field, (Field.ValidationOutput)problems);
        }
        return 0;
    }

    public static int requiredWhenNoHostname(Configuration config, Field field, Field.ValidationOutput problems) {
        if (config.getString(HOSTNAME) == null) {
            return Field.isRequired((Configuration)config, (Field)field, (Field.ValidationOutput)problems);
        }
        return 0;
    }

    public static int validateRacNodes(Configuration config, Field field, Field.ValidationOutput problems) {
        boolean portProvided;
        int errors = 0;
        if (ConnectorAdapter.LOG_MINER.equals((Object)ConnectorAdapter.parse(config.getString(CONNECTOR_ADAPTER))) && !(portProvided = config.hasKey(PORT.name()))) {
            Set racNodes = Strings.setOf((String)config.getString(RAC_NODES), String::new);
            for (String racNode : racNodes) {
                String[] parts = racNode.split(":");
                if (parts.length != 1) continue;
                problems.accept(field, (Object)racNode, "Must be specified as 'ip/hostname:port' since no 'database.port' is provided");
                ++errors;
            }
        }
        return errors;
    }

    private static int validateLogMiningBufferType(Configuration config, Field field, Field.ValidationOutput problems) {
        String serverList;
        LogMiningBufferType bufferType = LogMiningBufferType.parse(config.getString(LOG_MINING_BUFFER_TYPE));
        if (LogMiningBufferType.INFINISPAN_REMOTE.equals((Object)bufferType) && Strings.isNullOrEmpty((String)(serverList = config.getString("log.mining.buffer.infinispan.client.hotrod.server_list")))) {
            LOGGER.error("The option '{}' must be supplied when using the buffer type '{}'", (Object)"log.mining.buffer.infinispan.client.hotrod.server_list", (Object)bufferType.name());
            return 1;
        }
        return 0;
    }

    public static int validateLogMiningInfinispanCacheConfiguration(Configuration config, Field field, Field.ValidationOutput problems) {
        LogMiningBufferType bufferType = LogMiningBufferType.parse(config.getString(LOG_MINING_BUFFER_TYPE));
        int errors = 0;
        if (bufferType.isInfinispan()) {
            errors = Field.isRequired((Configuration)config, (Field)field, (Field.ValidationOutput)problems);
        }
        return errors;
    }

    public static int validateLogMiningReadOnly(Configuration config, Field field, Field.ValidationOutput problems) {
        if (config.getBoolean(LOG_MINING_READ_ONLY)) {
            LOGGER.warn("When using '{}', the LogMiner tablespace requires write access for the Oracle background LogMiner process; however, the connector itself will not perform any write operations against the database.", (Object)LOG_MINING_READ_ONLY.name());
            Set racNodes = Strings.setOf((String)config.getString(RAC_NODES), String::new);
            if (!racNodes.isEmpty()) {
                LOGGER.warn("The property '{}' is set, but is ignored due to using read-only mode.", (Object)RAC_NODES.name());
            }
        }
        return 0;
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        private final Pattern COMPRESSION_ADVISOR = Pattern.compile("^CMP[3|4]\\$[0-9]+$");
        private final Configuration config;

        SystemTablesPredicate(Configuration config) {
            this.config = config;
        }

        public boolean isIncluded(TableId t) {
            return !this.isExcludedSchema(t) && !this.isFlushTable(t) && !this.isCompressionAdvisorTable(t);
        }

        private boolean isExcludedSchema(TableId id) {
            return EXCLUDED_SCHEMAS.contains(id.schema().toLowerCase());
        }

        private boolean isFlushTable(TableId id) {
            return LogWriterFlushStrategy.isFlushTable(id, this.config.getString(RelationalDatabaseConnectorConfig.USER));
        }

        private boolean isCompressionAdvisorTable(TableId id) {
            return this.COMPRESSION_ADVISOR.matcher(id.table()).matches();
        }
    }

    public static enum IntervalHandlingMode implements EnumeratedValue
    {
        NUMERIC("numeric"),
        STRING("string");

        private final String value;

        private IntervalHandlingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static IntervalHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (IntervalHandlingMode option : IntervalHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static IntervalHandlingMode parse(String value, String defaultValue) {
            IntervalHandlingMode mode = IntervalHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = IntervalHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        ALWAYS("always", true, true, true),
        INITIAL("initial", true, true, false),
        INITIAL_ONLY("initial_only", true, false, false),
        SCHEMA_ONLY("schema_only", false, true, false),
        SCHEMA_ONLY_RECOVERY("schema_only_recovery", false, true, true);

        private final String value;
        private final boolean includeData;
        private final boolean shouldStream;
        private final boolean shouldSnapshotOnSchemaError;

        private SnapshotMode(String value, boolean includeData, boolean shouldStream, boolean shouldSnapshotOnSchemaError) {
            this.value = value;
            this.includeData = includeData;
            this.shouldStream = shouldStream;
            this.shouldSnapshotOnSchemaError = shouldSnapshotOnSchemaError;
        }

        public String getValue() {
            return this.value;
        }

        public boolean includeData() {
            return this.includeData;
        }

        public boolean shouldStream() {
            return this.shouldStream;
        }

        public boolean shouldSnapshotOnSchemaError() {
            return this.shouldSnapshotOnSchemaError;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum ConnectorAdapter implements EnumeratedValue
    {
        XSTREAM("XStream"){

            @Override
            public String getConnectionUrl() {
                return "jdbc:oracle:oci:@${" + JdbcConfiguration.HOSTNAME + "}:${" + JdbcConfiguration.PORT + "}/${" + JdbcConfiguration.DATABASE + "}";
            }

            @Override
            public StreamingAdapter getInstance(OracleConnectorConfig connectorConfig) {
                return (StreamingAdapter)Instantiator.getInstanceWithProvidedConstructorType((String)"io.debezium.connector.oracle.xstream.XStreamAdapter", OracleConnectorConfig.class, (Object)((Object)connectorConfig));
            }
        }
        ,
        LOG_MINER("LogMiner"){

            @Override
            public String getConnectionUrl() {
                return "jdbc:oracle:thin:@${" + JdbcConfiguration.HOSTNAME + "}:${" + JdbcConfiguration.PORT + "}/${" + JdbcConfiguration.DATABASE + "}";
            }

            @Override
            public StreamingAdapter getInstance(OracleConnectorConfig connectorConfig) {
                return (StreamingAdapter)Instantiator.getInstanceWithProvidedConstructorType((String)"io.debezium.connector.oracle.logminer.LogMinerAdapter", OracleConnectorConfig.class, (Object)((Object)connectorConfig));
            }
        };

        private final String value;

        public abstract String getConnectionUrl();

        public abstract StreamingAdapter getInstance(OracleConnectorConfig var1);

        private ConnectorAdapter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ConnectorAdapter parse(String value) {
            if (value == null) {
                return LOG_MINER;
            }
            value = value.trim();
            for (ConnectorAdapter adapter : ConnectorAdapter.values()) {
                if (!adapter.getValue().equalsIgnoreCase(value)) continue;
                return adapter;
            }
            return null;
        }

        public static ConnectorAdapter parse(String value, String defaultValue) {
            ConnectorAdapter mode = ConnectorAdapter.parse(value);
            if (mode == null && defaultValue != null) {
                mode = ConnectorAdapter.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotLockingMode implements EnumeratedValue
    {
        SHARED("shared"),
        NONE("none");

        private final String value;

        private SnapshotLockingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean usesLocking() {
            return !this.value.equals(SnapshotLockingMode.NONE.value);
        }

        public static SnapshotLockingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotLockingMode option : SnapshotLockingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotLockingMode parse(String value, String defaultValue) {
            SnapshotLockingMode mode = SnapshotLockingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotLockingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum LogMiningStrategy implements EnumeratedValue
    {
        ONLINE_CATALOG("online_catalog"),
        CATALOG_IN_REDO("redo_log_catalog");

        private final String value;

        private LogMiningStrategy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static LogMiningStrategy parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (LogMiningStrategy adapter : LogMiningStrategy.values()) {
                if (!adapter.getValue().equalsIgnoreCase(value)) continue;
                return adapter;
            }
            return null;
        }

        public static LogMiningStrategy parse(String value, String defaultValue) {
            LogMiningStrategy mode = LogMiningStrategy.parse(value);
            if (mode == null && defaultValue != null) {
                mode = LogMiningStrategy.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum LogMiningBufferType implements EnumeratedValue
    {
        MEMORY("memory"){

            @Override
            public LogMinerEventProcessor createProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleConnection connection, EventDispatcher<OraclePartition, TableId> dispatcher, OraclePartition partition, OracleOffsetContext offsetContext, OracleDatabaseSchema schema, OracleStreamingChangeEventSourceMetrics metrics) {
                return new MemoryLogMinerEventProcessor(context, connectorConfig, connection, dispatcher, partition, offsetContext, schema, metrics);
            }
        }
        ,
        INFINISPAN_EMBEDDED("infinispan_embedded"){

            @Override
            public LogMinerEventProcessor createProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleConnection connection, EventDispatcher<OraclePartition, TableId> dispatcher, OraclePartition partition, OracleOffsetContext offsetContext, OracleDatabaseSchema schema, OracleStreamingChangeEventSourceMetrics metrics) {
                return new EmbeddedInfinispanLogMinerEventProcessor(context, connectorConfig, connection, dispatcher, partition, offsetContext, schema, metrics);
            }
        }
        ,
        INFINISPAN_REMOTE("infinispan_remote"){

            @Override
            public LogMinerEventProcessor createProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleConnection connection, EventDispatcher<OraclePartition, TableId> dispatcher, OraclePartition partition, OracleOffsetContext offsetContext, OracleDatabaseSchema schema, OracleStreamingChangeEventSourceMetrics metrics) {
                return new RemoteInfinispanLogMinerEventProcessor(context, connectorConfig, connection, dispatcher, partition, offsetContext, schema, metrics);
            }
        };

        private final String value;

        public abstract LogMinerEventProcessor createProcessor(ChangeEventSource.ChangeEventSourceContext var1, OracleConnectorConfig var2, OracleConnection var3, EventDispatcher<OraclePartition, TableId> var4, OraclePartition var5, OracleOffsetContext var6, OracleDatabaseSchema var7, OracleStreamingChangeEventSourceMetrics var8);

        private LogMiningBufferType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isInfinispan() {
            return !MEMORY.equals((Object)this);
        }

        public boolean isInfinispanEmbedded() {
            return this.isInfinispan() && INFINISPAN_EMBEDDED.equals((Object)this);
        }

        public static LogMiningBufferType parse(String value) {
            if (value != null) {
                value = value.trim();
                for (LogMiningBufferType option : LogMiningBufferType.values()) {
                    if (!option.getValue().equalsIgnoreCase(value)) continue;
                    return option;
                }
            }
            return null;
        }

        private static LogMiningBufferType parse(String value, String defaultValue) {
            LogMiningBufferType type = LogMiningBufferType.parse(value);
            if (type == null && defaultValue != null) {
                type = LogMiningBufferType.parse(defaultValue);
            }
            return type;
        }
    }

    public static enum TransactionSnapshotBoundaryMode implements EnumeratedValue
    {
        SKIP("skip"),
        TRANSACTION_VIEW_ONLY("transaction_view_only"),
        ALL("all");

        private final String value;

        private TransactionSnapshotBoundaryMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static TransactionSnapshotBoundaryMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (TransactionSnapshotBoundaryMode option : TransactionSnapshotBoundaryMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static TransactionSnapshotBoundaryMode parse(String value, String defaultValue) {
            TransactionSnapshotBoundaryMode mode = TransactionSnapshotBoundaryMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = TransactionSnapshotBoundaryMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

