/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.GlobalRpcCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.metrics.XSiteMetricsCollector;

@Listener
@Scope(value=Scopes.GLOBAL)
public class GlobalInboundInvocationHandler
implements InboundInvocationHandler {
    private static final Log log = LogFactory.getLog(GlobalInboundInvocationHandler.class);
    @Inject
    @ComponentName(value="org.infinispan.executors.blocking")
    ExecutorService blockingExecutor;
    @Inject
    GlobalComponentRegistry globalComponentRegistry;
    @Inject
    CacheManagerNotifier managerNotifier;
    private final Map<RemoteSiteCache, LocalSiteCache> localCachesMap = new ConcurrentHashMap<RemoteSiteCache, LocalSiteCache>();

    private static Response shuttingDownResponse() {
        return CacheNotFoundResponse.INSTANCE;
    }

    private static ExceptionResponse exceptionHandlingCommand(Throwable throwable) {
        if (throwable instanceof Exception) {
            return new ExceptionResponse((Exception)throwable);
        }
        return new ExceptionResponse((Exception)((Object)new CacheException("Problems invoking command.", throwable)));
    }

    @Start
    public void start() {
        this.managerNotifier.addListener(this);
    }

    @Stop
    public void stop() {
        this.managerNotifier.removeListener(this);
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        ByteString cacheName = ByteString.fromString(event.getCacheName());
        this.localCachesMap.entrySet().removeIf(entry -> ((LocalSiteCache)entry.getValue()).cacheName.equals(cacheName));
    }

    @Override
    public void handleFromCluster(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
        command.setOrigin(origin);
        try {
            if (command.getCommandId() == 30) {
                reply.reply(null);
            } else if (command instanceof CacheRpcCommand) {
                this.handleCacheRpcCommand(origin, (CacheRpcCommand)command, reply, order);
            } else {
                this.handleReplicableCommand(origin, command, reply, order);
            }
        }
        catch (Throwable t) {
            if (command.logThrowable(t)) {
                Log.CLUSTER.exceptionHandlingCommand(command, t);
            }
            reply.reply(GlobalInboundInvocationHandler.exceptionHandlingCommand(t));
        }
    }

    @Override
    public void handleFromRemoteSite(String origin, XSiteReplicateCommand<?> command, Reply reply, DeliverOrder order) {
        LocalSiteCache localCache;
        if (log.isTraceEnabled()) {
            log.tracef("Handling command %s from remote site %s", command, origin);
        }
        if ((localCache = this.findLocalCacheForRemoteSite(origin, command.getCacheName())) == null) {
            reply.reply(new ExceptionResponse((Exception)((Object)log.xsiteCacheNotFound(origin, command.getCacheName()))));
            return;
        }
        if (localCache.local) {
            reply.reply(new ExceptionResponse((Exception)((Object)log.xsiteInLocalCache(origin, localCache.cacheName))));
            return;
        }
        ComponentRegistry cr = this.globalComponentRegistry.getNamedComponentRegistry(localCache.cacheName);
        if (cr == null) {
            reply.reply(new ExceptionResponse((Exception)((Object)log.xsiteCacheNotStarted(origin, localCache.cacheName))));
            return;
        }
        cr.getComponent(XSiteMetricsCollector.class).recordRequestsReceived(origin);
        command.performInLocalSite(cr, order.preserveOrder()).whenComplete(new ResponseConsumer(command, reply));
    }

    private void handleCacheRpcCommand(Address origin, CacheRpcCommand command, Reply reply, DeliverOrder mode) {
        ByteString cacheName;
        ComponentRegistry cr;
        if (log.isTraceEnabled()) {
            log.tracef("Attempting to execute CacheRpcCommand: %s [sender=%s]", command, origin);
        }
        if ((cr = this.globalComponentRegistry.getNamedComponentRegistry(cacheName = command.getCacheName())) == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Silently ignoring that %s cache is not defined", cacheName);
            }
            reply.reply(CacheNotFoundResponse.INSTANCE);
            return;
        }
        CommandsFactory commandsFactory = cr.getCommandsFactory();
        commandsFactory.initializeReplicableCommand(command, true);
        PerCacheInboundInvocationHandler handler = cr.getPerCacheInboundInvocationHandler();
        handler.handle(command, reply, mode);
    }

    private void handleReplicableCommand(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
        if (log.isTraceEnabled()) {
            log.tracef("Attempting to execute non-CacheRpcCommand: %s [sender=%s]", command, origin);
        }
        ReplicableCommandRunner runnable = new ReplicableCommandRunner(command, reply, this.globalComponentRegistry, order.preserveOrder());
        if (order.preserveOrder() || !command.canBlock()) {
            runnable.run();
        } else {
            this.blockingExecutor.execute(runnable);
        }
    }

    public ByteString getLocalCacheForRemoteSite(String remoteSite, ByteString remoteCache) {
        LocalSiteCache cache = this.localCachesMap.get(new RemoteSiteCache(remoteSite, remoteCache));
        return cache == null ? null : cache.cacheName;
    }

    private LocalSiteCache findLocalCacheForRemoteSite(String remoteSite, ByteString remoteCache) {
        RemoteSiteCache key = new RemoteSiteCache(remoteSite, remoteCache);
        return this.localCachesMap.computeIfAbsent(key, this::lookupLocalCaches);
    }

    private LocalSiteCache lookupLocalCaches(RemoteSiteCache remoteSiteCache) {
        for (String name : this.getCacheNames()) {
            Configuration configuration = this.getCacheConfiguration(name);
            if (configuration == null || !this.isBackupForRemoteCache(configuration, remoteSiteCache, name)) continue;
            return new LocalSiteCache(ByteString.fromString(name), GlobalInboundInvocationHandler.isLocal(configuration));
        }
        String name = remoteSiteCache.originCache.toString();
        log.debugf("Did not find any backup explicitly configured backup cache for remote cache/site: %s/%s. Using %s", remoteSiteCache.originSite, name, name);
        Configuration configuration = this.getCacheConfiguration(name);
        if (configuration == null) {
            return null;
        }
        return new LocalSiteCache(remoteSiteCache.originCache, GlobalInboundInvocationHandler.isLocal(configuration));
    }

    private Collection<String> getCacheNames() {
        return this.globalComponentRegistry.getCacheManager().getCacheNames();
    }

    private Configuration getCacheConfiguration(String cacheName) {
        return this.globalComponentRegistry.getComponent(ConfigurationManager.class).getConfiguration(cacheName, false);
    }

    private static boolean isLocal(Configuration configuration) {
        return !configuration.clustering().cacheMode().isClustered();
    }

    private boolean isBackupForRemoteCache(Configuration cacheConfiguration, RemoteSiteCache remoteSite, String localCacheName) {
        String remoteSiteName = remoteSite.originSite;
        String remoteCacheName = remoteSite.originCache.toString();
        boolean found = cacheConfiguration.sites().backupFor().isBackupFor(remoteSiteName, remoteCacheName);
        if (log.isTraceEnabled() && found) {
            log.tracef("Found local cache '%s' is backup for cache '%s' from site '%s'", localCacheName, remoteCacheName, remoteSiteName);
        }
        return found;
    }

    private static class LocalSiteCache {
        private final ByteString cacheName;
        private final boolean local;

        private LocalSiteCache(ByteString cacheName, boolean local) {
            this.cacheName = cacheName;
            this.local = local;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalSiteCache that = (LocalSiteCache)o;
            return this.local == that.local && Objects.equals(this.cacheName, that.cacheName);
        }

        public int hashCode() {
            return Objects.hash(this.cacheName, this.local);
        }
    }

    private static class RemoteSiteCache {
        private final String originSite;
        private final ByteString originCache;

        private RemoteSiteCache(String originSite, ByteString originCache) {
            this.originSite = originSite;
            this.originCache = originCache;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteSiteCache remoteSiteCache = (RemoteSiteCache)o;
            return Objects.equals(this.originSite, remoteSiteCache.originSite) && Objects.equals(this.originCache, remoteSiteCache.originCache);
        }

        public int hashCode() {
            return Objects.hash(this.originSite, this.originCache);
        }
    }

    private static class ResponseConsumer
    implements BiConsumer<Object, Throwable> {
        final ReplicableCommand command;
        private final Reply reply;

        private ResponseConsumer(ReplicableCommand command, Reply reply) {
            this.command = command;
            this.reply = reply;
        }

        @Override
        public void accept(Object retVal, Throwable throwable) {
            this.reply.reply(this.convertToResponse(retVal, throwable));
        }

        private Response convertToResponse(Object retVal, Throwable throwable) {
            if (throwable != null) {
                if ((throwable = CompletableFutures.extractException((Throwable)throwable)) instanceof InterruptedException || throwable instanceof IllegalLifecycleStateException) {
                    Log.CLUSTER.debugf("Shutdown while handling command %s", this.command);
                    return GlobalInboundInvocationHandler.shuttingDownResponse();
                }
                if (this.command.logThrowable(throwable)) {
                    Log.CLUSTER.exceptionHandlingCommand(this.command, throwable);
                }
                return GlobalInboundInvocationHandler.exceptionHandlingCommand(throwable);
            }
            if (retVal == null || retVal instanceof Response) {
                return (Response)retVal;
            }
            return SuccessfulResponse.create(retVal);
        }
    }

    private static class ReplicableCommandRunner
    extends ResponseConsumer
    implements Runnable {
        private final GlobalComponentRegistry globalComponentRegistry;
        private final boolean preserveOrder;

        private ReplicableCommandRunner(ReplicableCommand command, Reply reply, GlobalComponentRegistry globalComponentRegistry, boolean preserveOrder) {
            super(command, reply);
            this.globalComponentRegistry = globalComponentRegistry;
            this.preserveOrder = preserveOrder;
        }

        @Override
        public void run() {
            try {
                CompletionStage stage;
                if (this.command instanceof GlobalRpcCommand) {
                    stage = ((GlobalRpcCommand)this.command).invokeAsync(this.globalComponentRegistry).whenComplete(this);
                } else {
                    this.globalComponentRegistry.wireDependencies(this.command);
                    stage = this.command.invokeAsync().whenComplete((BiConsumer)this);
                }
                if (this.preserveOrder) {
                    CompletionStages.join(stage);
                }
            }
            catch (Throwable throwable) {
                this.accept((Object)null, throwable);
            }
        }
    }
}

