/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.util.Strings;
import java.util.Iterator;

public class LogMinerQueryBuilder {
    private static final String LOGMNR_CONTENTS_VIEW = "V$LOGMNR_CONTENTS";

    public static String build(OracleConnectorConfig connectorConfig) {
        String excludedSchemas;
        StringBuilder query = new StringBuilder(1024);
        query.append("SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, ");
        query.append("USERNAME, ROW_ID, ROLLBACK, RS_ID, STATUS, INFO, SSN, THREAD# ");
        query.append("FROM ").append(LOGMNR_CONTENTS_VIEW).append(" ");
        query.append("WHERE SCN > ? AND SCN <= ? ");
        String pdbName = connectorConfig.getPdbName();
        if (!Strings.isNullOrEmpty((String)pdbName)) {
            String pdbPredicate = "SRC_CON_NAME = '" + pdbName + "' ";
            query.append("AND ").append(pdbPredicate);
        }
        if ((excludedSchemas = LogMinerQueryBuilder.resolveExcludedSchemaPredicate("SEG_OWNER")).length() > 0) {
            query.append("AND ").append(excludedSchemas).append(' ');
        }
        query.append("AND OPERATION_CODE IN (1,2,3,5,6,7");
        if (connectorConfig.isLobEnabled()) {
            query.append(",9,10,11,29");
        }
        query.append(",34,36,255) ");
        return query.toString();
    }

    private static String resolveExcludedSchemaPredicate(String fieldName) {
        if (!OracleConnectorConfig.EXCLUDED_SCHEMAS.isEmpty()) {
            StringBuilder query = new StringBuilder();
            query.append('(').append(fieldName).append(" IS NULL OR ");
            query.append(fieldName).append(" NOT IN (");
            Iterator<String> i = OracleConnectorConfig.EXCLUDED_SCHEMAS.iterator();
            while (i.hasNext()) {
                String excludedSchema = i.next();
                query.append('\'').append(excludedSchema.toUpperCase()).append('\'');
                if (!i.hasNext()) continue;
                query.append(',');
            }
            return query.append(')').append(')').toString();
        }
        return "";
    }
}

