/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SnapshotSelectOverridesIT
extends AbstractConnectorTest {
    private static final int INITIAL_RECORDS_PER_TABLE = 10;
    private static final String DDL = "CREATE TABLE %s (ID numeric(9,0) primary key, NAME varchar2(30), PRICE numeric(8,2), TS date, SOFT_DELETED number(1))";
    private static final String DML = "INSERT INTO %s VALUES (%s, '%s', %s, TO_DATE('%s','yyyy-mm-dd'), %s)";
    private OracleConnection connection;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        this.cleanupTables();
        this.connection.execute(new String[]{String.format(DDL, "table1")});
        this.connection.execute(new String[]{String.format(DDL, "table2")});
        this.connection.execute(new String[]{String.format(DDL, "table3")});
        for (int i = 0; i < 10; ++i) {
            this.connection.execute(new String[]{String.format(DML, "table1", i, "name" + i, new BigDecimal(i + ".23"), "2018-07-18", i % 2)});
            this.connection.execute(new String[]{String.format(DML, "table2", i, "name" + i, new BigDecimal(i + ".23"), "2018-07-18", i % 2)});
            this.connection.execute(new String[]{String.format(DML, "table3", i, "name" + i, new BigDecimal(i + ".23"), "2018-07-18", i % 2)});
        }
        TestHelper.streamTable(this.connection, "debezium.table1");
        TestHelper.streamTable(this.connection, "debezium.table2");
        TestHelper.streamTable(this.connection, "debezium.table3");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws Exception {
        if (this.connection != null) {
            this.cleanupTables();
            this.connection.close();
        }
    }

    private void cleanupTables() {
        TestHelper.dropTable(this.connection, "debezium.table1");
        TestHelper.dropTable(this.connection, "debezium.table2");
        TestHelper.dropTable(this.connection, "debezium.table3");
    }

    @Test
    @FixFor(value={"DBZ-3250"})
    public void takeSnapshotWithOverrides() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.TABLE[1-3]")).with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, "DEBEZIUM.TABLE1,DEBEZIUM.TABLE3")).with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + ".DEBEZIUM.TABLE1", "SELECT * FROM DEBEZIUM.TABLE1 WHERE SOFT_DELETED = 0 ORDER BY ID DESC").with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + ".DEBEZIUM.TABLE3", "SELECT * FROM DEBEZIUM.TABLE3 WHERE SOFT_DELETED = 0").build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        int expected = 20;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(expected);
        List table1 = records.recordsForTopic("server1.DEBEZIUM.TABLE1");
        List table2 = records.recordsForTopic("server1.DEBEZIUM.TABLE2");
        List table3 = records.recordsForTopic("server1.DEBEZIUM.TABLE3");
        Assertions.assertThat((List)table1).hasSize(5);
        Assertions.assertThat((List)table2).hasSize(10);
        Assertions.assertThat((List)table3).hasSize(5);
        StringBuilder actualIdsForTable1 = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            SourceRecord record = (SourceRecord)table1.get(i);
            Struct key = (Struct)record.key();
            actualIdsForTable1.append(key.get("ID"));
            Struct value = (Struct)record.value();
            Assertions.assertThat((Object)((Struct)value.get("after")).get("SOFT_DELETED")).isEqualTo((Object)0);
        }
        String expectedIdsForTable1 = "86420";
        Assertions.assertThat((String)actualIdsForTable1.toString()).isEqualTo((Object)"86420");
    }
}

