/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.converters.NumberOneToBooleanConverter;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OracleNumberOneIT
extends AbstractConnectorTest {
    private OracleConnection connection;

    @Before
    public void before() throws Exception {
        this.connection = TestHelper.testConnection();
        TestHelper.dropTable(this.connection, "debezium.number_one_test");
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        this.connection.execute(new String[]{"CREATE TABLE NUMBER_ONE_TEST (id numeric primary key, data number(1) default 0, data2 number(1) default 1)"});
        TestHelper.streamTable(this.connection, "debezium.number_one_test");
    }

    @After
    public void after() throws Exception {
        if (this.connection != null && this.connection.isConnected()) {
            TestHelper.dropTable(this.connection, "debezium.number_one_test");
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-3208"})
    public void shouldHandleNumberOneAsNumber() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.NUMBER_ONE_TEST")).build();
        this.insertDataBatchStartingAtKey(1);
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleNumberOneIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        List testRecords = records.recordsForTopic("server1.DEBEZIUM.NUMBER_ONE_TEST");
        Assertions.assertThat((List)testRecords).hasSize(5);
        this.assertRecordNumberValue(testRecords, 0, BigDecimal.valueOf(1L), Byte.valueOf("0"), Byte.valueOf("0"));
        this.assertRecordNumberValue(testRecords, 1, BigDecimal.valueOf(2L), Byte.valueOf("1"), Byte.valueOf("1"));
        this.assertRecordNumberValue(testRecords, 2, BigDecimal.valueOf(3L), Byte.valueOf("2"), Byte.valueOf("2"));
        this.assertRecordNumberValue(testRecords, 3, BigDecimal.valueOf(4L), Byte.valueOf("-1"), Byte.valueOf("-1"));
        this.assertRecordNumberValue(testRecords, 4, BigDecimal.valueOf(5L), Byte.valueOf("0"), Byte.valueOf("1"));
        OracleNumberOneIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        this.insertDataBatchStartingAtKey(6);
        records = this.consumeRecordsByTopic(5);
        testRecords = records.recordsForTopic("server1.DEBEZIUM.NUMBER_ONE_TEST");
        Assertions.assertThat((List)testRecords).hasSize(5);
        this.assertRecordNumberValue(testRecords, 0, BigDecimal.valueOf(6L), Byte.valueOf("0"), Byte.valueOf("0"));
        this.assertRecordNumberValue(testRecords, 1, BigDecimal.valueOf(7L), Byte.valueOf("1"), Byte.valueOf("1"));
        this.assertRecordNumberValue(testRecords, 2, BigDecimal.valueOf(8L), Byte.valueOf("2"), Byte.valueOf("2"));
        this.assertRecordNumberValue(testRecords, 3, BigDecimal.valueOf(9L), Byte.valueOf("-1"), Byte.valueOf("-1"));
        this.assertRecordNumberValue(testRecords, 4, BigDecimal.valueOf(10L), Byte.valueOf("0"), Byte.valueOf("1"));
    }

    @Test
    @FixFor(value={"DBZ-3208"})
    public void shouldHandleNumberOneAsBoolean() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.NUMBER_ONE_TEST")).with(OracleConnectorConfig.CUSTOM_CONVERTERS, "boolean")).with("boolean.type", NumberOneToBooleanConverter.class.getName()).with("boolean.selector", ".*NUMBER_ONE_TEST\\.DATA.*").build();
        this.insertDataBatchStartingAtKey(1);
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleNumberOneIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        List testRecords = records.recordsForTopic("server1.DEBEZIUM.NUMBER_ONE_TEST");
        Assertions.assertThat((List)testRecords).hasSize(5);
        this.assertRecordNumberValue(testRecords, 0, BigDecimal.valueOf(1L), false, false);
        this.assertRecordNumberValue(testRecords, 1, BigDecimal.valueOf(2L), true, true);
        this.assertRecordNumberValue(testRecords, 2, BigDecimal.valueOf(3L), true, true);
        this.assertRecordNumberValue(testRecords, 3, BigDecimal.valueOf(4L), false, false);
        this.assertRecordNumberValue(testRecords, 4, BigDecimal.valueOf(5L), false, true);
        OracleNumberOneIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        this.insertDataBatchStartingAtKey(6);
        records = this.consumeRecordsByTopic(5);
        testRecords = records.recordsForTopic("server1.DEBEZIUM.NUMBER_ONE_TEST");
        Assertions.assertThat((List)testRecords).hasSize(5);
        this.assertRecordNumberValue(testRecords, 0, BigDecimal.valueOf(6L), false, false);
        this.assertRecordNumberValue(testRecords, 1, BigDecimal.valueOf(7L), true, true);
        this.assertRecordNumberValue(testRecords, 2, BigDecimal.valueOf(8L), true, true);
        this.assertRecordNumberValue(testRecords, 3, BigDecimal.valueOf(9L), false, false);
        this.assertRecordNumberValue(testRecords, 4, BigDecimal.valueOf(10L), false, true);
    }

    private void assertRecordNumberValue(List<SourceRecord> records, int index, Object key, Object data, Object data2) {
        Struct after = (Struct)((Struct)records.get(index).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo(key);
        Assertions.assertThat((Object)after.get("DATA")).isEqualTo(data);
        Assertions.assertThat((Object)after.get("DATA2")).isEqualTo(data2);
    }

    private void insertDataBatchStartingAtKey(int initialKey) throws SQLException {
        this.connection.executeWithoutCommitting(new String[]{"INSERT INTO debezium.number_one_test values (" + initialKey + ", 0, 0)"});
        this.connection.executeWithoutCommitting(new String[]{"INSERT INTO debezium.number_one_test values (" + (initialKey + 1) + ", 1, 1)"});
        this.connection.executeWithoutCommitting(new String[]{"INSERT INTO debezium.number_one_test values (" + (initialKey + 2) + ", 2, 2)"});
        this.connection.executeWithoutCommitting(new String[]{"INSERT INTO debezium.number_one_test values (" + (initialKey + 3) + ", -1, -1)"});
        this.connection.executeWithoutCommitting(new String[]{"INSERT INTO debezium.number_one_test (id) values (" + (initialKey + 4) + ")"});
        this.connection.execute(new String[]{"COMMIT"});
    }
}

