/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.processor.TransactionCommitConsumer;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.Envelope;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.util.Testing;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.awaitility.Awaitility;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class OracleClobDataTypeIT
extends AbstractConnectorTest {
    private static final String JSON_DATA = Testing.Files.readResourceAsString((String)"data/test_lob_data.json");
    private static final String JSON_DATA2 = Testing.Files.readResourceAsString((String)"data/test_lob_data2.json");
    @Rule
    public final TestRule skipAdapterRule = new SkipTestDependingOnAdapterNameRule();
    private OracleConnection connection;

    @Before
    public void before() {
        this.connection = TestHelper.testConnection();
        TestHelper.dropTable(this.connection, "CLOB_TEST");
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws Exception {
        if (this.connection != null) {
            TestHelper.dropTable(this.connection, "CLOB_TEST");
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldSnapshotClobDataTypeValues() throws Exception {
        String ddl = "CREATE TABLE CLOB_TEST (ID numeric(9,0), VAL_CLOB_SHORT clob, VAL_CLOB_LONG clob, VAL_NCLOB_SHORT nclob, VAL_NCLOB_LONG nclob, primary key(id))";
        this.connection.execute(new String[]{ddl});
        Clob clob1 = this.createClob("Hello World");
        Clob clob2 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 5000));
        NClob nclob1 = this.createNClob("Hello World");
        NClob nclob2 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 0, 5000));
        this.connection.prepareQuery("INSERT INTO CLOB_TEST VALUES (1, ?, ?, ?, ?)", ps -> {
            ps.setClob(1, clob1);
            ps.setClob(2, clob2);
            ps.setNClob(3, nclob1);
            ps.setNClob(4, nclob2);
        }, null);
        this.connection.commit();
        TestHelper.streamTable(this.connection, "debezium.clob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleClobDataTypeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB_SHORT")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1));
        Assertions.assertThat((Object)after.get("VAL_CLOB_LONG")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2));
        Assertions.assertThat((Object)after.get("VAL_NCLOB_SHORT")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1));
        Assertions.assertThat((Object)after.get("VAL_NCLOB_LONG")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2));
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamInlineClobDataTypeValues() throws Exception {
        String ddl = "CREATE TABLE CLOB_TEST (ID numeric(9,0), VAL_CLOB clob, VAL_NCLOB nclob, primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.clob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleClobDataTypeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Clob clob1 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 1000));
        NClob nclob1 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 0, 1000));
        this.connection.prepareQuery("INSERT INTO CLOB_TEST VALUES (1, ?, ?)", ps -> {
            ps.setClob(1, clob1);
            ps.setNClob(2, nclob1);
        }, null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1));
        Clob clob2 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 1000));
        NClob nclob2 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 1, 1000));
        this.connection.prepareQuery("INSERT INTO CLOB_TEST VALUES (2, ?, ?)", ps -> {
            ps.setClob(1, clob2);
            ps.setNClob(2, nclob2);
        }, null);
        Clob clob3 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 2, 1000));
        NClob nclob3 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 2, 1000));
        this.connection.prepareQuery("INSERT INTO CLOB_TEST VALUES (3, ?, ?)", ps -> {
            ps.setClob(1, clob3);
            ps.setNClob(2, nclob3);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2));
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)3);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob3));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob3));
        Clob clob1Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 1000));
        NClob nclob1Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 1, 1000));
        this.connection.prepareQuery("UPDATE CLOB_TEST SET val_clob=?, val_nclob=? WHERE id = 1", ps -> {
            ps.setClob(1, clob1Update);
            ps.setNClob(2, nclob1Update);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1Update));
        Clob clob2Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 1024));
        NClob nclob2Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 0, 1024));
        this.connection.prepareQuery("UPDATE CLOB_TEST SET val_clob=?, val_nclob=? WHERE id = 2", ps -> {
            ps.setClob(1, clob2Update);
            ps.setNClob(2, nclob2Update);
        }, null);
        Clob clob3Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 1025));
        NClob nclob3Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 1, 1025));
        this.connection.prepareQuery("UPDATE CLOB_TEST SET val_clob=?, val_nclob=? WHERE id = 3", ps -> {
            ps.setClob(1, clob3Update);
            ps.setNClob(2, nclob3Update);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2Update));
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(1);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)3);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob3Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob3Update));
        this.connection.execute(new String[]{"DELETE FROM debezium.clob_test WHERE id = 1"});
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
        Struct before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.clob_test WHERE id = 2"});
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.clob_test WHERE id = 3"});
        this.connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(4);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(4);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)2);
        before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(2);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)3);
        before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamInlineClobDataTypeValuesWithNonClobDataTypeField() throws Exception {
        String ddl = "CREATE TABLE CLOB_TEST (ID numeric(9,0), VAL_CLOB clob, VAL_NCLOB nclob, VAL_DATA varchar2(50), primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.clob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleClobDataTypeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Clob clob1 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 1000));
        NClob nclob1 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 0, 1000));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (1, ?, ?, 'Test1')", ps -> {
            ps.setClob(1, clob1);
            ps.setNClob(2, nclob1);
        }, null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test1");
        Clob clob2 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 1000));
        NClob nclob2 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 1, 1000));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (2, ?, ?, 'Test2')", ps -> {
            ps.setClob(1, clob2);
            ps.setNClob(2, nclob2);
        }, null);
        Clob clob3 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 2, 1000));
        NClob nclob3 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 2, 1000));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (3, ?, ?, 'Test3')", ps -> {
            ps.setClob(1, clob3);
            ps.setNClob(2, nclob3);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test2");
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)3);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob3));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob3));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test3");
        Clob clob1Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 1000));
        NClob nclob1Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 1, 1000));
        this.connection.prepareQuery("UPDATE clob_test SET val_clob=?, val_nclob=?, val_data='Test1U' WHERE id = 1", ps -> {
            ps.setClob(1, clob1Update);
            ps.setNClob(2, nclob1Update);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1Update));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test1U");
        Clob clob2Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 1024));
        NClob nclob2Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 0, 1024));
        this.connection.prepareQuery("UPDATE clob_test SET val_clob=?, val_nclob=?, val_data='Test2U' WHERE id = 2", ps -> {
            ps.setClob(1, clob2Update);
            ps.setNClob(2, nclob2Update);
        }, null);
        Clob clob3Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 1025));
        NClob nclob3Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 1, 1025));
        this.connection.prepareQuery("UPDATE clob_test SET val_clob=?, val_nclob=?, val_data='Test3U' WHERE id = 3", ps -> {
            ps.setClob(1, clob3Update);
            ps.setNClob(2, nclob3Update);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2Update));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test2U");
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(1);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)3);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob3Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob3Update));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test3U");
        this.connection.execute(new String[]{"DELETE FROM debezium.clob_test WHERE id = 1"});
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
        Struct before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test1U");
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.clob_test WHERE id = 2"});
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.clob_test WHERE id = 3"});
        this.connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(4);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(4);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)2);
        before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test2U");
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(2);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)3);
        before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test3U");
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamLargeClobDataTypeValues() throws Exception {
        String ddl = "CREATE TABLE CLOB_TEST (ID numeric(9,0), VAL_CLOB clob, VAL_NCLOB nclob, primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.clob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleClobDataTypeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Clob clob1 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 25000));
        NClob nclob1 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 0, 25000));
        this.connection.prepareQuery("INSERT INTO CLOB_TEST VALUES (1, ?, ?)", ps -> {
            ps.setClob(1, clob1);
            ps.setNClob(2, nclob1);
        }, null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1));
        Clob clob2 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 24450));
        NClob nclob2 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 1, 24450));
        this.connection.prepareQuery("INSERT INTO CLOB_TEST VALUES (2, ?, ?)", ps -> {
            ps.setClob(1, clob2);
            ps.setNClob(2, nclob2);
        }, null);
        Clob clob3 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 3, 24450));
        NClob nclob3 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 3, 24450));
        this.connection.prepareQuery("INSERT INTO CLOB_TEST VALUES (3, ?, ?)", ps -> {
            ps.setClob(1, clob3);
            ps.setNClob(2, nclob3);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2));
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)3);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob3));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob3));
        Clob clob1Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 24500));
        NClob nclob1Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 1, 24500));
        this.connection.prepareQuery("UPDATE CLOB_TEST SET val_clob=?, val_nclob=? WHERE id = 1", ps -> {
            ps.setClob(1, clob1Update);
            ps.setNClob(2, nclob1Update);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1Update));
        Clob clob2Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 2, 25000));
        NClob nclob2Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 2, 25000));
        this.connection.prepareQuery("UPDATE CLOB_TEST SET val_clob=?, val_nclob=? WHERE id = 2", ps -> {
            ps.setClob(1, clob2Update);
            ps.setNClob(2, nclob2Update);
        }, null);
        Clob clob3Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 3, 25000));
        NClob nclob3Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 3, 25000));
        this.connection.prepareQuery("UPDATE CLOB_TEST SET val_clob=?, val_nclob=? WHERE id = 3", ps -> {
            ps.setClob(1, clob3Update);
            ps.setNClob(2, nclob3Update);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2Update));
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(1);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)3);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob3Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob3Update));
        this.connection.execute(new String[]{"DELETE FROM debezium.clob_test WHERE id = 1"});
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
        Struct before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.clob_test WHERE id = 2"});
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.clob_test WHERE id = 3"});
        this.connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(4);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(4);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)2);
        before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(2);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)3);
        before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamLargeClobDataTypeValuesWithNonClobDataTypeField() throws Exception {
        String ddl = "CREATE TABLE CLOB_TEST (ID numeric(9,0), VAL_CLOB clob, VAL_NCLOB nclob, VAL_DATA varchar2(50), primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.clob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleClobDataTypeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Clob clob1 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 25000));
        NClob nclob1 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 0, 25000));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (1, ?, ?, 'Test1')", ps -> {
            ps.setClob(1, clob1);
            ps.setNClob(2, nclob1);
        }, null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test1");
        Clob clob2 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 24450));
        NClob nclob2 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 2, 24450));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (2, ?, ?, 'Test2')", ps -> {
            ps.setClob(1, clob2);
            ps.setNClob(2, nclob2);
        }, null);
        Clob clob3 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 3, 24450));
        NClob nclob3 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 4, 24450));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (3, ?, ?, 'Test3')", ps -> {
            ps.setClob(1, clob3);
            ps.setNClob(2, nclob3);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test2");
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)3);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob3));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob3));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test3");
        Clob clob1Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 24500));
        NClob nclob1Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 1, 24500));
        this.connection.prepareQuery("UPDATE clob_test SET val_clob=?, val_nclob=?, val_data='Test1U' WHERE id = 1", ps -> {
            ps.setClob(1, clob1Update);
            ps.setNClob(2, nclob1Update);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1Update));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test1U");
        Clob clob2Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 2, 25000));
        NClob nclob2Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 2, 25000));
        this.connection.prepareQuery("UPDATE clob_test SET val_clob=?, val_nclob=?, val_data='Test2U' WHERE id = 2", ps -> {
            ps.setClob(1, clob2Update);
            ps.setNClob(2, nclob2Update);
        }, null);
        Clob clob3Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 3, 25000));
        NClob nclob3Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 3, 25000));
        this.connection.prepareQuery("UPDATE clob_test SET val_clob=?, val_nclob=?, val_data='Test3U' WHERE id = 3", ps -> {
            ps.setClob(1, clob3Update);
            ps.setNClob(2, nclob3Update);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2Update));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test2U");
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(1);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)3);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob3Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob3Update));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test3U");
        this.connection.execute(new String[]{"DELETE FROM debezium.clob_test WHERE id = 1"});
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
        Struct before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test1U");
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.clob_test WHERE id = 2"});
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.clob_test WHERE id = 3"});
        this.connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(4);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(4);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)2);
        before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test2U");
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(2);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)3);
        before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test3U");
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamMixedClobDataTypeValuesWithNonClobFieldsSameTable() throws Exception {
        String ddl = "CREATE TABLE CLOB_TEST (ID numeric(9,0), VAL_CLOB clob, VAL_NCLOB nclob, VAL_CLOBS clob, VAL_NCLOBS nclob, VAL_VARCHAR2 varchar2(50),primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.clob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleClobDataTypeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Clob clob1 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 25000));
        NClob nclob1 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 0, 25000));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (1, ?, ?, 'ClobTest', 'NClobTest', 'Test1')", ps -> {
            ps.setClob(1, clob1);
            ps.setNClob(2, nclob1);
        }, null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test1");
        Clob clob2 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 24450));
        NClob nclob2 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 2, 24450));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (2, ?, ?, 'ClobTest2', 'NClobTest2', 'Test2')", ps -> {
            ps.setClob(1, clob2);
            ps.setNClob(2, nclob2);
        }, null);
        Clob clob3 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 3, 24450));
        NClob nclob3 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 4, 24450));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (3, ?, ?, 'ClobTest3', 'NClobTest3', 'Test3')", ps -> {
            ps.setClob(1, clob3);
            ps.setNClob(2, nclob3);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest2");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest2");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test2");
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)3);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob3));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob3));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest3");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest3");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test3");
        Clob clob1Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 24500));
        NClob nclob1Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 1, 24500));
        this.connection.prepareQuery("UPDATE clob_test SET val_clob=?, val_nclob=?, val_clobs=?, val_nclobs=?, val_varchar2='Test1U' WHERE id = 1", ps -> {
            ps.setClob(1, clob1Update);
            ps.setNClob(2, nclob1Update);
            ps.setString(3, "ClobTest1Updated");
            ps.setString(4, "NClobTest1Updated");
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1Update));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest1Updated");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest1Updated");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test1U");
        Clob clob2Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 2, 25000));
        NClob nclob2Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 2, 25000));
        this.connection.prepareQuery("UPDATE clob_test SET val_clob=?, val_nclob=?, val_clobs=?, val_nclobs=?, val_varchar2='Test2U' WHERE id = 2", ps -> {
            ps.setClob(1, clob2Update);
            ps.setNClob(2, nclob2Update);
            ps.setString(3, "ClobTest2Updated");
            ps.setString(4, "NClobTest2Updated");
        }, null);
        Clob clob3Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 3, 25000));
        NClob nclob3Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 3, 25000));
        this.connection.prepareQuery("UPDATE clob_test SET val_clob=?, val_nclob=?, val_clobs=?, val_nclobs=?, val_varchar2='Test3U' WHERE id = 3", ps -> {
            ps.setClob(1, clob3Update);
            ps.setNClob(2, nclob3Update);
            ps.setString(3, "ClobTest3Updated");
            ps.setString(4, "NClobTest3Updated");
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2Update));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest2Updated");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest2Updated");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test2U");
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(1);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)3);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob3Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob3Update));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest3Updated");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest3Updated");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test3U");
        this.connection.execute(new String[]{"DELETE FROM debezium.clob_test WHERE id = 1"});
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
        Struct before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_VARCHAR2")).isEqualTo((Object)"Test1U");
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.clob_test WHERE id = 2"});
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.clob_test WHERE id = 3"});
        this.connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(4);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(4);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)2);
        before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_VARCHAR2")).isEqualTo((Object)"Test2U");
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(2);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)3);
        before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_VARCHAR2")).isEqualTo((Object)"Test3U");
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-2948", "DBZ-5773"})
    public void shouldNotStreamAnyChangesWhenLobEraseIsDetected() throws Exception {
        String ddl = "CREATE TABLE CLOB_TEST (ID numeric(9,0), VAL_CLOB clob, primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.clob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        LogInterceptor logminerLogInterceptor = new LogInterceptor(TransactionCommitConsumer.class);
        LogInterceptor xstreamLogInterceptor = new LogInterceptor("io.debezium.connector.oracle.xstream.LcrEventHandler");
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleClobDataTypeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Clob clob1 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 25000));
        this.connection.prepareQuery("INSERT INTO CLOB_TEST VALUES (1, ?)", ps -> ps.setClob(1, clob1), null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1));
        this.connection.execute(new String[]{"DECLARE loc_c CLOB; amount integer; BEGIN SELECT \"VAL_CLOB\" INTO loc_c FROM CLOB_TEST WHERE ID = 1 for update; amount := 10;dbms_lob.erase(loc_c, amount, 1); end;"});
        Awaitility.await().atMost(Duration.ofMinutes(1L)).until(() -> logminerLogInterceptor.containsWarnMessage("LOB_ERASE for table") || xstreamLogInterceptor.containsWarnMessage("LOB_ERASE for table"));
        this.assertNoRecordsToConsume();
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamClobDataTypeValuesWithPrimaryKeyChange() throws Exception {
        String ddl = "CREATE TABLE CLOB_TEST (ID numeric(9,0), VAL_CLOB clob, VAL_NCLOB nclob, VAL_CLOBS clob, VAL_NCLOBS nclob, VAL_VARCHAR2 varchar2(50), primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.clob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleClobDataTypeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Clob clob1 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 25000));
        NClob nclob1 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 0, 25000));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (1, ?, ?, 'ClobTest', 'NClobTest', 'Test1')", ps -> {
            ps.setClob(1, clob1);
            ps.setNClob(2, nclob1);
        }, null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test1");
        Clob clob1Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 24500));
        NClob nclob1Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 1, 24500));
        this.connection.prepareQuery("UPDATE clob_test SET id=2, val_clob=?, val_nclob=?, val_clobs=?, val_nclobs=?, val_varchar2='Test1U' WHERE id = 1", ps -> {
            ps.setClob(1, clob1Update);
            ps.setNClob(2, nclob1Update);
            ps.setString(3, "ClobTest1Updated");
            ps.setString(4, "NClobTest1Updated");
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(3);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(3);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(2);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1Update));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest1Updated");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest1Updated");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test1U");
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamClobDataTypeValuesUsingBasicFileStorage() throws Exception {
        String ddl = "CREATE TABLE CLOB_TEST (ID numeric(9,0), VAL_CLOB clob, VAL_NCLOB nclob, VAL_CLOBS clob, VAL_NCLOBS nclob, VAL_VARCHAR2 varchar2(50), primary key(id)) LOB(VAL_CLOB) STORE AS BASICFILE LOB(VAL_NCLOB) STORE AS BASICFILE LOB(VAL_CLOBS) STORE AS BASICFILE LOB(VAL_NCLOBS) STORE AS BASICFILE";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.clob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleClobDataTypeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Clob clob1 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 25000));
        NClob nclob1 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 0, 25000));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (1, ?, ?, 'ClobTest', 'NClobTest', 'Test1')", ps -> {
            ps.setClob(1, clob1);
            ps.setNClob(2, nclob1);
        }, null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test1");
        Clob clob2 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 24450));
        NClob nclob2 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 2, 24450));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (2, ?, ?, 'ClobTest2', 'NClobTest2', 'Test2')", ps -> {
            ps.setClob(1, clob2);
            ps.setNClob(2, nclob2);
        }, null);
        Clob clob3 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 3, 24450));
        NClob nclob3 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 4, 24450));
        this.connection.prepareQuery("INSERT INTO clob_test VALUES (3, ?, ?, 'ClobTest3', 'NClobTest3', 'Test3')", ps -> {
            ps.setClob(1, clob3);
            ps.setNClob(2, nclob3);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest2");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest2");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test2");
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)3);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob3));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob3));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest3");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest3");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test3");
        Clob clob1Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 24500));
        NClob nclob1Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 1, 24500));
        this.connection.prepareQuery("UPDATE clob_test SET val_clob=?, val_nclob=?, val_clobs=?, val_nclobs=?, val_varchar2='Test1U' WHERE id = 1", ps -> {
            ps.setClob(1, clob1Update);
            ps.setNClob(2, nclob1Update);
            ps.setString(3, "ClobTest1Updated");
            ps.setString(4, "NClobTest1Updated");
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1Update));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest1Updated");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest1Updated");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test1U");
        Clob clob2Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 2, 25000));
        NClob nclob2Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 2, 25000));
        this.connection.prepareQuery("UPDATE clob_test SET val_clob=?, val_nclob=?, val_clobs=?, val_nclobs=?, val_varchar2='Test2U' WHERE id = 2", ps -> {
            ps.setClob(1, clob2Update);
            ps.setNClob(2, nclob2Update);
            ps.setString(3, "ClobTest2Updated");
            ps.setString(4, "NClobTest2Updated");
        }, null);
        Clob clob3Update = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 3, 25000));
        NClob nclob3Update = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 3, 25000));
        this.connection.prepareQuery("UPDATE clob_test SET val_clob=?, val_nclob=?, val_clobs=?, val_nclobs=?, val_varchar2='Test3U' WHERE id = 3", ps -> {
            ps.setClob(1, clob3Update);
            ps.setNClob(2, nclob3Update);
            ps.setString(3, "ClobTest3Updated");
            ps.setString(4, "NClobTest3Updated");
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)2);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob2Update));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest2Updated");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest2Updated");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test2U");
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(1);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)3);
        after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob3Update));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob3Update));
        Assertions.assertThat((Object)after.get("VAL_CLOBS")).isEqualTo((Object)"ClobTest3Updated");
        Assertions.assertThat((Object)after.get("VAL_NCLOBS")).isEqualTo((Object)"NClobTest3Updated");
        Assertions.assertThat((Object)after.get("VAL_VARCHAR2")).isEqualTo((Object)"Test3U");
        this.connection.execute(new String[]{"DELETE FROM debezium.clob_test WHERE id = 1"});
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
        Struct before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_VARCHAR2")).isEqualTo((Object)"Test1U");
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.clob_test WHERE id = 2"});
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.clob_test WHERE id = 3"});
        this.connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(4);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(4);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)2);
        before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_VARCHAR2")).isEqualTo((Object)"Test2U");
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(2);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)3);
        before = OracleClobDataTypeIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)before.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        Assertions.assertThat((Object)before.get("VAL_VARCHAR2")).isEqualTo((Object)"Test3U");
        Assertions.assertThat((Object)OracleClobDataTypeIT.after(record)).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3631"})
    public void shouldReconcileTransactionWhenAllBlobClobAreInitializedAsNull() throws Exception {
        String DDL = "CREATE TABLE dbz3631 (ID NUMBER(38) NOT NULL,ENTITY_ID NUMBER(38) NOT NULL,DOCX CLOB,DOCX_SIGNATURE CLOB,XML_OOS CLOB,XML_OOS_SIGNATURE CLOB,PRIMARY KEY(ID))";
        TestHelper.dropTable(this.connection, "dbz3631");
        try {
            this.connection.execute(new String[]{"CREATE TABLE dbz3631 (ID NUMBER(38) NOT NULL,ENTITY_ID NUMBER(38) NOT NULL,DOCX CLOB,DOCX_SIGNATURE CLOB,XML_OOS CLOB,XML_OOS_SIGNATURE CLOB,PRIMARY KEY(ID))"});
            TestHelper.streamTable(this.connection, "dbz3631");
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM.DBZ3631")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleClobDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            this.connection.executeWithoutCommitting(new String[]{"INSERT INTO dbz3631 (ID,ENTITY_ID) VALUES (13268281,13340568)"});
            this.connection.commit();
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List table = records.recordsForTopic("server1.DEBEZIUM.DBZ3631");
            Assertions.assertThat((List)table).hasSize(1);
            SourceRecord record = (SourceRecord)table.get(0);
            Struct value = (Struct)record.value();
            Struct after = value.getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(13268281L));
            Assertions.assertThat((Object)after.get("ENTITY_ID")).isEqualTo((Object)BigDecimal.valueOf(13340568L));
            Assertions.assertThat((Object)after.get("DOCX")).isNull();
            Assertions.assertThat((Object)after.get("DOCX_SIGNATURE")).isNull();
            Assertions.assertThat((Object)after.get("XML_OOS")).isNull();
            Assertions.assertThat((Object)after.get("XML_OOS_SIGNATURE")).isNull();
            Assertions.assertThat((Object)value.get("op")).isEqualTo((Object)Envelope.Operation.CREATE.code());
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3631");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3645"})
    public void shouldNotEmitClobFieldValuesWhenLobSupportIsNotEnabled() throws Exception {
        boolean logMinerAdapter = TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.LOG_MINER);
        TestHelper.dropTable(this.connection, "dbz3645");
        try {
            this.connection.execute(new String[]{"CREATE TABLE dbz3645 (id numeric(9,0), data clob, primary key(id))"});
            TestHelper.streamTable(this.connection, "dbz3645");
            this.connection.execute(new String[]{"INSERT INTO dbz3645 (id,data) values (1,'Test1')"});
            Clob clob1 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 25000));
            this.connection.prepareQuery("INSERT INTO dbz3645 (id,data) values (2,?)", ps -> ps.setClob(1, clob1), null);
            this.connection.commit();
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3645")).with(OracleConnectorConfig.LOB_ENABLED, false)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleClobDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(2);
            List table = sourceRecords.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ3645"));
            Assertions.assertThat((List)table).hasSize(2);
            SourceRecord record = (SourceRecord)table.get(0);
            Struct after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isNull();
            record = (SourceRecord)table.get(1);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("DATA")).isNull();
            this.connection.executeWithoutCommitting(new String[]{"INSERT INTO dbz3645 (id,data) values (3,'Test3')"});
            this.connection.prepareQuery("INSERT INTO dbz3645 (id,data) values (4,?)", ps -> ps.setClob(1, clob1), null);
            this.connection.commit();
            sourceRecords = this.consumeRecordsByTopic(logMinerAdapter ? 3 : 2);
            table = sourceRecords.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ3645"));
            Assertions.assertThat((List)table).hasSize(logMinerAdapter ? 3 : 2);
            record = (SourceRecord)table.get(0);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
            if (logMinerAdapter) {
                Assertions.assertThat((Object)after.get("DATA")).isNull();
            } else {
                Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)"Test3");
            }
            Assertions.assertThat((Object)((Struct)record.value()).get("op")).isEqualTo((Object)"c");
            if (logMinerAdapter) {
                record = (SourceRecord)table.get(1);
                after = ((Struct)record.value()).getStruct("after");
                Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
                Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)"Test3");
                Assertions.assertThat((Object)((Struct)record.value()).get("op")).isEqualTo((Object)"u");
            }
            record = (SourceRecord)table.get(logMinerAdapter ? 2 : 1);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)4);
            if (logMinerAdapter) {
                Assertions.assertThat((Object)after.get("DATA")).isNull();
            } else {
                Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1));
            }
            Assertions.assertThat((Object)((Struct)record.value()).get("op")).isEqualTo((Object)"c");
            this.connection.executeWithoutCommitting(new String[]{"UPDATE dbz3645 set data='Test3U' WHERE id = 3"});
            this.connection.commit();
            sourceRecords = this.consumeRecordsByTopic(1);
            table = sourceRecords.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ3645"));
            VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)table.get(0)), (String)"ID", (int)3);
            Assertions.assertThat((Object)OracleClobDataTypeIT.getBeforeField((SourceRecord)table.get(0), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            Assertions.assertThat((Object)OracleClobDataTypeIT.getAfterField((SourceRecord)table.get(0), "DATA")).isEqualTo((Object)"Test3U");
            this.assertNoRecordsToConsume();
            Clob clob2 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1000, 21500));
            this.connection.prepareQuery("UPDATE dbz3645 set data=? WHERE id=4", ps -> ps.setClob(1, clob2), null);
            this.connection.commit();
            if (logMinerAdapter) {
                this.waitForAvailableRecords(10L, TimeUnit.SECONDS);
            } else {
                sourceRecords = this.consumeRecordsByTopic(1);
                table = sourceRecords.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ3645"));
                VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)table.get(0)), (String)"ID", (int)4);
                Assertions.assertThat((Object)OracleClobDataTypeIT.getBeforeField((SourceRecord)table.get(0), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
                Assertions.assertThat((Object)OracleClobDataTypeIT.getAfterField((SourceRecord)table.get(0), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2));
            }
            this.assertNoRecordsToConsume();
            this.connection.executeWithoutCommitting(new String[]{"UPDATE dbz3645 set id=5 where id=3"});
            this.connection.commit();
            sourceRecords = this.consumeRecordsByTopic(3);
            table = sourceRecords.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ3645"));
            VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)table.get(0)), (String)"ID", (int)3);
            VerifyRecord.isValidTombstone((SourceRecord)((SourceRecord)table.get(1)), (String)"ID", (int)3);
            VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)table.get(2)), (String)"ID", (int)5);
            Assertions.assertThat((Object)OracleClobDataTypeIT.getBeforeField((SourceRecord)table.get(0), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            Assertions.assertThat((Object)OracleClobDataTypeIT.getAfterField((SourceRecord)table.get(2), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            this.assertNoRecordsToConsume();
            this.connection.executeWithoutCommitting(new String[]{"UPDATE dbz3645 SET ID=6 WHERE ID=4"});
            this.connection.commit();
            sourceRecords = this.consumeRecordsByTopic(3);
            table = sourceRecords.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ3645"));
            VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)table.get(0)), (String)"ID", (int)4);
            VerifyRecord.isValidTombstone((SourceRecord)((SourceRecord)table.get(1)), (String)"ID", (int)4);
            VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)table.get(2)), (String)"ID", (int)6);
            Assertions.assertThat((Object)OracleClobDataTypeIT.getBeforeField((SourceRecord)table.get(0), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            Assertions.assertThat((Object)OracleClobDataTypeIT.getAfterField((SourceRecord)table.get(2), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            this.assertNoRecordsToConsume();
            Clob clob1u2 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 10, 260));
            this.connection.prepareQuery("UPDATE dbz3645 SET data=?, id=7 WHERE id=5", ps -> ps.setClob(1, clob1u2), null);
            this.connection.commit();
            sourceRecords = this.consumeRecordsByTopic(logMinerAdapter ? 4 : 3);
            table = sourceRecords.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ3645"));
            VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)table.get(0)), (String)"ID", (int)5);
            VerifyRecord.isValidTombstone((SourceRecord)((SourceRecord)table.get(1)), (String)"ID", (int)5);
            VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)table.get(2)), (String)"ID", (int)7);
            if (logMinerAdapter) {
                VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)table.get(3)), (String)"ID", (int)7);
            }
            Assertions.assertThat((Object)OracleClobDataTypeIT.getBeforeField((SourceRecord)table.get(0), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            if (logMinerAdapter) {
                Assertions.assertThat((Object)OracleClobDataTypeIT.getAfterField((SourceRecord)table.get(2), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
                Assertions.assertThat((Object)OracleClobDataTypeIT.getBeforeField((SourceRecord)table.get(3), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
                Assertions.assertThat((Object)OracleClobDataTypeIT.getAfterField((SourceRecord)table.get(3), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1u2));
            } else {
                Assertions.assertThat((Object)OracleClobDataTypeIT.getAfterField((SourceRecord)table.get(2), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1u2));
            }
            this.assertNoRecordsToConsume();
            Clob clob2u2 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 10, 12500));
            this.connection.prepareQuery("UPDATE dbz3645 SET data=?, id=8 WHERE id=6", ps -> ps.setClob(1, clob2u2), null);
            this.connection.commit();
            sourceRecords = this.consumeRecordsByTopic(3);
            table = sourceRecords.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ3645"));
            VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)table.get(0)), (String)"ID", (int)6);
            VerifyRecord.isValidTombstone((SourceRecord)((SourceRecord)table.get(1)), (String)"ID", (int)6);
            VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)table.get(2)), (String)"ID", (int)8);
            Assertions.assertThat((Object)OracleClobDataTypeIT.getBeforeField((SourceRecord)table.get(0), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            if (logMinerAdapter) {
                Assertions.assertThat((Object)OracleClobDataTypeIT.getAfterField((SourceRecord)table.get(2), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            } else {
                Assertions.assertThat((Object)OracleClobDataTypeIT.getAfterField((SourceRecord)table.get(2), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob2u2));
            }
            this.assertNoRecordsToConsume();
            if (!logMinerAdapter) {
                return;
            }
            this.connection.execute(new String[]{"DELETE FROM dbz3645 WHERE id=7"});
            sourceRecords = this.consumeRecordsByTopic(2);
            table = sourceRecords.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ3645"));
            VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)table.get(0)), (String)"ID", (int)7);
            VerifyRecord.isValidTombstone((SourceRecord)((SourceRecord)table.get(1)), (String)"ID", (int)7);
            Assertions.assertThat((Object)OracleClobDataTypeIT.getBeforeField((SourceRecord)table.get(0), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            this.assertNoRecordsToConsume();
            this.connection.execute(new String[]{"DELETE FROM dbz3645 WHERE id=8"});
            sourceRecords = this.consumeRecordsByTopic(2);
            table = sourceRecords.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ3645"));
            VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)table.get(0)), (String)"ID", (int)8);
            VerifyRecord.isValidTombstone((SourceRecord)((SourceRecord)table.get(1)), (String)"ID", (int)8);
            Assertions.assertThat((Object)OracleClobDataTypeIT.getBeforeField((SourceRecord)table.get(0), "DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            this.assertNoRecordsToConsume();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3645");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3893"})
    public void shouldStreamNotNullClobUsingEmptyClobFunction() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3898");
        try {
            this.connection.execute(new String[]{"CREATE TABLE dbz3898 (id numeric(9,0), data clob not null, primary key(id))"});
            TestHelper.streamTable(this.connection, "dbz3898");
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3898")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleClobDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            this.connection.execute(new String[]{"INSERT INTO dbz3898 (id,data) values (1,EMPTY_CLOB())"});
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ3898"))).hasSize(1);
            SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ3898")).get(0);
            Struct after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)"");
            this.assertNoRecordsToConsume();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3898");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-4276"})
    public void shouldStreamClobWithUnavailableColumnValuePlaceholder() throws Exception {
        TestHelper.dropTable(this.connection, "dbz4276");
        try {
            this.connection.execute(new String[]{"CREATE TABLE dbz4276 (id numeric(9,0), data clob not null, data2 nclob not null, data3 varchar2(50), primary key(id))"});
            TestHelper.streamTable(this.connection, "dbz4276");
            this.connection.execute(new String[]{"INSERT INTO dbz4276 (id,data,data2,data3) values (1,EMPTY_CLOB(),EMPTY_CLOB(),'Test')"});
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ4276")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleClobDataTypeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ4276"))).hasSize(1);
            SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ4276")).get(0);
            Struct after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)"");
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"");
            Assertions.assertThat((Object)after.get("DATA3")).isEqualTo((Object)"Test");
            OracleClobDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            this.connection.execute(new String[]{"UPDATE dbz4276 set data3 = '123' WHERE id = 1"});
            records = this.consumeRecordsByTopic(1);
            Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ4276"))).hasSize(1);
            record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ4276")).get(0);
            Struct before = ((Struct)record.value()).getStruct("before");
            Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)before.get("DATA")).isEqualTo((Object)config.getString(OracleConnectorConfig.UNAVAILABLE_VALUE_PLACEHOLDER));
            Assertions.assertThat((Object)before.get("DATA2")).isEqualTo((Object)config.getString(OracleConnectorConfig.UNAVAILABLE_VALUE_PLACEHOLDER));
            Assertions.assertThat((Object)before.get("DATA3")).isEqualTo((Object)"Test");
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)config.getString(OracleConnectorConfig.UNAVAILABLE_VALUE_PLACEHOLDER));
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)config.getString(OracleConnectorConfig.UNAVAILABLE_VALUE_PLACEHOLDER));
            Assertions.assertThat((Object)after.get("DATA3")).isEqualTo((Object)"123");
            this.connection.execute(new String[]{"DELETE FROM dbz4276 WHERE id = 1"});
            records = this.consumeRecordsByTopic(2);
            Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ4276"))).hasSize(2);
            record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ4276")).get(0);
            before = ((Struct)record.value()).getStruct("before");
            Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)before.get("DATA")).isEqualTo((Object)config.getString(OracleConnectorConfig.UNAVAILABLE_VALUE_PLACEHOLDER));
            Assertions.assertThat((Object)before.get("DATA2")).isEqualTo((Object)config.getString(OracleConnectorConfig.UNAVAILABLE_VALUE_PLACEHOLDER));
            Assertions.assertThat((Object)before.get("DATA3")).isEqualTo((Object)"123");
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after).isNull();
            this.assertNoRecordsToConsume();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz4276");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER, reason="Xstream marks chunks as end of rows")
    @FixFor(value={"DBZ-4366"})
    public void shouldStreamClobsWrittenInChunkedMode() throws Exception {
        TestHelper.dropTable(this.connection, "dbz4366");
        try {
            this.connection.execute(new String[]{"CREATE TABLE dbz4366 (id numeric(9,0), val_clob clob not null, val_nclob nclob not null, primary key(id))"});
            TestHelper.streamTable(this.connection, "dbz4366");
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ4366")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleClobDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            this.connection.executeWithoutCommitting(new String[]{"INSERT INTO dbz4366 (id,val_clob,val_nclob) values (1,EMPTY_CLOB(),EMPTY_CLOB())"});
            String fillQuery = "DECLARE\n  loc CLOB;\n  nloc NCLOB;\n  i PLS_INTEGER;\n  str VARCHAR2(1024);\nBEGIN\n  str := ?;\n  SELECT val_clob into loc FROM dbz4366 WHERE id = 1 FOR UPDATE;\n  SELECT val_nclob into nloc FROM dbz4366 WHERE id = 1 FOR UPDATE;\n  DBMS_LOB.OPEN(loc, DBMS_LOB.LOB_READWRITE);\n  DBMS_LOB.OPEN(nloc, DBMS_LOB.LOB_READWRITE);\n  FOR i IN 1..1024 LOOP\n    DBMS_LOB.WRITEAPPEND(loc, 1024, str);\n    DBMS_LOB.WRITEAPPEND(nloc, 1024, str);\n  END LOOP;\n  DBMS_LOB.CLOSE(loc);\n  DBMS_LOB.CLOSE(nloc);\nEND;";
            this.connection.prepareQuery("DECLARE\n  loc CLOB;\n  nloc NCLOB;\n  i PLS_INTEGER;\n  str VARCHAR2(1024);\nBEGIN\n  str := ?;\n  SELECT val_clob into loc FROM dbz4366 WHERE id = 1 FOR UPDATE;\n  SELECT val_nclob into nloc FROM dbz4366 WHERE id = 1 FOR UPDATE;\n  DBMS_LOB.OPEN(loc, DBMS_LOB.LOB_READWRITE);\n  DBMS_LOB.OPEN(nloc, DBMS_LOB.LOB_READWRITE);\n  FOR i IN 1..1024 LOOP\n    DBMS_LOB.WRITEAPPEND(loc, 1024, str);\n    DBMS_LOB.WRITEAPPEND(nloc, 1024, str);\n  END LOOP;\n  DBMS_LOB.CLOSE(loc);\n  DBMS_LOB.CLOSE(nloc);\nEND;", ps -> ps.setString(1, OracleClobDataTypeIT.part(JSON_DATA, 0, 1024)), null);
            this.connection.execute(new String[]{"COMMIT"});
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ4366"))).hasSize(1);
            SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ4366")).get(0);
            Struct after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            String clobval = (String)after.get("VAL_CLOB");
            Assertions.assertThat((int)clobval.length()).isEqualTo(0x100000);
            String nclobval = (String)after.get("VAL_NCLOB");
            Assertions.assertThat((int)nclobval.length()).isEqualTo(0x100000);
            this.assertNoRecordsToConsume();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz4366");
        }
    }

    @Test
    @FixFor(value={"DBZ-4891", "DBZ-4862", "DBZ-4994"})
    public void shouldStreamClobValueWithEscapedSingleQuoteValue() throws Exception {
        String ddl = "CREATE TABLE CLOB_TEST (ID numeric(9,0), VAL_CLOB clob, VAL_NCLOB nclob, VAL_USERNAME varchar2(100),VAL_DATA varchar2(100), primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.clob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleClobDataTypeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        String simpleQuote = "This will be fixed soon so please don''t worry, she wrote.";
        String complexQuote = "2\"''\" sd f\"\"\" '''''''' ''''";
        this.connection.execute(new String[]{"INSERT INTO clob_test (id,val_username,val_data) values (1,'This will be fixed soon so please don''t worry, she wrote.','2\"''\" sd f\"\"\" '''''''' ''''')"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Clob clob1 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 25000));
        NClob nclob1 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 0, 25000));
        this.connection.prepareQuery("update clob_test set val_clob=?, val_nclob=? where id=1", ps -> {
            ps.setClob(1, clob1);
            ps.setClob(2, nclob1);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST"))).hasSize(1);
        record = (SourceRecord)records.recordsForTopic(OracleClobDataTypeIT.topicName("CLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleClobDataTypeIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_CLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(clob1));
        Assertions.assertThat((Object)after.get("VAL_NCLOB")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(nclob1));
        Assertions.assertThat((Object)after.get("VAL_USERNAME")).isEqualTo((Object)"This will be fixed soon so please don't worry, she wrote.");
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"2\"'\" sd f\"\"\" '''' ''");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER, reason="Commit SCN is only applicable to LogMiner")
    @FixFor(value={"DBZ-5266"})
    public void shouldUpdateCommitScnOnLobTransaction() throws Exception {
        TestHelper.dropTable(this.connection, "dbz5266");
        try {
            this.connection.execute(new String[]{"create table dbz5266 (data clob)"});
            TestHelper.streamTable(this.connection, "dbz5266");
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ5266")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleClobDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            String query = "INSERT INTO dbz5266 values (?)";
            try (PreparedStatement ps = this.connection.connection().prepareStatement("INSERT INTO dbz5266 values (?)");){
                URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("data/test_lob_data.json");
                File file = new File(resource.toURI());
                ps.setCharacterStream(1, (Reader)new FileReader(file), file.length());
                ps.addBatch();
                ps.executeBatch();
                this.connection.commit();
            }
            catch (Exception e) {
                Fail.fail((String)"Insert of clob data failed to happen", (Throwable)e);
            }
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List tableRecords = records.recordsForTopic("server1.DEBEZIUM.DBZ5266");
            Assertions.assertThat((List)tableRecords).hasSize(1);
            Struct after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after.get("DATA")).isNotNull();
            Struct source = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("source");
            Assertions.assertThat((Object)source.get("scn")).isNotNull();
            Assertions.assertThat((Object)source.get("commit_scn")).isNotNull();
            String commitScn = source.getString("commit_scn");
            String scn = source.getString("scn");
            Assertions.assertThat((long)Scn.valueOf((String)commitScn).longValue()).isGreaterThanOrEqualTo(Scn.valueOf((String)scn).longValue());
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz5266");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER, reason="Commit SCN is only applicable to LogMiner")
    @FixFor(value={"DBZ-5266"})
    public void shouldUpdateCommitScnOnNonLobTransactionWithLobEnabled() throws Exception {
        TestHelper.dropTable(this.connection, "dbz5266");
        try {
            this.connection.execute(new String[]{"create table dbz5266 (data varchar2(50))"});
            TestHelper.streamTable(this.connection, "dbz5266");
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ5266")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleClobDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            this.connection.execute(new String[]{"INSERT INTO dbz5266 values ('test')"});
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List tableRecords = records.recordsForTopic("server1.DEBEZIUM.DBZ5266");
            Assertions.assertThat((List)tableRecords).hasSize(1);
            Struct after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after.get("DATA")).isNotNull();
            Struct source = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("source");
            Assertions.assertThat((Object)source.get("scn")).isNotNull();
            Assertions.assertThat((Object)source.get("commit_scn")).isNotNull();
            String commitScn = source.getString("commit_scn");
            String scn = source.getString("scn");
            Assertions.assertThat((long)Scn.valueOf((String)commitScn).longValue()).isGreaterThanOrEqualTo(Scn.valueOf((String)scn).longValue());
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz5266");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER, reason="Commit SCN is only applicable to LogMiner")
    @FixFor(value={"DBZ-5266"})
    public void shouldUpdateCommitScnOnNonLobTransactionWithLobDisabled() throws Exception {
        TestHelper.dropTable(this.connection, "dbz5266");
        try {
            this.connection.execute(new String[]{"create table dbz5266 (data varchar2(50))"});
            TestHelper.streamTable(this.connection, "dbz5266");
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ5266")).with(OracleConnectorConfig.LOB_ENABLED, false)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleClobDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            this.connection.execute(new String[]{"INSERT INTO dbz5266 values ('test')"});
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List tableRecords = records.recordsForTopic("server1.DEBEZIUM.DBZ5266");
            Assertions.assertThat((List)tableRecords).hasSize(1);
            Struct after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after.get("DATA")).isNotNull();
            Struct source = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("source");
            Assertions.assertThat((Object)source.get("scn")).isNotNull();
            Assertions.assertThat((Object)source.get("commit_scn")).isNotNull();
            String commitScn = source.getString("commit_scn");
            String scn = source.getString("scn");
            Assertions.assertThat((long)Scn.valueOf((String)commitScn).longValue()).isGreaterThanOrEqualTo(Scn.valueOf((String)scn).longValue());
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz5266");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-5295"})
    public void shouldReselectClobAfterPrimaryKeyChange() throws Exception {
        TestHelper.dropTable(this.connection, "dbz5295");
        try {
            this.connection.execute(new String[]{"create table dbz5295 (id numeric(9,0) primary key, data clob, data2 clob)"});
            TestHelper.streamTable(this.connection, "dbz5295");
            this.connection.execute(new String[]{"INSERT INTO dbz5295 (id,data,data2) values (1,'Small clob data','Data2')"});
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ5295")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleClobDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List recordsForTopic = records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ5295"));
            Assertions.assertThat((List)recordsForTopic).hasSize(1);
            SourceRecord record = (SourceRecord)recordsForTopic.get(0);
            Struct after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)"Small clob data");
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Data2");
            this.connection.execute(new String[]{"UPDATE dbz5295 set id = 2 where id = 1"});
            records = this.consumeRecordsByTopic(3);
            recordsForTopic = records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ5295"));
            Assertions.assertThat((List)recordsForTopic).hasSize(3);
            record = (SourceRecord)recordsForTopic.get(0);
            VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after).isNull();
            record = (SourceRecord)recordsForTopic.get(1);
            VerifyRecord.isValidTombstone((SourceRecord)record);
            record = (SourceRecord)recordsForTopic.get(2);
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)"Small clob data");
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Data2");
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz5295");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-5295"})
    public void shouldReselectClobAfterPrimaryKeyChangeWithRowDeletion() throws Exception {
        TestHelper.dropTable(this.connection, "dbz5295");
        try {
            this.connection.execute(new String[]{"create table dbz5295 (id numeric(9,0) primary key, data clob, data2 clob)"});
            TestHelper.streamTable(this.connection, "dbz5295");
            this.connection.execute(new String[]{"INSERT INTO dbz5295 (id,data,data2) values (1,'Small clob data','Data2')"});
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ5295")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleClobDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List recordsForTopic = records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ5295"));
            Assertions.assertThat((List)recordsForTopic).hasSize(1);
            SourceRecord record = (SourceRecord)recordsForTopic.get(0);
            Struct after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)"Small clob data");
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Data2");
            this.connection.executeWithoutCommitting(new String[]{"UPDATE dbz5295 set id = 2 where id = 1"});
            this.connection.execute(new String[]{"DELETE FROM dbz5295 where id = 2"});
            records = this.consumeRecordsByTopic(4);
            recordsForTopic = records.recordsForTopic(OracleClobDataTypeIT.topicName("DBZ5295"));
            Assertions.assertThat((List)recordsForTopic).hasSize(4);
            record = (SourceRecord)recordsForTopic.get(0);
            VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after).isNull();
            record = (SourceRecord)recordsForTopic.get(1);
            VerifyRecord.isValidTombstone((SourceRecord)record);
            record = (SourceRecord)recordsForTopic.get(2);
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            record = (SourceRecord)recordsForTopic.get(3);
            VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)2);
            Struct before = ((Struct)record.value()).getStruct("before");
            Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)before.get("DATA")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            Assertions.assertThat((Object)before.get("DATA2")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz5295");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-5581"})
    public void testClobUnavailableValuePlaceholderUpdateOnlyOneClobColumn() throws Exception {
        TestHelper.dropTable(this.connection, "dbz5581");
        try {
            this.connection.execute(new String[]{"create table dbz5581 (id numeric(9,0) primary key, a1 varchar2(200), a2 clob, a3 nclob, a4 varchar2(100))"});
            TestHelper.streamTable(this.connection, "dbz5581");
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ5581")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleClobDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            Clob a2 = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 0, 4100));
            NClob a3 = this.createNClob(OracleClobDataTypeIT.part(JSON_DATA2, 0, 4100));
            this.connection.prepareQuery("INSERT into dbz5581 (id,a1,a2,a3,a4) values (1, 'lwmzVQd6r7', ?, ?, 'cuTVQV0OpK')", st -> {
                st.setClob(1, a2);
                st.setNClob(2, a3);
            }, null);
            this.connection.commit();
            Clob a2u = this.createClob(OracleClobDataTypeIT.part(JSON_DATA, 1, 4101));
            this.connection.prepareQuery("UPDATE dbz5581 set A2=? WHERE ID=1", st -> st.setClob(1, a2u), null);
            this.connection.commit();
            this.connection.execute(new String[]{"UPDATE dbz5581 set A2=NULL WHERE ID=1"});
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(3);
            List recordsForTopic = records.recordsForTopic("server1.DEBEZIUM.DBZ5581");
            Assertions.assertThat((List)recordsForTopic).hasSize(3);
            SourceRecord record = (SourceRecord)recordsForTopic.get(0);
            Struct after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("A1")).isEqualTo((Object)"lwmzVQd6r7");
            Assertions.assertThat((Object)after.get("A2")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(a2));
            Assertions.assertThat((Object)after.get("A3")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(a3));
            Assertions.assertThat((Object)after.get("A4")).isEqualTo((Object)"cuTVQV0OpK");
            record = (SourceRecord)recordsForTopic.get(1);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("A1")).isEqualTo((Object)"lwmzVQd6r7");
            Assertions.assertThat((Object)after.get("A2")).isEqualTo((Object)OracleClobDataTypeIT.getClobString(a2u));
            Assertions.assertThat((Object)after.get("A3")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            Assertions.assertThat((Object)after.get("A4")).isEqualTo((Object)"cuTVQV0OpK");
            record = (SourceRecord)recordsForTopic.get(2);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("A1")).isEqualTo((Object)"lwmzVQd6r7");
            Assertions.assertThat((Object)after.get("A2")).isNull();
            Assertions.assertThat((Object)after.get("A3")).isEqualTo((Object)OracleClobDataTypeIT.getUnavailableValuePlaceholder(config));
            Assertions.assertThat((Object)after.get("A4")).isEqualTo((Object)"cuTVQV0OpK");
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz5581");
        }
    }

    private Clob createClob(String data) throws SQLException {
        Clob clob = this.connection.connection().createClob();
        clob.setString(1L, data);
        return clob;
    }

    private NClob createNClob(String data) throws SQLException {
        NClob nclob = this.connection.connection().createNClob();
        nclob.setString(1L, data);
        return nclob;
    }

    private static String part(String text, int start, int length) {
        return text == null ? "" : text.substring(start, Math.min(length, text.length()));
    }

    private static Struct before(SourceRecord record) {
        return ((Struct)record.value()).getStruct("before");
    }

    private static Struct after(SourceRecord record) {
        return ((Struct)record.value()).getStruct("after");
    }

    private static String topicName(String tableName) {
        return "server1.DEBEZIUM." + tableName;
    }

    private static String getClobString(Clob clob) throws SQLException {
        return clob.getSubString(1L, (int)clob.length());
    }

    private static String getUnavailableValuePlaceholder(Configuration config) {
        return config.getString(OracleConnectorConfig.UNAVAILABLE_VALUE_PLACEHOLDER);
    }

    private static Object getBeforeField(SourceRecord record, String fieldName) {
        return OracleClobDataTypeIT.before(record).get(fieldName);
    }

    private static Object getAfterField(SourceRecord record, String fieldName) {
        return OracleClobDataTypeIT.after(record).get(fieldName);
    }
}

