/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class LogMinerQueryBuilder {
    private static final String LOGMNR_CONTENTS_VIEW = "V$LOGMNR_CONTENTS";

    public static String build(OracleConnectorConfig connectorConfig, OracleDatabaseSchema schema) {
        String tablePredicate;
        StringBuilder query = new StringBuilder(1024);
        query.append("SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, ");
        query.append("USERNAME, ROW_ID, ROLLBACK, RS_ID, STATUS, INFO, SSN, THREAD# ");
        query.append("FROM ").append(LOGMNR_CONTENTS_VIEW).append(" ");
        query.append("WHERE SCN > ? AND SCN <= ? ");
        String pdbName = connectorConfig.getPdbName();
        String pdbPredicate = !Strings.isNullOrEmpty((String)pdbName) ? "SRC_CON_NAME = '" + pdbName + "'" : null;
        String excludedSchemas = LogMinerQueryBuilder.resolveExcludedSchemaPredicate("SEG_OWNER");
        if (excludedSchemas.length() > 0) {
            query.append("AND ").append(excludedSchemas).append(' ');
        }
        query.append("AND (");
        query.append("(OPERATION_CODE IN (6,7,34,36)");
        if (!schema.storeOnlyCapturedTables()) {
            query.append(" OR ").append(LogMinerQueryBuilder.buildDdlPredicate(pdbPredicate)).append(" ");
            if (connectorConfig.isLobEnabled()) {
                query.append(") OR (OPERATION_CODE IN (1,2,3,9,10,11,29) ");
            } else {
                query.append(") OR (OPERATION_CODE IN (1,2,3,255) ");
            }
            if (pdbPredicate != null) {
                query.append("AND ").append(pdbPredicate).append(' ');
            }
        } else {
            query.append(") OR (");
            if (pdbPredicate != null) {
                query.append(pdbPredicate).append(" AND ");
            }
            if (connectorConfig.isLobEnabled()) {
                query.append("(OPERATION_CODE IN (1,2,3,9,10,11,29) ");
            } else {
                query.append("(OPERATION_CODE IN (1,2,3,255) ");
            }
            query.append("OR ").append(LogMinerQueryBuilder.buildDdlPredicate(null)).append(") ");
        }
        query.append("AND TABLE_NAME != '").append("LOG_MINING_FLUSH").append("' ");
        String schemaPredicate = LogMinerQueryBuilder.buildSchemaPredicate(connectorConfig);
        if (!Strings.isNullOrEmpty((String)schemaPredicate)) {
            query.append("AND ").append(schemaPredicate).append(" ");
        }
        if (!Strings.isNullOrEmpty((String)(tablePredicate = LogMinerQueryBuilder.buildTablePredicate(connectorConfig)))) {
            query.append("AND ").append(tablePredicate).append(" ");
        }
        query.append("))");
        return query.toString();
    }

    private static String buildDdlPredicate(String pdbPredicate) {
        StringBuilder predicate = new StringBuilder(256);
        predicate.append("(OPERATION_CODE = 5 ");
        predicate.append("AND USERNAME NOT IN ('SYS','SYSTEM') ");
        predicate.append("AND INFO NOT LIKE 'INTERNAL DDL%' ");
        if (pdbPredicate != null) {
            predicate.append("AND ").append(pdbPredicate).append(' ');
        }
        predicate.append("AND (TABLE_NAME IS NULL OR TABLE_NAME NOT LIKE 'ORA_TEMP_%'))");
        return predicate.toString();
    }

    private static String buildSchemaPredicate(OracleConnectorConfig connectorConfig) {
        StringBuilder predicate = new StringBuilder();
        if (Strings.isNullOrEmpty((String)connectorConfig.schemaIncludeList())) {
            if (!Strings.isNullOrEmpty((String)connectorConfig.schemaExcludeList())) {
                List patterns = Strings.listOfRegex((String)connectorConfig.schemaExcludeList(), (int)0);
                predicate.append("(").append(LogMinerQueryBuilder.listOfPatternsToSql(patterns, "SEG_OWNER", true)).append(")");
            }
        } else {
            List patterns = Strings.listOfRegex((String)connectorConfig.schemaIncludeList(), (int)0);
            predicate.append("(").append(LogMinerQueryBuilder.listOfPatternsToSql(patterns, "SEG_OWNER", false)).append(")");
        }
        return predicate.toString();
    }

    private static String buildTablePredicate(OracleConnectorConfig connectorConfig) {
        StringBuilder predicate = new StringBuilder();
        if (Strings.isNullOrEmpty((String)connectorConfig.tableIncludeList())) {
            if (!Strings.isNullOrEmpty((String)connectorConfig.tableExcludeList())) {
                List patterns = Strings.listOfRegex((String)connectorConfig.tableExcludeList(), (int)0);
                predicate.append("(").append(LogMinerQueryBuilder.listOfPatternsToSql(patterns, "SEG_OWNER || '.' || TABLE_NAME", true)).append(LogMinerQueryBuilder.buildSignalDataCollectionPredicate(connectorConfig)).append(")");
            }
        } else {
            List patterns = Strings.listOfRegex((String)connectorConfig.tableIncludeList(), (int)0);
            predicate.append("(").append(LogMinerQueryBuilder.listOfPatternsToSql(patterns, "SEG_OWNER || '.' || TABLE_NAME", false)).append(LogMinerQueryBuilder.buildSignalDataCollectionPredicate(connectorConfig)).append(")");
        }
        return predicate.toString();
    }

    private static String buildSignalDataCollectionPredicate(OracleConnectorConfig connectorConfig) {
        String signalDataCollection = connectorConfig.getSignalingDataCollectionId();
        if (signalDataCollection == null) {
            return "";
        }
        TableId signalDataCollectionTableId = TableId.parse((String)signalDataCollection, (boolean)connectorConfig.useCatalogBeforeSchema());
        return " OR SEG_OWNER || '.' || TABLE_NAME='" + connectorConfig.getTableIdMapper().toString(signalDataCollectionTableId) + "'";
    }

    private static String listOfPatternsToSql(List<Pattern> patterns, String columnName, boolean inclusion) {
        StringBuilder predicate = new StringBuilder();
        Iterator<Pattern> i = patterns.iterator();
        while (i.hasNext()) {
            Pattern pattern = i.next();
            if (inclusion) {
                predicate.append("NOT ");
            }
            String text = LogMinerQueryBuilder.resolveRegExpLikePattern(pattern);
            predicate.append("REGEXP_LIKE(").append(columnName).append(",'").append(text).append("','i')");
            if (!i.hasNext()) continue;
            predicate.append(inclusion ? " AND " : " OR ");
        }
        return predicate.toString();
    }

    private static String resolveRegExpLikePattern(Pattern pattern) {
        Object text = pattern.pattern();
        if (!((String)text).startsWith("^")) {
            text = "^" + (String)text;
        }
        if (!((String)text).endsWith("$")) {
            text = (String)text + "$";
        }
        return text;
    }

    private static String resolveExcludedSchemaPredicate(String fieldName) {
        if (!OracleConnectorConfig.EXCLUDED_SCHEMAS.isEmpty()) {
            StringBuilder query = new StringBuilder();
            query.append('(').append(fieldName).append(" IS NULL OR ");
            query.append(fieldName).append(" NOT IN (");
            Iterator<String> i = OracleConnectorConfig.EXCLUDED_SCHEMAS.iterator();
            while (i.hasNext()) {
                String excludedSchema = i.next();
                query.append('\'').append(excludedSchema.toUpperCase()).append('\'');
                if (!i.hasNext()) continue;
                query.append(',');
            }
            return query.append(')').append(')').toString();
        }
        return "";
    }
}

