/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSnapshotChangeEventSource
extends RelationalSnapshotChangeEventSource<OraclePartition, OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleSnapshotChangeEventSource.class);
    private final OracleConnectorConfig connectorConfig;
    private final OracleConnection jdbcConnection;
    private final OracleDatabaseSchema databaseSchema;

    public OracleSnapshotChangeEventSource(OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, OracleDatabaseSchema schema, EventDispatcher<OraclePartition, TableId> dispatcher, Clock clock, SnapshotProgressListener<OraclePartition> snapshotProgressListener) {
        super((RelationalDatabaseConnectorConfig)connectorConfig, (JdbcConnection)jdbcConnection, (RelationalDatabaseSchema)schema, dispatcher, clock, snapshotProgressListener);
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = jdbcConnection;
        this.databaseSchema = schema;
    }

    protected AbstractSnapshotChangeEventSource.SnapshottingTask getSnapshottingTask(OraclePartition partition, OracleOffsetContext previousOffset) {
        boolean snapshotSchema = true;
        boolean snapshotData = true;
        if (previousOffset != null && !previousOffset.isSnapshotRunning()) {
            LOGGER.info("The previous offset has been found.");
            snapshotSchema = this.databaseSchema.isStorageInitializationExecuted();
            snapshotData = false;
        } else {
            LOGGER.info("No previous offset has been found.");
            snapshotData = this.connectorConfig.getSnapshotMode().includeData();
        }
        if (snapshotData && snapshotSchema) {
            LOGGER.info("According to the connector configuration both schema and data will be snapshot.");
        } else if (snapshotSchema) {
            LOGGER.info("According to the connector configuration only schema will be snapshot.");
        }
        return new AbstractSnapshotChangeEventSource.SnapshottingTask(snapshotSchema, snapshotData);
    }

    protected AbstractSnapshotChangeEventSource.SnapshotContext<OraclePartition, OracleOffsetContext> prepare(OraclePartition partition) throws Exception {
        if (this.connectorConfig.getPdbName() != null) {
            this.jdbcConnection.setSessionToPdb(this.connectorConfig.getPdbName());
        }
        return new OracleSnapshotContext(partition, this.connectorConfig.getCatalogName());
    }

    protected Set<TableId> getAllTableIds(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> ctx) throws Exception {
        return this.jdbcConnection.getAllTableIds(ctx.catalogName);
    }

    protected void lockTablesForSchemaSnapshot(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext) throws SQLException, InterruptedException {
        if (this.connectorConfig.getSnapshotLockingMode().usesLocking()) {
            ((OracleSnapshotContext)snapshotContext).preSchemaSnapshotSavepoint = this.jdbcConnection.connection().setSavepoint("dbz_schema_snapshot");
            try (Statement statement = this.jdbcConnection.connection().createStatement();){
                for (TableId tableId : snapshotContext.capturedTables) {
                    if (!sourceContext.isRunning()) {
                        throw new InterruptedException("Interrupted while locking table " + tableId);
                    }
                    LOGGER.debug("Locking table {}", (Object)tableId);
                    statement.execute("LOCK TABLE " + OracleSnapshotChangeEventSource.quote(tableId) + " IN ROW SHARE MODE");
                }
            }
        } else {
            LOGGER.info("Schema locking was disabled in connector configuration");
        }
    }

    protected void releaseSchemaSnapshotLocks(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext) throws SQLException {
        if (this.connectorConfig.getSnapshotLockingMode().usesLocking()) {
            this.jdbcConnection.connection().rollback(((OracleSnapshotContext)snapshotContext).preSchemaSnapshotSavepoint);
        }
    }

    protected void determineSnapshotOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> ctx, OracleOffsetContext previousOffset) throws Exception {
        if (previousOffset != null) {
            ctx.offset = previousOffset;
            this.tryStartingSnapshot(ctx);
            return;
        }
        ctx.offset = this.connectorConfig.getAdapter().determineSnapshotOffset(ctx, this.connectorConfig, this.jdbcConnection);
    }

    protected void readTableStructure(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, OracleOffsetContext offsetContext) throws SQLException, InterruptedException {
        Set capturedSchemaTables;
        if (this.databaseSchema.storeOnlyCapturedTables()) {
            capturedSchemaTables = snapshotContext.capturedTables;
            LOGGER.info("Only captured tables schema should be captured, capturing: {}", (Object)capturedSchemaTables);
        } else {
            capturedSchemaTables = snapshotContext.capturedSchemaTables;
            LOGGER.info("All eligible tables schema should be captured, capturing: {}", (Object)capturedSchemaTables);
        }
        Set schemas = capturedSchemaTables.stream().map(TableId::schema).collect(Collectors.toSet());
        for (String schema : schemas) {
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while reading structure of schema " + schema);
            }
            this.jdbcConnection.readSchema(snapshotContext.tables, null, schema, null, null, false);
        }
    }

    protected String enhanceOverriddenSelect(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, String overriddenSelect, TableId tableId) {
        String snapshotOffset = (String)((OracleOffsetContext)snapshotContext.offset).getOffset().get("scn");
        String token = this.connectorConfig.getTokenToReplaceInSnapshotPredicate();
        if (token != null) {
            return overriddenSelect.replaceAll(token, " AS OF SCN " + snapshotOffset);
        }
        return overriddenSelect;
    }

    protected void createSchemaChangeEventsForTables(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask) throws Exception {
        this.tryStartingSnapshot(snapshotContext);
        Iterator iterator = snapshotContext.capturedSchemaTables.iterator();
        while (iterator.hasNext()) {
            TableId tableId = (TableId)iterator.next();
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while capturing schema of table " + tableId);
            }
            LOGGER.info("Capturing structure of table {}", (Object)tableId);
            Table table = snapshotContext.tables.forTable(tableId);
            if (!this.schema().isHistorized()) continue;
            ((OracleOffsetContext)snapshotContext.offset).event((DataCollectionId)tableId, this.getClock().currentTime());
            if (!snapshottingTask.snapshotData() && !iterator.hasNext()) {
                this.lastSnapshotRecord(snapshotContext);
            }
            this.dispatcher.dispatchSchemaChangeEvent((Partition)((OraclePartition)snapshotContext.partition), (DataCollectionId)table.id(), receiver -> {
                try {
                    receiver.schemaChangeEvent(this.getCreateTableEvent(snapshotContext, table));
                }
                catch (Exception e) {
                    throw new DebeziumException((Throwable)e);
                }
            });
        }
    }

    protected SchemaChangeEvent getCreateTableEvent(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, Table table) throws SQLException {
        return SchemaChangeEvent.ofCreate((Partition)snapshotContext.partition, (OffsetContext)snapshotContext.offset, (String)snapshotContext.catalogName, (String)table.id().schema(), (String)this.jdbcConnection.getTableMetadataDdl(table.id()), (Table)table, (boolean)true);
    }

    protected Instant getSnapshotSourceTimestamp(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, TableId tableId) {
        try {
            Optional<OffsetDateTime> snapshotTs = this.jdbcConnection.getScnToTimestamp(((OracleOffsetContext)snapshotContext.offset).getScn());
            if (snapshotTs.isEmpty()) {
                throw new ConnectException("Failed reading SCN timestamp from source database");
            }
            return snapshotTs.get().toInstant();
        }
        catch (SQLException e) {
            throw new ConnectException("Failed reading SCN timestamp from source database", (Throwable)e);
        }
    }

    protected Optional<String> getSnapshotSelect(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, TableId tableId, List<String> columns) {
        OracleOffsetContext offset = (OracleOffsetContext)snapshotContext.offset;
        String snapshotOffset = offset.getScn().toString();
        String snapshotSelectColumns = columns.stream().collect(Collectors.joining(", "));
        assert (snapshotOffset != null);
        return Optional.of(String.format("SELECT %s FROM %s AS OF SCN %s", snapshotSelectColumns, OracleSnapshotChangeEventSource.quote(tableId), snapshotOffset));
    }

    protected void complete(AbstractSnapshotChangeEventSource.SnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext) {
        if (this.connectorConfig.getPdbName() != null) {
            this.jdbcConnection.resetSessionToCdb();
        }
    }

    private static String quote(TableId tableId) {
        return TableId.parse((String)(tableId.schema() + "." + tableId.table()), (boolean)true).toDoubleQuotedString();
    }

    private static class OracleSnapshotContext
    extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> {
        private Savepoint preSchemaSnapshotSavepoint;

        public OracleSnapshotContext(OraclePartition partition, String catalogName) throws SQLException {
            super((Partition)partition, catalogName);
        }
    }
}

