/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.DebeziumException;
import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseVersion;
import io.debezium.connector.oracle.Scn;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.util.Strings;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnection
extends JdbcConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleConnection.class);
    private static final int ORACLE_UNSET_SCALE = -127;
    private static final Pattern SYS_NC_PATTERN = Pattern.compile("^SYS_NC(?:_OID|_ROWINFO|[0-9][0-9][0-9][0-9][0-9])\\$$");
    private static final Pattern ADT_INDEX_NAMES_PATTERN = Pattern.compile("^\".*\"\\.\".*\".*");
    private static final Pattern MROW_PATTERN = Pattern.compile("^M_ROW\\$\\$");
    private static final Field URL = Field.create((String)"url", (String)"Raw JDBC url");
    private final OracleDatabaseVersion databaseVersion = this.resolveOracleDatabaseVersion();
    private static final String QUOTED_CHARACTER = "\"";

    public OracleConnection(JdbcConfiguration config, Supplier<ClassLoader> classLoaderSupplier) {
        this(config, classLoaderSupplier, true);
    }

    public OracleConnection(JdbcConfiguration config, Supplier<ClassLoader> classLoaderSupplier, boolean showVersion) {
        super(config, OracleConnection.resolveConnectionFactory(config), classLoaderSupplier, QUOTED_CHARACTER, QUOTED_CHARACTER);
        if (showVersion) {
            LOGGER.info("Database Version: {}", (Object)this.databaseVersion.getBanner());
        }
    }

    public void setSessionToPdb(String pdbName) {
        Statement statement = null;
        try {
            statement = this.connection().createStatement();
            statement.execute("alter session set container=" + pdbName);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Couldn't close statement", (Throwable)e);
                }
            }
        }
    }

    public void resetSessionToCdb() {
        Statement statement = null;
        try {
            statement = this.connection().createStatement();
            statement.execute("alter session set container=cdb$root");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Couldn't close statement", (Throwable)e);
                }
            }
        }
    }

    public OracleDatabaseVersion getOracleVersion() {
        return this.databaseVersion;
    }

    private OracleDatabaseVersion resolveOracleDatabaseVersion() {
        String versionStr;
        try {
            try {
                versionStr = (String)this.queryAndMap("SELECT BANNER_FULL FROM V$VERSION WHERE BANNER_FULL LIKE 'Oracle Database%'", rs -> {
                    if (rs.next()) {
                        return rs.getString(1);
                    }
                    return null;
                });
            }
            catch (SQLException e) {
                if (e.getMessage().contains("ORA-00904: \"BANNER_FULL\"")) {
                    LOGGER.debug("BANNER_FULL column not in V$VERSION, using BANNER column as fallback");
                    versionStr = null;
                }
                throw e;
            }
            if (versionStr == null) {
                versionStr = (String)this.queryAndMap("SELECT BANNER FROM V$VERSION WHERE BANNER LIKE 'Oracle Database%'", rs -> {
                    if (rs.next()) {
                        return rs.getString(1);
                    }
                    return null;
                });
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to resolve Oracle database version", e);
        }
        if (versionStr == null) {
            throw new RuntimeException("Failed to resolve Oracle database version");
        }
        return OracleDatabaseVersion.parse(versionStr);
    }

    public Set<TableId> readTableNames(String databaseCatalog, String schemaNamePattern, String tableNamePattern, String[] tableTypes) throws SQLException {
        Set tableIds = super.readTableNames(null, schemaNamePattern, tableNamePattern, tableTypes);
        return tableIds.stream().map(t -> new TableId(databaseCatalog, t.schema(), t.table())).collect(Collectors.toSet());
    }

    protected Set<TableId> getAllTableIds(String catalogName) throws SQLException {
        String query = "select owner, table_name from all_tables where table_name NOT LIKE 'MDRT_%' and table_name NOT LIKE 'MDRS_%' and table_name NOT LIKE 'MDXT_%' and (table_name NOT LIKE 'SYS_IOT_OVER_%' and IOT_NAME IS NULL) ";
        HashSet<TableId> tableIds = new HashSet<TableId>();
        this.query("select owner, table_name from all_tables where table_name NOT LIKE 'MDRT_%' and table_name NOT LIKE 'MDRS_%' and table_name NOT LIKE 'MDXT_%' and (table_name NOT LIKE 'SYS_IOT_OVER_%' and IOT_NAME IS NULL) ", rs -> {
            while (rs.next()) {
                tableIds.add(new TableId(catalogName, rs.getString(1), rs.getString(2)));
            }
            LOGGER.trace("TableIds are: {}", (Object)tableIds);
        });
        return tableIds;
    }

    protected String resolveCatalogName(String catalogName) {
        String pdbName = this.config().getString("pdb.name");
        return (!Strings.isNullOrEmpty((String)pdbName) ? pdbName : this.config().getString("dbname")).toUpperCase();
    }

    public List<String> readTableUniqueIndices(DatabaseMetaData metadata, TableId id) throws SQLException {
        return super.readTableUniqueIndices(metadata, id.toDoubleQuoted());
    }

    protected boolean isTableUniqueIndexIncluded(String indexName, String columnName) {
        if (columnName != null) {
            return !SYS_NC_PATTERN.matcher(columnName).matches() && !ADT_INDEX_NAMES_PATTERN.matcher(columnName).matches() && !MROW_PATTERN.matcher(columnName).matches();
        }
        return false;
    }

    public Scn getCurrentScn() throws SQLException {
        return (Scn)this.queryAndMap("SELECT CURRENT_SCN FROM V$DATABASE", rs -> {
            if (rs.next()) {
                return Scn.valueOf(rs.getString(1));
            }
            throw new IllegalStateException("Could not get SCN");
        });
    }

    public String getTableMetadataDdl(TableId tableId) throws SQLException {
        String string;
        try {
            this.executeWithoutCommitting(new String[]{"begin dbms_metadata.set_transform_param(DBMS_METADATA.SESSION_TRANSFORM, 'STORAGE', false); end;"});
            this.executeWithoutCommitting(new String[]{"begin dbms_metadata.set_transform_param(DBMS_METADATA.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', false); end;"});
            this.executeWithoutCommitting(new String[]{"begin dbms_metadata.set_transform_param(DBMS_METADATA.SESSION_TRANSFORM, 'SQLTERMINATOR', true); end;"});
            string = (String)this.queryAndMap("SELECT dbms_metadata.get_ddl('TABLE','" + tableId.table() + "','" + tableId.schema() + "') FROM DUAL", rs -> {
                if (!rs.next()) {
                    throw new DebeziumException("Could not get DDL metadata for table: " + tableId);
                }
                Object res = rs.getObject(1);
                return ((Clob)res).getSubString(1L, (int)((Clob)res).length());
            });
        }
        catch (Throwable throwable) {
            this.executeWithoutCommitting(new String[]{"begin dbms_metadata.set_transform_param(DBMS_METADATA.SESSION_TRANSFORM, 'DEFAULT'); end;"});
            throw throwable;
        }
        this.executeWithoutCommitting(new String[]{"begin dbms_metadata.set_transform_param(DBMS_METADATA.SESSION_TRANSFORM, 'DEFAULT'); end;"});
        return string;
    }

    public Long getSessionStatisticByName(String name) throws SQLException {
        return (Long)this.queryAndMap("SELECT VALUE FROM v$statname n, v$mystat m WHERE n.name='" + name + "' AND n.statistic#=m.statistic#", rs -> rs.next() ? rs.getLong(1) : 0L);
    }

    public boolean isTableExists(String tableName) throws SQLException {
        return (Boolean)this.queryAndMap("SELECT COUNT(1) FROM USER_TABLES WHERE TABLE_NAME = '" + tableName + "'", rs -> rs.next() && rs.getLong(1) > 0L);
    }

    public boolean isTableExists(TableId tableId) throws SQLException {
        return (Boolean)this.queryAndMap("SELECT COUNT(1) FROM ALL_TABLES WHERE OWNER = '" + tableId.schema() + "' AND TABLE_NAME = '" + tableId.table() + "'", rs -> rs.next() && rs.getLong(1) > 0L);
    }

    public boolean isTableEmpty(String tableName) throws SQLException {
        return this.getRowCount(tableName) == 0L;
    }

    public long getRowCount(String tableName) throws SQLException {
        return (Long)this.queryAndMap("SELECT COUNT(1) FROM " + tableName, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    public <T> T singleOptionalValue(String query, JdbcConnection.ResultSetExtractor<T> extractor) throws SQLException {
        return (T)this.queryAndMap(query, rs -> rs.next() ? extractor.apply(rs) : null);
    }

    public String buildSelectWithRowLimits(TableId tableId, int limit, String projection, Optional<String> condition, String orderBy) {
        TableId table = new TableId(null, tableId.schema(), tableId.table());
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(projection).append(" FROM ");
        sql.append(this.quotedTableIdString(table));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        if (this.getOracleVersion().getMajor() < 12) {
            sql.insert(0, " SELECT * FROM (").append(" ORDER BY ").append(orderBy).append(")").append(" WHERE ROWNUM <=").append(limit);
        } else {
            sql.append(" ORDER BY ").append(orderBy).append(" FETCH NEXT ").append(limit).append(" ROWS ONLY");
        }
        return sql.toString();
    }

    public static String connectionString(JdbcConfiguration config) {
        return config.getString(URL) != null ? config.getString(URL) : OracleConnectorConfig.ConnectorAdapter.parse(config.getString("connection.adapter")).getConnectionUrl();
    }

    private static JdbcConnection.ConnectionFactory resolveConnectionFactory(JdbcConfiguration config) {
        return JdbcConnection.patternBasedFactory((String)OracleConnection.connectionString(config), (Field[])new Field[0]);
    }

    protected boolean isArchiveLogMode() {
        try {
            String mode = (String)this.queryAndMap("SELECT LOG_MODE FROM V$DATABASE", rs -> rs.next() ? rs.getString(1) : "");
            LOGGER.debug("LOG_MODE={}", (Object)mode);
            return "ARCHIVELOG".equalsIgnoreCase(mode);
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to Oracle and looking at LOG_MODE mode: ", (Throwable)e);
        }
    }

    public Optional<OffsetDateTime> getScnToTimestamp(Scn scn) throws SQLException {
        try {
            return (Optional)this.queryAndMap("SELECT scn_to_timestamp('" + scn + "') FROM DUAL", rs -> rs.next() ? Optional.of(rs.getObject(1, OffsetDateTime.class)) : Optional.empty());
        }
        catch (SQLException e) {
            if (e.getMessage().startsWith("ORA-08181")) {
                return Optional.empty();
            }
            throw e;
        }
    }

    protected ColumnEditor overrideColumn(ColumnEditor column) {
        if (93 == column.jdbcType()) {
            column.length(column.scale().orElse(-1).intValue()).scale(null);
        } else if (2 == column.jdbcType()) {
            column.scale().filter(s -> s == -127).ifPresent(s -> column.scale(null));
        }
        return column;
    }

    protected Map<TableId, List<Column>> getColumnsDetails(String databaseCatalog, String schemaNamePattern, String tableName, Tables.TableFilter tableFilter, Tables.ColumnNameFilter columnFilter, DatabaseMetaData metadata, Set<TableId> viewIds) throws SQLException {
        if (tableName != null && tableName.contains("/")) {
            tableName = tableName.replace("/", "//");
        }
        return super.getColumnsDetails(databaseCatalog, schemaNamePattern, tableName, tableFilter, columnFilter, metadata, viewIds);
    }
}

