/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.SourceInfo;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class CommitScn
implements Comparable<Scn> {
    public static final String ROLLBACK_SEGMENT_ID_KEY = "rs_id";
    public static final String SQL_SEQUENCE_NUMBER_KEY = "ssn";
    public static final String REDO_THREAD_KEY = "redo_thread";
    private final Map<Integer, RedoThreadCommitScn> redoThreadCommitScns = new TreeMap<Integer, RedoThreadCommitScn>();

    private CommitScn(Set<RedoThreadCommitScn> commitScns) {
        for (RedoThreadCommitScn commitScn : commitScns) {
            this.redoThreadCommitScns.put(commitScn.getThread(), commitScn);
        }
    }

    public Scn getMaxCommittedScn() {
        return this.redoThreadCommitScns.values().stream().map(RedoThreadCommitScn::getCommitScn).max(Scn::compareTo).orElse(Scn.NULL);
    }

    public Map<Integer, Scn> getCommitScnForAllRedoThreads() {
        HashMap<Integer, Scn> result = new HashMap<Integer, Scn>();
        for (Map.Entry<Integer, RedoThreadCommitScn> entry : this.redoThreadCommitScns.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getCommitScn());
        }
        return Collections.unmodifiableMap(result);
    }

    public Scn getCommitScnForRedoThread(int thread) {
        RedoThreadCommitScn commitScn = this.redoThreadCommitScns.get(thread);
        return commitScn != null ? commitScn.getCommitScn() : Scn.NULL;
    }

    public boolean hasCommitAlreadyBeenHandled(LogMinerEventRow row) {
        RedoThreadCommitScn commitScn = this.redoThreadCommitScns.get(row.getThread());
        if (commitScn != null) {
            return commitScn.getCommitScn().compareTo(row.getScn()) >= 0;
        }
        return false;
    }

    public void recordCommit(LogMinerEventRow row) {
        RedoThreadCommitScn redoCommitScn = this.redoThreadCommitScns.get(row.getThread());
        if (redoCommitScn != null) {
            redoCommitScn.setCommitScn(row.getScn());
            redoCommitScn.setRsId(row.getRsId());
            redoCommitScn.setSsn(row.getSsn());
        } else {
            this.redoThreadCommitScns.put(row.getThread(), new RedoThreadCommitScn(row));
        }
    }

    public void setCommitScnOnAllThreads(Scn commitScn) {
        for (RedoThreadCommitScn redoCommitScn : this.redoThreadCommitScns.values()) {
            redoCommitScn.setCommitScn(commitScn);
        }
    }

    @Override
    public int compareTo(Scn scn) {
        if (this.redoThreadCommitScns.isEmpty()) {
            return Scn.NULL.compareTo(scn);
        }
        int result = 1;
        for (RedoThreadCommitScn commitScn : this.redoThreadCommitScns.values()) {
            int check = commitScn.getCommitScn().compareTo(scn);
            if (check >= result) continue;
            result = check;
        }
        return result;
    }

    public Map<String, Object> store(Map<String, Object> offset) {
        offset.put("commit_scn", this.toCommaSeparatedValue());
        return offset;
    }

    public Struct store(SourceInfo sourceInfo, Struct sourceInfoStruct) {
        RedoThreadCommitScn redoThreadCommitScn;
        if (sourceInfo.getRedoThread() != null && (redoThreadCommitScn = this.redoThreadCommitScns.get(sourceInfo.getRedoThread())) != null) {
            if (redoThreadCommitScn.getCommitScn() != null && !redoThreadCommitScn.getCommitScn().isNull()) {
                sourceInfoStruct.put("commit_scn", (Object)redoThreadCommitScn.getCommitScn().toString());
            }
            if (redoThreadCommitScn.getRsId() != null) {
                sourceInfoStruct.put(ROLLBACK_SEGMENT_ID_KEY, (Object)redoThreadCommitScn.getRsId());
            }
            sourceInfoStruct.put(SQL_SEQUENCE_NUMBER_KEY, (Object)redoThreadCommitScn.getSsn());
            sourceInfoStruct.put(REDO_THREAD_KEY, (Object)redoThreadCommitScn.getThread());
        }
        return sourceInfoStruct;
    }

    public String toLoggableFormat() {
        StringBuilder sb = new StringBuilder("[");
        if (!this.redoThreadCommitScns.isEmpty()) {
            sb.append(this.redoThreadCommitScns.values().stream().map(v -> "\"" + v.getFormattedString() + "\"").collect(Collectors.joining(",")));
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        return "CommitScn [redoThreadCommitScns=" + this.redoThreadCommitScns + "]";
    }

    public static CommitScn valueOf(String value) {
        HashSet<RedoThreadCommitScn> scns = new HashSet<RedoThreadCommitScn>();
        if (value != null) {
            String[] parts = value.split(",");
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                scns.add(RedoThreadCommitScn.valueOf(part));
            }
        }
        return new CommitScn(scns);
    }

    public static CommitScn valueOf(Long value) {
        HashSet<RedoThreadCommitScn> scns = new HashSet<RedoThreadCommitScn>();
        if (value != null) {
            scns.add(new RedoThreadCommitScn(1, Scn.valueOf(value), null, 0));
        }
        return new CommitScn(scns);
    }

    public static CommitScn load(Map<String, ?> offset) {
        Object value = offset.get("commit_scn");
        if (value instanceof String) {
            return CommitScn.valueOf((String)value);
        }
        if (value != null) {
            return CommitScn.valueOf((Long)value);
        }
        return new CommitScn(Collections.emptySet());
    }

    public static SchemaBuilder schemaBuilder(SchemaBuilder schemaBuilder) {
        return schemaBuilder.field(ROLLBACK_SEGMENT_ID_KEY, Schema.OPTIONAL_STRING_SCHEMA).field(SQL_SEQUENCE_NUMBER_KEY, Schema.OPTIONAL_INT32_SCHEMA).field(REDO_THREAD_KEY, Schema.OPTIONAL_INT32_SCHEMA);
    }

    private String toCommaSeparatedValue() {
        if (!this.redoThreadCommitScns.isEmpty()) {
            return this.redoThreadCommitScns.values().stream().map(RedoThreadCommitScn::getFormattedString).collect(Collectors.joining(","));
        }
        return null;
    }

    public static class RedoThreadCommitScn {
        private final int thread;
        private Scn commitScn;
        private String rsId;
        private int ssn;

        public RedoThreadCommitScn(int thread) {
            this(thread, Scn.NULL, null, 0);
        }

        public RedoThreadCommitScn(LogMinerEventRow row) {
            this(row.getThread(), row.getScn(), row.getRsId(), row.getSsn());
        }

        public RedoThreadCommitScn(int thread, Scn commitScn, String rsId, int ssn) {
            this.thread = thread;
            this.commitScn = commitScn;
            this.rsId = rsId;
            this.ssn = ssn;
        }

        public int getThread() {
            return this.thread;
        }

        public Scn getCommitScn() {
            return this.commitScn;
        }

        public void setCommitScn(Scn commitScn) {
            this.commitScn = commitScn;
        }

        public String getRsId() {
            return this.rsId;
        }

        public void setRsId(String rsId) {
            this.rsId = rsId;
        }

        public int getSsn() {
            return this.ssn;
        }

        public void setSsn(int ssn) {
            this.ssn = ssn;
        }

        public String getFormattedString() {
            return this.commitScn.toString() + ":" + (this.rsId != null ? this.rsId : "") + ":" + this.ssn + ":" + this.thread;
        }

        public static RedoThreadCommitScn valueOf(String value) {
            String[] parts = value.split(":");
            if (parts.length == 1) {
                return new RedoThreadCommitScn(1, Scn.valueOf(parts[0]), null, 0);
            }
            if (parts.length == 4) {
                Scn scn = Scn.valueOf(parts[0]);
                String rsId = parts[1];
                int ssn = Integer.parseInt(parts[2]);
                int thread = Integer.parseInt(parts[3]);
                return new RedoThreadCommitScn(thread, scn, rsId, ssn);
            }
            throw new DebeziumException("An unexpected redo thread commit scn entry: '" + value + "'");
        }

        public String toString() {
            return "RedoThreadCommitScn{thread=" + this.thread + ", commitScn=" + this.commitScn + ", rsId='" + this.rsId + "', ssn=" + this.ssn + "}";
        }
    }
}

