/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.processor.AbstractProcessorUnitTest;
import io.debezium.connector.oracle.logminer.processor.infinispan.AbstractInfinispanLogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.infinispan.EmbeddedInfinispanLogMinerEventProcessor;
import io.debezium.connector.oracle.util.TestHelper;
import org.fest.assertions.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER, reason="Only applicable for LogMiner")
public class EmbeddedInfinispanProcessorTest
extends AbstractProcessorUnitTest<AbstractInfinispanLogMinerEventProcessor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedInfinispanProcessorTest.class);

    @Override
    protected Configuration.Builder getConfig() {
        OracleConnectorConfig.LogMiningBufferType bufferType = OracleConnectorConfig.LogMiningBufferType.INFINISPAN_EMBEDDED;
        return TestHelper.withDefaultInfinispanCacheConfigurations(bufferType, (Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.LOG_MINING_BUFFER_TYPE, (EnumeratedValue)bufferType)).with(OracleConnectorConfig.LOG_MINING_BUFFER_DROP_ON_STOP, true));
    }

    @Override
    protected boolean isTransactionAbandonmentSupported() {
        return false;
    }

    @Override
    protected AbstractInfinispanLogMinerEventProcessor getProcessor(OracleConnectorConfig connectorConfig) {
        Assertions.assertThat((boolean)connectorConfig.validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0))).isTrue();
        return new EmbeddedInfinispanLogMinerEventProcessor(this.context, connectorConfig, this.connection, this.dispatcher, this.partition, this.offsetContext, this.schema, this.metrics);
    }
}

