/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.Scn;
import java.math.BigInteger;
import java.util.Objects;

public class LogFile {
    private final String fileName;
    private final Scn firstScn;
    private final Scn nextScn;
    private final BigInteger sequence;
    private final boolean current;
    private final Type type;

    public LogFile(String fileName, Scn firstScn, Scn nextScn, BigInteger sequence, Type type) {
        this(fileName, firstScn, nextScn, sequence, type, false);
    }

    public LogFile(String fileName, Scn firstScn, Scn nextScn, BigInteger sequence, Type type, boolean current) {
        this.fileName = fileName;
        this.firstScn = firstScn;
        this.nextScn = nextScn;
        this.sequence = sequence;
        this.current = current;
        this.type = type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Scn getFirstScn() {
        return this.firstScn;
    }

    public Scn getNextScn() {
        return this.isCurrent() ? Scn.MAX : this.nextScn;
    }

    public BigInteger getSequence() {
        return this.sequence;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.sequence);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LogFile)) {
            return false;
        }
        LogFile other = (LogFile)obj;
        return Objects.equals(this.sequence, other.sequence);
    }

    public static enum Type {
        ARCHIVE,
        REDO;

    }
}

