/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.CommitScn;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.Column;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.AbstractDatabaseHistoryTest;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.TableChanges;
import io.debezium.util.Collect;
import java.util.Collections;

public class OracleDatabaseHistoryTest
extends AbstractDatabaseHistoryTest {
    protected HistoryRecord getRenameCreateHistoryRecord() {
        return new HistoryRecord(Collect.hashMapOf((Object)"server", (Object)"server1"), Collect.hashMapOf((Object)"snapshot_scn", (Object)"1", (Object)"snapshot", (Object)true, (Object)"scn", (Object)"1", (Object)"snapshot_completed", (Object)false), TestHelper.getDatabaseName(), "DEBEZIUM", "CREATE TABLE \"DEBEZIUM\".\"DBZ4451A\" (\"ID\" NUMBER(9,0), PRIMARY KEY(\"ID\");", new TableChanges().create(this.getTableToBeRenamed()));
    }

    protected HistoryRecord getRenameAlterHistoryRecord() {
        Table oldTable = this.getTableToBeRenamed();
        TableId oldTableId = oldTable.id();
        Table table = oldTable.edit().tableId(this.getRenameTableId()).create();
        return new HistoryRecord(Collect.hashMapOf((Object)"server", (Object)"server1"), Collect.hashMapOf((Object)"snapshot_scn", (Object)"2", (Object)"scn", (Object)"2", (Object)"commit_scn", (Object)"2"), TestHelper.getDatabaseName(), "DEBEZIUM", "ALTER TABLE DBZ4451A RENAME TO DBZ4451B;", new TableChanges().rename(table, oldTableId));
    }

    protected TableId getRenameTableId() {
        return TableId.parse((String)"ORCLPDB1.DEBEZIUM.DBZ4451B");
    }

    protected Offsets<Partition, OffsetContext> getOffsets() {
        OraclePartition source = new OraclePartition("server1");
        Configuration config = ((Configuration.Builder)Configuration.empty().edit().with(RelationalDatabaseConnectorConfig.SERVER_NAME, "server1")).build();
        OracleOffsetContext position = new OracleOffsetContext(new OracleConnectorConfig(config), Scn.valueOf((int)999), CommitScn.valueOf((Long)999L), null, Scn.valueOf((int)999), Collections.emptyMap(), false, true, new TransactionContext(), (IncrementalSnapshotContext)new SignalBasedIncrementalSnapshotContext());
        return Offsets.of((Partition)source, (OffsetContext)position);
    }

    protected DdlParser getDdlParser() {
        return new OracleDdlParser();
    }

    private Table getTableToBeRenamed() {
        TableId tableId = TableId.parse((String)"ORCLPDB1.DEBEZIUM.DBZ4451A");
        return Table.editor().tableId(tableId).addColumn(Column.editor().name("ID").type("NUMBER").length(9).scale(Integer.valueOf(0)).jdbcType(2).optional(false).create()).setPrimaryKeyNames(new String[]{"ID"}).create();
    }
}

