/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleTableIdParser;
import io.debezium.doc.FixFor;
import io.debezium.relational.TableId;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class OracleTableIdParserTest {
    @Test
    @FixFor(value={"DBZ-4744"})
    public void shouldParseFullyQualifiedTableNameWithDomainNameAsCatalog() throws Exception {
        TableId tableId = OracleTableIdParser.parse((String)"RB02.DOMAIN.COM.TBSLV.DEBEZIUM_SIGNAL");
        Assertions.assertThat((String)tableId.table()).isEqualTo((Object)"DEBEZIUM_SIGNAL");
        Assertions.assertThat((String)tableId.schema()).isEqualTo((Object)"TBSLV");
        Assertions.assertThat((String)tableId.catalog()).isEqualTo((Object)"RB02.DOMAIN.COM");
    }

    @Test
    @FixFor(value={"DBZ-4744"})
    public void shouldParseFullyQualifiedTableWithoutDomainNameAsCatalogName() throws Exception {
        TableId tableId = OracleTableIdParser.parse((String)"SERVER1.TBSLV.DEBEZIUM_SIGNAL");
        Assertions.assertThat((String)tableId.table()).isEqualTo((Object)"DEBEZIUM_SIGNAL");
        Assertions.assertThat((String)tableId.schema()).isEqualTo((Object)"TBSLV");
        Assertions.assertThat((String)tableId.catalog()).isEqualTo((Object)"SERVER1");
    }
}

