/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.AbstractStreamingAdapter;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.LogMinerOracleOffsetContextLoader;
import io.debezium.connector.oracle.logminer.LogMinerStreamingChangeEventSource;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.document.Document;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.util.Clock;
import io.debezium.util.HexConverter;
import io.debezium.util.Strings;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerAdapter
extends AbstractStreamingAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerAdapter.class);
    public static final String TYPE = "logminer";

    public LogMinerAdapter(OracleConnectorConfig connectorConfig) {
        super(connectorConfig);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return LogMinerAdapter.this.resolveScn(recorded).compareTo(LogMinerAdapter.this.resolveScn(desired)) < 1;
            }
        };
    }

    @Override
    public OffsetContext.Loader<OracleOffsetContext> getOffsetContextLoader() {
        return new LogMinerOracleOffsetContextLoader(this.connectorConfig);
    }

    @Override
    public StreamingChangeEventSource<OraclePartition, OracleOffsetContext> getSource(OracleConnection connection, EventDispatcher<OraclePartition, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, OracleTaskContext taskContext, Configuration jdbcConfig, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        return new LogMinerStreamingChangeEventSource(this.connectorConfig, connection, dispatcher, errorHandler, clock, schema, jdbcConfig, streamingMetrics);
    }

    @Override
    public OracleOffsetContext determineSnapshotOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> ctx, OracleConnectorConfig connectorConfig, OracleConnection connection) throws SQLException {
        LinkedHashMap<String, Scn> pendingTransactions;
        Scn latestTableDdlScn = this.getLatestTableDdlScn(ctx, connection).orElse(null);
        Optional<Scn> currentScn = this.getPendingTransactions(latestTableDdlScn, connection, pendingTransactions = new LinkedHashMap<String, Scn>());
        if (!currentScn.isPresent()) {
            throw new DebeziumException("Failed to resolve current SCN");
        }
        if (!Strings.isNullOrBlank((String)connectorConfig.getPdbName())) {
            try (OracleConnection conn = new OracleConnection(connection.config(), () -> this.getClass().getClassLoader(), false);){
                conn.setAutoCommit(false);
                conn.resetSessionToCdb();
                OracleOffsetContext oracleOffsetContext = this.determineSnapshotOffset(connectorConfig, conn, currentScn.get(), pendingTransactions);
                return oracleOffsetContext;
            }
        }
        return this.determineSnapshotOffset(connectorConfig, connection, currentScn.get(), pendingTransactions);
    }

    private Optional<Scn> getPendingTransactions(Scn latestTableDdlScn, OracleConnection connection, Map<String, Scn> transactions) throws SQLException {
        String query = "SELECT d.CURRENT_SCN, t.XID, t.START_SCN FROM V$DATABASE d LEFT OUTER JOIN V$TRANSACTION t ON t.START_SCN < d.CURRENT_SCN ";
        Scn currentScn = null;
        do {
            currentScn = null;
            transactions.clear();
            try (Statement s = connection.connection().createStatement();
                 ResultSet rs = s.executeQuery("SELECT d.CURRENT_SCN, t.XID, t.START_SCN FROM V$DATABASE d LEFT OUTER JOIN V$TRANSACTION t ON t.START_SCN < d.CURRENT_SCN ");){
                while (rs.next()) {
                    String pendingTxStartScn;
                    if (currentScn == null) {
                        currentScn = Scn.valueOf(rs.getString(1));
                    }
                    if (Strings.isNullOrEmpty((String)(pendingTxStartScn = rs.getString(3)))) continue;
                    transactions.put(HexConverter.convertToHexString((byte[])rs.getBytes(2)), Scn.valueOf(pendingTxStartScn));
                }
            }
            catch (SQLException e) {
                LOGGER.warn("Could not query the V$TRANSACTION view: {}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
        } while (this.areSameTimestamp(latestTableDdlScn, currentScn, connection));
        return Optional.ofNullable(currentScn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OracleOffsetContext determineSnapshotOffset(OracleConnectorConfig connectorConfig, OracleConnection connection, Scn currentScn, Map<String, Scn> pendingTransactions) throws SQLException {
        if (!connectorConfig.isLogMiningQueryLogsForSnapshotOffset()) {
            LOGGER.info("\tSkipping transaction logs for resolving snapshot offset, only using V$TRANSACTION.");
        } else {
            LOGGER.info("\tConsulting V$TRANSACTION and transaction logs for resolving snapshot offset.");
            Scn oldestScn = this.getOldestScnAvailableInLogs(connectorConfig, connection);
            List<LogFile> logFiles = this.getOrderedLogsFromScn(connectorConfig, oldestScn, connection);
            if (logFiles.isEmpty()) {
                throw new DebeziumException("Failed to get log files from Oracle");
            }
            int logIndex = 0;
            for (int i = 0; i < logFiles.size(); ++i) {
                if (!logFiles.get(i).isScnInLogFileRange(currentScn)) continue;
                logIndex = i;
                break;
            }
            for (int pos = logIndex; pos >= 0; --pos) {
                try {
                    this.addLogsToSession(logFiles, pos, logIndex, connection);
                    this.startSession(connection);
                    Optional<String> transactionId = this.getTransactionIdForScn(currentScn, connection);
                    if (!transactionId.isPresent()) {
                        throw new DebeziumException("Failed to get transaction id for current SCN " + currentScn);
                    }
                    if (pendingTransactions.containsKey(transactionId.get())) {
                        LOGGER.info("\tCurrent SCN transaction '{}' was found in V$TRANSACTION", (Object)transactionId.get());
                        break;
                    }
                    Scn startScn = this.getTransactionStartScn(transactionId.get(), currentScn, connection);
                    if (startScn.isNull() && pos == 0) {
                        LOGGER.warn("Failed to find start SCN for transaction '{}', transaction will not be included.", (Object)transactionId.get());
                        continue;
                    }
                    pendingTransactions.put(transactionId.get(), startScn);
                    break;
                }
                finally {
                    this.stopSession(connection);
                }
            }
        }
        if (!pendingTransactions.isEmpty()) {
            for (Map.Entry<String, Scn> entry : pendingTransactions.entrySet()) {
                LOGGER.info("\tFound in-progress transaction {}, starting at SCN {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        } else {
            LOGGER.info("\tFound no in-progress transactions.");
        }
        return OracleOffsetContext.create().logicalName(connectorConfig).scn(currentScn).snapshotScn(currentScn).snapshotPendingTransactions(pendingTransactions).transactionContext(new TransactionContext()).incrementalSnapshotContext((IncrementalSnapshotContext<TableId>)new SignalBasedIncrementalSnapshotContext()).build();
    }

    private void addLogsToSession(List<LogFile> logs, int from, int to, OracleConnection connection) throws SQLException {
        for (int i = from; i <= to; ++i) {
            LogFile logFile = logs.get(i);
            LOGGER.debug("\tAdding log: {}", (Object)logFile.getFileName());
            connection.executeWithoutCommitting(new String[]{SqlUtils.addLogFileStatement("DBMS_LOGMNR.ADDFILE", logFile.getFileName())});
        }
    }

    private void startSession(OracleConnection connection) throws SQLException {
        String query = "BEGIN sys.dbms_logmnr.start_logmnr(OPTIONS => DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG + DBMS_LOGMNR.NO_ROWID_IN_STMT);END;";
        LOGGER.debug("\tStarting mining session");
        connection.executeWithoutCommitting(new String[]{"BEGIN sys.dbms_logmnr.start_logmnr(OPTIONS => DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG + DBMS_LOGMNR.NO_ROWID_IN_STMT);END;"});
    }

    private void stopSession(OracleConnection connection) throws SQLException {
        try {
            LOGGER.debug("\tStopping mining session");
            connection.executeWithoutCommitting(new String[]{"BEGIN SYS.DBMS_LOGMNR.END_LOGMNR(); END;"});
        }
        catch (SQLException e) {
            if (e.getMessage().toUpperCase().contains("ORA-01307")) {
                LOGGER.debug("LogMiner mining session is already closed.");
            }
            throw e;
        }
    }

    private Scn getOldestScnAvailableInLogs(OracleConnectorConfig config, OracleConnection connection) throws SQLException {
        Duration archiveLogRetention = config.getLogMiningArchiveLogRetention();
        String archiveLogDestinationName = config.getLogMiningArchiveDestinationName();
        return (Scn)connection.queryAndMap(SqlUtils.oldestFirstChangeQuery(archiveLogRetention, archiveLogDestinationName), rs -> {
            String value;
            if (rs.next() && !Strings.isNullOrEmpty((String)(value = rs.getString(1)))) {
                return Scn.valueOf(value);
            }
            return Scn.NULL;
        });
    }

    private List<LogFile> getOrderedLogsFromScn(OracleConnectorConfig config, Scn sinceScn, OracleConnection connection) throws SQLException {
        return LogMinerHelper.getLogFilesForOffsetScn(connection, sinceScn, config.getLogMiningArchiveLogRetention(), config.isArchiveLogOnlyMode(), config.getLogMiningArchiveDestinationName()).stream().sorted(Comparator.comparing(LogFile::getSequence)).collect(Collectors.toList());
    }

    private Optional<String> getTransactionIdForScn(Scn scn, OracleConnection connection) throws SQLException {
        LOGGER.debug("\tGet transaction id for SCN {}", (Object)scn);
        AtomicReference transactionId = new AtomicReference();
        connection.call("SELECT XID FROM V$LOGMNR_CONTENTS WHERE SCN = ?", s -> s.setLong(1, scn.longValue()), rs -> {
            if (rs.next()) {
                transactionId.set(HexConverter.convertToHexString((byte[])rs.getBytes("XID")));
            }
        });
        return Optional.ofNullable((String)transactionId.get());
    }

    private Scn getTransactionStartScn(String transactionId, Scn currentScn, OracleConnection connection) throws SQLException {
        LOGGER.debug("\tGet start SCN for transaction '{}'", (Object)transactionId);
        AtomicReference<Scn> startScn = new AtomicReference<Scn>(Scn.NULL);
        for (int attempt = 1; attempt <= 5; ++attempt) {
            connection.call("SELECT SCN, START_SCN, OPERATION FROM V$LOGMNR_CONTENTS WHERE XID=HEXTORAW(UPPER(?))", s -> s.setString(1, transactionId), rs -> {
                while (rs.next()) {
                    if (Strings.isNullOrEmpty((String)rs.getString("START_SCN"))) continue;
                    Scn value = Scn.valueOf(rs.getString("START_SCN"));
                    if (currentScn.compareTo(value) == 0) {
                        startScn.set(value.subtract(Scn.ONE));
                        LOGGER.debug("\tCurrent SCN {} starts a transaction, using value-1.", (Object)value);
                        break;
                    }
                    startScn.set(Scn.valueOf(rs.getString("START_SCN")));
                    LOGGER.debug("\tCurrent SCN transaction starts at SCN {}", (Object)value);
                    break;
                }
            });
            if (!startScn.get().isNull()) break;
        }
        return startScn.get();
    }
}

