/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.pipeline.spi.OffsetContext;
import java.util.HashMap;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OracleOffsetContextTest {
    private OracleConnectorConfig connectorConfig;
    private OffsetContext.Loader offsetLoader;

    @Before
    public void beforeEach() throws Exception {
        this.connectorConfig = new OracleConnectorConfig(TestHelper.defaultConfig().build());
        this.offsetLoader = this.connectorConfig.getAdapter().getOffsetContextLoader();
    }

    @Test
    @FixFor(value={"DBZ-2994"})
    public void shouldreadScnAndCommitScnAsLongValues() throws Exception {
        HashMap<String, Long> offsetValues = new HashMap<String, Long>();
        offsetValues.put("scn", 12345L);
        offsetValues.put("commit_scn", 23456L);
        OracleOffsetContext offsetContext = (OracleOffsetContext)this.offsetLoader.load(offsetValues);
        Assertions.assertThat((Object)offsetContext.getScn()).isEqualTo((Object)Scn.valueOf((String)"12345"));
        if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.LOG_MINER)) {
            Assertions.assertThat((Object)offsetContext.getCommitScn()).isEqualTo((Object)Scn.valueOf((String)"23456"));
        }
    }

    @Test
    @FixFor(value={"DBZ-2994"})
    public void shouldReadScnAndCommitScnAsStringValues() throws Exception {
        HashMap<String, String> offsetValues = new HashMap<String, String>();
        offsetValues.put("scn", "12345");
        offsetValues.put("commit_scn", "23456");
        OracleOffsetContext offsetContext = (OracleOffsetContext)this.offsetLoader.load(offsetValues);
        Assertions.assertThat((Object)offsetContext.getScn()).isEqualTo((Object)Scn.valueOf((String)"12345"));
        if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.LOG_MINER)) {
            Assertions.assertThat((Object)offsetContext.getCommitScn()).isEqualTo((Object)Scn.valueOf((String)"23456"));
        }
    }

    @Test
    @FixFor(value={"DBZ-2994"})
    public void shouldHandleNullScnAndCommitScnValues() throws Exception {
        HashMap<String, Object> offsetValues = new HashMap<String, Object>();
        offsetValues.put("scn", null);
        offsetValues.put("commit_scn", null);
        OracleOffsetContext offsetContext = (OracleOffsetContext)this.offsetLoader.load(offsetValues);
        Assertions.assertThat((Object)offsetContext.getScn()).isNull();
        Assertions.assertThat((Object)offsetContext.getCommitScn()).isNull();
    }

    @Test
    @FixFor(value={"DBZ-4937"})
    public void shouldCorrectlySerializeOffsetsWithSnapshotBasedKeysFromOlderOffsets() throws Exception {
        HashMap<String, String> offsetValues = new HashMap<String, String>();
        offsetValues.put("scn", "745688898023");
        offsetValues.put("commit_scn", "745688898024");
        offsetValues.put("transaction_id", null);
        OracleOffsetContext offsetContext = (OracleOffsetContext)this.offsetLoader.load(offsetValues);
        Map writeValues = offsetContext.getOffset();
        Assertions.assertThat(writeValues.get("scn")).isEqualTo((Object)"745688898023");
        Assertions.assertThat(writeValues.get("commit_scn")).isEqualTo((Object)"745688898024");
        Assertions.assertThat(writeValues.get("snapshot_pending_tx")).isNull();
        Assertions.assertThat(writeValues.get("snapshot_scn")).isNull();
        offsetContext = (OracleOffsetContext)this.offsetLoader.load(writeValues);
        writeValues = offsetContext.getOffset();
        Assertions.assertThat(writeValues.get("scn")).isEqualTo((Object)"745688898023");
        Assertions.assertThat(writeValues.get("commit_scn")).isEqualTo((Object)"745688898024");
        Assertions.assertThat(writeValues.get("snapshot_pending_tx")).isNull();
        Assertions.assertThat(writeValues.get("snapshot_scn")).isNull();
    }
}

