/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.SourceInfo;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class OracleOffsetContext
implements OffsetContext {
    public static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    public static final String SNAPSHOT_PENDING_TRANSACTIONS_KEY = "snapshot_pending_tx";
    public static final String SNAPSHOT_SCN_KEY = "snapshot_scn";
    private final Schema sourceInfoSchema;
    private final SourceInfo sourceInfo;
    private final TransactionContext transactionContext;
    private final IncrementalSnapshotContext<TableId> incrementalSnapshotContext;
    private final Scn snapshotScn;
    private Map<String, Scn> snapshotPendingTransactions;
    private boolean snapshotCompleted;

    public OracleOffsetContext(OracleConnectorConfig connectorConfig, Scn scn, Scn commitScn, String lcrPosition, Scn snapshotScn, Map<String, Scn> snapshotPendingTransactions, boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext) {
        this(connectorConfig, scn, lcrPosition, snapshotScn, snapshotPendingTransactions, snapshot, snapshotCompleted, transactionContext, incrementalSnapshotContext);
        this.sourceInfo.setCommitScn(commitScn);
    }

    public OracleOffsetContext(OracleConnectorConfig connectorConfig, Scn scn, String lcrPosition, Scn snapshotScn, Map<String, Scn> snapshotPendingTransactions, boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext) {
        this.sourceInfo = new SourceInfo(connectorConfig);
        this.sourceInfo.setScn(scn);
        this.sourceInfo.setLcrPosition(lcrPosition);
        this.sourceInfoSchema = this.sourceInfo.schema();
        this.snapshotScn = snapshotScn == null ? Scn.NULL : snapshotScn;
        this.snapshotPendingTransactions = snapshotPendingTransactions;
        this.transactionContext = transactionContext;
        this.incrementalSnapshotContext = incrementalSnapshotContext;
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            this.sourceInfo.setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
    }

    public static Builder create() {
        return new Builder();
    }

    public Map<String, ?> getOffset() {
        if (this.sourceInfo.isSnapshot()) {
            HashMap<String, Object> offset = new HashMap<String, Object>();
            Scn scn = this.sourceInfo.getScn();
            offset.put("scn", scn != null ? scn.toString() : scn);
            offset.put("snapshot", true);
            offset.put(SNAPSHOT_COMPLETED_KEY, this.snapshotCompleted);
            if (this.snapshotPendingTransactions != null) {
                String encoded = this.snapshotPendingTransactions.entrySet().stream().map(e -> (String)e.getKey() + ":" + ((Scn)e.getValue()).toString()).collect(Collectors.joining(","));
                offset.put(SNAPSHOT_PENDING_TRANSACTIONS_KEY, encoded);
            }
            offset.put(SNAPSHOT_SCN_KEY, this.snapshotScn != null ? this.snapshotScn.toString() : null);
            return offset;
        }
        HashMap<String, String> offset = new HashMap<String, String>();
        if (this.sourceInfo.getLcrPosition() != null) {
            offset.put("lcr_position", this.sourceInfo.getLcrPosition());
        } else {
            Scn scn = this.sourceInfo.getScn();
            Scn commitScn = this.sourceInfo.getCommitScn();
            offset.put("scn", scn != null ? scn.toString() : null);
            offset.put("commit_scn", commitScn != null ? commitScn.toString() : null);
        }
        if (this.snapshotPendingTransactions != null) {
            String encoded = this.snapshotPendingTransactions.entrySet().stream().map(e -> (String)e.getKey() + ":" + ((Scn)e.getValue()).toString()).collect(Collectors.joining(","));
            offset.put(SNAPSHOT_PENDING_TRANSACTIONS_KEY, encoded);
        }
        offset.put(SNAPSHOT_SCN_KEY, this.snapshotScn != null ? this.snapshotScn.toString() : null);
        return this.incrementalSnapshotContext.store(this.transactionContext.store(offset));
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    public void setScn(Scn scn) {
        this.sourceInfo.setScn(scn);
    }

    public void setCommitScn(Scn commitScn) {
        this.sourceInfo.setCommitScn(commitScn);
    }

    public Scn getScn() {
        return this.sourceInfo.getScn();
    }

    public Scn getCommitScn() {
        return this.sourceInfo.getCommitScn();
    }

    public void setLcrPosition(String lcrPosition) {
        this.sourceInfo.setLcrPosition(lcrPosition);
    }

    public String getLcrPosition() {
        return this.sourceInfo.getLcrPosition();
    }

    public Scn getSnapshotScn() {
        return this.snapshotScn;
    }

    public Map<String, Scn> getSnapshotPendingTransactions() {
        return this.snapshotPendingTransactions;
    }

    public void setSnapshotPendingTransactions(Map<String, Scn> snapshotPendingTransactions) {
        this.snapshotPendingTransactions = snapshotPendingTransactions;
    }

    public void setTransactionId(String transactionId) {
        this.sourceInfo.setTransactionId(transactionId);
    }

    public void setSourceTime(Instant instant) {
        this.sourceInfo.setSourceTime(instant);
    }

    public void setTableId(TableId tableId) {
        this.sourceInfo.tableEvent(tableId);
    }

    public boolean isSnapshotRunning() {
        return this.sourceInfo.isSnapshot() && !this.snapshotCompleted;
    }

    public void preSnapshotStart() {
        this.sourceInfo.setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
    }

    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    public void postSnapshotCompletion() {
        this.sourceInfo.setSnapshot(SnapshotRecord.FALSE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OracleOffsetContext [scn=").append(this.getScn());
        if (this.sourceInfo.isSnapshot()) {
            sb.append(", snapshot=").append(this.sourceInfo.isSnapshot());
            sb.append(", snapshot_completed=").append(this.snapshotCompleted);
        }
        sb.append("]");
        return sb.toString();
    }

    public void markLastSnapshotRecord() {
        this.sourceInfo.setSnapshot(SnapshotRecord.LAST);
    }

    public void event(DataCollectionId tableId, Instant timestamp) {
        this.sourceInfo.tableEvent((TableId)tableId);
        this.sourceInfo.setSourceTime(timestamp);
    }

    public void tableEvent(TableId tableId, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.tableEvent(tableId);
    }

    public void tableEvent(Set<TableId> tableIds, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.tableEvent(tableIds);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public void incrementalSnapshotEvents() {
        this.sourceInfo.setSnapshot(SnapshotRecord.INCREMENTAL);
    }

    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.incrementalSnapshotContext;
    }

    public static Scn getScnFromOffsetMapByKey(Map<String, ?> offset, String key) {
        Object scn = offset.get(key);
        if (scn instanceof String) {
            return Scn.valueOf((String)scn);
        }
        if (scn != null) {
            return Scn.valueOf((Long)scn);
        }
        return null;
    }

    public static Map<String, Scn> loadSnapshotPendingTransactions(Map<String, ?> offset) {
        HashMap<String, Scn> snapshotPendingTransactions = new HashMap<String, Scn>();
        String encoded = (String)offset.get(SNAPSHOT_PENDING_TRANSACTIONS_KEY);
        if (encoded != null) {
            Arrays.stream(encoded.split(",")).map(String::trim).filter(s -> !s.isEmpty()).forEach(e -> {
                String[] parts = e.split(":", 2);
                String txid = parts[0];
                Scn startScn = Scn.valueOf(parts[1]);
                snapshotPendingTransactions.put(txid, startScn);
            });
        }
        return snapshotPendingTransactions;
    }

    public static Scn loadSnapshotScn(Map<String, ?> offset) {
        return OracleOffsetContext.getScnFromOffsetMapByKey(offset, SNAPSHOT_SCN_KEY);
    }

    public static class Builder {
        private OracleConnectorConfig connectorConfig;
        private Scn scn;
        private String lcrPosition;
        private boolean snapshot;
        private boolean snapshotCompleted;
        private TransactionContext transactionContext;
        private IncrementalSnapshotContext<TableId> incrementalSnapshotContext;
        private Map<String, Scn> snapshotPendingTransactions;
        private Scn snapshotScn;

        public Builder logicalName(OracleConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
            return this;
        }

        public Builder scn(Scn scn) {
            this.scn = scn;
            return this;
        }

        public Builder lcrPosition(String lcrPosition) {
            this.lcrPosition = lcrPosition;
            return this;
        }

        public Builder snapshot(boolean snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder snapshotCompleted(boolean snapshotCompleted) {
            this.snapshotCompleted = snapshotCompleted;
            return this;
        }

        public Builder transactionContext(TransactionContext transactionContext) {
            this.transactionContext = transactionContext;
            return this;
        }

        public Builder incrementalSnapshotContext(IncrementalSnapshotContext<TableId> incrementalSnapshotContext) {
            this.incrementalSnapshotContext = incrementalSnapshotContext;
            return this;
        }

        public Builder snapshotPendingTransactions(Map<String, Scn> snapshotPendingTransactions) {
            this.snapshotPendingTransactions = snapshotPendingTransactions;
            return this;
        }

        public Builder snapshotScn(Scn scn) {
            this.snapshotScn = scn;
            return this;
        }

        OracleOffsetContext build() {
            return new OracleOffsetContext(this.connectorConfig, this.scn, this.lcrPosition, this.snapshotScn, this.snapshotPendingTransactions, this.snapshot, this.snapshotCompleted, this.transactionContext, this.incrementalSnapshotContext);
        }
    }
}

