/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.NAMED_CACHE)
public class BiFunctionMapper
implements BiFunction {
    private final DataConversion keyDataConversion;
    private final DataConversion valueDataConversion;
    private final BiFunction biFunction;

    @Inject
    public void injectDependencies(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
    }

    public BiFunctionMapper(BiFunction remappingFunction, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        this.biFunction = remappingFunction;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    public DataConversion getKeyDataConversion() {
        return this.keyDataConversion;
    }

    public DataConversion getValueDataConversion() {
        return this.valueDataConversion;
    }

    public Object apply(Object k, Object v) {
        Object value;
        Object key = this.keyDataConversion.fromStorage(k);
        Object result = this.biFunction.apply(key, value = this.valueDataConversion.fromStorage(v));
        return result != null ? this.valueDataConversion.toStorage(result) : null;
    }

    public static class Externalizer
    implements AdvancedExternalizer<BiFunctionMapper> {
        public Set<Class<? extends BiFunctionMapper>> getTypeClasses() {
            return Collections.singleton(BiFunctionMapper.class);
        }

        public Integer getId() {
            return 126;
        }

        public void writeObject(ObjectOutput output, BiFunctionMapper object) throws IOException {
            output.writeObject(object.biFunction);
            DataConversion.writeTo(output, object.keyDataConversion);
            DataConversion.writeTo(output, object.valueDataConversion);
        }

        public BiFunctionMapper readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new BiFunctionMapper((BiFunction)input.readObject(), DataConversion.readFrom(input), DataConversion.readFrom(input));
        }
    }
}

