/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.connector.oracle.antlr.listener.BaseParserListener;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.TableEditor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public class ColumnDefinitionParserListener
extends BaseParserListener {
    private final OracleDdlParser parser;
    private final DataTypeResolver dataTypeResolver;
    private final TableEditor tableEditor;
    private final List<ParseTreeListener> listeners;
    private ColumnEditor columnEditor;

    ColumnDefinitionParserListener(TableEditor tableEditor, ColumnEditor columnEditor, OracleDdlParser parser, List<ParseTreeListener> listeners) {
        this.tableEditor = tableEditor;
        this.columnEditor = columnEditor;
        this.parser = parser;
        this.dataTypeResolver = parser.dataTypeResolver();
        this.listeners = listeners;
    }

    void setColumnEditor(ColumnEditor columnEditor) {
        this.columnEditor = columnEditor;
    }

    Column getColumn() {
        return this.columnEditor.create();
    }

    public void enterColumn_definition(PlSqlParser.Column_definitionContext ctx) {
        this.resolveColumnDataType(ctx);
        if (ctx.DEFAULT() != null) {
            this.columnEditor.defaultValueExpression(ctx.column_default_value().getText());
        }
        super.enterColumn_definition(ctx);
    }

    public void enterPrimary_key_clause(PlSqlParser.Primary_key_clauseContext ctx) {
        this.columnEditor.optional(false);
        this.tableEditor.addColumn(this.columnEditor.create());
        this.tableEditor.setPrimaryKeyNames(new String[]{this.columnEditor.name()});
        super.enterPrimary_key_clause(ctx);
    }

    public void enterModify_col_properties(PlSqlParser.Modify_col_propertiesContext ctx) {
        this.resolveColumnDataType(ctx);
        if (ctx.DEFAULT() != null) {
            this.columnEditor.defaultValueExpression(ctx.column_default_value().getText());
        }
        super.enterModify_col_properties(ctx);
    }

    private void resolveColumnDataType(PlSqlParser.Column_definitionContext ctx) {
        this.columnEditor.name(this.getColumnName(ctx.column_name()));
        boolean hasNotNullConstraint = ctx.inline_constraint().stream().anyMatch(c -> c.NOT() != null);
        this.columnEditor.optional(!hasNotNullConstraint);
        if (ctx.datatype() == null) {
            if (ctx.type_name() != null && "\"MDSYS\".\"SDO_GEOMETRY\"".equalsIgnoreCase(ctx.type_name().getText())) {
                this.columnEditor.jdbcType(2002).type("MDSYS.SDO_GEOMETRY");
            }
        } else {
            this.resolveColumnDataType(ctx.datatype());
        }
    }

    private void resolveColumnDataType(PlSqlParser.Modify_col_propertiesContext ctx) {
        this.columnEditor.name(this.getColumnName(ctx.column_name()));
        this.resolveColumnDataType(ctx.datatype());
        boolean hasNullConstraint = ctx.inline_constraint().stream().anyMatch(c -> c.NULL_() != null);
        boolean hasNotNullConstraint = ctx.inline_constraint().stream().anyMatch(c -> c.NOT() != null);
        if (hasNotNullConstraint && this.columnEditor.isOptional()) {
            this.columnEditor.optional(false);
        } else if (hasNullConstraint && !this.columnEditor.isOptional()) {
            this.columnEditor.optional(true);
        }
    }

    private void resolveColumnDataType(PlSqlParser.DatatypeContext ctx) {
        PlSqlParser.Precision_partContext precisionPart = null;
        if (ctx != null) {
            precisionPart = ctx.precision_part();
        }
        if (ctx != null && ctx.native_datatype_element() != null) {
            if (ctx.native_datatype_element().INT() != null || ctx.native_datatype_element().INTEGER() != null || ctx.native_datatype_element().SMALLINT() != null || ctx.native_datatype_element().NUMERIC() != null || ctx.native_datatype_element().DECIMAL() != null) {
                this.columnEditor.jdbcType(2).type("NUMBER");
                if (precisionPart == null) {
                    this.columnEditor.length(38).scale(Integer.valueOf(0));
                } else {
                    this.setPrecision(precisionPart, this.columnEditor);
                    this.setScale(precisionPart, this.columnEditor);
                }
            } else if (ctx.native_datatype_element().DATE() != null) {
                this.columnEditor.jdbcType(93).type("DATE");
            } else if (ctx.native_datatype_element().TIMESTAMP() != null) {
                if (ctx.WITH() != null && ctx.TIME() != null && ctx.ZONE() != null) {
                    if (ctx.LOCAL() != null) {
                        this.columnEditor.jdbcType(-102).type("TIMESTAMP WITH LOCAL TIME ZONE");
                    } else {
                        this.columnEditor.jdbcType(-101).type("TIMESTAMP WITH TIME ZONE");
                    }
                } else {
                    this.columnEditor.jdbcType(93).type("TIMESTAMP");
                }
                if (precisionPart == null) {
                    this.columnEditor.length(6);
                } else {
                    this.setPrecision(precisionPart, this.columnEditor);
                }
            } else if (ctx.native_datatype_element().VARCHAR2() != null || ctx.native_datatype_element().VARCHAR() != null) {
                this.columnEditor.jdbcType(12).type("VARCHAR2");
                if (precisionPart == null) {
                    this.columnEditor.length(this.getVarCharDefaultLength());
                } else {
                    this.setPrecision(precisionPart, this.columnEditor);
                }
            } else if (ctx.native_datatype_element().NVARCHAR2() != null) {
                this.columnEditor.jdbcType(-9).type("NVARCHAR2");
                if (precisionPart == null) {
                    this.columnEditor.length(this.getVarCharDefaultLength());
                } else {
                    this.setPrecision(precisionPart, this.columnEditor);
                }
            } else if (ctx.native_datatype_element().CHAR() != null) {
                this.columnEditor.jdbcType(1).type("CHAR").length(1);
                if (precisionPart != null) {
                    this.setPrecision(precisionPart, this.columnEditor);
                }
            } else if (ctx.native_datatype_element().NCHAR() != null) {
                this.columnEditor.jdbcType(-15).type("NCHAR").length(1);
                if (precisionPart != null) {
                    this.setPrecision(precisionPart, this.columnEditor);
                }
            } else if (ctx.native_datatype_element().BINARY_FLOAT() != null) {
                this.columnEditor.jdbcType(100).type("BINARY_FLOAT");
            } else if (ctx.native_datatype_element().BINARY_DOUBLE() != null) {
                this.columnEditor.jdbcType(101).type("BINARY_DOUBLE");
            } else if (ctx.native_datatype_element().FLOAT() != null || ctx.native_datatype_element().DOUBLE() != null && ctx.native_datatype_element().PRECISION() != null) {
                this.columnEditor.jdbcType(6).type("FLOAT").length(126);
                if (precisionPart != null) {
                    this.setPrecision(precisionPart, this.columnEditor);
                }
            } else if (ctx.native_datatype_element().REAL() != null) {
                this.columnEditor.jdbcType(6).type("FLOAT").length(63);
            } else if (ctx.native_datatype_element().NUMBER() != null) {
                this.columnEditor.jdbcType(2).type("NUMBER");
                if (precisionPart == null) {
                    this.columnEditor.length(38);
                } else {
                    if (precisionPart.ASTERISK() != null) {
                        this.columnEditor.length(38);
                    } else {
                        this.setPrecision(precisionPart, this.columnEditor);
                    }
                    this.setScale(precisionPart, this.columnEditor);
                }
            } else if (ctx.native_datatype_element().BLOB() != null) {
                this.columnEditor.jdbcType(2004).type("BLOB");
            } else if (ctx.native_datatype_element().CLOB() != null) {
                this.columnEditor.jdbcType(2005).type("CLOB");
            } else if (ctx.native_datatype_element().NCLOB() != null) {
                this.columnEditor.jdbcType(2011).type("NCLOB");
            } else if (ctx.native_datatype_element().RAW() != null) {
                this.columnEditor.jdbcType(-2).type("RAW");
                this.setPrecision(precisionPart, this.columnEditor);
            } else if (ctx.native_datatype_element().SDO_GEOMETRY() != null) {
                this.columnEditor.jdbcType(1111).type("SDO_GEOMETRY").length(1);
            } else if (ctx.native_datatype_element().ROWID() != null) {
                this.columnEditor.jdbcType(12).type("ROWID");
            } else {
                this.columnEditor.jdbcType(1111).type(ctx.native_datatype_element().getText());
            }
        } else if (ctx.INTERVAL() != null && ctx.YEAR() != null && ctx.TO() != null && ctx.MONTH() != null) {
            this.columnEditor.jdbcType(-103).type("INTERVAL YEAR TO MONTH").length(2);
            if (!ctx.expression().isEmpty()) {
                this.columnEditor.length(Integer.valueOf(ctx.expression(0).getText()).intValue());
            }
        } else if (ctx.INTERVAL() != null && ctx.DAY() != null && ctx.TO() != null && ctx.SECOND() != null) {
            this.columnEditor.jdbcType(-104).type("INTERVAL DAY TO SECOND").length(2).scale(Integer.valueOf(6));
            for (PlSqlParser.ExpressionContext e : ctx.expression()) {
                if (e.getSourceInterval().startsAfter(ctx.TO().getSourceInterval())) {
                    this.columnEditor.scale(Integer.valueOf(e.getText()));
                    continue;
                }
                this.columnEditor.length(Integer.valueOf(e.getText()).intValue());
            }
            if (!ctx.expression().isEmpty()) {
                this.columnEditor.length(Integer.valueOf(ctx.expression(0).getText()).intValue());
            }
        } else {
            this.columnEditor.jdbcType(1111).type(ctx.getText());
        }
    }

    private int getVarCharDefaultLength() {
        return 4000;
    }

    private void setPrecision(PlSqlParser.Precision_partContext precisionPart, ColumnEditor columnEditor) {
        columnEditor.length(Integer.valueOf(precisionPart.numeric(0).getText()).intValue());
    }

    private void setScale(PlSqlParser.Precision_partContext precisionPart, ColumnEditor columnEditor) {
        if (precisionPart.numeric().size() > 1) {
            columnEditor.scale(Integer.valueOf(precisionPart.numeric(1).getText()));
        } else if (precisionPart.numeric_negative() != null) {
            columnEditor.scale(Integer.valueOf(precisionPart.numeric_negative().getText()));
        } else {
            columnEditor.scale(Integer.valueOf(0));
        }
    }
}

