/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleSchemaChangeEventEmitter;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogMinerChangeRecordEmitter;
import io.debezium.connector.oracle.logminer.events.DmlEvent;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.connector.oracle.logminer.events.LobEraseEvent;
import io.debezium.connector.oracle.logminer.events.LobWriteEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.connector.oracle.logminer.events.SelectLobLocatorEvent;
import io.debezium.connector.oracle.logminer.events.TruncateEvent;
import io.debezium.connector.oracle.logminer.parser.DmlParserException;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntryImpl;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlParser;
import io.debezium.connector.oracle.logminer.parser.SelectLobParser;
import io.debezium.connector.oracle.logminer.processor.AbstractTransaction;
import io.debezium.connector.oracle.logminer.processor.LogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.TransactionCommitConsumer;
import io.debezium.data.Envelope;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogMinerEventProcessor<T extends AbstractTransaction>
implements LogMinerEventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLogMinerEventProcessor.class);
    private final ChangeEventSource.ChangeEventSourceContext context;
    private final OracleConnectorConfig connectorConfig;
    private final OracleDatabaseSchema schema;
    private final OraclePartition partition;
    private final OracleOffsetContext offsetContext;
    private final EventDispatcher<OraclePartition, TableId> dispatcher;
    private final OracleStreamingChangeEventSourceMetrics metrics;
    private final LogMinerDmlParser dmlParser;
    private final SelectLobParser selectLobParser;
    protected final Counters counters;
    private Scn currentOffsetScn = Scn.NULL;
    private Scn currentOffsetCommitScn = Scn.NULL;
    private Scn lastCommittedScn = Scn.NULL;
    private Scn maxCommittedScn = Scn.NULL;
    private Scn lastProcessedScn = Scn.NULL;
    private boolean sequenceUnavailable = false;
    private static Pattern LOB_WRITE_SQL_PATTERN = Pattern.compile("(?s).* := ((?:HEXTORAW\\()?'.*'(?:\\))?);\\s*dbms_lob.write\\([^,]+,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,[^,]+\\);.*");

    public AbstractLogMinerEventProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleDatabaseSchema schema, OraclePartition partition, OracleOffsetContext offsetContext, EventDispatcher<OraclePartition, TableId> dispatcher, OracleStreamingChangeEventSourceMetrics metrics) {
        this.context = context;
        this.connectorConfig = connectorConfig;
        this.schema = schema;
        this.partition = partition;
        this.offsetContext = offsetContext;
        this.dispatcher = dispatcher;
        this.metrics = metrics;
        this.counters = new Counters();
        this.dmlParser = new LogMinerDmlParser();
        this.selectLobParser = new SelectLobParser();
    }

    protected OracleConnectorConfig getConfig() {
        return this.connectorConfig;
    }

    protected OracleDatabaseSchema getSchema() {
        return this.schema;
    }

    protected boolean isRecentlyProcessed(String transactionId) {
        return false;
    }

    protected boolean hasSchemaChangeBeenSeen(LogMinerEventRow row) {
        return false;
    }

    protected Scn getLastProcessedScn() {
        return this.lastProcessedScn;
    }

    protected abstract Map<String, T> getTransactionCache();

    protected abstract T createTransaction(LogMinerEventRow var1);

    protected abstract void removeEventWithRowId(LogMinerEventRow var1);

    protected abstract int getTransactionEventCount(T var1);

    protected boolean isTrxIdRawValue() {
        return true;
    }

    @Override
    public Scn process(OraclePartition partition, Scn startScn, Scn endScn) throws SQLException, InterruptedException {
        this.counters.reset();
        try (PreparedStatement statement = this.createQueryStatement();){
            Scn scn;
            block14: {
                LOGGER.debug("Fetching results for SCN [{}, {}]", (Object)startScn, (Object)endScn);
                statement.setFetchSize(this.getConfig().getLogMiningViewFetchSize());
                statement.setFetchDirection(1000);
                statement.setString(1, startScn.toString());
                statement.setString(2, endScn.toString());
                Instant queryStart = Instant.now();
                ResultSet resultSet = statement.executeQuery();
                try {
                    this.metrics.setLastDurationOfBatchCapturing(Duration.between(queryStart, Instant.now()));
                    Instant startProcessTime = Instant.now();
                    this.processResults(this.partition, resultSet);
                    Duration totalTime = Duration.between(startProcessTime, Instant.now());
                    this.metrics.setLastCapturedDmlCount(this.counters.dmlCount);
                    if (this.counters.dmlCount > 0 || this.counters.commitCount > 0 || this.counters.rollbackCount > 0) {
                        this.warnPotentiallyStuckScn(this.currentOffsetScn, this.currentOffsetCommitScn);
                        this.currentOffsetScn = this.offsetContext.getScn();
                        if (this.offsetContext.getCommitScn() != null) {
                            this.currentOffsetCommitScn = this.offsetContext.getCommitScn();
                        }
                    }
                    LOGGER.debug("{}.", (Object)this.counters);
                    LOGGER.debug("Processed in {} ms. Lag: {}. Offset SCN: {}, Offset Commit SCN: {}, Active Transactions: {}, Sleep: {}", new Object[]{totalTime.toMillis(), this.metrics.getLagFromSourceInMilliseconds(), this.offsetContext.getScn(), this.offsetContext.getCommitScn(), this.metrics.getNumberOfActiveTransactions(), this.metrics.getMillisecondToSleepBetweenMiningQuery()});
                    this.metrics.addProcessedRows(this.counters.rows);
                    scn = this.calculateNewStartScn(endScn, this.maxCommittedScn);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return scn;
        }
    }

    protected abstract PreparedStatement createQueryStatement() throws SQLException;

    protected abstract Scn calculateNewStartScn(Scn var1, Scn var2) throws InterruptedException;

    protected void processResults(OraclePartition partition, ResultSet resultSet) throws SQLException, InterruptedException {
        while (this.context.isRunning() && this.hasNextWithMetricsUpdate(resultSet)) {
            ++this.counters.rows;
            this.processRow(partition, LogMinerEventRow.fromResultSet(resultSet, this.getConfig().getCatalogName(), this.isTrxIdRawValue()));
        }
    }

    protected void processRow(OraclePartition partition, LogMinerEventRow row) throws SQLException, InterruptedException {
        Map<String, Scn> snapshotPendingTransactions;
        if (!row.getEventType().equals((Object)EventType.MISSING_SCN)) {
            this.lastProcessedScn = row.getScn();
        }
        if (!(row.getScn().compareTo(this.offsetContext.getSnapshotScn()) >= 0 || (snapshotPendingTransactions = this.offsetContext.getSnapshotPendingTransactions()) != null && snapshotPendingTransactions.containsKey(row.getTransactionId()))) {
            LOGGER.debug("Skipping event {} (SCN {}) because it is already encompassed by the initial snapshot", (Object)row.getEventType(), (Object)row.getScn());
            return;
        }
        switch (row.getEventType()) {
            case MISSING_SCN: {
                this.handleMissingScn(row);
            }
            case START: {
                this.handleStart(row);
                break;
            }
            case COMMIT: {
                this.handleCommit(partition, row);
                break;
            }
            case ROLLBACK: {
                this.handleRollback(row);
                break;
            }
            case DDL: {
                this.handleSchemaChange(row);
                break;
            }
            case SELECT_LOB_LOCATOR: {
                this.handleSelectLobLocator(row);
                break;
            }
            case LOB_WRITE: {
                this.handleLobWrite(row);
                break;
            }
            case LOB_ERASE: {
                this.handleLobErase(row);
                break;
            }
            case INSERT: 
            case UPDATE: 
            case DELETE: {
                this.handleDataEvent(row);
            }
        }
    }

    protected void handleMissingScn(LogMinerEventRow row) {
        LOGGER.warn("Missing SCN detected. {}", (Object)row);
    }

    protected void handleStart(LogMinerEventRow row) {
        String transactionId = row.getTransactionId();
        AbstractTransaction transaction = (AbstractTransaction)this.getTransactionCache().get(transactionId);
        if (transaction == null && !this.isRecentlyProcessed(transactionId)) {
            this.getTransactionCache().put(transactionId, this.createTransaction(row));
            this.metrics.setActiveTransactions(this.getTransactionCache().size());
        } else if (transaction != null && !this.isRecentlyProcessed(transactionId)) {
            LOGGER.trace("Transaction {} is not yet committed and START event detected.", (Object)transactionId);
            transaction.start();
        }
    }

    protected void handleCommit(final OraclePartition partition, LogMinerEventRow row) throws InterruptedException {
        final String transactionId = row.getTransactionId();
        if (this.isRecentlyProcessed(transactionId)) {
            LOGGER.debug("\tTransaction is already committed, skipped.");
            return;
        }
        final T transaction = this.getAndRemoveTransactionFromCache(transactionId);
        if (transaction == null) {
            LOGGER.trace("Transaction {} not found, commit skipped.", (Object)transactionId);
            return;
        }
        final Scn smallestScn = this.getTransactionCacheMinimumScn();
        this.metrics.setOldestScn(smallestScn.isNull() ? Scn.valueOf(-1) : smallestScn);
        final Scn commitScn = row.getScn();
        if (this.isTransactionAlreadyProcessed(commitScn, this.offsetContext.getCommitScn())) {
            LOGGER.debug("Transaction {} has already been processed. Offset Commit SCN {}, Transaction Commit SCN {}, Last Seen Commit SCN {}.", new Object[]{transactionId, this.offsetContext.getCommitScn(), commitScn, this.lastCommittedScn});
            this.removeTransactionAndEventsFromCache(transaction);
            this.metrics.setActiveTransactions(this.getTransactionCache().size());
            return;
        }
        ++this.counters.commitCount;
        int numEvents = this.getTransactionEventCount(transaction);
        LOGGER.trace("Commit (smallest SCN {}) {}", (Object)smallestScn, (Object)row);
        LOGGER.trace("Transaction {} has {} events", (Object)transactionId, (Object)numEvents);
        final ZoneOffset databaseOffset = this.metrics.getDatabaseOffset();
        final boolean skipExcludedUserName = this.isTransactionUserExcluded(transaction);
        BlockingConsumer<LogMinerEvent> delegate = new BlockingConsumer<LogMinerEvent>(){
            private int numEvents;
            {
                this.numEvents = AbstractLogMinerEventProcessor.this.getTransactionEventCount(transaction);
            }

            public void accept(LogMinerEvent event) throws InterruptedException {
                if (smallestScn.isNull() || commitScn.compareTo(smallestScn) < 0) {
                    AbstractLogMinerEventProcessor.this.offsetContext.setScn(event.getScn());
                    AbstractLogMinerEventProcessor.this.metrics.setOldestScn(event.getScn());
                }
                AbstractLogMinerEventProcessor.this.offsetContext.setTransactionId(transactionId);
                AbstractLogMinerEventProcessor.this.offsetContext.setSourceTime(event.getChangeTime().minusSeconds(databaseOffset.getTotalSeconds()));
                AbstractLogMinerEventProcessor.this.offsetContext.setTableId(event.getTableId());
                if (--this.numEvents == 0) {
                    AbstractLogMinerEventProcessor.this.offsetContext.setCommitScn(commitScn);
                }
                DmlEvent dmlEvent = (DmlEvent)event;
                if (!skipExcludedUserName) {
                    LogMinerChangeRecordEmitter logMinerChangeRecordEmitter = dmlEvent instanceof TruncateEvent ? new LogMinerChangeRecordEmitter((Partition)partition, (OffsetContext)AbstractLogMinerEventProcessor.this.offsetContext, Envelope.Operation.TRUNCATE, dmlEvent.getDmlEntry().getOldValues(), dmlEvent.getDmlEntry().getNewValues(), AbstractLogMinerEventProcessor.this.getSchema().tableFor(event.getTableId()), Clock.system()) : new LogMinerChangeRecordEmitter((Partition)partition, (OffsetContext)AbstractLogMinerEventProcessor.this.offsetContext, dmlEvent.getEventType(), dmlEvent.getDmlEntry().getOldValues(), dmlEvent.getDmlEntry().getNewValues(), AbstractLogMinerEventProcessor.this.getSchema().tableFor(event.getTableId()), Clock.system());
                    AbstractLogMinerEventProcessor.this.dispatcher.dispatchDataChangeEvent((Partition)partition, (DataCollectionId)event.getTableId(), (ChangeRecordEmitter)logMinerChangeRecordEmitter);
                }
            }
        };
        Instant start = Instant.now();
        int dispatchedEventCount = 0;
        if (numEvents > 0) {
            try (TransactionCommitConsumer commitConsumer = new TransactionCommitConsumer(delegate, this.connectorConfig, this.schema);){
                Iterator<LogMinerEvent> iterator = this.getTransactionEventIterator(transaction);
                while (iterator.hasNext()) {
                    if (!this.context.isRunning()) {
                        return;
                    }
                    LogMinerEvent event = iterator.next();
                    LOGGER.trace("Dispatching event {} {}", (Object)(++dispatchedEventCount), (Object)event.getEventType());
                    commitConsumer.accept(event);
                }
            }
        }
        this.lastCommittedScn = Scn.valueOf(commitScn.longValue());
        if (this.getTransactionEventCount(transaction) > 0 && !skipExcludedUserName) {
            this.dispatcher.dispatchTransactionCommittedEvent((Partition)partition, (OffsetContext)this.offsetContext);
        } else {
            this.dispatcher.dispatchHeartbeatEvent((Partition)partition, (OffsetContext)this.offsetContext);
        }
        this.metrics.calculateLagMetrics(row.getChangeTime());
        if (this.lastCommittedScn.compareTo(this.maxCommittedScn) > 0) {
            this.maxCommittedScn = this.lastCommittedScn;
        }
        this.finalizeTransactionCommit(transactionId, commitScn);
        this.removeTransactionAndEventsFromCache(transaction);
        this.metrics.incrementCommittedTransactions();
        this.metrics.setActiveTransactions(this.getTransactionCache().size());
        this.metrics.incrementCommittedDmlCount(dispatchedEventCount);
        this.metrics.setCommittedScn(commitScn);
        this.metrics.setOffsetScn(this.offsetContext.getScn());
        this.metrics.setLastCommitDuration(Duration.between(start, Instant.now()));
    }

    protected boolean isTransactionAlreadyProcessed(Scn commitScn, Scn offsetCommitScn) {
        return offsetCommitScn != null && offsetCommitScn.compareTo(commitScn) > 0 || this.lastCommittedScn.compareTo(commitScn) > 0;
    }

    protected abstract T getAndRemoveTransactionFromCache(String var1);

    protected abstract void removeTransactionAndEventsFromCache(T var1);

    protected abstract Iterator<LogMinerEvent> getTransactionEventIterator(T var1);

    protected abstract void finalizeTransactionCommit(String var1, Scn var2);

    protected boolean isTransactionUserExcluded(T transaction) {
        if (transaction != null) {
            if (((AbstractTransaction)transaction).getUserName() == null && this.getTransactionEventCount(transaction) > 0) {
                LOGGER.debug("Detected transaction with null username {}", transaction);
                return false;
            }
            if (this.connectorConfig.getLogMiningUsernameExcludes().contains(((AbstractTransaction)transaction).getUserName())) {
                LOGGER.trace("Skipped transaction with excluded username {}", transaction);
                return true;
            }
        }
        return false;
    }

    protected void handleRollback(LogMinerEventRow row) {
        if (this.getTransactionCache().containsKey(row.getTransactionId())) {
            this.finalizeTransactionRollback(row.getTransactionId(), row.getScn());
            this.metrics.setActiveTransactions(this.getTransactionCache().size());
            this.metrics.incrementRolledBackTransactions();
            this.metrics.addRolledBackTransactionId(row.getTransactionId());
            ++this.counters.rollbackCount;
        }
    }

    protected abstract void finalizeTransactionRollback(String var1, Scn var2);

    protected void handleSchemaChange(LogMinerEventRow row) throws InterruptedException {
        if (this.hasSchemaChangeBeenSeen(row)) {
            LOGGER.trace("DDL: Scn {}, SQL '{}' has already been processed, skipped.", (Object)row.getScn(), (Object)row.getRedoSql());
            return;
        }
        LOGGER.trace("DDL: '{}' {}", (Object)row.getRedoSql(), (Object)row);
        if (row.getTableName() != null) {
            ++this.counters.ddlCount;
            TableId tableId = row.getTableId();
            this.dispatcher.dispatchSchemaChangeEvent((Partition)this.partition, (DataCollectionId)tableId, (SchemaChangeEventEmitter)new OracleSchemaChangeEventEmitter(this.getConfig(), this.partition, this.offsetContext, tableId, tableId.catalog(), tableId.schema(), row.getRedoSql(), this.getSchema(), row.getChangeTime(), this.metrics, () -> this.processTruncateEvent(row)));
        }
    }

    private void processTruncateEvent(LogMinerEventRow row) {
        LOGGER.debug("Handling truncate event");
        this.addToTransaction(row.getTransactionId(), row, () -> {
            LogMinerDmlEntry dmlEntry = LogMinerDmlEntryImpl.forValuelessDdl();
            dmlEntry.setObjectName(row.getTableName());
            dmlEntry.setObjectOwner(row.getTablespaceName());
            return new TruncateEvent(row, dmlEntry);
        });
    }

    protected void handleSelectLobLocator(LogMinerEventRow row) {
        if (!this.getConfig().isLobEnabled()) {
            LOGGER.trace("LOB support is disabled, SEL_LOB_LOCATOR '{}' skipped.", (Object)row.getRedoSql());
            return;
        }
        LOGGER.trace("SEL_LOB_LOCATOR: {}", (Object)row);
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            LOGGER.warn("SEL_LOB_LOCATOR for table '{}' is not known, skipped.", (Object)tableId);
            return;
        }
        this.addToTransaction(row.getTransactionId(), row, () -> {
            LogMinerDmlEntry dmlEntry = this.selectLobParser.parse(row.getRedoSql(), table);
            dmlEntry.setObjectName(row.getTableName());
            dmlEntry.setObjectOwner(row.getTablespaceName());
            return new SelectLobLocatorEvent(row, dmlEntry, this.selectLobParser.getColumnName(), this.selectLobParser.isBinary());
        });
        this.metrics.incrementRegisteredDmlCount();
    }

    protected void handleLobWrite(LogMinerEventRow row) {
        if (!this.getConfig().isLobEnabled()) {
            LOGGER.trace("LOB support is disabled, LOB_WRITE scn={}, tableId={} skipped", (Object)row.getScn(), (Object)row.getTableId());
            return;
        }
        LOGGER.trace("LOB_WRITE: scn={}, tableId={}, changeTime={}, transactionId={}", new Object[]{row.getScn(), row.getTableId(), row.getChangeTime(), row.getTransactionId()});
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            LOGGER.warn("LOB_WRITE for table '{}' is not known, skipped", (Object)tableId);
            return;
        }
        if (row.getRedoSql() != null) {
            this.addToTransaction(row.getTransactionId(), row, () -> {
                ParsedLobWriteSql parsed = this.parseLobWriteSql(row.getRedoSql());
                return new LobWriteEvent(row, parsed.data, parsed.offset, parsed.length);
            });
        }
    }

    private void handleLobErase(LogMinerEventRow row) {
        if (!this.getConfig().isLobEnabled()) {
            LOGGER.trace("LOB support is disabled, LOB_ERASE '{}' skipped", (Object)row);
            return;
        }
        LOGGER.trace("LOB_ERASE: {}", (Object)row);
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            LOGGER.warn("LOB_ERASE for table '{}' is not known, skipped", (Object)tableId);
            return;
        }
        this.addToTransaction(row.getTransactionId(), row, () -> new LobEraseEvent(row));
    }

    protected void handleDataEvent(LogMinerEventRow row) throws SQLException, InterruptedException {
        if (row.getRedoSql() == null) {
            return;
        }
        LOGGER.trace("DML: {}", (Object)row);
        LOGGER.trace("\t{}", (Object)row.getRedoSql());
        ++this.counters.dmlCount;
        switch (row.getEventType()) {
            case INSERT: {
                ++this.counters.insertCount;
                break;
            }
            case UPDATE: {
                ++this.counters.updateCount;
                break;
            }
            case DELETE: {
                ++this.counters.deleteCount;
            }
        }
        Table table = this.getTableForDataEvent(row);
        if (table == null) {
            return;
        }
        if (row.isRollbackFlag()) {
            this.removeEventWithRowId(row);
            return;
        }
        this.addToTransaction(row.getTransactionId(), row, () -> {
            LogMinerDmlEntry dmlEntry = this.parseDmlStatement(row.getRedoSql(), table, row.getTransactionId());
            dmlEntry.setObjectName(row.getTableName());
            dmlEntry.setObjectOwner(row.getTablespaceName());
            return new DmlEvent(row, dmlEntry);
        });
        this.metrics.incrementRegisteredDmlCount();
    }

    protected void warnPotentiallyStuckScn(Scn previousOffsetScn, Scn previousOffsetCommitScn) {
        if (this.offsetContext != null && this.offsetContext.getCommitScn() != null) {
            Scn scn = this.offsetContext.getScn();
            Scn commitScn = this.offsetContext.getCommitScn();
            if (previousOffsetScn.equals(scn) && !previousOffsetCommitScn.equals(commitScn)) {
                ++this.counters.stuckCount;
                if (this.counters.stuckCount == 25) {
                    LOGGER.warn("Offset SCN {} has not changed in 25 mining session iterations. This indicates long running transaction(s) are active.  Commit SCN {}.", (Object)previousOffsetScn, (Object)previousOffsetCommitScn);
                    this.metrics.incrementScnFreezeCount();
                }
            } else {
                this.counters.stuckCount = 0;
            }
        }
    }

    private Table getTableForDataEvent(LogMinerEventRow row) throws SQLException, InterruptedException {
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            if (!this.getConfig().getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
                return null;
            }
            table = this.dispatchSchemaChangeEventAndGetTableForNewCapturedTable(tableId, this.offsetContext, this.dispatcher);
        }
        return table;
    }

    private boolean hasNextWithMetricsUpdate(ResultSet resultSet) throws SQLException {
        Instant start = Instant.now();
        boolean result = false;
        try {
            if (resultSet.next()) {
                this.metrics.addCurrentResultSetNext(Duration.between(start, Instant.now()));
                result = true;
            }
            if (this.sequenceUnavailable) {
                LOGGER.debug("The previous batch's unavailable log problem has been cleared.");
                this.sequenceUnavailable = false;
            }
        }
        catch (SQLException e) {
            if (!e.getMessage().startsWith("ORA-00310")) {
                throw e;
            }
            if (this.sequenceUnavailable) {
                LOGGER.error("The log availability error '{}' wasn't cleared, stop requested.", (Object)e.getMessage());
                throw e;
            }
            LOGGER.debug("A mined log is no longer available: {}", (Object)e.getMessage());
            LOGGER.warn("Restarting mining session after a log became unavailable.");
            this.sequenceUnavailable = true;
        }
        return result;
    }

    protected abstract void addToTransaction(String var1, LogMinerEventRow var2, Supplier<LogMinerEvent> var3);

    private Table dispatchSchemaChangeEventAndGetTableForNewCapturedTable(TableId tableId, OracleOffsetContext offsetContext, EventDispatcher<OraclePartition, TableId> dispatcher) throws SQLException, InterruptedException {
        LOGGER.info("Table '{}' is new and will now be captured.", (Object)tableId);
        offsetContext.event((DataCollectionId)tableId, Instant.now());
        dispatcher.dispatchSchemaChangeEvent((Partition)this.partition, (DataCollectionId)tableId, (SchemaChangeEventEmitter)new OracleSchemaChangeEventEmitter(this.connectorConfig, this.partition, offsetContext, tableId, tableId.catalog(), tableId.schema(), this.getTableMetadataDdl(tableId), this.getSchema(), Instant.now(), this.metrics, null));
        return this.getSchema().tableFor(tableId);
    }

    private String getTableMetadataDdl(TableId tableId) throws SQLException {
        ++this.counters.tableMetadataCount;
        LOGGER.info("Getting database metadata for table '{}'", (Object)tableId);
        try (OracleConnection connection = new OracleConnection(this.connectorConfig.getJdbcConfig(), () -> this.getClass().getClassLoader());){
            connection.setAutoCommit(false);
            String pdbName = this.getConfig().getPdbName();
            if (pdbName != null) {
                connection.setSessionToPdb(pdbName);
            }
            String string = connection.getTableMetadataDdl(tableId);
            return string;
        }
    }

    private LogMinerDmlEntry parseDmlStatement(String redoSql, Table table, String transactionId) {
        LogMinerDmlEntry dmlEntry;
        try {
            Instant parseStart = Instant.now();
            dmlEntry = this.dmlParser.parse(redoSql, table);
            this.metrics.addCurrentParseTime(Duration.between(parseStart, Instant.now()));
        }
        catch (DmlParserException e) {
            String message = "DML statement couldn't be parsed. Please open a Jira issue with the statement '" + redoSql + "'.";
            throw new DmlParserException(message, (Throwable)((Object)e));
        }
        if (dmlEntry.getOldValues().length == 0 && (EventType.UPDATE == dmlEntry.getEventType() || EventType.DELETE == dmlEntry.getEventType())) {
            LOGGER.warn("The DML event '{}' contained no before state.", (Object)redoSql);
            this.metrics.incrementWarningCount();
        }
        return dmlEntry;
    }

    private ParsedLobWriteSql parseLobWriteSql(String sql) {
        if (sql == null) {
            return null;
        }
        Matcher m = LOB_WRITE_SQL_PATTERN.matcher(sql.trim());
        if (!m.matches()) {
            throw new DebeziumException("Unable to parse unsupported LOB_WRITE SQL: " + sql);
        }
        String data = m.group(1);
        if (data.startsWith("'")) {
            data = data.substring(1, data.length() - 1);
        }
        int length = Integer.parseInt(m.group(2));
        int offset = Integer.parseInt(m.group(3)) - 1;
        return new ParsedLobWriteSql(offset, length, data);
    }

    protected abstract Scn getTransactionCacheMinimumScn();

    protected class Counters {
        public int stuckCount;
        public int dmlCount;
        public int ddlCount;
        public int insertCount;
        public int updateCount;
        public int deleteCount;
        public int commitCount;
        public int rollbackCount;
        public int tableMetadataCount;
        public long rows;

        protected Counters() {
        }

        public void reset() {
            this.stuckCount = 0;
            this.dmlCount = 0;
            this.ddlCount = 0;
            this.insertCount = 0;
            this.updateCount = 0;
            this.deleteCount = 0;
            this.commitCount = 0;
            this.rollbackCount = 0;
            this.tableMetadataCount = 0;
            this.rows = 0L;
        }

        public String toString() {
            return "Counters{rows=" + this.rows + ", stuckCount=" + this.stuckCount + ", dmlCount=" + this.dmlCount + ", ddlCount=" + this.ddlCount + ", insertCount=" + this.insertCount + ", updateCount=" + this.updateCount + ", deleteCount=" + this.deleteCount + ", commitCount=" + this.commitCount + ", rollbackCount=" + this.rollbackCount + ", tableMetadataCount=" + this.tableMetadataCount + '}';
        }
    }

    private class ParsedLobWriteSql {
        final int offset;
        final int length;
        final String data;

        ParsedLobWriteSql(int _offset, int _length, String _data) {
            this.offset = _offset;
            this.length = _length;
            this.data = _data;
        }
    }
}

