/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.events.DmlEvent;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.connector.oracle.logminer.events.LobWriteEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.SelectLobLocatorEvent;
import io.debezium.function.BlockingConsumer;
import io.debezium.relational.Table;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import oracle.sql.RAW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCommitConsumer
implements AutoCloseable,
BlockingConsumer<LogMinerEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionCommitConsumer.class);
    private final BlockingConsumer<LogMinerEvent> delegate;
    private final OracleConnectorConfig connectorConfig;
    private final OracleDatabaseSchema schema;
    private final Map<String, RowState> rows = new HashMap<String, RowState>();
    private String currentLobRowId;
    private String currentLobColumnName;
    private int currentLobColumnPosition = -1;
    private int transactionIndex = 0;

    public TransactionCommitConsumer(BlockingConsumer<LogMinerEvent> delegate, OracleConnectorConfig connectorConfig, OracleDatabaseSchema schema) {
        this.delegate = delegate;
        this.connectorConfig = connectorConfig;
        this.schema = schema;
    }

    @Override
    public void close() throws InterruptedException {
        ArrayList<RowState> pending = new ArrayList<RowState>(this.rows.values());
        Collections.sort(pending, (a, b) -> a.transactionIndex - b.transactionIndex);
        for (RowState rowState : pending) {
            this.prepareAndDispatch(rowState.event);
        }
    }

    public void accept(LogMinerEvent event) throws InterruptedException {
        if (!this.connectorConfig.isLobEnabled()) {
            this.dispatchChangeEvent(event);
            return;
        }
        if (event instanceof DmlEvent) {
            this.acceptDmlEvent((DmlEvent)event);
        } else {
            this.acceptLobManipulationEvent(event);
        }
    }

    private void acceptDmlEvent(DmlEvent event) throws InterruptedException {
        DmlEvent accumulatorEvent;
        ++this.transactionIndex;
        Table table = this.schema.tableFor(event.getTableId());
        if (table == null) {
            LOGGER.trace("Unable to locate table '{}' schema, ignoring event.", (Object)event.getTableId());
            return;
        }
        String rowId = this.rowIdFromEvent(table, event);
        RowState rowState = this.rows.get(rowId);
        DmlEvent dmlEvent = accumulatorEvent = null == rowState ? null : rowState.event;
        if (!this.tryMerge(accumulatorEvent, event)) {
            this.prepareAndDispatch(accumulatorEvent);
            if (rowId.equals(this.currentLobRowId)) {
                this.currentLobRowId = null;
                this.currentLobColumnName = null;
            }
            this.rows.put(rowId, new RowState(event, this.transactionIndex));
            accumulatorEvent = event;
        }
        if (EventType.SELECT_LOB_LOCATOR == event.getEventType()) {
            this.currentLobRowId = rowId;
            this.currentLobColumnName = ((SelectLobLocatorEvent)event).getColumnName();
            this.currentLobColumnPosition = LogMinerHelper.getColumnIndexByName(this.currentLobColumnName, table);
            Object[] values = this.newValues(accumulatorEvent);
            Object prevValue = values[this.currentLobColumnPosition];
            values[this.currentLobColumnPosition] = LobUnderConstruction.fromInitialValue(prevValue);
        }
    }

    private void acceptLobManipulationEvent(LogMinerEvent event) {
        if (null == this.currentLobRowId || null == this.currentLobColumnName) {
            LOGGER.trace("Got LOB manipulation event without preceding LOB selector; ignoring {} {}.", (Object)event.getEventType(), (Object)event);
            return;
        }
        if (EventType.LOB_WRITE != event.getEventType()) {
            LOGGER.warn("\t{} for table '{}' column '{}' is not supported.", new Object[]{event.getEventType(), event.getTableId(), this.currentLobColumnName});
            LOGGER.trace("All LOB manipulation events apart from LOB_WRITE are currently ignored; ignoring {} {}.", (Object)event.getEventType(), (Object)event);
            return;
        }
        LobUnderConstruction lob = (LobUnderConstruction)this.newValues(this.rows.get((Object)this.currentLobRowId).event)[this.currentLobColumnPosition];
        try {
            lob.add(new LobFragment(event));
        }
        catch (DebeziumException exception) {
            LOGGER.warn("\tInvalid LOB manipulation event: {} ; ignoring {} {}", new Object[]{exception, event.getEventType(), event});
        }
    }

    private void prepareAndDispatch(DmlEvent event) throws InterruptedException {
        if (null == event) {
            return;
        }
        Object[] values = this.newValues(event);
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] instanceof LobUnderConstruction)) continue;
            values[i] = ((LobUnderConstruction)values[i]).merge();
        }
        if (EventType.SELECT_LOB_LOCATOR == event.getEventType()) {
            boolean noop = true;
            Object[] oldValues = this.oldValues(event);
            for (int i = 0; i < values.length; ++i) {
                if (Objects.equals(oldValues[i], values[i])) continue;
                noop = false;
                break;
            }
            if (noop) {
                LOGGER.trace("\tSkip emitting event {} {} because it's effectively a NOOP.", (Object)event.getEventType(), (Object)event);
                return;
            }
        }
        this.dispatchChangeEvent(event);
    }

    private boolean tryMerge(DmlEvent prev, DmlEvent next) {
        if (prev == null) {
            return false;
        }
        boolean merge = false;
        block0 : switch (prev.getEventType()) {
            case SELECT_LOB_LOCATOR: 
            case UPDATE: 
            case INSERT: {
                switch (next.getEventType()) {
                    case SELECT_LOB_LOCATOR: {
                        merge = true;
                        break block0;
                    }
                    case UPDATE: {
                        this.mergeEvents(prev, next);
                        merge = true;
                        break block0;
                    }
                }
            }
        }
        if (merge) {
            LOGGER.trace("\tMerging {} event into previous {} event.", (Object)next.getEventType(), (Object)prev.getEventType());
        }
        return merge;
    }

    private void mergeEvents(DmlEvent into, DmlEvent from) {
        Object[] intoVals = this.newValues(into);
        Object[] fromVals = this.newValues(from);
        for (int i = 0; i < intoVals.length; ++i) {
            if (fromVals[i] == null || OracleValueConverters.UNAVAILABLE_VALUE.equals(fromVals[i])) continue;
            LOGGER.trace("\t\tMerge column {}: replacing {} with {}.", new Object[]{i, intoVals[i], fromVals[i]});
            intoVals[i] = fromVals[i];
        }
    }

    private void dispatchChangeEvent(LogMinerEvent event) throws InterruptedException {
        LOGGER.trace("\tEmitting event {} {}", (Object)event.getEventType(), (Object)event);
        this.delegate.accept((Object)event);
    }

    private String rowIdFromEvent(Table table, DmlEvent event) {
        ArrayList<String> idParts = new ArrayList<String>();
        idParts.add(event.getTableId().toString());
        Object[] values = EventType.DELETE == event.getEventType() ? this.oldValues(event) : this.newValues(event);
        for (String columnName : table.primaryKeyColumnNames()) {
            int position = LogMinerHelper.getColumnIndexByName(columnName, table);
            if (position >= values.length) {
                throw new DebeziumException("Field values corrupt for " + (Object)((Object)event.getEventType()) + " " + event);
            }
            Object value = values[position];
            if (value == null) {
                throw new DebeziumException("Could not find column " + columnName + " in event");
            }
            idParts.add(value.toString());
        }
        return String.join((CharSequence)"|", idParts);
    }

    private Object[] newValues(DmlEvent event) {
        return event.getDmlEntry().getNewValues();
    }

    private Object[] oldValues(DmlEvent event) {
        return event.getDmlEntry().getOldValues();
    }

    private static class RowState {
        final DmlEvent event;
        final int transactionIndex;

        RowState(DmlEvent event, int transactionIndex) {
            this.event = event;
            this.transactionIndex = transactionIndex;
        }
    }

    static class LobUnderConstruction {
        final List<LobFragment> fragments = new LinkedList<LobFragment>();
        int start = 0;
        int end = 0;
        boolean binary = false;
        boolean isNull = true;
        int middleInserts = 0;

        LobUnderConstruction() {
        }

        void add(LobFragment fragment) {
            LobFragment frag;
            this.isNull = false;
            if (this.fragments.isEmpty()) {
                this.fragments.add(fragment);
                this.start = fragment.offset;
                this.end = fragment.end();
                this.binary = fragment.binary;
                return;
            }
            if (fragment.binary != this.binary) {
                throw new DebeziumException("mixing binary and non-binary writes in a single LOB");
            }
            if (fragment.offset >= this.end) {
                this.fragments.add(fragment);
                this.end = fragment.end();
                return;
            }
            ++this.middleInserts;
            if (this.middleInserts % 10 == 0) {
                this.compact();
            }
            ListIterator<LobFragment> iter = this.fragments.listIterator();
            while (iter.hasNext()) {
                frag = iter.next();
                if (fragment.offset < frag.end() && fragment.offset >= frag.offset) {
                    if (fragment.end() >= frag.end()) {
                        frag.truncate(fragment.offset - frag.offset);
                        iter.add(fragment);
                        break;
                    }
                    frag.absorb(fragment);
                    break;
                }
                if (frag.offset <= fragment.offset) continue;
                iter.previous();
                iter.add(fragment);
                break;
            }
            while (iter.hasNext()) {
                frag = iter.next();
                if (frag.offset >= fragment.end()) break;
                if (frag.end() <= fragment.end()) {
                    iter.remove();
                    continue;
                }
                frag.frontTruncate(frag.end() - fragment.end());
            }
            if (fragment.offset < this.start) {
                this.start = fragment.offset;
            }
            if (fragment.end() > this.end) {
                this.end = fragment.end();
            }
        }

        void compact() {
            ListIterator<LobFragment> iter = this.fragments.listIterator();
            if (!iter.hasNext()) {
                return;
            }
            LobFragment prev = iter.next();
            while (iter.hasNext()) {
                LobFragment frag = iter.next();
                if (frag.offset - prev.end() < 128) {
                    prev.append(frag);
                    iter.remove();
                    continue;
                }
                prev = frag;
            }
        }

        Object merge() {
            if (this.isNull) {
                return null;
            }
            if (this.end == 0) {
                if (this.binary) {
                    return "EMPTY_BLOB()";
                }
                return "EMPTY_CLOB()";
            }
            if (this.binary) {
                byte[] buffer = new byte[this.end];
                ListIterator<LobFragment> iter = this.fragments.listIterator();
                while (iter.hasNext()) {
                    LobFragment frag = iter.next();
                    System.arraycopy(frag.bytes, 0, buffer, frag.offset, frag.bytes.length);
                }
                return buffer;
            }
            StringBuilder builder = new StringBuilder();
            int offset = 0;
            ListIterator<LobFragment> iter = this.fragments.listIterator();
            while (iter.hasNext()) {
                LobFragment frag = iter.next();
                if (offset < frag.offset) {
                    builder.append(LobFragment.spaces(frag.offset - offset));
                }
                if (frag.length() == 0) continue;
                builder.append(frag.data);
                offset = frag.end();
            }
            return builder.toString();
        }

        public String toString() {
            return "LobUnderConstruction{binary = " + this.binary + ", start = " + this.start + ", end = " + this.end + ", #fragments = " + this.fragments.size() + "}";
        }

        static LobUnderConstruction fromInitialValue(Object value) {
            if (null == value) {
                return new LobUnderConstruction();
            }
            if (value instanceof LobUnderConstruction) {
                return (LobUnderConstruction)value;
            }
            if (value instanceof String) {
                String strval = (String)value;
                LobUnderConstruction lob = new LobUnderConstruction();
                if ("EMPTY_BLOB()".equals(strval)) {
                    lob.binary = true;
                    lob.isNull = false;
                } else if ("EMPTY_CLOB()".equals(strval)) {
                    lob.binary = false;
                    lob.isNull = false;
                } else {
                    lob.add(new LobFragment(strval));
                }
                return lob;
            }
            LOGGER.trace("Don't know how to construct an initial LOB value from {}.", value);
            return new LobUnderConstruction();
        }
    }

    static class LobFragment {
        boolean binary;
        String data;
        byte[] bytes;
        int offset;

        LobFragment(LogMinerEvent event) {
            if (EventType.LOB_WRITE != event.getEventType()) {
                throw new IllegalArgumentException("can only construct LobFragments from LOB_WRITE events");
            }
            LobWriteEvent writeEvent = (LobWriteEvent)event;
            this.initializeFromData(writeEvent.getData());
            this.offset = writeEvent.getOffset();
            int eventLength = writeEvent.getLength();
            if (eventLength < this.length()) {
                this.truncate(eventLength);
            }
        }

        LobFragment(String value) {
            this.initializeFromData(value);
            this.offset = 0;
        }

        private void initializeFromData(String data) {
            boolean bl = this.binary = data.startsWith("HEXTORAW('") && data.endsWith("')");
            if (this.binary) {
                try {
                    this.bytes = RAW.hexString2Bytes((String)data.substring(10, data.length() - 2));
                }
                catch (SQLException e) {
                    throw new DebeziumException("malformed hex string in LogMiner event BLOB value", (Throwable)e);
                }
            } else {
                this.data = data;
            }
        }

        int length() {
            return this.binary ? this.bytes.length : this.data.length();
        }

        int end() {
            return this.offset + this.length();
        }

        void truncate(int newLength) {
            if (newLength > this.length()) {
                throw new DebeziumException("cannot truncate LOB fragment from length " + this.length() + " to length " + newLength);
            }
            if (this.binary) {
                this.bytes = Arrays.copyOf(this.bytes, newLength);
            } else {
                this.data = this.data.substring(0, newLength);
            }
        }

        void frontTruncate(int newLength) {
            if (newLength > this.length()) {
                throw new DebeziumException("cannot front-truncate LOB fragment from length " + this.length() + " to length " + newLength);
            }
            if (this.binary) {
                this.bytes = Arrays.copyOfRange(this.bytes, this.bytes.length - newLength, this.bytes.length);
            } else {
                this.data = this.data.substring(this.data.length() - newLength);
            }
            this.offset += this.length() - newLength;
        }

        void absorb(LobFragment other) {
            if (other.offset < this.offset || other.end() > this.end()) {
                throw new DebeziumException("cannot absorb fragment (" + other.offset + ", " + other.end() + ") into fragment (" + this.offset + ", " + this.end() + ") because the absorbee does not fully overlap the absorber");
            }
            int prefixEnd = other.offset - this.offset;
            int suffixStart = other.end() - this.offset;
            if (this.binary) {
                System.arraycopy(other.bytes, 0, this.bytes, prefixEnd, other.bytes.length);
            } else {
                this.data = this.data.substring(0, prefixEnd) + other.data + this.data.substring(suffixStart);
            }
        }

        void append(LobFragment other) {
            if (other.offset < this.end()) {
                throw new DebeziumException("cannot append fragment: offset " + other.offset + " is before this fragment's end " + this.end());
            }
            if (this.binary) {
                this.bytes = Arrays.copyOf(this.bytes, other.end() - this.offset);
                System.arraycopy(other.bytes, 0, this.bytes, other.offset - this.offset, other.bytes.length);
            } else {
                int gap = other.offset - this.end();
                this.data = gap > 0 ? this.data + LobFragment.spaces(gap) + other.data : this.data + other.data;
            }
        }

        static String spaces(int length) {
            char[] backing = new char[length];
            Arrays.fill(backing, ' ');
            return new String(backing);
        }
    }
}

