/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class OracleRowIdDataTypeIT
extends AbstractConnectorTest {
    private static OracleConnection connection;

    @BeforeClass
    public static void beforeClass() throws Exception {
        connection = TestHelper.testConnection();
        TestHelper.dropTable(connection, "debezium.type_rowid");
        String ddl = "create table debezium.type_rowid (  id numeric(9,0) not null,   name varchar2(50),   parent_rowid rowid,   primary key (id))";
        connection.execute(new String[]{ddl});
        TestHelper.streamTable(connection, "debezium.type_rowid");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (connection != null) {
            TestHelper.dropTable(connection, "debezium.type_rowid");
            connection.close();
        }
    }

    @Before
    public void before() throws Exception {
        connection.execute(new String[]{"delete from debezium.type_rowid"});
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @Test
    @FixFor(value={"DBZ-4595"})
    public void shouldSnapshotAndStreamRowIdAndURowIdColumnTypes() throws Exception {
        connection.executeWithoutCommitting(new String[]{"INSERT INTO debezium.type_rowid (id,name) values (1,'Parent')"});
        String parentRowId = (String)connection.queryAndMap("SELECT ROWID FROM debezium.type_rowid WHERE id = 1", rs -> {
            if (rs.next()) {
                return rs.getString(1);
            }
            return null;
        });
        connection.executeWithoutCommitting(new String[]{"INSERT INTO debezium.type_rowid (id,name,parent_rowid) values (2,'Child','" + parentRowId + "')"});
        connection.commit();
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.TYPE_ROWID")).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords snapshot = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)snapshot.allRecordsInOrder()).hasSize(2);
        List records = snapshot.recordsForTopic("server1.DEBEZIUM.TYPE_ROWID");
        Assertions.assertThat((List)records).hasSize(2);
        Struct after = ((Struct)((SourceRecord)records.get(0)).value()).getStruct("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Parent");
        Assertions.assertThat((Object)after.get("PARENT_ROWID")).isNull();
        after = ((Struct)((SourceRecord)records.get(1)).value()).getStruct("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Child");
        Assertions.assertThat((Object)after.get("PARENT_ROWID")).isEqualTo((Object)parentRowId);
        OracleRowIdDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        connection.execute(new String[]{"UPDATE debezium.type_rowid set name = 'Only Child' WHERE id = 2"});
        AbstractConnectorTest.SourceRecords stream = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)stream.allRecordsInOrder()).hasSize(1);
        records = stream.recordsForTopic("server1.DEBEZIUM.TYPE_ROWID");
        Assertions.assertThat((List)records).hasSize(1);
        after = ((Struct)((SourceRecord)records.get(0)).value()).getStruct("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Only Child");
        Assertions.assertThat((Object)after.get("PARENT_ROWID")).isEqualTo((Object)parentRowId);
    }
}

