/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.json;

import java.io.IOException;
import java.io.Writer;
import org.infinispan.commons.configuration.io.AbstractConfigurationWriter;
import org.infinispan.commons.configuration.io.ConfigurationWriterException;
import org.infinispan.commons.configuration.io.NamingStrategy;

public class JsonConfigurationWriter
extends AbstractConfigurationWriter {
    private boolean openTag;
    private boolean attributes;

    public JsonConfigurationWriter(Writer writer, boolean prettyPrint) {
        super(writer, 2, prettyPrint, NamingStrategy.KEBAB_CASE);
    }

    @Override
    public void writeStartDocument() {
        try {
            this.writer.write(123);
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeStartElement(String name) {
        try {
            if (this.attributes) {
                this.writer.write(44);
                this.nl();
            }
            this.tagStack.push(new AbstractConfigurationWriter.Tag(name));
            this.writeIndent();
            this.writer.write(34);
            this.writer.write(this.naming.convert(name));
            this.writer.write("\": {");
            this.openTag = true;
            this.attributes = false;
            this.nl();
            this.indent();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeStartElement(String prefix, String namespace, String name) {
        this.writeStartElement((prefix == null ? "" : prefix + ":") + name);
    }

    @Override
    public void writeStartListElement(String name, boolean explicit) {
        try {
            this.writer.write(91);
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeStartListElement(String prefix, String namespace, String name, boolean explicit) {
        this.writeStartListElement(this.prefixName(prefix, name), explicit);
    }

    private String prefixName(String prefix, String name) {
        return (prefix == null ? "" : prefix + ":") + name;
    }

    @Override
    public void writeEndListElement() {
        try {
            this.writer.write(93);
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeStartMapElement(String name) {
    }

    @Override
    public void writeEndMapElement() {
    }

    @Override
    public void writeStartMapEntry(String name, String key, String value) {
    }

    @Override
    public void writeNamespace(String prefix, String namespace) {
        if (!this.openTag) {
            throw new ConfigurationWriterException("Cannot set namespace without a started element");
        }
    }

    @Override
    public void writeDefaultNamespace(String namespace) {
        if (!this.openTag) {
            throw new ConfigurationWriterException("Cannot set namespace without a started element");
        }
    }

    @Override
    public void writeEndElement() {
        try {
            this.nl();
            this.outdent();
            this.writeIndent();
            this.writer.write(125);
            this.nl();
            this.openTag = false;
            this.attributes = false;
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeEndDocument() {
        try {
            this.writer.write(125);
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeAttribute(String name, String value) {
        try {
            this.openTag = false;
            if (!this.attributes) {
                this.attributes = true;
            } else {
                this.writer.write(44);
                this.nl();
            }
            this.writeIndent();
            this.writer.write(34);
            this.writer.write(name);
            this.writer.write("\": \"");
            this.writer.write(value);
            this.writer.write(34);
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeCharacters(String chars) {
        try {
            if (this.attributes) {
                this.writeAttribute("value", chars);
            } else {
                this.writer.write(": \"");
                this.writer.write(chars);
                this.writer.write(34);
                this.nl();
            }
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeEmptyElement(String name) {
        this.writeStartElement(name);
        this.writeCharacters("");
        this.writeEndElement();
    }

    @Override
    public void writeComment(String comment) {
        try {
            this.writer.write("# ");
            this.writer.write(comment);
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }
}

