/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import io.reactivex.rxjava3.core.Flowable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.TopologyIracVersion;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.file.SecurityActions;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Store
@ConfiguredBy(value=SingleFileStoreConfiguration.class)
public class SingleFileStore<K, V>
implements AdvancedLoadWriteStore<K, V> {
    private static final Log log = LogFactory.getLog(SingleFileStore.class);
    public static final byte[] MAGIC_BEFORE_11 = new byte[]{70, 67, 83, 49};
    public static final byte[] MAGIC_11_0 = new byte[]{70, 67, 83, 50};
    public static final byte[] MAGIC_12_0 = new byte[]{70, 67, 83, 51};
    public static final byte[] MAGIC_12_1 = new byte[]{70, 67, 83, 52};
    public static final byte[] MAGIC_LATEST = MAGIC_12_1;
    private static final byte[] ZERO_INT = new byte[]{0, 0, 0, 0};
    private static final int KEYLEN_POS = 4;
    public static final int KEY_POS_BEFORE_11 = 24;
    public static final int KEY_POS_11_0 = 28;
    public static final int KEY_POS_LATEST = 28;
    private static final int TIMESTAMP_BYTES = 16;
    private static final int SMALLEST_ENTRY_SIZE = 128;
    private SingleFileStoreConfiguration configuration;
    protected InitializationContext ctx;
    private FileChannel channel;
    private Map<K, FileEntry> entries;
    private SortedSet<FileEntry> freeList;
    private long filePos = MAGIC_LATEST.length;
    private File file;
    private float fragmentationFactor = 0.75f;
    private final ReadWriteLock resizeLock = new ReentrantReadWriteLock();
    private TimeService timeService;
    private MarshallableEntryFactory<K, V> entryFactory;

    public static File getStoreFile(GlobalConfiguration globalConfiguration, String locationPath, String cacheName) {
        Path location = PersistenceUtil.getLocation(globalConfiguration, locationPath);
        return new File(location.toFile(), cacheName + ".dat");
    }

    @Override
    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (SingleFileStoreConfiguration)ctx.getConfiguration();
        this.timeService = ctx.getTimeService();
        this.entryFactory = ctx.getMarshallableEntryFactory();
    }

    public void start() {
        try {
            File dir;
            this.file = SingleFileStore.getStoreFile(this.ctx.getGlobalConfiguration(), this.configuration.location(), this.ctx.getCache().getName());
            if (!SecurityActions.fileExists(this.file) && !SecurityActions.createDirectoryIfNeeded(dir = this.file.getParentFile())) {
                throw Log.PERSISTENCE.directoryCannotBeCreated(dir.getAbsolutePath());
            }
            this.channel = SecurityActions.openFileChannel(this.file);
            HashMap entryMap = this.configuration.maxEntries() > 0 ? new LinkedHashMap(16, 0.75f, true) : new HashMap();
            this.entries = Collections.synchronizedMap(entryMap);
            this.freeList = Collections.synchronizedSortedSet(new TreeSet());
            byte[] header = new byte[MAGIC_LATEST.length];
            if (!this.configuration.purgeOnStartup() && this.channel.read(java.nio.ByteBuffer.wrap(header), 0L) == MAGIC_LATEST.length) {
                if (Arrays.equals(MAGIC_LATEST, header)) {
                    this.rebuildIndex();
                    this.processFreeEntries();
                } else if (Arrays.equals(MAGIC_12_0, header)) {
                    this.migrateFromV12_0();
                    this.processFreeEntries();
                } else if (Arrays.equals(MAGIC_11_0, header)) {
                    this.migrateFromV11();
                    this.processFreeEntries();
                } else {
                    if (Arrays.equals(MAGIC_BEFORE_11, header)) {
                        throw Log.PERSISTENCE.persistedDataMigrationAcrossMajorVersions();
                    }
                    this.clear();
                }
            } else {
                this.clear();
            }
            this.fragmentationFactor = this.configuration.fragmentationFactor();
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public void stop() {
        try {
            if (this.channel != null) {
                log.tracef("Stopping store %s, size = %d, file size = %d", this.ctx.getCache().getName(), this.entries.size(), this.channel.size());
                this.channel.close();
                this.channel = null;
                this.entries = null;
                this.freeList = null;
                this.filePos = MAGIC_LATEST.length;
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void destroy() {
        this.stop();
        if (this.file.delete()) {
            log.tracef("Deleted file: " + this.file, new Object[0]);
        } else {
            log.tracef("Could not delete file: " + this.file, new Object[0]);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.file.exists();
    }

    private void rebuildIndex() throws Exception {
        java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(28);
        while ((buf = this.readChannel(buf, this.filePos, 28)).remaining() <= 0) {
            buf.flip();
            FileEntry fe = new FileEntry(this.filePos, buf);
            if (fe.size < 28 + fe.keyLen + fe.dataLen + fe.metadataLen + fe.internalMetadataLen) {
                throw Log.PERSISTENCE.errorReadingFileStore(this.file.getPath(), this.filePos);
            }
            this.filePos += (long)fe.size;
            if (fe.keyLen > 0) {
                buf = this.readChannel(buf, fe.offset + 28L, fe.keyLen);
                Object key = this.ctx.getPersistenceMarshaller().objectFromByteBuffer(buf.array(), 0, fe.keyLen);
                this.entries.put(key, fe);
                continue;
            }
            this.freeList.add(fe);
        }
    }

    private PrivateMetadata generateMissingInternalMetadata() {
        AdvancedCache cache = this.ctx.getCache().getAdvancedCache();
        Configuration config = cache.getCacheConfiguration();
        TransactionConfiguration txConfig = config.transaction();
        PrivateMetadata.Builder builder = new PrivateMetadata.Builder();
        if (txConfig.transactionMode() == TransactionMode.TRANSACTIONAL && txConfig.lockingMode() == LockingMode.OPTIMISTIC) {
            builder.entryVersion(new SimpleClusteredVersion(1, 1L));
        }
        if (config.sites().hasAsyncEnabledBackups()) {
            String siteName = cache.getCacheManager().getTransport().localSiteName();
            IracEntryVersion version = new IracEntryVersion(Collections.singletonMap(siteName, TopologyIracVersion.newVersion(1)));
            builder.iracMetadata(new IracMetadata(siteName, version));
        }
        return builder.build();
    }

    private void migrateFromV12_0() throws Exception {
        if (this.ctx.getGlobalConfiguration().serialization().marshaller() == null) {
            this.migrateCorruptDataV12_0();
            return;
        }
        String cacheName = this.ctx.getCache().getName();
        Log.PERSISTENCE.startMigratingPersistenceData(cacheName);
        try {
            this.channel.write(java.nio.ByteBuffer.wrap(MAGIC_LATEST), 0L);
        }
        catch (IOException e) {
            throw Log.PERSISTENCE.persistedDataMigrationFailed(cacheName, e);
        }
        this.rebuildIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateCorruptDataV12_0() {
        String cacheName = this.ctx.getCache().getName();
        Log.PERSISTENCE.startRecoveringCorruptPersistenceData(cacheName);
        File newFile = new File(this.file.getParentFile(), cacheName + "_new.dat");
        long sanityEpoch = LocalDate.of(2019, 10, 26).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        long currentTs = this.timeService.wallClockTime();
        int entriesRecovered = 0;
        java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(28);
        ByRef bufRef = ByRef.create((Object)buf);
        try (FileChannel newChannel = SecurityActions.openFileChannel(newFile);){
            newChannel.truncate(0L);
            newChannel.write(java.nio.ByteBuffer.wrap(MAGIC_LATEST), 0L);
            long fileSize = this.channel.size();
            long oldFilePos = MAGIC_12_0.length;
            while ((buf = this.readChannel(buf, oldFilePos, 28)).remaining() <= 0) {
                Object value;
                Object key;
                buf.flip();
                FileEntry fe = new FileEntry(oldFilePos, buf);
                if (fe.size <= 0 || fe.expiryTime < -1L || fe.keyLen <= 0 || fe.keyLen > fe.size || fe.dataLen <= 0 || fe.dataLen > fe.size || fe.metadataLen < 0 || fe.metadataLen > fe.size || fe.internalMetadataLen < 0 || fe.internalMetadataLen > fe.size) {
                    ++oldFilePos;
                    continue;
                }
                long estimateSizeExcludingInternal = fe.keyLen;
                estimateSizeExcludingInternal += (long)fe.dataLen;
                if ((estimateSizeExcludingInternal += (long)fe.metadataLen) > fileSize - oldFilePos) {
                    ++oldFilePos;
                    continue;
                }
                Metadata metadata = null;
                ByRef.Long offset = new ByRef.Long(oldFilePos + 28L);
                bufRef.set((Object)buf);
                try {
                    int metaLen;
                    key = this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, fe.keyLen);
                    value = this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, fe.dataLen);
                    int n = metaLen = fe.metadataLen > 0 ? fe.metadataLen - 16 : 0;
                    if (metaLen > 0) {
                        metadata = (Metadata)this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, metaLen);
                    }
                    oldFilePos = offset.get();
                }
                catch (Throwable t) {
                    ++oldFilePos;
                    continue;
                }
                finally {
                    buf = (java.nio.ByteBuffer)bufRef.get();
                    continue;
                }
                long created = -1L;
                long lastUsed = -1L;
                if (fe.metadataLen > 0 && fe.expiryTime > 0L) {
                    buf = this.readChannelUpdateOffset(buf, offset, 16);
                    buf.flip();
                    created = buf.getLong();
                    lastUsed = buf.getLong();
                    if (created != -1L && (created > currentTs || created < sanityEpoch)) {
                        long lifespan = metadata.lifespan();
                        long l = created = lifespan > 0L ? fe.expiryTime - lifespan : currentTs;
                    }
                    if (lastUsed != -1L && (lastUsed > currentTs || lastUsed < sanityEpoch)) {
                        long maxIdle = metadata.maxIdle();
                        lastUsed = maxIdle > 0L ? fe.expiryTime - maxIdle : currentTs;
                    }
                    oldFilePos = offset.get();
                }
                PrivateMetadata internalMeta = null;
                if (fe.internalMetadataLen > 0) {
                    try {
                        bufRef.set((Object)buf);
                        internalMeta = (PrivateMetadata)this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, fe.internalMetadataLen);
                        oldFilePos = offset.get();
                    }
                    catch (Throwable t) {
                        internalMeta = this.generateMissingInternalMetadata();
                    }
                    finally {
                        buf = (java.nio.ByteBuffer)bufRef.get();
                    }
                }
                if (fe.expiryTime > 0L && fe.expiryTime < currentTs) continue;
                MarshallableEntry me = this.ctx.getMarshallableEntryFactory().create(key, value, metadata, internalMeta, created, lastUsed);
                this.write(me, newChannel);
                ++entriesRecovered;
            }
        }
        catch (IOException e) {
            throw Log.PERSISTENCE.corruptDataMigrationFailed(cacheName, e);
        }
        try {
            this.channel.close();
            Files.move(newFile.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.channel = SecurityActions.openFileChannel(this.file);
            Log.PERSISTENCE.corruptDataSuccessfulMigrated(cacheName, entriesRecovered);
        }
        catch (IOException e) {
            throw Log.PERSISTENCE.corruptDataMigrationFailed(cacheName, e);
        }
    }

    private void migrateFromV11() {
        String cacheName = this.ctx.getCache().getName();
        Log.PERSISTENCE.startMigratingPersistenceData(cacheName);
        File newFile = new File(this.file.getParentFile(), cacheName + "_new.dat");
        if (newFile.exists()) {
            newFile.delete();
        }
        long oldFilePos = MAGIC_11_0.length;
        boolean wrapperMissing = this.ctx.getGlobalConfiguration().serialization().marshaller() == null;
        try (FileChannel newChannel = SecurityActions.openFileChannel(newFile);){
            newChannel.truncate(0L);
            newChannel.write(java.nio.ByteBuffer.wrap(MAGIC_LATEST), 0L);
            long currentTs = this.timeService.wallClockTime();
            java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(28);
            ByRef bufRef = ByRef.create((Object)buf);
            while ((buf = this.readChannelUpdateOffset(buf, new ByRef.Long(oldFilePos), 28)).remaining() <= 0) {
                buf.flip();
                FileEntry oldFe = new FileEntry(oldFilePos, buf);
                if (oldFe.size < 28 + oldFe.keyLen + oldFe.dataLen + oldFe.metadataLen + oldFe.internalMetadataLen) {
                    throw Log.PERSISTENCE.errorReadingFileStore(this.file.getPath(), this.filePos);
                }
                oldFilePos += (long)oldFe.size;
                if (oldFe.keyLen < 1 || oldFe.expiryTime > 0L && oldFe.expiryTime < currentTs) continue;
                ByRef.Long offset = new ByRef.Long(oldFe.offset + 28L);
                long created = -1L;
                long lastUsed = -1L;
                bufRef.set((Object)buf);
                Object key = this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, oldFe.keyLen, wrapperMissing);
                Object value = this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, oldFe.dataLen, wrapperMissing);
                Metadata metadata = null;
                if (oldFe.metadataLen > 0) {
                    metadata = (Metadata)this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, oldFe.metadataLen - 16, wrapperMissing);
                    if (oldFe.expiryTime > 0L) {
                        buf = (java.nio.ByteBuffer)bufRef.get();
                        buf = this.readChannelUpdateOffset(buf, offset, 16);
                        buf.flip();
                        created = buf.getLong();
                        lastUsed = buf.getLong();
                        bufRef.set((Object)buf);
                    }
                }
                PrivateMetadata internalMeta = null;
                if (oldFe.internalMetadataLen > 0) {
                    internalMeta = (PrivateMetadata)this.unmarshallObject((ByRef<java.nio.ByteBuffer>)bufRef, offset, oldFe.internalMetadataLen, wrapperMissing);
                    buf = (java.nio.ByteBuffer)bufRef.get();
                }
                MarshallableEntry me = this.ctx.getMarshallableEntryFactory().create(key, value, metadata, internalMeta, created, lastUsed);
                this.write(me, newChannel);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw Log.PERSISTENCE.persistedDataMigrationFailed(cacheName, e);
        }
        try {
            this.channel.close();
            Files.move(newFile.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.channel = SecurityActions.openFileChannel(this.file);
            Log.PERSISTENCE.persistedDataSuccessfulMigrated(cacheName);
        }
        catch (IOException e) {
            throw Log.PERSISTENCE.persistedDataMigrationFailed(cacheName, e);
        }
    }

    private <T> T unmarshallObject(ByRef<java.nio.ByteBuffer> buf, ByRef.Long offset, int length) throws ClassNotFoundException, IOException {
        return this.unmarshallObject(buf, offset, length, false);
    }

    private <T> T unmarshallObject(ByRef<java.nio.ByteBuffer> bufRef, ByRef.Long offset, int length, boolean legacyWrapperMissing) throws ClassNotFoundException, IOException {
        java.nio.ByteBuffer buf = (java.nio.ByteBuffer)bufRef.get();
        buf = this.readChannelUpdateOffset(buf, offset, length);
        byte[] bytes = buf.array();
        bufRef.set((Object)buf);
        PersistenceMarshaller persistenceMarshaller = this.ctx.getPersistenceMarshaller();
        if (legacyWrapperMissing) {
            Marshaller marshaller = persistenceMarshaller.getUserMarshaller();
            try {
                return (T)marshaller.objectFromByteBuffer(bytes, 0, length);
            }
            catch (IllegalArgumentException e) {
                return (T)persistenceMarshaller.objectFromByteBuffer(bytes, 0, length);
            }
        }
        return (T)persistenceMarshaller.objectFromByteBuffer(bytes, 0, length);
    }

    private java.nio.ByteBuffer readChannelUpdateOffset(java.nio.ByteBuffer buf, ByRef.Long offset, int length) throws IOException {
        return this.readChannel(buf, offset.getAndAdd((long)length), length);
    }

    private java.nio.ByteBuffer readChannel(java.nio.ByteBuffer buf, long offset, int length) throws IOException {
        buf = this.allocate(buf, length);
        this.channel.read(buf, offset);
        return buf;
    }

    private java.nio.ByteBuffer allocate(java.nio.ByteBuffer buf, int length) {
        buf.flip();
        if (buf.capacity() < length) {
            buf = java.nio.ByteBuffer.allocate(length);
        }
        buf.clear().limit(length);
        return buf;
    }

    @Override
    public boolean contains(Object key) {
        FileEntry entry = this.entries.get(key);
        return entry != null && !entry.isExpired(this.timeService.wallClockTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry allocate(int len) {
        SortedSet<FileEntry> sortedSet = this.freeList;
        synchronized (sortedSet) {
            SortedSet<FileEntry> candidates = this.freeList.tailSet(new FileEntry(0L, len));
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                FileEntry free = (FileEntry)it.next();
                if (free.isLocked()) continue;
                it.remove();
                return this.allocateExistingEntry(free, len);
            }
            FileEntry fe = new FileEntry(this.filePos, len);
            this.filePos += (long)len;
            if (log.isTraceEnabled()) {
                log.tracef("New entry allocated at %d:%d, %d free entries, file size is %d", new Object[]{fe.offset, fe.size, this.freeList.size(), this.filePos});
            }
            return fe;
        }
    }

    private FileEntry allocateExistingEntry(FileEntry free, int len) {
        int remainder = free.size - len;
        if (remainder >= 128 && (float)len <= (float)free.size * this.fragmentationFactor) {
            try {
                FileEntry newFreeEntry = new FileEntry(free.offset + (long)len, remainder);
                this.addNewFreeEntry(newFreeEntry);
                FileEntry newEntry = new FileEntry(free.offset, len);
                if (log.isTraceEnabled()) {
                    log.tracef("Split entry at %d:%d, allocated %d:%d, free %d:%d, %d free entries", new Object[]{free.offset, free.size, newEntry.offset, newEntry.size, newFreeEntry.offset, newFreeEntry.size, this.freeList.size()});
                }
                return newEntry;
            }
            catch (IOException e) {
                throw new PersistenceException("Cannot add new free entry", e);
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Existing free entry allocated at %d:%d, %d free entries", free.offset, free.size, this.freeList.size());
        }
        return free;
    }

    private void addNewFreeEntry(FileEntry fe) throws IOException {
        java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(28);
        buf.putInt(fe.size);
        buf.putInt(0);
        buf.putInt(0);
        buf.putInt(0);
        buf.putInt(0);
        buf.putLong(-1L);
        buf.flip();
        this.channel.write(buf, fe.offset);
        this.freeList.add(fe);
    }

    private void free(FileEntry fe) throws IOException {
        if (fe != null) {
            this.channel.write(java.nio.ByteBuffer.wrap(ZERO_INT), fe.offset + 4L);
            if (!this.freeList.add(fe)) {
                throw new IllegalStateException(String.format("Trying to free an entry that was not allocated: %s", fe));
            }
            if (log.isTraceEnabled()) {
                log.tracef("Deleted entry at %d:%d, there are now %d free entries", fe.offset, fe.size, this.freeList.size());
            }
        }
    }

    @Override
    public void write(MarshallableEntry<? extends K, ? extends V> marshalledEntry) {
        this.write(marshalledEntry, this.channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(MarshallableEntry<? extends K, ? extends V> marshalledEntry, FileChannel channel) {
        try {
            FileEntry oldEntry;
            block14: {
                ByteBuffer key = marshalledEntry.getKeyBytes();
                ByteBuffer data = marshalledEntry.getValueBytes();
                ByteBuffer metadata = marshalledEntry.getMetadataBytes();
                ByteBuffer internalMetadata = marshalledEntry.getInternalMetadataBytes();
                int metadataLength = metadata == null ? 0 : metadata.getLength() + 16;
                int internalMetadataLength = internalMetadata == null ? 0 : internalMetadata.getLength();
                int len = 28 + key.getLength() + data.getLength() + metadataLength + internalMetadataLength;
                oldEntry = null;
                this.resizeLock.readLock().lock();
                try {
                    FileEntry newEntry = this.allocate(len);
                    newEntry = new FileEntry(newEntry.offset, newEntry.size, key.getLength(), data.getLength(), metadataLength, internalMetadataLength, marshalledEntry.expiryTime());
                    java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(len);
                    newEntry.writeToBuf(buf);
                    buf.put(key.getBuf(), key.getOffset(), key.getLength());
                    buf.put(data.getBuf(), data.getOffset(), data.getLength());
                    if (metadata != null) {
                        buf.put(metadata.getBuf(), metadata.getOffset(), metadata.getLength());
                        if (newEntry.expiryTime > 0L) {
                            buf.putLong(marshalledEntry.created());
                            buf.putLong(marshalledEntry.lastUsed());
                        }
                    }
                    if (internalMetadata != null) {
                        buf.put(internalMetadata.getBuf(), internalMetadata.getOffset(), internalMetadata.getLength());
                    }
                    buf.flip();
                    channel.write(buf, newEntry.offset);
                    if (log.isTraceEnabled()) {
                        log.tracef("Wrote entry %s:%d at %d:%d", new Object[]{marshalledEntry.getKey(), len, newEntry.offset, newEntry.size});
                    }
                    if ((oldEntry = this.entries.put(marshalledEntry.getKey(), newEntry)) != null) break block14;
                    oldEntry = this.evict();
                }
                catch (Throwable throwable) {
                    try {
                        this.free(oldEntry);
                    }
                    finally {
                        this.resizeLock.readLock().unlock();
                    }
                    throw throwable;
                }
            }
            try {
                this.free(oldEntry);
            }
            finally {
                this.resizeLock.readLock().unlock();
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry evict() {
        if (this.configuration.maxEntries() > 0) {
            Map<K, FileEntry> map = this.entries;
            synchronized (map) {
                if (this.entries.size() > this.configuration.maxEntries()) {
                    Iterator<FileEntry> it = this.entries.values().iterator();
                    FileEntry fe = it.next();
                    it.remove();
                    return fe;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.resizeLock.writeLock().lock();
        try {
            Map<K, FileEntry> map = this.entries;
            synchronized (map) {
                SortedSet<FileEntry> sortedSet = this.freeList;
                synchronized (sortedSet) {
                    for (FileEntry fe : this.entries.values()) {
                        fe.waitUnlocked();
                    }
                    for (FileEntry fe : this.freeList) {
                        fe.waitUnlocked();
                    }
                    this.entries.clear();
                    this.freeList.clear();
                    if (log.isTraceEnabled()) {
                        log.tracef("Truncating file, current size is %d", this.filePos);
                    }
                    this.channel.truncate(0L);
                    this.channel.write(java.nio.ByteBuffer.wrap(MAGIC_LATEST), 0L);
                    this.filePos = MAGIC_LATEST.length;
                }
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            this.resizeLock.writeLock().unlock();
        }
    }

    @Override
    public boolean delete(Object key) {
        this.resizeLock.readLock().lock();
        try {
            FileEntry fe = this.entries.remove(key);
            this.free(fe);
            boolean bl = fe != null;
            return bl;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            this.resizeLock.readLock().unlock();
        }
    }

    @Override
    public MarshallableEntry<K, V> loadEntry(Object key) {
        return this._load(key, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private MarshallableEntry<K, V> _load(Object key, boolean loadValue, boolean loadMetadata) {
        byte[] data;
        FileEntry fe;
        block22: {
            this.resizeLock.readLock().lock();
            Map<K, FileEntry> map = this.entries;
            // MONITORENTER : map
            fe = this.entries.get(key);
            if (fe == null) {
                MarshallableEntry<K, V> marshallableEntry = null;
                // MONITOREXIT : map
                this.resizeLock.readLock().unlock();
                return marshallableEntry;
            }
            if (!fe.isExpired(this.timeService.wallClockTime())) break block22;
            MarshallableEntry<K, V> marshallableEntry = null;
            this.resizeLock.readLock().unlock();
            return marshallableEntry;
        }
        try {
            fe.lock();
            // MONITOREXIT : map
        }
        finally {
            this.resizeLock.readLock().unlock();
        }
        ByteBuffer valueBb = null;
        if (!loadValue && !loadMetadata) {
            try {
                MarshallableEntry<K, V> marshallableEntry = this.entryFactory.create(key);
                return marshallableEntry;
            }
            finally {
                fe.unlock();
            }
        }
        try {
            data = new byte[fe.keyLen + fe.dataLen + (loadMetadata ? fe.metadataLen + fe.internalMetadataLen : 0)];
            this.channel.read(java.nio.ByteBuffer.wrap(data), fe.offset + 28L);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            fe.unlock();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Read entry %s at %d:%d", key, fe.offset, fe.actualSize());
        }
        ByteBufferFactory factory = this.ctx.getByteBufferFactory();
        ByteBuffer keyBb = factory.newByteBuffer(data, 0, fe.keyLen);
        if (loadValue) {
            valueBb = factory.newByteBuffer(data, fe.keyLen, fe.dataLen);
        }
        if (!loadMetadata) return this.entryFactory.create(keyBb, valueBb);
        long created = -1L;
        long lastUsed = -1L;
        ByteBuffer metadataBb = null;
        ByteBuffer internalMetadataBb = null;
        int offset = fe.keyLen + fe.dataLen;
        if (fe.metadataLen > 0) {
            int metaLength = fe.metadataLen - 16;
            metadataBb = factory.newByteBuffer(data, offset, metaLength);
            java.nio.ByteBuffer buffer = java.nio.ByteBuffer.wrap(data, offset += metaLength, 16);
            if (fe.expiryTime > 0L) {
                offset += 16;
                created = buffer.getLong();
                lastUsed = buffer.getLong();
            }
        }
        if (fe.internalMetadataLen <= 0) return this.entryFactory.create(keyBb, valueBb, metadataBb, internalMetadataBb, created, lastUsed);
        internalMetadataBb = factory.newByteBuffer(data, offset, fe.internalMetadataLen);
        return this.entryFactory.create(keyBb, valueBb, metadataBb, internalMetadataBb, created, lastUsed);
    }

    @Override
    public Flowable<K> publishKeys(Predicate<? super K> filter) {
        return Flowable.fromIterable(() -> {
            ArrayList<K> keys = new ArrayList<K>(this.entries.size());
            long now = this.ctx.getTimeService().wallClockTime();
            Map<K, FileEntry> map = this.entries;
            synchronized (map) {
                for (Map.Entry<K, FileEntry> e : this.entries.entrySet()) {
                    K key = e.getKey();
                    if (e.getValue().isExpired(now) || filter != null && !filter.test((K)key)) continue;
                    keys.add(key);
                }
            }
            return keys.iterator();
        });
    }

    @Override
    public Flowable<MarshallableEntry<K, V>> entryPublisher(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        if (fetchMetadata || fetchValue) {
            return Flowable.fromIterable(() -> {
                ArrayList<KeyValuePair> keysToLoad = new ArrayList<KeyValuePair>(this.entries.size());
                long now = this.ctx.getTimeService().wallClockTime();
                Map<K, FileEntry> map = this.entries;
                synchronized (map) {
                    for (Map.Entry<K, FileEntry> e : this.entries.entrySet()) {
                        if (filter != null && !filter.test((K)e.getKey()) || e.getValue().isExpired(now)) continue;
                        keysToLoad.add(new KeyValuePair<K, FileEntry>(e.getKey(), e.getValue()));
                    }
                }
                keysToLoad.sort(Comparator.comparingLong(o -> ((FileEntry)o.getValue()).offset));
                return keysToLoad.iterator();
            }).map(kvp -> {
                MarshallableEntry<K, V> entry = this._load(kvp.getKey(), fetchValue, fetchMetadata);
                if (entry == null) {
                    entry = this.entryFactory.getEmpty();
                }
                return entry;
            }).filter(me -> me != this.entryFactory.getEmpty());
        }
        return this.publishKeys(filter).map(k -> this.entryFactory.create(k));
    }

    private void processFreeEntries() {
        ArrayList<FileEntry> l = new ArrayList<FileEntry>(this.freeList);
        l.sort((o1, o2) -> {
            long diff = o1.offset - o2.offset;
            return diff == 0L ? 0 : (diff > 0L ? -1 : 1);
        });
        this.truncateFile(l);
        this.mergeFreeEntries(l);
    }

    private void truncateFile(List<FileEntry> entries) {
        FileEntry fe;
        long startTime = 0L;
        if (log.isTraceEnabled()) {
            startTime = this.timeService.wallClockTime();
        }
        int reclaimedSpace = 0;
        int removedEntries = 0;
        long truncateOffset = -1L;
        Iterator<FileEntry> it = entries.iterator();
        while (it.hasNext() && !(fe = it.next()).isLocked() && fe.offset + (long)fe.size == this.filePos) {
            truncateOffset = fe.offset;
            this.filePos = fe.offset;
            this.freeList.remove(fe);
            it.remove();
            reclaimedSpace += fe.size;
            ++removedEntries;
        }
        if (truncateOffset > 0L) {
            try {
                this.channel.truncate(truncateOffset);
            }
            catch (IOException e) {
                throw new PersistenceException("Error while truncating file", e);
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Removed entries: %d, Reclaimed Space: %d, Free Entries %d", removedEntries, reclaimedSpace, this.freeList.size());
            log.tracef("Time taken for truncateFile: %d (ms)", this.timeService.wallClockTime() - startTime);
        }
    }

    private void mergeFreeEntries(List<FileEntry> entries) {
        long startTime = 0L;
        if (log.isTraceEnabled()) {
            startTime = this.timeService.wallClockTime();
        }
        FileEntry lastEntry = null;
        FileEntry newEntry = null;
        int mergeCounter = 0;
        for (FileEntry fe : entries) {
            if (fe.isLocked()) continue;
            if (lastEntry != null && lastEntry.offset == fe.offset + (long)fe.size) {
                if (newEntry == null) {
                    newEntry = new FileEntry(fe.offset, fe.size + lastEntry.size);
                    this.freeList.remove(lastEntry);
                    ++mergeCounter;
                } else {
                    newEntry = new FileEntry(fe.offset, fe.size + newEntry.size);
                }
                this.freeList.remove(fe);
                ++mergeCounter;
            } else if (newEntry != null) {
                this.mergeAndLogEntry(newEntry, mergeCounter);
                newEntry = null;
                mergeCounter = 0;
            }
            lastEntry = fe;
        }
        if (newEntry != null) {
            this.mergeAndLogEntry(newEntry, mergeCounter);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Total time taken for mergeFreeEntries: " + (this.timeService.wallClockTime() - startTime) + " (ms)", new Object[0]);
        }
    }

    private void mergeAndLogEntry(FileEntry entry, int mergeCounter) {
        try {
            this.addNewFreeEntry(entry);
            if (log.isTraceEnabled()) {
                log.tracef("Merged %d entries at %d:%d, %d free entries", new Object[]{mergeCounter, entry.offset, entry.size, this.freeList.size()});
            }
        }
        catch (IOException e) {
            throw new PersistenceException("Could not add new merged entry", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener task) {
        long now = this.timeService.wallClockTime();
        ArrayList<KeyValuePair<K, FileEntry>> entriesToPurge = new ArrayList<KeyValuePair<K, FileEntry>>();
        Object object = this.entries;
        synchronized (object) {
            Iterator<Map.Entry<K, FileEntry>> it = this.entries.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<K, FileEntry> next = it.next();
                FileEntry fe = next.getValue();
                if (!fe.isExpired(now)) continue;
                it.remove();
                entriesToPurge.add(new KeyValuePair<K, FileEntry>(next.getKey(), fe));
            }
        }
        this.resizeLock.readLock().lock();
        try {
            Iterator it = entriesToPurge.iterator();
            while (it.hasNext()) {
                KeyValuePair next = (KeyValuePair)it.next();
                FileEntry fe = (FileEntry)next.getValue();
                if (!fe.isExpired(now)) continue;
                it.remove();
                try {
                    this.free(fe);
                }
                catch (Exception e) {
                    throw new PersistenceException(e);
                }
                if (task == null) continue;
                task.entryPurged(next.getKey());
            }
            object = this.freeList;
            synchronized (object) {
                this.processFreeEntries();
            }
        }
        finally {
            this.resizeLock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    Map<K, FileEntry> getEntries() {
        return this.entries;
    }

    SortedSet<FileEntry> getFreeList() {
        return this.freeList;
    }

    long getFileSize() {
        return this.filePos;
    }

    public SingleFileStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    private static class FileEntry
    implements Comparable<FileEntry> {
        final long offset;
        final int size;
        final int keyLen;
        final int dataLen;
        final int metadataLen;
        final int internalMetadataLen;
        final long expiryTime;
        transient int readers = 0;

        FileEntry(long offset, java.nio.ByteBuffer buf) {
            this.offset = offset;
            this.size = buf.getInt();
            this.keyLen = buf.getInt();
            this.dataLen = buf.getInt();
            this.metadataLen = buf.getInt();
            this.internalMetadataLen = buf.getInt();
            this.expiryTime = buf.getLong();
        }

        FileEntry(long offset, int size) {
            this(offset, size, 0, 0, 0, 0, -1L);
        }

        FileEntry(long offset, int size, int keyLen, int dataLen, int metadataLen, int internalMetadataLen, long expiryTime) {
            this.offset = offset;
            this.size = size;
            this.keyLen = keyLen;
            this.dataLen = dataLen;
            this.metadataLen = metadataLen;
            this.internalMetadataLen = internalMetadataLen;
            this.expiryTime = expiryTime;
        }

        synchronized boolean isLocked() {
            return this.readers > 0;
        }

        synchronized void lock() {
            ++this.readers;
        }

        synchronized void unlock() {
            --this.readers;
            if (this.readers == 0) {
                this.notifyAll();
            }
        }

        synchronized void waitUnlocked() {
            while (this.readers > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        boolean isExpired(long now) {
            return this.expiryTime > 0L && this.expiryTime < now;
        }

        int actualSize() {
            return 28 + this.keyLen + this.dataLen + this.metadataLen + this.internalMetadataLen;
        }

        void writeToBuf(java.nio.ByteBuffer buf) {
            buf.putInt(this.size);
            buf.putInt(this.keyLen);
            buf.putInt(this.dataLen);
            buf.putInt(this.metadataLen);
            buf.putInt(this.internalMetadataLen);
            buf.putLong(this.expiryTime);
        }

        @Override
        public int compareTo(FileEntry fe) {
            int diff = this.size - fe.size;
            if (diff != 0) {
                return diff;
            }
            return this.offset < fe.offset ? -1 : (this.offset == fe.offset ? 0 : 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileEntry fileEntry = (FileEntry)o;
            if (this.offset != fileEntry.offset) {
                return false;
            }
            return this.size == fileEntry.size;
        }

        public int hashCode() {
            int result = (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + this.size;
            return result;
        }

        public String toString() {
            return "FileEntry@" + this.offset + "{size=" + this.size + ", actual=" + this.actualSize() + '}';
        }
    }
}

