/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.infinispan;

import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.processor.infinispan.AbstractInfinispanLogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.infinispan.InfinispanTransaction;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.relational.TableId;
import java.util.Objects;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedInfinispanLogMinerEventProcessor
extends AbstractInfinispanLogMinerEventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedInfinispanLogMinerEventProcessor.class);
    private final EmbeddedCacheManager cacheManager;
    private final boolean dropBufferOnStop;
    private final Cache<String, InfinispanTransaction> transactionCache;
    private final Cache<String, LogMinerEvent> eventCache;
    private final Cache<String, String> processedTransactionsCache;
    private final Cache<String, String> schemaChangesCache;

    public EmbeddedInfinispanLogMinerEventProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<TableId> dispatcher, OraclePartition partition, OracleOffsetContext offsetContext, OracleDatabaseSchema schema, OracleStreamingChangeEventSourceMetrics metrics) {
        super(context, connectorConfig, jdbcConnection, dispatcher, partition, offsetContext, schema, metrics);
        LOGGER.info("Using Infinispan in embedded mode.");
        this.cacheManager = new DefaultCacheManager();
        this.dropBufferOnStop = connectorConfig.isLogMiningBufferDropOnStop();
        this.transactionCache = this.createCache("transactions", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_TRANSACTIONS);
        this.processedTransactionsCache = this.createCache("processed-transactions", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_PROCESSED_TRANSACTIONS);
        this.schemaChangesCache = this.createCache("schema-changes", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_SCHEMA_CHANGES);
        this.eventCache = this.createCache("events", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_EVENTS);
        this.displayCacheStatistics();
    }

    @Override
    public void close() throws Exception {
        if (this.dropBufferOnStop) {
            LOGGER.info("Clearing infinispan caches");
            this.transactionCache.clear();
            this.eventCache.clear();
            this.schemaChangesCache.clear();
            this.processedTransactionsCache.clear();
            this.cacheManager.administration().removeCache("transactions");
            this.cacheManager.administration().removeCache("processed-transactions");
            this.cacheManager.administration().removeCache("schema-changes");
            this.cacheManager.administration().removeCache("events");
        }
        LOGGER.info("Shutting down infinispan embedded caches");
        this.cacheManager.close();
    }

    @Override
    public BasicCache<String, InfinispanTransaction> getTransactionCache() {
        return this.transactionCache;
    }

    @Override
    public BasicCache<String, LogMinerEvent> getEventCache() {
        return this.eventCache;
    }

    @Override
    public BasicCache<String, String> getSchemaChangesCache() {
        return this.schemaChangesCache;
    }

    @Override
    public BasicCache<String, String> getProcessedTransactionsCache() {
        return this.processedTransactionsCache;
    }

    @Override
    protected Scn getTransactionCacheMinimumScn() {
        Scn minimumScn = Scn.NULL;
        try (CloseableIterator iterator = this.transactionCache.values().iterator();){
            while (iterator.hasNext()) {
                Scn transactionScn = ((InfinispanTransaction)iterator.next()).getStartScn();
                if (minimumScn.isNull()) {
                    minimumScn = transactionScn;
                    continue;
                }
                if (transactionScn.compareTo(minimumScn) >= 0) continue;
                minimumScn = transactionScn;
            }
        }
        return minimumScn;
    }

    private <K, V> Cache<K, V> createCache(String cacheName, OracleConnectorConfig connectorConfig, Field field) {
        Objects.requireNonNull(cacheName);
        String cacheConfiguration = connectorConfig.getConfig().getString(field);
        Objects.requireNonNull(cacheConfiguration);
        this.cacheManager.defineConfiguration(cacheName, ((ConfigurationBuilder)new ParserRegistry().parse(cacheConfiguration).getNamedConfigurationBuilders().get(cacheName)).build());
        return this.cacheManager.getCache(cacheName);
    }
}

