/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.BlobChunkList;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.events.DmlEvent;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.connector.oracle.logminer.events.LobWriteEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.SelectLobLocatorEvent;
import io.debezium.function.BlockingConsumer;
import io.debezium.relational.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCommitConsumer
implements AutoCloseable,
BlockingConsumer<LogMinerEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionCommitConsumer.class);
    private final BlockingConsumer<LogMinerEvent> delegate;
    private final OracleConnectorConfig connectorConfig;
    private final OracleDatabaseSchema schema;
    private final List<String> lobWriteData;
    private LogMinerEvent lastEvent;
    private SelectLobLocatorEvent lastSelectLobLocatorEvent;
    private LobState lobState;

    public TransactionCommitConsumer(BlockingConsumer<LogMinerEvent> delegate, OracleConnectorConfig connectorConfig, OracleDatabaseSchema schema) {
        this.delegate = delegate;
        this.lobState = LobState.OTHER;
        this.lobWriteData = new ArrayList<String>();
        this.connectorConfig = connectorConfig;
        this.schema = schema;
    }

    @Override
    public void close() throws InterruptedException {
        if (this.lastEvent != null) {
            if (!this.lobWriteData.isEmpty()) {
                this.mergeLobWriteData(this.lastEvent);
            }
            this.dispatchChangeEvent(this.lastEvent);
        }
    }

    public void accept(LogMinerEvent event) throws InterruptedException {
        if (!this.connectorConfig.isLobEnabled()) {
            this.dispatchChangeEvent(event);
            return;
        }
        if (this.lastEvent == null) {
            this.lastEvent = event;
            if (EventType.SELECT_LOB_LOCATOR == event.getEventType()) {
                this.lastSelectLobLocatorEvent = (SelectLobLocatorEvent)event;
            }
        } else {
            LobState currentLobState = this.resolveLobStateByCurrentEvent(event);
            if (currentLobState != this.lobState) {
                if (this.lobState == LobState.WRITE) {
                    this.mergeLobWriteData(this.lastEvent);
                }
                this.lobState = currentLobState;
            }
            if (!this.isMerged(event, this.lastEvent)) {
                LOGGER.trace("\tMerged skipped.");
                this.dispatchChangeEvent(this.lastEvent);
                this.lastEvent = event;
            } else {
                LOGGER.trace("\tMerged successfully.");
            }
        }
    }

    private void dispatchChangeEvent(LogMinerEvent event) throws InterruptedException {
        LOGGER.trace("\tEmitting event {} {}", (Object)event.getEventType(), (Object)event);
        this.delegate.accept((Object)event);
    }

    private LobState resolveLobStateByCurrentEvent(LogMinerEvent event) {
        switch (event.getEventType()) {
            case LOB_WRITE: {
                return LobState.WRITE;
            }
            case LOB_ERASE: {
                return LobState.ERASE;
            }
        }
        return LobState.OTHER;
    }

    private boolean isMerged(LogMinerEvent event, LogMinerEvent prevEvent) {
        LOGGER.trace("\tVerifying merge eligibility for event {} with {}", (Object)event.getEventType(), (Object)prevEvent.getEventType());
        if (EventType.SELECT_LOB_LOCATOR == event.getEventType()) {
            SelectLobLocatorEvent locatorEvent;
            this.lastSelectLobLocatorEvent = locatorEvent = (SelectLobLocatorEvent)event;
            if (EventType.INSERT == prevEvent.getEventType()) {
                if (this.isForSameTableOrScn(event, prevEvent)) {
                    LOGGER.trace("\tMerging SEL_LOB_LOCATOR with previous INSERT event");
                    return true;
                }
            } else if (EventType.UPDATE == prevEvent.getEventType()) {
                if (this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                    LOGGER.trace("\tUpdating SEL_LOB_LOCATOR column '{}' to previous UPDATE event", (Object)locatorEvent.getColumnName());
                    return true;
                }
            } else if (EventType.SELECT_LOB_LOCATOR == prevEvent.getEventType() && this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                LOGGER.trace("\tAdding column '{}' to previous SEL_LOB_LOCATOR event", (Object)locatorEvent.getColumnName());
                return true;
            }
        } else {
            if (EventType.LOB_WRITE == event.getEventType()) {
                LobWriteEvent writeEvent = (LobWriteEvent)event;
                if (this.lastSelectLobLocatorEvent.isBinary() && !writeEvent.getData().startsWith("HEXTORAW('") && !writeEvent.getData().endsWith("')")) {
                    throw new DebeziumException("Unexpected LOB data chunk: " + writeEvent.getData());
                }
                LOGGER.trace("\tAdded LOB_WRITE data to internal LOB queue.");
                this.lobWriteData.add(writeEvent.getData());
                return true;
            }
            if (EventType.LOB_ERASE == event.getEventType()) {
                LOGGER.warn("\tLOB_ERASE for table '{}' column '{}' is not supported.", (Object)this.lastSelectLobLocatorEvent.getTableId(), (Object)this.lastSelectLobLocatorEvent.getColumnName());
                LOGGER.trace("\tSkipped LOB_ERASE, treated as merged.");
                return true;
            }
            if (EventType.LOB_TRIM == event.getEventType()) {
                LOGGER.trace("\tSkipped LOB_TRIM, treated as merged.");
                return true;
            }
            if (EventType.INSERT == event.getEventType() || EventType.UPDATE == event.getEventType()) {
                if (EventType.INSERT == prevEvent.getEventType()) {
                    if (EventType.UPDATE == event.getEventType() && this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                        LOGGER.trace("\tMerging UPDATE event with previous INSERT event");
                        this.mergeNewColumns((DmlEvent)event, (DmlEvent)prevEvent);
                        return true;
                    }
                } else if (EventType.UPDATE == prevEvent.getEventType()) {
                    if (EventType.UPDATE == event.getEventType() && this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                        LOGGER.trace("\tMerging UPDATE event with previous UPDATE event");
                        this.mergeNewColumns((DmlEvent)event, (DmlEvent)prevEvent);
                        return true;
                    }
                } else if (EventType.SELECT_LOB_LOCATOR == prevEvent.getEventType() && EventType.UPDATE == event.getEventType() && this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                    for (int i = 0; i < ((DmlEvent)event).getDmlEntry().getNewValues().length; ++i) {
                        Object value = ((DmlEvent)event).getDmlEntry().getNewValues()[i];
                        Object prevValue = ((DmlEvent)prevEvent).getDmlEntry().getNewValues()[i];
                        if (prevValue != null || value == null) continue;
                        LOGGER.trace("\tAdding column index {} to previous SEL_LOB_LOCATOR event", (Object)i);
                        ((DmlEvent)prevEvent).getDmlEntry().getNewValues()[i] = value;
                    }
                    return true;
                }
            }
        }
        LOGGER.trace("\tEvent {} is for a different row, merge skipped.", (Object)event.getEventType());
        return false;
    }

    private void mergeLobWriteData(LogMinerEvent event) {
        Object data = this.lastSelectLobLocatorEvent.isBinary() ? new BlobChunkList(this.lobWriteData) : String.join((CharSequence)"", this.lobWriteData);
        DmlEvent dmlEvent = (DmlEvent)event;
        String columnName = this.lastSelectLobLocatorEvent.getColumnName();
        int columnIndex = this.getSelectLobLocatorColumnIndex();
        LOGGER.trace("\tSet LOB data for column '{}' on table {} in event {}", new Object[]{columnName, event.getTableId(), event.getEventType()});
        dmlEvent.getDmlEntry().getNewValues()[columnIndex] = data;
        this.lobWriteData.clear();
    }

    private int getSelectLobLocatorColumnIndex() {
        String columnName = this.lastSelectLobLocatorEvent.getColumnName();
        return LogMinerHelper.getColumnIndexByName(columnName, this.schema.tableFor(this.lastSelectLobLocatorEvent.getTableId()));
    }

    private boolean isForSameTableOrScn(LogMinerEvent event, LogMinerEvent prevEvent) {
        if (prevEvent != null) {
            if (event.getTableId().equals((Object)prevEvent.getTableId())) {
                return true;
            }
            return event.getScn().equals(prevEvent.getScn()) && event.getRsId().equals(prevEvent.getRsId());
        }
        return false;
    }

    private boolean isSameTableRow(LogMinerEvent event, LogMinerEvent prevEvent) {
        Table table = this.schema.tableFor(event.getTableId());
        if (table == null) {
            LOGGER.trace("Unable to locate table '{}' schema, unable to detect if same row.", (Object)event.getTableId());
            return false;
        }
        for (String columnName : table.primaryKeyColumnNames()) {
            int position = LogMinerHelper.getColumnIndexByName(columnName, table);
            Object prevValue = ((DmlEvent)prevEvent).getDmlEntry().getNewValues()[position];
            if (prevValue == null) {
                throw new DebeziumException("Could not find column " + columnName + " in previous event");
            }
            Object value = ((DmlEvent)event).getDmlEntry().getNewValues()[position];
            if (value == null) {
                throw new DebeziumException("Could not find column " + columnName + " in event");
            }
            if (Objects.equals(value, prevValue)) continue;
            return false;
        }
        return true;
    }

    private void mergeNewColumns(DmlEvent event, DmlEvent prevEvent) {
        boolean prevEventIsInsert = EventType.INSERT == prevEvent.getEventType();
        for (int i = 0; i < event.getDmlEntry().getNewValues().length; ++i) {
            Object value = event.getDmlEntry().getNewValues()[i];
            Object prevValue = prevEvent.getDmlEntry().getNewValues()[i];
            if (prevEventIsInsert && "EMPTY_CLOB()".equals(prevValue)) {
                LOGGER.trace("\tAssigning column index {} with updated CLOB value.", (Object)i);
                prevEvent.getDmlEntry().getNewValues()[i] = value;
                continue;
            }
            if (prevEventIsInsert && "EMPTY_BLOB()".equals(prevValue)) {
                LOGGER.trace("\tAssigning column index {} with updated BLOB value.", (Object)i);
                prevEvent.getDmlEntry().getNewValues()[i] = value;
                continue;
            }
            if (!prevEventIsInsert && OracleValueConverters.UNAVAILABLE_VALUE.equals(value)) {
                LOGGER.trace("\tSkipped column index {} with unavailable column value.", (Object)i);
                continue;
            }
            if (prevEventIsInsert || value == null) continue;
            LOGGER.trace("\tUpdating column index {} in previous event", (Object)i);
            prevEvent.getDmlEntry().getNewValues()[i] = value;
        }
    }

    static enum LobState {
        WRITE,
        ERASE,
        OTHER;

    }
}

