/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.infinispan;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.processor.TransactionCache;
import io.debezium.connector.oracle.logminer.processor.infinispan.InfinispanTransaction;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;

public class InfinispanTransactionCache
implements TransactionCache<InfinispanTransaction, Map.Entry<String, InfinispanTransaction>> {
    private final Cache<String, InfinispanTransaction> cache;

    public InfinispanTransactionCache(Cache<String, InfinispanTransaction> cache) {
        this.cache = cache;
    }

    @Override
    public InfinispanTransaction get(String transactionId) {
        return (InfinispanTransaction)this.cache.get((Object)transactionId);
    }

    @Override
    public void put(String transactionId, InfinispanTransaction transaction) {
        this.cache.put((Object)transactionId, (Object)transaction);
    }

    @Override
    public InfinispanTransaction remove(String transactionId) {
        return (InfinispanTransaction)this.cache.remove((Object)transactionId);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public Iterator<Map.Entry<String, InfinispanTransaction>> iterator() {
        return this.cache.entrySet().iterator();
    }

    @Override
    public Scn getMinimumScn() {
        Scn minimumScn = Scn.NULL;
        try (CloseableIterator iterator = this.cache.values().iterator();){
            while (iterator.hasNext()) {
                Scn transactionScn = ((InfinispanTransaction)iterator.next()).getStartScn();
                if (minimumScn.isNull()) {
                    minimumScn = transactionScn;
                    continue;
                }
                if (transactionScn.compareTo(minimumScn) >= 0) continue;
                minimumScn = transactionScn;
            }
        }
        return minimumScn;
    }

    @Override
    public void close() throws Exception {
        this.cache.stop();
    }
}

