/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.CompletionStages;

public abstract class BaseBlockingRunnable
implements BlockingRunnable {
    protected final BasePerCacheInboundInvocationHandler handler;
    protected final CacheRpcCommand command;
    protected final Reply reply;
    protected final boolean sync;
    protected Response response;

    protected BaseBlockingRunnable(BasePerCacheInboundInvocationHandler handler, CacheRpcCommand command, Reply reply, boolean sync) {
        this.handler = handler;
        this.command = command;
        this.reply = reply;
        this.sync = sync;
    }

    @Override
    public void run() {
        if (this.sync) {
            this.runSync();
        } else {
            this.runAsync();
        }
    }

    private void runSync() {
        try {
            CompletionStage<CacheNotFoundResponse> beforeStage = this.beforeInvoke();
            if (beforeStage != null) {
                this.response = CompletionStages.join(beforeStage);
                if (this.response != null) {
                    this.afterInvoke();
                    return;
                }
            }
            CompletableFuture<Response> commandFuture = this.handler.invokeCommand(this.command);
            this.response = commandFuture.join();
            this.afterInvoke();
        }
        catch (Throwable t) {
            this.afterCommandException(this.unwrap(t));
        }
        finally {
            if (this.handler.isStopped()) {
                this.response = CacheNotFoundResponse.INSTANCE;
            }
            this.reply.reply(this.response);
            this.onFinally();
        }
    }

    private void runAsync() {
        CompletionStage<CacheNotFoundResponse> beforeStage = this.beforeInvoke();
        if (beforeStage == null) {
            this.invoke();
        } else {
            beforeStage.whenComplete((rsp, throwable) -> {
                if (rsp != null) {
                    this.response = rsp;
                    this.afterInvoke();
                    if (this.handler.isStopped()) {
                        rsp = CacheNotFoundResponse.INSTANCE;
                        this.response = rsp;
                    }
                    this.reply.reply((Response)rsp);
                    this.onFinally();
                } else if (throwable != null) {
                    this.afterCommandException(this.unwrap((Throwable)throwable));
                    if (this.handler.isStopped()) {
                        this.response = CacheNotFoundResponse.INSTANCE;
                    }
                    this.reply.reply(this.response);
                    this.onFinally();
                } else {
                    this.invoke();
                }
            });
        }
    }

    private void invoke() {
        CompletableFuture<Response> commandFuture;
        try {
            commandFuture = this.handler.invokeCommand(this.command);
        }
        catch (Throwable t) {
            this.afterCommandException(this.unwrap(t));
            if (this.handler.isStopped()) {
                this.response = CacheNotFoundResponse.INSTANCE;
            }
            this.reply.reply(this.response);
            this.onFinally();
            return;
        }
        if (CompletionStages.isCompletedSuccessfully(commandFuture)) {
            this.invokedComplete(commandFuture.join(), null);
        } else {
            commandFuture.whenComplete(this::invokedComplete);
        }
    }

    private void invokedComplete(Response rsp, Throwable throwable) {
        try {
            if (throwable == null) {
                this.response = rsp;
                this.afterInvoke();
            } else {
                this.afterCommandException(this.unwrap(throwable));
            }
        }
        finally {
            if (this.handler.isStopped()) {
                this.response = CacheNotFoundResponse.INSTANCE;
            }
            this.reply.reply(this.response);
            this.onFinally();
        }
    }

    private Throwable unwrap(Throwable throwable) {
        if (throwable instanceof CompletionException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    private void afterCommandException(Throwable throwable) {
        this.response = throwable instanceof InterruptedException ? this.handler.interruptedException(this.command) : (throwable instanceof OutdatedTopologyException ? this.handler.outdatedTopology((OutdatedTopologyException)((Object)throwable)) : (throwable instanceof IllegalLifecycleStateException ? CacheNotFoundResponse.INSTANCE : this.handler.exceptionHandlingCommand(this.command, throwable)));
        this.onException(throwable);
    }

    protected void onFinally() {
    }

    protected void onException(Throwable throwable) {
    }

    protected void afterInvoke() {
    }

    protected CompletionStage<CacheNotFoundResponse> beforeInvoke() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("{command=").append(this.command);
        sb.append(", sync=").append(this.sync);
        sb.append('}');
        return sb.toString();
    }
}

