/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.infinispan.marshalling;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.Transaction;
import java.time.Instant;
import java.util.List;
import org.infinispan.protostream.annotations.ProtoAdapter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;

@ProtoAdapter(value=Transaction.class)
public class TransactionAdapter {
    @ProtoFactory
    public Transaction factory(String transactionId, String scn, String changeTime, List<LogMinerEvent> events, String userName, int numberOfEvents) {
        return new Transaction(transactionId, Scn.valueOf(scn), Instant.parse(changeTime), events, userName, numberOfEvents);
    }

    @ProtoField(number=1, required=true)
    public String getTransactionId(Transaction transaction) {
        return transaction.getTransactionId();
    }

    @ProtoField(number=2, required=true)
    public String getScn(Transaction transaction) {
        return transaction.getStartScn().toString();
    }

    @ProtoField(number=3, required=true)
    public String getChangeTime(Transaction transaction) {
        return transaction.getChangeTime().toString();
    }

    @ProtoField(number=4)
    public List<LogMinerEvent> getEvents(Transaction transaction) {
        return transaction.getEvents();
    }

    @ProtoField(number=5)
    public String getUserName(Transaction transaction) {
        return transaction.getUserName();
    }

    @ProtoField(number=6, defaultValue="0")
    public int getNumberOfEvents(Transaction transaction) {
        return transaction.getNumberOfEvents();
    }
}

