/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.events;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transaction.class);
    private static final String UNKNOWN = "UNKNOWN";
    private final String transactionId;
    private final Scn startScn;
    private final Instant changeTime;
    private final List<LogMinerEvent> events;
    private final String userName;
    private int numberOfEvents;

    public Transaction(String transactionId, Scn startScn, Instant changeTime, List<LogMinerEvent> events, String userName, int numberOfEvents) {
        this.transactionId = transactionId;
        this.startScn = startScn;
        this.changeTime = changeTime;
        this.events = events;
        this.userName = !UNKNOWN.equalsIgnoreCase(userName) ? userName : null;
        this.numberOfEvents = numberOfEvents;
    }

    public Transaction(String transactionId, Scn startScn, Instant changeTime, String userName) {
        this(transactionId, startScn, changeTime, new ArrayList<LogMinerEvent>(), userName, 0);
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Scn getStartScn() {
        return this.startScn;
    }

    public Instant getChangeTime() {
        return this.changeTime;
    }

    public List<LogMinerEvent> getEvents() {
        return this.events;
    }

    public int getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public int getNextEventId() {
        return this.numberOfEvents++;
    }

    public void started() {
        this.numberOfEvents = 0;
    }

    public void removeEventWithRowId(String rowId) {
        this.events.removeIf(event -> {
            if (event.getRowId().equals(rowId)) {
                LOGGER.trace("Undo applied for event {}.", event);
                return true;
            }
            return false;
        });
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return Objects.equals(this.transactionId, that.transactionId);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId);
    }

    public String toString() {
        return "Transaction{transactionId='" + this.transactionId + '\'' + ", startScn=" + this.startScn + ", userName='" + this.userName + ", numberOfEvents=" + this.numberOfEvents + "'}";
    }
}

