/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.xstream;

import io.debezium.connector.oracle.BaseChangeRecordEmitter;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Table;
import io.debezium.util.Clock;
import java.util.Map;
import oracle.streams.ColumnValue;
import oracle.streams.RowLCR;

public class XStreamChangeRecordEmitter
extends BaseChangeRecordEmitter<ColumnValue> {
    private final RowLCR lcr;
    private final Map<String, Object> oldChunkValues;
    private final Map<String, Object> newChunkValues;

    public XStreamChangeRecordEmitter(Partition partition, OffsetContext offset, RowLCR lcr, Map<String, Object> oldChunkValues, Map<String, Object> newChunkValues, Table table, Clock clock) {
        super(partition, offset, table, clock);
        this.lcr = lcr;
        this.oldChunkValues = oldChunkValues;
        this.newChunkValues = newChunkValues;
    }

    @Override
    protected Envelope.Operation getOperation() {
        switch (this.lcr.getCommandType()) {
            case "INSERT": {
                return Envelope.Operation.CREATE;
            }
            case "DELETE": {
                return Envelope.Operation.DELETE;
            }
            case "UPDATE": {
                return Envelope.Operation.UPDATE;
            }
        }
        throw new IllegalArgumentException("Received event of unexpected command type: " + this.lcr);
    }

    protected Object[] getOldColumnValues() {
        return this.getColumnValues(this.lcr.getOldValues(), this.oldChunkValues);
    }

    protected Object[] getNewColumnValues() {
        return this.getColumnValues(this.lcr.getNewValues(), this.newChunkValues);
    }

    private Object[] getColumnValues(ColumnValue[] columnValues, Map<String, Object> chunkValues) {
        Object[] values = new Object[this.table.columns().size()];
        for (ColumnValue columnValue : columnValues) {
            int index = this.table.columnWithName(columnValue.getColumnName()).position() - 1;
            values[index] = columnValue.getColumnData();
        }
        for (Map.Entry entry : chunkValues.entrySet()) {
            int index = this.table.columnWithName((String)entry.getKey()).position() - 1;
            values[index] = entry.getValue();
        }
        return values;
    }
}

