/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.oracle.BlobChunkList;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.logminer.UnistrHelper;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.ResultReceiver;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.time.MicroDuration;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.NumberConversions;
import io.debezium.util.Strings;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class OracleValueConverters
extends JdbcValueConverters {
    public static final Object UNAVAILABLE_VALUE = new Object();
    private static final Pattern INTERVAL_DAY_SECOND_PATTERN = Pattern.compile("([+\\-])?(\\d+) (\\d+):(\\d+):(\\d+).(\\d+)");
    private static final ZoneId GMT_ZONE_ID = ZoneId.of("GMT");
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).optionalEnd().toFormatter();
    private static final DateTimeFormatter TIMESTAMP_AM_PM_SHORT_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("dd-MMM-yy hh.mm.ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).optionalEnd().appendPattern(" a").toFormatter(Locale.ENGLISH);
    private static final DateTimeFormatter TIMESTAMP_TZ_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).optionalEnd().optionalStart().appendPattern(" ").optionalEnd().appendOffset("+HH:MM", "").toFormatter();
    private static final String EMPTY_BLOB_FUNCTION = "EMPTY_BLOB()";
    private static final String EMPTY_CLOB_FUNCTION = "EMPTY_CLOB()";
    private static final String HEXTORAW_FUNCTION_START = "HEXTORAW('";
    private static final String HEXTORAW_FUNCTION_END = "')";
    private static final Pattern TO_TIMESTAMP = Pattern.compile("TO_TIMESTAMP\\('(.*)'\\)", 2);
    private static final Pattern TO_TIMESTAMP_TZ = Pattern.compile("TO_TIMESTAMP_TZ\\('(.*)'\\)", 2);
    private static final Pattern TO_DATE = Pattern.compile("TO_DATE\\('(.*)',[ ]*'(.*)'\\)", 2);
    private final OracleConnection connection;
    private final boolean lobEnabled;
    private final byte[] unavailableValuePlaceholderBinary;
    private final String unavailableValuePlaceholderString;

    public OracleValueConverters(OracleConnectorConfig config, OracleConnection connection) {
        super(config.getDecimalMode(), config.getTemporalPrecisionMode(), ZoneOffset.UTC, null, null, null);
        this.connection = connection;
        this.lobEnabled = config.isLobEnabled();
        this.unavailableValuePlaceholderBinary = config.getUnavailableValuePlaceholder();
        this.unavailableValuePlaceholderString = new String(config.getUnavailableValuePlaceholder());
    }

    public SchemaBuilder schemaBuilder(Column column) {
        this.logger.debug("Building schema for column {} of type {} named {} with constraints ({},{})", new Object[]{column.name(), column.jdbcType(), column.typeName(), column.length(), column.scale()});
        switch (column.jdbcType()) {
            case 6: {
                return this.variableScaleSchema(column);
            }
            case 2: {
                return this.getNumericSchema(column);
            }
            case 100: {
                return SchemaBuilder.float32();
            }
            case 101: {
                return SchemaBuilder.float64();
            }
            case -102: 
            case -101: {
                return ZonedTimestamp.builder();
            }
            case -104: 
            case -103: {
                return MicroDuration.builder();
            }
            case 2002: {
                return SchemaBuilder.string();
            }
        }
        SchemaBuilder builder = super.schemaBuilder(column);
        this.logger.debug("JdbcValueConverters returned '{}' for column '{}'", (Object)(builder != null ? builder.getClass().getName() : null), (Object)column.name());
        return builder;
    }

    private SchemaBuilder getNumericSchema(Column column) {
        if (column.scale().isPresent()) {
            Integer scale = (Integer)column.scale().get();
            if (scale <= 0) {
                int width = column.length() - scale;
                if (width < 3) {
                    return SchemaBuilder.int8();
                }
                if (width < 5) {
                    return SchemaBuilder.int16();
                }
                if (width < 10) {
                    return SchemaBuilder.int32();
                }
                if (width < 19) {
                    return SchemaBuilder.int64();
                }
            }
            return super.schemaBuilder(column);
        }
        return this.variableScaleSchema(column);
    }

    private SchemaBuilder variableScaleSchema(Column column) {
        if (this.decimalMode == JdbcValueConverters.DecimalMode.PRECISE) {
            return VariableScaleDecimal.builder();
        }
        return SpecialValueDecimal.builder((JdbcValueConverters.DecimalMode)this.decimalMode, (int)column.length(), (int)column.scale().orElse(-1));
    }

    public ValueConverter converter(Column column, Field fieldDefn) {
        switch (column.jdbcType()) {
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 2002: 
            case 2005: {
                return data -> this.convertString(column, fieldDefn, data);
            }
            case 2004: {
                return data -> this.convertBinary(column, fieldDefn, data, this.binaryMode);
            }
            case 100: {
                return data -> this.convertFloat(column, fieldDefn, data);
            }
            case 101: {
                return data -> this.convertDouble(column, fieldDefn, data);
            }
            case 2: {
                return this.getNumericConverter(column, fieldDefn);
            }
            case 6: {
                return data -> this.convertVariableScale(column, fieldDefn, data);
            }
            case -102: 
            case -101: {
                return data -> this.convertTimestampWithZone(column, fieldDefn, data);
            }
            case -103: {
                return data -> this.convertIntervalYearMonth(column, fieldDefn, data);
            }
            case -104: {
                return data -> this.convertIntervalDaySecond(column, fieldDefn, data);
            }
            case -2: {
                return null;
            }
        }
        return super.converter(column, fieldDefn);
    }

    private ValueConverter getNumericConverter(Column column, Field fieldDefn) {
        if (column.scale().isPresent()) {
            Integer scale = (Integer)column.scale().get();
            if (scale <= 0) {
                int width = column.length() - scale;
                if (width < 3) {
                    return data -> this.convertNumericAsTinyInt(column, fieldDefn, data);
                }
                if (width < 5) {
                    return data -> this.convertNumericAsSmallInt(column, fieldDefn, data);
                }
                if (width < 10) {
                    return data -> this.convertNumericAsInteger(column, fieldDefn, data);
                }
                if (width < 19) {
                    return data -> this.convertNumericAsBigInteger(column, fieldDefn, data);
                }
            }
            return data -> this.convertNumeric(column, fieldDefn, data);
        }
        return data -> this.convertVariableScale(column, fieldDefn, data);
    }

    protected Object convertString(Column column, Field fieldDefn, Object data) {
        if (data instanceof CHAR) {
            return ((CHAR)data).stringValue();
        }
        if (data instanceof Clob) {
            if (!this.lobEnabled) {
                return null;
            }
            try {
                Clob clob = (Clob)data;
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (SQLException e) {
                throw new DebeziumException("Couldn't convert value for column " + column.name(), (Throwable)e);
            }
        }
        if (data instanceof String) {
            String s = (String)data;
            if (EMPTY_CLOB_FUNCTION.equals(s)) {
                return column.isOptional() ? null : "";
            }
            if (UnistrHelper.isUnistrFunction(s)) {
                return UnistrHelper.convert(s);
            }
        }
        if (data == UNAVAILABLE_VALUE) {
            return this.unavailableValuePlaceholderString;
        }
        return super.convertString(column, fieldDefn, data);
    }

    protected Object convertBinary(Column column, Field fieldDefn, Object data, CommonConnectorConfig.BinaryHandlingMode mode) {
        try {
            if (data instanceof String) {
                String str = (String)data;
                if (EMPTY_BLOB_FUNCTION.equals(str)) {
                    if (column.isOptional()) {
                        return null;
                    }
                    data = "";
                } else if (this.isHexToRawFunctionCall(str)) {
                    data = RAW.hexString2Bytes((String)this.getHexToRawHexString(str));
                }
            } else if (data instanceof BlobChunkList) {
                if (!this.lobEnabled) {
                    return null;
                }
                data = this.convertBlobChunkList((BlobChunkList)data);
            } else if (data instanceof Blob) {
                if (!this.lobEnabled) {
                    return null;
                }
                Blob blob = (Blob)data;
                data = blob.getBytes(1L, Long.valueOf(blob.length()).intValue());
            }
            if (data == UNAVAILABLE_VALUE) {
                data = this.unavailableValuePlaceholderBinary;
            }
            return super.convertBinary(column, fieldDefn, data, mode);
        }
        catch (SQLException e) {
            throw new DebeziumException("Couldn't convert value for column " + column.name(), (Throwable)e);
        }
    }

    private byte[] convertBlobChunkList(BlobChunkList chunks) throws SQLException {
        if (chunks.isEmpty()) {
            return null;
        }
        StringBuilder hexString = new StringBuilder();
        for (String chunk : chunks) {
            hexString.append(this.getHexToRawHexString(chunk));
        }
        return RAW.hexString2Bytes((String)hexString.toString());
    }

    protected Object convertInteger(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).intValue();
            }
            catch (SQLException e) {
                throw new DebeziumException("Couldn't convert value for column " + column.name(), (Throwable)e);
            }
        }
        return super.convertInteger(column, fieldDefn, data);
    }

    protected Object convertFloat(Column column, Field fieldDefn, Object data) {
        if (data instanceof Float) {
            return data;
        }
        if (data instanceof NUMBER) {
            return Float.valueOf(((NUMBER)data).floatValue());
        }
        if (data instanceof BINARY_FLOAT) {
            try {
                return Float.valueOf(((BINARY_FLOAT)data).floatValue());
            }
            catch (SQLException e) {
                throw new DebeziumException("Couldn't convert value for column " + column.name(), (Throwable)e);
            }
        }
        if (data instanceof String) {
            return Float.valueOf(Float.parseFloat((String)data));
        }
        return super.convertFloat(column, fieldDefn, data);
    }

    protected Object convertDouble(Column column, Field fieldDefn, Object data) {
        if (data instanceof BINARY_DOUBLE) {
            try {
                return ((BINARY_DOUBLE)data).doubleValue();
            }
            catch (SQLException e) {
                throw new DebeziumException("Couldn't convert value for column " + column.name(), (Throwable)e);
            }
        }
        if (data instanceof String) {
            return Double.parseDouble((String)data);
        }
        return super.convertDouble(column, fieldDefn, data);
    }

    protected Object convertDecimal(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).bigDecimalValue();
            }
            catch (SQLException e) {
                throw new DebeziumException("Couldn't convert value for column " + column.name(), (Throwable)e);
            }
        }
        if (data instanceof String) {
            data = this.toBigDecimal(column, fieldDefn, data);
        }
        if (data instanceof BigDecimal) {
            data = this.withScaleAdjustedIfNeeded(column, (BigDecimal)data);
        }
        return super.convertDecimal(column, fieldDefn, data);
    }

    protected Object convertNumeric(Column column, Field fieldDefn, Object data) {
        return this.convertDecimal(column, fieldDefn, data);
    }

    protected Object convertNumericAsTinyInt(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).byteValue();
            }
            catch (SQLException e) {
                throw new DebeziumException("Couldn't convert value for column " + column.name(), (Throwable)e);
            }
        }
        return this.convertTinyInt(column, fieldDefn, data);
    }

    protected Object convertNumericAsSmallInt(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).shortValue();
            }
            catch (SQLException e) {
                throw new DebeziumException("Couldn't convert value for column " + column.name(), (Throwable)e);
            }
        }
        return super.convertSmallInt(column, fieldDefn, data);
    }

    protected Object convertNumericAsInteger(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).intValue();
            }
            catch (SQLException e) {
                throw new DebeziumException("Couldn't convert value for column " + column.name(), (Throwable)e);
            }
        }
        return super.convertInteger(column, fieldDefn, data);
    }

    protected Object convertNumericAsBigInteger(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).longValue();
            }
            catch (SQLException e) {
                throw new DebeziumException("Couldn't convert value for column " + column.name(), (Throwable)e);
            }
        }
        return super.convertBigInt(column, fieldDefn, data);
    }

    protected Object convertBoolean(Column column, Field fieldDefn, Object data) {
        if (data instanceof BigDecimal) {
            return ((BigDecimal)data).byteValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof String) {
            return Byte.parseByte((String)data) == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof NUMBER) {
            try {
                return ((NUMBER)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            catch (SQLException e) {
                throw new DebeziumException("Couldn't convert value for column " + column.name(), (Throwable)e);
            }
        }
        return super.convertBoolean(column, fieldDefn, data);
    }

    protected Object convertTinyInt(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.BYTE_FALSE, r -> {
            if (data instanceof Byte) {
                r.deliver(data);
            } else if (data instanceof Number) {
                Number value = (Number)data;
                r.deliver((Object)value.byteValue());
            } else if (data instanceof Boolean) {
                r.deliver((Object)NumberConversions.getByte((boolean)((Boolean)data)));
            } else if (data instanceof String) {
                r.deliver((Object)Byte.parseByte((String)data));
            }
        });
    }

    protected Object convertVariableScale(Column column, Field fieldDefn, Object data) {
        if ((data = this.convertNumeric(column, fieldDefn, data)) == null) {
            return null;
        }
        if (this.decimalMode == JdbcValueConverters.DecimalMode.PRECISE) {
            if (data instanceof SpecialValueDecimal) {
                return VariableScaleDecimal.fromLogical((Schema)fieldDefn.schema(), (SpecialValueDecimal)((SpecialValueDecimal)data));
            }
            if (data instanceof BigDecimal) {
                return VariableScaleDecimal.fromLogical((Schema)fieldDefn.schema(), (SpecialValueDecimal)new SpecialValueDecimal((BigDecimal)data));
            }
        } else {
            return data;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object fromOracleTimeClasses(Column column, Object data) {
        try {
            if (data instanceof TIMESTAMP) {
                data = ((TIMESTAMP)data).timestampValue();
            } else if (data instanceof DATE) {
                data = ((DATE)data).timestampValue();
            } else if (data instanceof TIMESTAMPTZ) {
                TIMESTAMPTZ ts = (TIMESTAMPTZ)data;
                data = ZonedDateTime.ofInstant(ts.timestampValue(this.connection.connection()).toInstant(), ts.getTimeZone().toZoneId());
            } else if (data instanceof TIMESTAMPLTZ) {
                TIMESTAMPLTZ ts = (TIMESTAMPLTZ)data;
                data = ZonedDateTime.ofInstant(ts.timestampValue(this.connection.connection()).toInstant(), ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC);
            }
        }
        catch (SQLException e) {
            throw new DebeziumException("Couldn't convert value for column " + column.name(), (Throwable)e);
        }
        return data;
    }

    protected Object convertTimestampToEpochMillisAsDate(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            data = this.resolveTimestampStringAsInstant((String)data);
        }
        return super.convertTimestampToEpochMillisAsDate(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    protected Object convertTimestampToEpochMicros(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            return data;
        }
        if (data instanceof String) {
            data = this.resolveTimestampStringAsInstant((String)data);
        }
        return super.convertTimestampToEpochMicros(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    protected Object convertTimestampToEpochMillis(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            data = this.resolveTimestampStringAsInstant((String)data);
        }
        return super.convertTimestampToEpochMillis(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    protected Object convertTimestampToEpochNanos(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            data = this.resolveTimestampStringAsInstant((String)data);
        }
        return super.convertTimestampToEpochNanos(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    private Instant resolveTimestampStringAsInstant(String data) {
        Matcher toTimestampMatcher = TO_TIMESTAMP.matcher(data);
        if (toTimestampMatcher.matches()) {
            String dateText = toTimestampMatcher.group(1);
            LocalDateTime dateTime = dateText.indexOf(" AM") > 0 || dateText.indexOf(" PM") > 0 ? LocalDateTime.from(TIMESTAMP_AM_PM_SHORT_FORMATTER.parse(dateText.trim())) : LocalDateTime.from(TIMESTAMP_FORMATTER.parse(dateText.trim()));
            return dateTime.atZone(GMT_ZONE_ID).toInstant();
        }
        Matcher toDateMatcher = TO_DATE.matcher(data);
        if (toDateMatcher.matches()) {
            LocalDateTime dateTime = LocalDateTime.from(TIMESTAMP_FORMATTER.parse(toDateMatcher.group(1)));
            return dateTime.atZone(GMT_ZONE_ID).toInstant();
        }
        return null;
    }

    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object data) {
        Matcher toTimestampTzMatcher;
        if (data instanceof String && (toTimestampTzMatcher = TO_TIMESTAMP_TZ.matcher((String)data)).matches()) {
            String dateText = toTimestampTzMatcher.group(1);
            data = ZonedDateTime.from(TIMESTAMP_TZ_FORMATTER.parse(dateText.trim()));
        }
        return super.convertTimestampWithZone(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    protected Object convertIntervalYearMonth(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.LONG_FALSE, r -> {
            if (data instanceof Number) {
                r.deliver((Object)((Number)data).longValue());
            } else if (data instanceof INTERVALYM) {
                this.convertOracleIntervalYearMonth(data, r);
            } else if (data instanceof String) {
                String value = (String)data;
                INTERVALYM interval = new INTERVALYM(value.substring(15, value.length() - 2));
                this.convertOracleIntervalYearMonth(interval, r);
            }
        });
    }

    private void convertOracleIntervalYearMonth(Object data, ResultReceiver r) {
        String interval = ((INTERVALYM)data).stringValue();
        int sign = 1;
        int start = 0;
        if (interval.charAt(0) == '-') {
            sign = -1;
            start = 1;
        }
        for (int i = 1; i < interval.length(); ++i) {
            if (interval.charAt(i) != '-') continue;
            int year = sign * Integer.parseInt(interval.substring(start, i));
            int month = sign * Integer.parseInt(interval.substring(i + 1, interval.length()));
            r.deliver((Object)MicroDuration.durationMicros((int)year, (int)month, (int)0, (int)0, (int)0, (double)0.0, (Double)30.4375));
        }
    }

    protected Object convertIntervalDaySecond(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.LONG_FALSE, r -> {
            if (data instanceof Number) {
                r.deliver((Object)((Number)data).longValue());
            } else if (data instanceof INTERVALDS) {
                this.convertOracleIntervalDaySecond(data, r);
            } else if (data instanceof String) {
                String value = (String)data;
                INTERVALDS interval = new INTERVALDS(value.substring(15, value.length() - 2));
                this.convertOracleIntervalDaySecond(interval, r);
            }
        });
    }

    private void convertOracleIntervalDaySecond(Object data, ResultReceiver r) {
        String interval = ((INTERVALDS)data).stringValue();
        Matcher m = INTERVAL_DAY_SECOND_PATTERN.matcher(interval);
        if (m.matches()) {
            int sign = "-".equals(m.group(1)) ? -1 : 1;
            r.deliver((Object)MicroDuration.durationMicros((int)0, (int)0, (int)(sign * Integer.valueOf(m.group(2))), (int)(sign * Integer.valueOf(m.group(3))), (int)(sign * Integer.valueOf(m.group(4))), (double)(sign * Integer.valueOf(m.group(5))), (int)(sign * Integer.valueOf(Strings.pad((String)m.group(6), (int)6, (char)'0'))), (Double)30.4375));
        }
    }

    private String getHexToRawHexString(String hexToRawValue) {
        if (this.isHexToRawFunctionCall(hexToRawValue)) {
            return hexToRawValue.substring(10, hexToRawValue.length() - 2);
        }
        return hexToRawValue;
    }

    private boolean isHexToRawFunctionCall(String value) {
        return value != null && value.startsWith(HEXTORAW_FUNCTION_START) && value.endsWith(HEXTORAW_FUNCTION_END);
    }
}

