/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.infinispan.marshalling;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.events.DmlEvent;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.connector.oracle.logminer.events.LobEraseEvent;
import io.debezium.connector.oracle.logminer.events.LobWriteEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.SelectLobLocatorEvent;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntryImpl;
import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.time.Instant;
import org.infinispan.protostream.annotations.ProtoAdapter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;

@ProtoAdapter(value=LogMinerEvent.class)
public class LogMinerEventAdapter {
    @ProtoFactory
    public LogMinerEvent factory(int eventType, String scn, String tableId, String rowId, String rsId, String changeTime, LogMinerDmlEntryImpl entry, String columnName, Boolean binary, String data) {
        EventType type = EventType.from(eventType);
        Scn eventScn = Scn.valueOf(scn);
        TableId id = Strings.isNullOrEmpty((String)tableId) ? null : TableId.parse((String)tableId);
        Instant time = Strings.isNullOrEmpty((String)changeTime) ? null : Instant.parse(changeTime);
        switch (type) {
            case INSERT: 
            case UPDATE: 
            case DELETE: {
                return new DmlEvent(type, eventScn, id, rowId, rsId, time, entry);
            }
            case SELECT_LOB_LOCATOR: {
                return new SelectLobLocatorEvent(type, eventScn, id, rowId, rsId, time, entry, columnName, binary);
            }
            case LOB_WRITE: {
                return new LobWriteEvent(type, eventScn, id, rowId, rsId, time, data);
            }
            case LOB_ERASE: {
                return new LobEraseEvent(type, eventScn, id, rowId, rsId, time);
            }
            case LOB_TRIM: {
                return new LogMinerEvent(type, eventScn, id, rowId, rsId, time);
            }
        }
        throw new DebeziumException("Unknown event type: " + eventType);
    }

    @ProtoField(number=1, required=true)
    public int getEventType(LogMinerEvent event) {
        return event.getEventType().getValue();
    }

    @ProtoField(number=2, required=true)
    public String getScn(LogMinerEvent event) {
        return event.getScn().toString();
    }

    @ProtoField(number=3, required=true)
    public String getTableId(LogMinerEvent event) {
        return event.getTableId().identifier();
    }

    @ProtoField(number=4, required=true)
    public String getRowId(LogMinerEvent event) {
        return event.getRowId();
    }

    @ProtoField(number=5, required=true)
    public String getRsId(LogMinerEvent event) {
        return event.getRsId();
    }

    @ProtoField(number=6, required=true)
    public String getChangeTime(LogMinerEvent event) {
        return event.getChangeTime().toString();
    }

    @ProtoField(number=7)
    public LogMinerDmlEntryImpl getEntry(LogMinerEvent event) {
        switch (event.getEventType()) {
            case INSERT: 
            case UPDATE: 
            case DELETE: 
            case SELECT_LOB_LOCATOR: {
                return (LogMinerDmlEntryImpl)((DmlEvent)event).getDmlEntry();
            }
        }
        return null;
    }

    @ProtoField(number=8)
    public String getColumnName(LogMinerEvent event) {
        if (EventType.SELECT_LOB_LOCATOR.equals((Object)event.getEventType())) {
            return ((SelectLobLocatorEvent)event).getColumnName();
        }
        return null;
    }

    @ProtoField(number=9)
    public Boolean getBinary(LogMinerEvent event) {
        if (EventType.SELECT_LOB_LOCATOR.equals((Object)event.getEventType())) {
            return ((SelectLobLocatorEvent)event).isBinary();
        }
        return null;
    }

    @ProtoField(number=10)
    public String getData(LogMinerEvent event) {
        if (EventType.LOB_WRITE.equals((Object)event.getEventType())) {
            return ((LobWriteEvent)event).getData();
        }
        return null;
    }
}

